"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const moment_1 = __importDefault(require("moment"));
const dal_constants_1 = require("../../../dal.constants");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
const nextExecTimeFifteenMinLater = (0, moment_1.default)().add(15, "minute");
async function up(client, dbuser, dbsuperuser) {
    await client.query(`
			ALTER TABLE public."scheduled_job"
				DROP CONSTRAINT IF EXISTS scheduled_job_interval_check,
				ADD CONSTRAINT scheduled_job_interval_check CHECK (	"interval" = ANY ('{1,2,3,4,5,6,7,8,9}'::smallint[]));
			`);
    await client.query(`	
		INSERT INTO public."scheduled_job"(
			id, "createdT", type, enabled, "interval", "firstExecutionDate", "nextExecutionDate")
			VALUES (uuid_generate_v4(), now(), $1, $2, $3, $4, $4);
			`, [109, true, 8, nextExecTimeFifteenMinLater.toDate()]);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    await client.query(`
		DELETE FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.scheduled_job}" WHERE type = $1;
		`, [109]);
    await client.query(`
		ALTER TABLE public."scheduled_job"
		DROP CONSTRAINT IF EXISTS scheduled_job_interval_check,
		ADD CONSTRAINT scheduled_job_interval_check 
		CHECK (	"interval" = ANY ('{1,2,3,4,5,6,7}'::smallint[]));
        `);
}
exports.down = down;
