"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const app_enums_1 = require("../../../../app.enums");
var EmployeeInfoSorting;
(function (EmployeeInfoSorting) {
    EmployeeInfoSorting[EmployeeInfoSorting["Username"] = 1] = "Username";
    EmployeeInfoSorting[EmployeeInfoSorting["ExtraWork"] = 2] = "ExtraWork";
    EmployeeInfoSorting[EmployeeInfoSorting["MissedWork"] = 3] = "MissedWork";
    EmployeeInfoSorting[EmployeeInfoSorting["EntranceDate"] = 4] = "EntranceDate";
    EmployeeInfoSorting[EmployeeInfoSorting["ExitDate"] = 5] = "ExitDate";
    EmployeeInfoSorting[EmployeeInfoSorting["LateAccess"] = 6] = "LateAccess";
    EmployeeInfoSorting[EmployeeInfoSorting["EarlyLeave"] = 7] = "EarlyLeave";
})(EmployeeInfoSorting || (EmployeeInfoSorting = {}));
async function up(client, dbuser, dbsuperuser) {
    const organizationIds = (await client.query(` SELECT id FROM public."organizationList";`)).rows.map((r) => r.id);
    if (organizationIds && organizationIds.length) {
        for (const organizationId of organizationIds) {
            const { rows } = await client.query(`
            	SELECT id, filter
				FROM "${organizationId}"."report_templates"
				WHERE type = 15   -- enums.ReportCode.PacsFirstInLastOutForSingleUser
			`);
            for (const row of rows) {
                const oldFilter = row.filter;
                let sortType;
                switch (oldFilter.sortingMethod) {
                    case EmployeeInfoSorting.ExtraWork:
                        sortType = app_enums_1.enums.WorkSummarySortType.ExtraWork;
                        break;
                    case EmployeeInfoSorting.MissedWork:
                        sortType = app_enums_1.enums.WorkSummarySortType.MissingWork;
                        break;
                    case EmployeeInfoSorting.EntranceDate:
                    case EmployeeInfoSorting.ExitDate:
                        sortType = app_enums_1.enums.WorkSummarySortType.Date;
                        break;
                    case EmployeeInfoSorting.LateAccess:
                        sortType = app_enums_1.enums.WorkSummarySortType.LateStart;
                        break;
                    case EmployeeInfoSorting.EarlyLeave:
                        sortType = app_enums_1.enums.WorkSummarySortType.EarylLeave;
                        break;
                    default:
                        sortType = app_enums_1.enums.WorkSummarySortType.Date;
                        break;
                }
                const newFilter = {
                    userId: oldFilter.userId,
                    workStatusFilter: oldFilter.workStatusFilter,
                    onlyWorkingDays: oldFilter.showOnlyDaysWithWorkingHours,
                    sortType: sortType,
                    sortOrder: "DESC",
                    userOrganizationStatus: app_enums_1.enums.IdentityStatusType.Enabled,
                };
                await client.query(`
					UPDATE "${organizationId}"."report_templates"
					SET type = $1, filter = $2
					WHERE id = $3
				`, [app_enums_1.enums.ReportCode.PacsEmployeeWorkingHoursSummary, newFilter, row.id]);
            }
        }
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const organizationIds = (await client.query(` SELECT id FROM public."organizationList";`)).rows.map((r) => r.id);
    if (organizationIds && organizationIds.length) {
        for (const organizationId of organizationIds) {
            const { rows } = await client.query(`
            	SELECT id, filter
				FROM "${organizationId}"."report_templates"
				WHERE type = $1
			`, [app_enums_1.enums.ReportCode.PacsEmployeeWorkingHoursSummary]);
            for (const row of rows) {
                const oldFilter = row.filter;
                let sortType;
                switch (oldFilter.sortType) {
                    case app_enums_1.enums.WorkSummarySortType.Name:
                        sortType = EmployeeInfoSorting.Username;
                        break;
                    case app_enums_1.enums.WorkSummarySortType.ExtraWork:
                        sortType = EmployeeInfoSorting.ExtraWork;
                        break;
                    case app_enums_1.enums.WorkSummarySortType.MissingWork:
                        sortType = EmployeeInfoSorting.MissedWork;
                        break;
                    case app_enums_1.enums.WorkSummarySortType.Date:
                        sortType = EmployeeInfoSorting.EntranceDate;
                        break;
                    case app_enums_1.enums.WorkSummarySortType.LateStart:
                        sortType = EmployeeInfoSorting.LateAccess;
                        break;
                    case app_enums_1.enums.WorkSummarySortType.EarylLeave:
                        sortType = EmployeeInfoSorting.EarlyLeave;
                        break;
                    default:
                        sortType = EmployeeInfoSorting.EntranceDate;
                        break;
                }
                const newFilter = {
                    userId: oldFilter.userId,
                    workStatusFilter: oldFilter.workStatusFilter,
                    showOnlyDaysWithWorkingHours: oldFilter.onlyWorkingDays,
                    sortingMethod: sortType,
                };
                await client.query(`
					UPDATE "${organizationId}"."report_templates"
					SET type = $1, filter = $2
					WHERE id = $3
				`, [15, newFilter, row.id]);
            }
        }
    }
}
exports.down = down;
