"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_constants_1 = require("../../../dal.constants");
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `
		ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."accessControlPoints"
    	ADD COLUMN IF NOT EXISTS "typedGeoLocation" jsonb;

		
		ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."workPlans"
    	ADD COLUMN IF NOT EXISTS "typedGeoLocations" jsonb;

		UPDATE "___ORGANIZATION_ID___"."accessControlPoints" 
		SET "typedGeoLocation" = jsonb_build_object(
			't', ${dal_constants_1.DalConstants.GeoLocationType.Circle},
			'lo', "geoLocation"->'lo',
			'la', "geoLocation"->'la',
			'r', "geoLocation"->'r'
		)
		WHERE "geoLocation" IS NOT NULL;

		
		UPDATE "___ORGANIZATION_ID___"."workPlans" wp
		SET "typedGeoLocations" = (
			SELECT JSONB_AGG (
				JSONB_BUILD_OBJECT(
					't', 1,
					'lo', t.value->'lo',
					'la', t.value->'la',
					'r', t.value-> 'r'
				)
			) AS x
			FROM "___ORGANIZATION_ID___"."workPlans", JSONB_ARRAY_ELEMENTS("geoLocations") t
				WHERE "geoLocations" IS NOT NULL
				AND id = wp.id
		)
		WHERE "geoLocations" IS NOT NULL;

		ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."accessControlPoints"
    	DROP COLUMN IF EXISTS "geoLocation";
		
		ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."workPlans"
    	DROP COLUMN IF EXISTS "geoLocations";
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const q = `
	ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."accessControlPoints"
	ADD COLUMN IF NOT EXISTS "geoLocation" jsonb;

	ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."workPlans"
	ADD COLUMN IF NOT EXISTS "geoLocations" jsonb;

	UPDATE "___ORGANIZATION_ID___"."accessControlPoints" 
	SET "geoLocation" = jsonb_build_object(
		'lo', "typedGeoLocation"->'lo',
		'la', "typedGeoLocation"->'la',
		'r', "typedGeoLocation"->'r'
	)
	WHERE "typedGeoLocation" IS NOT NULL
	AND "typedGeoLocation"->>'t' = '${dal_constants_1.DalConstants.GeoLocationType.Circle}';

	UPDATE "___ORGANIZATION_ID___"."workPlans" wp
		SET "geoLocations" = (
			SELECT JSONB_AGG (
				JSONB_BUILD_OBJECT(
					'lo', t.value->'lo',
					'la', t.value->'la',
					'r', t.value-> 'r'
				)
			) AS x
			FROM "___ORGANIZATION_ID___"."workPlans", JSONB_ARRAY_ELEMENTS ("typedGeoLocations") t
				WHERE "typedGeoLocations" IS NOT NULL
				AND id = wp.id
				AND t.value->>'t' = '1'
		)
		WHERE "typedGeoLocations" IS NOT NULL;

	ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."accessControlPoints"
	DROP COLUMN IF EXISTS "typedGeoLocation";

	ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."workPlans"
	DROP COLUMN IF EXISTS "typedGeoLocations";
`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.down = down;
