"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `

-------------dryContactInput Trigger-----------------
CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".device_dry_contact_input_id_fk()
	RETURNS trigger
	LANGUAGE 'plpgsql'
	COST 100
	VOLATILE NOT LEAKPROOF
AS $BODY$
	BEGIN
		IF (TG_OP = 'DELETE' OR (TG_OP = 'UPDATE' AND (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL))) THEN
			DELETE FROM "___ORGANIZATION_ID___"."cameraActions"
			WHERE (settings ->> 'dryContactInputId')::uuid = OLD.id;
		ELSIF (TG_OP = 'UPDATE' AND NEW.id != OLD.id) THEN
			UPDATE "___ORGANIZATION_ID___"."cameraActions"
			SET settings = (settings::jsonb - 'dryContactInputId') || jsonb_build_object('dryContactInputId', NEW.id)
			WHERE (settings ->> 'dryContactInputId')::uuid = OLD.id;
		END IF;
        RETURN NULL;
    END;
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".device_dry_contact_input_id_fk()
    OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".device_dry_contact_input_id_fk() TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".device_dry_contact_input_id_fk() TO PUBLIC;

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".device_dry_contact_input_id_fk() TO ${dbuser};


CREATE TRIGGER device_dry_contact_input_id_fk
    AFTER DELETE OR UPDATE 
    ON "___ORGANIZATION_ID___"."deviceDryContactInputs"
    FOR EACH ROW
    EXECUTE PROCEDURE "___ORGANIZATION_ID___".device_dry_contact_input_id_fk();

-----------RELAY TRIGGER----------------
CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk()
	RETURNS trigger
	LANGUAGE 'plpgsql'
	COST 100
	VOLATILE NOT LEAKPROOF
AS $BODY$
	BEGIN
		IF (TG_OP = 'DELETE' OR (TG_OP = 'UPDATE' AND (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL))) THEN
			DELETE FROM "___ORGANIZATION_ID___"."deviceDryContactInputs"
			WHERE (settings ->> 'relayId')::uuid = OLD.id;
		ELSIF (TG_OP = 'UPDATE' AND NEW.id != OLD.id) THEN
			UPDATE "___ORGANIZATION_ID___"."deviceDryContactInputs"
			SET settings = (settings::jsonb - 'relayId') || jsonb_build_object('relayId', NEW.id)
			WHERE (settings ->> 'relayId')::uuid = OLD.id;
		END IF;
        RETURN NULL;
    END;
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk()
    OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk() TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk() TO PUBLIC;

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk() TO ${dbuser};


CREATE TRIGGER device_relay_id_fk
    AFTER DELETE OR UPDATE 
    ON "___ORGANIZATION_ID___"."deviceRelays"
    FOR EACH ROW
    EXECUTE PROCEDURE "___ORGANIZATION_ID___".device_relay_id_fk();
	

	`;
    (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
