"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const app_logs_1 = require("../../../../app.logs");
async function up(client, dbuser, dbsuperuser) {
    const { rowCount, rows } = await client.query(`SELECT id FROM public."organizationList"`);
    const organizationIds = rowCount > 0 ? rows.map((row) => row.id) : [];
    for (const organizationId of organizationIds) {
        const locale = (await client.query(`SELECT settings FROM "${organizationId}".organizations`)).rows[0].settings.locale;
        await client.query(` UPDATE "${organizationId}".users
        SET settings = $1
        WHERE settings->'locale' IS NULL`, [JSON.stringify({ locale })]);
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    app_logs_1.logger.info("migrate down to 20210102");
}
exports.down = down;
