"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `ALTER TABLE "___ORGANIZATION_ID___"."organizations"
    ADD COLUMN IF NOT EXISTS "organizationUnitDynamicFormId" uuid;
    
    ALTER TABLE "___ORGANIZATION_ID___"."organizations"
    ADD FOREIGN KEY ("organizationUnitDynamicFormId") REFERENCES "___ORGANIZATION_ID___"."dynamicForms"(id); 

    UPDATE "___ORGANIZATION_ID___"."organizationUnits"
    SET settings = '{"dynamicFormData": { "visitorParkCapacity": 5}}';

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".fgetorganizationunitdetailed(
        organization_id uuid,
        organization_unit_id uuid,
        is_system_administrator boolean,
        user_id uuid)
        RETURNS json
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE PARALLEL UNSAFE
        AS $BODY$
        DECLARE 
            _ri RECORD;
            _ji JSON;
            _result JSON;
            _parent JSON;
            _defaultAccessControlPoints JSON[];
        BEGIN	
            _result = null;
            _defaultAccessControlPoints = ARRAY[]::JSON[];
            
            SELECT json_build_object(
            'id', ou."id",
            'name', ou."name",
            'typeId', ou."typeId",
            'typeDefinition', oud.value,
            'ancestorIds', CASE WHEN ou."ancestorIds" = '[]' OR ou."ancestorIds" = '' OR ou."ancestorIds" IS null THEN ARRAY[]::uuid[] 
                        ELSE regexp_split_to_array(ou."ancestorIds", E',')::uuid[] END,
            'shortCode', ou."shortCode",
			'dynamicFormData', ou.settings->'dynamicFormData',
            'parent', CASE WHEN ou."parentId" IS NULL THEN NULL ELSE ( 
                SELECT json_build_object('id', pou."id", 'name', pou."name",
                'typeId', pou."typeId", 
                'typeDefinition', poud.value,
                'ancestorIds', CASE WHEN pou."ancestorIds" = '[]' OR pou."ancestorIds" = '' OR pou."ancestorIds" IS NULL THEN ARRAY[]::uuid[] 
                        ELSE regexp_split_to_array(pou."ancestorIds", E',')::uuid[] END,
                        'shortCode', pou."shortCode",
                        'parentId', pou."parentId",
						'dynamicFormData', ou.settings->'dynamicFormData'
                ) FROM "___ORGANIZATION_ID___"."organizationUnits" AS pou
                INNER JOIN "___ORGANIZATION_ID___"."organizationUserDefinedListValues" AS poud ON pou."typeId" = poud.id
                WHERE pou."id" = ou."parentId" AND pou."deletedAt" IS NULL) END,
                'defaultAccessControlPoints', ARRAY[]::JSON[]	
            )
            INTO _result 
            FROM "___ORGANIZATION_ID___"."organizationUnits" AS ou 
            INNER JOIN "___ORGANIZATION_ID___"."organizationUserDefinedListValues" AS oud ON ou."typeId" = oud.id
            WHERE ou."organizationId" = organization_id AND ou."id" = organization_unit_id AND ou."deletedAt" IS NULL;
            
            FOR _ri IN
            SELECT 
                acp."id", acp."name", acp."location", acp."remoteAvailable", acp."isRemoteDefault", acp."accessControlPointType" AS "type",
                (CASE WHEN uar."id" IS NULL AND is_system_administrator = FALSE THEN FALSE ELSE TRUE END) AS "managable", oudacp."defaultPrivileges"
            FROM "___ORGANIZATION_ID___"."organizationUnitDefaultAccessControlPoints" AS oudacp
            INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = oudacp."accessControlPointId"
            LEFT OUTER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = user_id AND uar."accessControlPointId" = acp."id" AND uar."deletedAt" IS NULL
            WHERE oudacp."deletedAt" IS NULL AND oudacp."organizationUnitId" = organization_unit_id AND acp."deletedAt" IS NULL
            ORDER BY acp."name"
            LOOP
                _defaultAccessControlPoints = _defaultAccessControlPoints || to_json(_ri);
            END LOOP;
            
            IF _result IS NULL
            THEN
                RAISE EXCEPTION '%', json_build_object('code', 404, 'message', 'The organization unit is not found!');
            END IF;
            
            SELECT json_append(_result, json_build_object('defaultAccessControlPoints', _defaultAccessControlPoints)) INTO _result;
                
            RETURN _result;
            END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".fgetorganizationunitdetailed(uuid, uuid, boolean, uuid)
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".fgetorganizationunitdetailed(uuid, uuid, boolean, uuid) TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".fgetorganizationunitdetailed(uuid, uuid, boolean, uuid) TO ${dbuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".fgetorganizationunitdetailed(uuid, uuid, boolean, uuid) TO ${dbsuperuser};


    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `ALTER TABLE "___ORGANIZATION_ID___"."organizations"
    DROP COLUMN IF EXISTS "organizationUnitDynamicFormId";
    
    UPDATE "___ORGANIZATION_ID___"."organizationUnits"
    SET settings = '{ "visitorParkCapacity": 5}';

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".fgetorganizationunitdetailed(
        organization_id uuid,
        organization_unit_id uuid,
        is_system_administrator boolean,
        user_id uuid)
        RETURNS json
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE PARALLEL UNSAFE
        AS $BODY$
        DECLARE 
                _ri RECORD;
                _ji JSON;
                _result JSON;
                _parent JSON;
                _defaultAccessControlPoints JSON[];
            BEGIN	
            _result = null;
            _defaultAccessControlPoints = ARRAY[]::JSON[];
            
            SELECT json_build_object(
            'id', ou."id",
            'name', ou."name",
            'typeId', ou."typeId",
            'typeDefinition', oud.value,
            'ancestorIds', CASE WHEN ou."ancestorIds" = '[]' OR ou."ancestorIds" = '' OR ou."ancestorIds" IS null THEN ARRAY[]::uuid[] 
                        ELSE regexp_split_to_array(ou."ancestorIds", E',')::uuid[] END,
            'shortCode', ou."shortCode",
            'parent', CASE WHEN ou."parentId" IS NULL THEN NULL ELSE ( 
                SELECT json_build_object('id', pou."id", 'name', pou."name",
                'typeId', pou."typeId", 
                'typeDefinition', poud.value,
                'ancestorIds', CASE WHEN pou."ancestorIds" = '[]' OR pou."ancestorIds" = '' OR pou."ancestorIds" IS NULL THEN ARRAY[]::uuid[] 
                        ELSE regexp_split_to_array(pou."ancestorIds", E',')::uuid[] END,
                        'shortCode', pou."shortCode",
                        'parentId', pou."parentId"
                ) FROM "___ORGANIZATION_ID___"."organizationUnits" AS pou
                INNER JOIN "___ORGANIZATION_ID___"."organizationUserDefinedListValues" AS poud ON pou."typeId" = poud.id
                WHERE pou."id" = ou."parentId" AND pou."deletedAt" IS NULL) END,
                'defaultAccessControlPoints', ARRAY[]::JSON[]	
            )
            INTO _result 
            FROM "___ORGANIZATION_ID___"."organizationUnits" AS ou 
            INNER JOIN "___ORGANIZATION_ID___"."organizationUserDefinedListValues" AS oud ON ou."typeId" = oud.id
            WHERE ou."organizationId" = organization_id AND ou."id" = organization_unit_id AND ou."deletedAt" IS NULL;
            
            FOR _ri IN
            SELECT 
                acp."id", acp."name", acp."location", acp."remoteAvailable", acp."isRemoteDefault", acp."accessControlPointType" AS "type",
                (CASE WHEN uar."id" IS NULL AND is_system_administrator = FALSE THEN FALSE ELSE TRUE END) AS "managable", oudacp."defaultPrivileges"
            FROM "___ORGANIZATION_ID___"."organizationUnitDefaultAccessControlPoints" AS oudacp
            INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = oudacp."accessControlPointId"
            LEFT OUTER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = user_id AND uar."accessControlPointId" = acp."id" AND uar."deletedAt" IS NULL
            WHERE oudacp."deletedAt" IS NULL AND oudacp."organizationUnitId" = organization_unit_id AND acp."deletedAt" IS NULL
            ORDER BY acp."name"
            LOOP
                _defaultAccessControlPoints = _defaultAccessControlPoints || to_json(_ri);
            END LOOP;
            
            IF _result IS NULL
            THEN
                RAISE EXCEPTION '%', json_build_object('code', 404, 'message', 'The organization unit is not found!');
            END IF;
            
            SELECT json_append(_result, json_build_object('defaultAccessControlPoints', _defaultAccessControlPoints)) INTO _result;
                
            RETURN _result;
            END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".fgetorganizationunitdetailed(uuid, uuid, boolean, uuid)
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".fgetorganizationunitdetailed(uuid, uuid, boolean, uuid) TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".fgetorganizationunitdetailed(uuid, uuid, boolean, uuid) TO ${dbuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".fgetorganizationunitdetailed(uuid, uuid, boolean, uuid) TO ${dbsuperuser};

    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
