"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".notify_pacs_live_recalculation()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
            DECLARE
            recalculate_required_count		integer;
            BEGIN
                SELECT COUNT(*) INTO recalculate_required_count
                FROM newtab
                LEFT OUTER JOIN oldtab ON newtab.id = oldtab.id 
                WHERE (oldtab."updateRequiredReason" = 1 AND newtab."updateRequiredReason" <> 1) OR oldtab.id IS NULL;

                IF(recalculate_required_count > 0)
                THEN
                    PERFORM PG_NOTIFY('pacs_live_recalculation', '___ORGANIZATION_ID___');
                END IF;
                RETURN NULL;
            END;
        $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".notify_pacs_live_recalculation()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".notify_pacs_live_recalculation() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".notify_pacs_live_recalculation() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".notify_pacs_live_recalculation() TO ${dbuser};`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".notify_pacs_live_recalculation()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
            DECLARE
            recalculate_required_count		integer;
            BEGIN
                SELECT COUNT(*) INTO recalculate_required_count
                FROM newtab
                LEFT OUTER JOIN oldtab ON newtab.id = oldtab.id 
                WHERE (oldtab."updateRequiredReason" = 1 AND newtab."updateRequiredReason" <> 1) OR oldtab.id IS NULL;

                IF(recalculate_required_count > 0)
                THEN
                    PERFORM PG_NOTIFY('pacs_live_recalculation', recalculate_required_count::text);
                END IF;
                RETURN NULL;
            END;
        $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".notify_pacs_live_recalculation()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".notify_pacs_live_recalculation() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".notify_pacs_live_recalculation() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".notify_pacs_live_recalculation() TO ${dbuser};`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
