"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const restapi_1 = require("../../../../lib/es/models/restapi");
const dal_utils_1 = require("../../../dal.utils");
const usageLimitExceededNotificatioId = "286b05ec-3b4e-4999-b4a4-3c8d3e2e1515";
const yilmazPlazaOrganizationId = "3d93c7c7-2610-4f4a-8158-44b29c82fa05";
async function up(client, dbuser, dbsuperuser) {
    const schemaList = await client.query("SELECT schema_name FROM information_schema.schemata");
    if (schemaList.rows.map((r) => r.schema_name).includes(yilmazPlazaOrganizationId)) {
        await client.query(`INSERT INTO "${yilmazPlazaOrganizationId}"."notification"
		(id, "createdT", "createdByUserId", type, "receiverFilterId", settings, email, sms, web, "pushNotification")	
		VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10)`, [usageLimitExceededNotificatioId, new Date(), null, restapi_1.NotificationType.Custom, null, null, true, false, true, true]);
    }
    const q = `
	ALTER TABLE "___ORGANIZATION_ID___"."organizationUnits"
	ADD COLUMN settings jsonb;

	UPDATE "___ORGANIZATION_ID___"."organizationUnits"
	SET settings = '{"visitorParkCapacity": 5}';
`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const schemaList = await client.query("SELECT schema_name FROM information_schema.schemata");
    if (schemaList.rows.map((r) => r.schema_name).includes(yilmazPlazaOrganizationId)) {
        await client.query(`DELETE FROM "${yilmazPlazaOrganizationId}"."notification"
			WHERE id = $1`, [usageLimitExceededNotificatioId]);
    }
    const q = `
		ALTER TABLE "___ORGANIZATION_ID___"."organizationUnits"
		DROP COLUMN settings;
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.down = down;
