"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    const q = `
	-- FUNCTION: ___ORGANIZATION_ID___.after_in_up_del_anti_passback_state()
	-- DROP FUNCTION "___ORGANIZATION_ID___".after_in_up_del_anti_passback_state();
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_in_up_del_anti_passback_state()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
	DECLARE
			data_object		 	json;
			related_device_ids 	uuid[];
			res					text;
			region_id			uuid;
		BEGIN
			IF (TG_OP = 'DELETE') THEN
				region_id := OLD."regionId";
			ELSIF (TG_OP = 'INSERT') THEN
				region_id := NEW."regionId";
			ELSIF (TG_OP = 'UPDATE') THEN
				region_id := NEW."regionId";
			END IF;
			
			IF ((SELECT "antiPassback" FROM "___ORGANIZATION_ID___"."regions" WHERE id = region_id) != TRUE) THEN
				RETURN NULL;
			END IF;
			IF (TG_OP = 'DELETE') THEN
				SELECT ARRAY_AGG(T."deviceId") FROM (
					SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
						FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" as uar
						INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS acp ON uar."accessControlPointId" = acp."id"
						INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}" AS racp ON racp."accessControlPointId" = acp."id"
						WHERE racp."regionId" = OLD."regionId" AND
							acp."deletedAt" IS NULL AND
							uar."userId" = OLD."userId" AND
							uar."deletedAt" IS NULL 
				) AS T INTO related_device_ids
				WHERE T.row_num = 1;
				data_object := JSON_BUILD_OBJECT(
					'userId', OLD."userId",
					'regionId', OLD."regionId",
					'state', 0,
					'actionDateISO', now());
			ELSIF (TG_OP = 'INSERT') THEN
				SELECT ARRAY_AGG(T."deviceId") FROM (
					SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
						FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" as uar
						INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS acp ON uar."accessControlPointId" = acp."id"
						INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}" AS racp ON racp."accessControlPointId" = acp."id"
						WHERE racp."regionId" = NEW."regionId" AND
							acp."deletedAt" IS NULL AND
							uar."userId" = NEW."userId" AND
							uar."deletedAt" IS NULL 
					AND	acp."deviceId" != (SELECT "deviceId" FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" WHERE "id" = NEW."accessControlPointId")
				) AS T INTO related_device_ids
				WHERE T.row_num = 1;
				data_object := JSON_BUILD_OBJECT(
					'userId', NEW."userId",
					'regionId', NEW."regionId",
					'state', NEW."state",
					'actionDateISO', NEW."actionUtc",
					'entranceLockExpirationDateISO', NEW."entranceLockExpirationUtc",
					'exitLockExpirationDateISO', NEW."exitLockExpirationUtc");
			ELSIF (TG_OP = 'UPDATE') THEN
				IF (OLD."userId" != NEW."userId" OR OLD."regionId" != NEW."regionId") THEN
					RETURN NULL;
				END IF;
				SELECT ARRAY_AGG(T."deviceId") FROM (
					SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
						FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" as uar
						INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS acp ON uar."accessControlPointId" = acp."id"
						INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}" AS racp ON racp."accessControlPointId" = acp."id"
						WHERE racp."regionId" = NEW."regionId" AND
							acp."deletedAt" IS NULL AND
							uar."userId" = NEW."userId" AND
							uar."deletedAt" IS NULL 
					AND
							acp."deviceId" != (SELECT "deviceId" FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" WHERE "id" = NEW."accessControlPointId")
				) AS T INTO related_device_ids
				WHERE T.row_num = 1;
	
				data_object := JSON_BUILD_OBJECT(
						'userId', NEW."userId",
						'regionId', NEW."regionId",
						'state', NEW."state",
						'actionDateISO', NEW."actionUtc",
						'entranceLockExpirationDateISO', NEW."entranceLockExpirationUtc",
						'exitLockExpirationDateISO', NEW."exitLockExpirationUtc");
			END IF;
			res :=JSON_BUILD_OBJECT(
						'data', data_object,
						'relatedDeviceIds', related_device_ids,
						'organizationId', TG_TABLE_SCHEMA)::text;
			PERFORM PG_NOTIFY('region_state_changes', res);
			RETURN NULL;
		END;
	$BODY$;
	
	ALTER FUNCTION "___ORGANIZATION_ID___".after_in_up_del_anti_passback_state()
		OWNER TO ${dbsuperuser};
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_in_up_del_anti_passback_state() TO ${dbsuperuser};
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_in_up_del_anti_passback_state() TO PUBLIC;
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_in_up_del_anti_passback_state() TO ${dbuser};

	------------------------ deadLetterOfflineLogs -------------------------------

	CREATE TABLE IF NOT EXISTS "___ORGANIZATION_ID___".unhandled_device_log(
		id uuid NOT NULL,
		"createdT" timestamp without time zone NOT NULL,
		"logReceiveMethod" smallint NOT NULL,
		"deviceId" uuid NOT NULL,
		type smallint NOT NULL,
		log jsonb NOT NULL,
		note jsonb, 
		CONSTRAINT unhandled_device_log_pkey PRIMARY KEY (id)
	)
	TABLESPACE pg_default;

	ALTER TABLE "___ORGANIZATION_ID___"."unhandled_device_log"
		OWNER to ${dbuser};
	
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const q = `
	-- FUNCTION: ___ORGANIZATION_ID___.after_in_up_del_anti_passback_state()
	-- DROP FUNCTION "___ORGANIZATION_ID___".after_in_up_del_anti_passback_state();
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_in_up_del_anti_passback_state()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
	DECLARE
			data_object		 	json;
			related_device_ids 	uuid[];
			res					text;
			region_id			uuid;
		BEGIN
			IF (TG_OP = 'DELETE') THEN
				region_id := OLD."regionId";
			ELSIF (TG_OP = 'INSERT') THEN
				region_id := NEW."regionId";
			ELSIF (TG_OP = 'UPDATE') THEN
				region_id := NEW."regionId";
			END IF;
			
			IF ((SELECT "antiPassback" FROM "___ORGANIZATION_ID___"."regions" WHERE id = region_id) != TRUE) THEN
				RETURN NULL;
			END IF;
			IF (TG_OP = 'DELETE') THEN
				SELECT ARRAY_AGG(T."deviceId") FROM (
					SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
						FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" as uar
						INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS acp ON uar."accessControlPointId" = acp."id"
						INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}" AS racp ON racp."accessControlPointId" = acp."id"
						WHERE racp."regionId" = OLD."regionId" AND
							acp."deletedAt" IS NULL AND
							uar."userId" = OLD."userId" AND
							uar."deletedAt" IS NULL 
				) AS T INTO related_device_ids
				WHERE T.row_num = 1;
				data_object := JSON_BUILD_OBJECT(
					'userId', OLD."userId",
					'regionId', OLD."regionId",
					'state', 0,
					'actionDateISO', now());
			ELSIF (TG_OP = 'INSERT') THEN
				SELECT ARRAY_AGG(T."deviceId") FROM (
					SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
						FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" as uar
						INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS acp ON uar."accessControlPointId" = acp."id"
						INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}" AS racp ON racp."accessControlPointId" = acp."id"
						WHERE racp."regionId" = NEW."regionId" AND
							acp."deletedAt" IS NULL AND
							uar."userId" = NEW."userId" AND
							uar."deletedAt" IS NULL 
					AND	acp."deviceId" != (SELECT "deviceId" FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" WHERE "id" = NEW."accessControlPointId")
				) AS T INTO related_device_ids
				WHERE T.row_num = 1;
				data_object := JSON_BUILD_OBJECT(
					'userId', NEW."userId",
					'regionId', NEW."regionId",
					'state', NEW."state",
					'actionDateISO', NEW."actionUtc",
					'entranceLockExpirationDateISO', NEW."entranceLockExpirationUtc",
					'exitLockExpirationDateISO', NEW."exitLockExpirationUtc");
			ELSIF (TG_OP = 'UPDATE') THEN
				IF (OLD."userId" != NEW."userId" OR OLD."regionId" != NEW."regionId") THEN
					RETURN NULL;
				END IF;
				SELECT ARRAY_AGG(T."deviceId") FROM (
					SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
						FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" as uar
						INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS acp ON uar."accessControlPointId" = acp."id"
						INNER JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}" AS racp ON racp."accessControlPointId" = acp."id"
						WHERE racp."regionId" = NEW."regionId" AND
							acp."deletedAt" IS NULL AND
							uar."userId" = NEW."userId" AND
							uar."deletedAt" IS NULL 
					AND
							acp."deviceId" != (SELECT "deviceId" FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" WHERE "id" = NEW."accessControlPointId")
				) AS T INTO related_device_ids
				WHERE T.row_num = 1;
	
				data_object := JSON_BUILD_OBJECT(
						'userId', NEW."userId",
						'regionId', NEW."regionId",
						'state', NEW."state",
						'actionDateISO', NEW."actionUtc",
						'entranceLockExpirationDateISO', NEW."entranceLockExpirationUtc",
						'exitLockExpirationDateISO', NEW."exitLockExpirationUtc");
			END IF;
			res :=JSON_BUILD_OBJECT(
						'data', data_object,
						'relatedDeviceIds', related_device_ids,
						'organizationId', TG_TABLE_SCHEMA)::text;
			PERFORM PG_NOTIFY('region_state_changes', res);
			RETURN NULL;
		END;
	$BODY$;
	
	ALTER FUNCTION "___ORGANIZATION_ID___".after_in_up_del_anti_passback_state()
		OWNER TO ${dbsuperuser};
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_in_up_del_anti_passback_state() TO ${dbsuperuser};
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_in_up_del_anti_passback_state() TO PUBLIC;
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_in_up_del_anti_passback_state() TO ${dbuser};


	-------------- drop dead_letter_offline_logs -------------------------------
	DROP TABLE IF EXISTS "___ORGANIZATION_ID___"."unhandled_device_log"; 
	
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.down = down;
