"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const moment_1 = __importDefault(require("moment"));
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    const query1 = `
        ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}"
        ADD COLUMN IF NOT EXISTS "offset" int NOT NULL DEFAULT 0;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query1, "___ORGANIZATION_ID___");
    const query2 = `
        ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}"
        ALTER COLUMN "offset" SET NOT NULL;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query2, "___ORGANIZATION_ID___");
    const { rowCount, rows } = await client.query(`SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"`);
    const organizationIds = rowCount > 0 ? rows.map((row) => row.id) : [];
    for (const organizationId of organizationIds) {
        const { rows: workPlanRows } = await client.query(`
            SELECT id, "endOfDayHour" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}";
        `);
        for (const workplan of workPlanRows) {
            if (!workplan.endOfDayHour || workplan.endOfDayHour === "0000" || workplan.endOfDayHour === "00:00")
                continue;
            const dayStart = (0, moment_1.default)(workplan.endOfDayHour + ":00", "HH:mm:ss");
            const workPlanEndOfDayHour = (0, moment_1.default)("00:00:00", "HH:mm:ss");
            const halfDay = (0, moment_1.default)("12:00:00", "HH:mm:ss");
            let duration;
            let minutes;
            if (dayStart.isBefore(halfDay)) {
                duration = moment_1.default.duration(dayStart.diff(workPlanEndOfDayHour));
                minutes = duration.asMinutes();
            }
            else {
                duration = moment_1.default.duration(dayStart.diff(workPlanEndOfDayHour));
                minutes = -(24 * 60 - duration.asMinutes());
            }
            client.query(`
				UPDATE "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}"
				SET "offset" = $1 WHERE id = $2
			`, [minutes, workplan.id]);
        }
    }
    const query3 = `
	    ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}"
	    DROP COLUMN IF EXISTS "endOfDayHour";
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query3, "___ORGANIZATION_ID___");
    const queryTrigger = `
		CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".process_recalculate_work_queue_start_date_time()
			RETURNS trigger
			LANGUAGE 'plpgsql'
			COST 100
			VOLATILE NOT LEAKPROOF
		AS $BODY$
		BEGIN
			DELETE FROM "___ORGANIZATION_ID___"."recalculateWorkQueue" 
			WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId" 
				AND "startDate" >= NEW."startDate";
			
			IF EXISTS(SELECT  FROM "___ORGANIZATION_ID___"."recalculateWorkQueue" 
				WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId" 
				AND "startDate" < NEW."startDate")
			THEN
				RETURN NULL; 
			ELSE
				NEW."startDate" = (NEW."startDate" - INTERVAL '1 day')::date;
				RETURN NEW;
			END IF;
		END;
		$BODY$;
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, queryTrigger, "___ORGANIZATION_ID___");
    const queryRecalculate = `
		INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
		(id, "userId", "organizationId", reason, "startDate")

		SELECT uuid_generate_v4(), uwp."userId", wp."organizationId", 128,
			lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*tstzrange(wpp."periodStartDateTime", null)*tstzrange('2021-01-01', null))
		FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
		INNER JOIN "___ORGANIZATION_ID___"."workPlanPeriods" wpp ON wpp."workPlanId" = uwp."workPlanId"
		INNER JOIN "___ORGANIZATION_ID___"."workPlans" wp ON wp.id = uwp."workPlanId"
		INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" uo ON uo."userId" = uwp."userId"
		INNER JOIN "___ORGANIZATION_ID___"."userOrganizationProfiles" uop ON uop."userId" = uwp."userId"
		WHERE wpp."deletedAt" IS NULL AND wp."deletedAt" IS NULL AND uop."deletedAt" IS NULL AND uo."deletedAt" IS NULL AND NOT uo."isDisabled"
		AND lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*tstzrange(wpp."periodStartDateTime", null)*tstzrange('2021-01-01', null)) IS NOT NULL
		AND NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*tstzrange(wpp."periodStartDateTime", null)*tstzrange('2021-01-01', null))
		AND wp."offset" != 0
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, queryRecalculate, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const queryTrigger = `
		CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".process_recalculate_work_queue_start_date_time()
			RETURNS trigger
			LANGUAGE 'plpgsql'
			COST 100
			VOLATILE NOT LEAKPROOF
		AS $BODY$
		BEGIN
			DELETE FROM "___ORGANIZATION_ID___"."recalculateWorkQueue" 
			WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId" 
				AND "startDate" >= NEW."startDate";
			
			IF EXISTS(SELECT  FROM "___ORGANIZATION_ID___"."recalculateWorkQueue" 
				WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId" 
				AND "startDate" < NEW."startDate")
			THEN
				RETURN NULL; 
			ELSE
				RETURN NEW;
			END IF;
		END;
		$BODY$;
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, queryTrigger, "___ORGANIZATION_ID___");
    const query1 = `
		ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}"
		ADD COLUMN IF NOT EXISTS "endOfDayHour" character varying(8) DEFAULT '00:00';
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query1, "___ORGANIZATION_ID___");
    const { rowCount, rows } = await client.query(`SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"`);
    const organizationIds = rowCount > 0 ? rows.map((row) => row.id) : [];
    for (const organizationId of organizationIds) {
        const { rows: workPlanRows } = await client.query(`
            SELECT id, "offset" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}";
        `);
        for (const workplan of workPlanRows) {
            let hour;
            let min;
            if (workplan.offset === 0)
                continue;
            if (workplan.offset > 0) {
                hour = String((workplan.offset - (workplan.offset % 60)) / 60);
                min = String(workplan.offset % 60);
            }
            else {
                const offset = -workplan.offset;
                min = String((60 - (offset % 60)) % 60);
                hour = String(((24 - (offset + (60 - (offset % 60))) / 60) % 24) + (min === "0" ? 1 : 0));
            }
            if (min.length === 1)
                min = "0" + min;
            if (hour.length === 1)
                hour = "0" + hour;
            const endOfDayHourString = hour + ":" + min;
            client.query(`
				UPDATE "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}"
				SET "endOfDayHour" = $1 WHERE id = $2
			`, [endOfDayHourString, workplan.id]);
        }
    }
    const query2 = `
	    ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}"
	    DROP COLUMN IF EXISTS "offset";
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query2, "___ORGANIZATION_ID___");
}
exports.down = down;
