"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
    UPDATE "___ORGANIZATION_ID___".organizations
    SET settings = settings - 'notification' || 
        jsonb_build_object('notification', 
          (settings->'notification')::jsonb - 'availableMediums' || 
          jsonb_build_object('mediumSettings',settings->'notification'->'availableMediums') ||
          jsonb_build_object('availableMediums', '{"sms": false, "web": true, "email": false, "pushNotification": false}'::json));

    UPDATE "___ORGANIZATION_ID___"."userOrganizations"
        SET settings = jsonb_build_object('notification', 
                (settings->'notification')::jsonb - 'availableMediums' ||
                jsonb_build_object('mediumSettings', settings->'notification'->'availableMediums'));

    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
    UPDATE "___ORGANIZATION_ID___".organizations
    SET settings = settings - 'notification'  || 
            jsonb_build_object('notification', 
              ((settings->'notification')::jsonb #- '{"availableMediums"}' #- '{"mediumSettings"}') || 
              jsonb_build_object('availableMeduims', settings->'notification'->'mediumSettings'));

    UPDATE "___ORGANIZATION_ID___"."userOrganizations"
    SET settings = jsonb_build_object('notification', 
            (settings->'notification')::jsonb - 'mediumSettings' ||
            jsonb_build_object('availableMediums', settings->'notification'->'mediumSettings'));

    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
