"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    const schemaQueries = `
		ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" 
			ADD COLUMN IF NOT EXISTS "privateKey" character varying(2048) COLLATE pg_catalog."default" DEFAULT 'PRIVATE_KEY'::character varying;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, schemaQueries, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
		ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" 
			DROP COLUMN IF EXISTS "privateKey";
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
