"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
	-- FUNCTION: "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens()

	-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens();
	
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
	DECLARE
		transaction_id	uuid;
		credential_exists	boolean;
		BEGIN
			transaction_id := uuid_generate_v4();
			IF (TG_OP = 'DELETE') THEN
				IF (OLD."deletedAt" IS NOT NULL AND OLD."oAuthClientId" IS NOT NULL) THEN
					DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
					WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
					-- 2 for BLE, 8 for NFC, 12 for QR
				END IF;
				RETURN OLD;
			ELSIF (TG_OP = 'UPDATE') THEN
				SELECT CASE WHEN (SELECT COUNT(*) AS C FROM
					"___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
					WHERE uoc."deletedAt" IS NULL AND
							uoc."userId" = NEW."userId" AND
							(uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12)) != 0 THEN true ELSE false END
				INTO credential_exists;
				IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL AND NEW."oAuthClientId" IS NOT NULL) THEN
				-- delete credentials
					DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
					WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
					RETURN NEW;
				ELSIF ((OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL AND NEW."oAuthClientId" IS NOT NULL) OR 
					   (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NULL AND OLD."oAuthClientId" IS NULL AND NEW."oAuthClientId" IS NOT NULL) OR
					   credential_exists = false AND NEW."oAuthClientId" IS NOT NULL AND NEW."deletedAt" IS NULL) THEN
				-- delete old credentials
				-- insert new credentials
					DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
					WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
	
					INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 2, NEW."oAuthClientId", null, null, null,null, null,null ,null);
	
					INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 8, NEW."oAuthClientId", null, null, null,null, null,null ,null);
	
					INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 12, NEW."userId", null, null, null,null, null,null ,null);
	
					RETURN NEW;
				ELSE
	
				END IF;
			ELSIF (TG_OP = 'INSERT') THEN
				-- check existing credentials
				SELECT CASE WHEN (SELECT COUNT(*) AS C FROM
					"___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
					WHERE uoc."deletedAt" IS NULL AND
							uoc."userId" = NEW."userId" AND
							(uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12)) != 0 THEN true ELSE false END
				INTO credential_exists;
				-- if no credentials present, then create 2 credentials for BLE and NFC
				IF (credential_exists = false AND NEW."oAuthClientId" IS NOT NULL) THEN
					INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 2, NEW."oAuthClientId", null, null, null,null, null,null ,null);
	
					INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 8, NEW."oAuthClientId", null, null, null,null, null,null ,null);
				
				
					INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 12, NEW."userId", null, null, null,null, null,null ,null);
	
				END IF;
			END IF;
			RETURN NEW;
		END;
	$BODY$;
	
	ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens()
		OWNER TO ${dbsuperuser};
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens() TO ${dbsuperuser};
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens() TO PUBLIC;
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens() TO ${dbuser};


	INSERT INTO public."oAuthRevokedTokens" ("id", "userId", "reason", "tokenId")
	SELECT uuid_generate_v4(), "userId", 'system operation', "id"
	FROM "___ORGANIZATION_ID___"."oAuthTokens"
	WHERE 
		"userId" = ANY(
			SELECT distinct("userId")
			FROM "___ORGANIZATION_ID___"."oAuthTokens" AS oat
				WHERE oat."deletedAt" is null AND
					oat."oAuthClientId" is not null AND
					(SELECT count (*) FROM  "___ORGANIZATION_ID___"."userOrganizationCredentials" uoc 
						WHERE uoc."userId" = oat."userId" AND uoc.type in (2, 8, 12)
					) = 0
			) AND
		"oAuthClientId" IS NOT NULL AND
		"deletedAt" IS NULL;
		
	UPDATE "___ORGANIZATION_ID___"."oAuthTokens"
	SET "deletedAt" = now()
	WHERE 
		"userId" = ANY(
			SELECT distinct("userId")
			FROM "___ORGANIZATION_ID___"."oAuthTokens" AS oat
				WHERE oat."deletedAt" is null AND
					oat."oAuthClientId" is not null AND
					(SELECT count (*) FROM  "___ORGANIZATION_ID___"."userOrganizationCredentials" uoc 
						WHERE uoc."userId" = oat."userId" AND uoc.type in (2, 8, 12)
					) = 0
			) AND
		"oAuthClientId" IS NOT NULL AND
		"deletedAt" IS NULL;
		
	ALTER TABLE "___ORGANIZATION_ID___".notification_instance_default 
		DISABLE TRIGGER after_insert_notification_instance_default;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
	-- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_o_auth_tokens()

	-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens();

	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
	DECLARE
		transaction_id	uuid;
		credential_exists	boolean;
		BEGIN
			transaction_id := uuid_generate_v4();
			IF (TG_OP = 'DELETE') THEN
				IF (OLD."deletedAt" IS NOT NULL AND OLD."oAuthClientId" IS NOT NULL) THEN
					DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
					WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
					-- 2 for BLE, 8 for NFC, 12 for QR
				END IF;
				RETURN OLD;
			ELSIF (TG_OP = 'UPDATE') THEN
				IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL AND NEW."oAuthClientId" IS NOT NULL) THEN
				-- delete credentials
					DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
					WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);
					RETURN NEW;
				ELSIF ((OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL AND NEW."oAuthClientId" IS NOT NULL) OR 
					(OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NULL AND OLD."oAuthClientId" IS NULL AND NEW."oAuthClientId" IS NOT NULL)) THEN
				-- delete old credentials
				-- insert new credentials
					DELETE FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
					WHERE uoc."userId" = OLD."userId" AND (uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12);

					INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 2, NEW."oAuthClientId", null, null, null,null, null,null ,null);

					INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 8, NEW."oAuthClientId", null, null, null,null, null,null ,null);

					INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 12, NEW."userId", null, null, null,null, null,null ,null);

					RETURN NEW;
				ELSE

				END IF;
			ELSIF (TG_OP = 'INSERT') THEN
				-- check existing credentials
				SELECT CASE WHEN (SELECT COUNT(*) AS C FROM
					"___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
					WHERE uoc."deletedAt" IS NULL AND
							uoc."userId" = NEW."userId" AND
							(uoc."type" = 2 OR uoc."type" = 8 OR uoc."type" = 12)) != 0 THEN true ELSE false END
				INTO credential_exists;
				-- if no credentials present, then create 2 credentials for BLE and NFC
				IF (credential_exists = false AND NEW."oAuthClientId" IS NOT NULL) THEN
					INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 2, NEW."oAuthClientId", null, null, null,null, null,null ,null);

					INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 8, NEW."oAuthClientId", null, null, null,null, null,null ,null);
				
				
					INSERT INTO "___ORGANIZATION_ID___"."userOrganizationCredentials"
					VALUES (uuid_generate_v4(), NEW."createdAt", now(), null, NEW."userId", ((NEW."organizationAuths"::json->>0)::json->>'i')::uuid, null, 12, NEW."userId", null, null, null,null, null,null ,null);

				END IF;
			END IF;
			RETURN NEW;
		END;
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens() TO ${dbuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens() TO PUBLIC;

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_o_auth_tokens() TO ${dbsuperuser};
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
