"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
    DROP TRIGGER add_recalculate_records_for_ppermission_change ON "___ORGANIZATION_ID___".ppermissions;
    DROP FUNCTION "___ORGANIZATION_ID___".add_recalculate_records_for_ppermission_change();

    CREATE FUNCTION "___ORGANIZATION_ID___".add_recalculate_records_for_ppermission_change()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    BEGIN
    IF (TG_OP = 'INSERT') THEN

        RETURN NEW;
    ELSIF (TG_OP = 'UPDATE') THEN
        IF ( tstzRange(OLD."startDateTime", OLD."endDateTime") = tstzRange(NEW."startDateTime", NEW."endDateTime") AND OLD."status" = NEW."status") THEN
            RETURN NEW;
        ELSE
            UPDATE "___ORGANIZATION_ID___"."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
            FROM "___ORGANIZATION_ID___"."userPPermissions" upp
            WHERE upp."ppermissionId" = NEW."id" AND eld."userId" = upp."userId" AND eld."organizationId" = NEW."organizationId"
            AND (NEW."startDateTime"::date <= now()::date OR OLD."startDateTime"::date <= now()::date)
            -- Make sure that status is newly approved or taken out from approved
            AND (((NEW."status" = 1 OR OLD."status" = 1) AND NEW."status" <> OLD."status")
                -- If the status did not change but is approved, check if the dates changed
                OR ((tstzRange(NEW."startDateTime", NEW."endDateTime") <> tstzRange(OLD."startDateTime", OLD."endDateTime"))AND NEW."status" = 1));

            INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
            (id, "userId", "organizationId", reason, "startDate")
            SELECT uuid_generate_v4(), upp."userId", NEW."organizationId", 16, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(NEW."startDateTime", NEW."endDateTime"))
            FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
            INNER JOIN "___ORGANIZATION_ID___"."workPlans" wp ON wp."id" = uwp."workPlanId"
            INNER JOIN "___ORGANIZATION_ID___"."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
            INNER JOIN "___ORGANIZATION_ID___"."userPPermissions" upp ON upp."ppermissionId" = NEW."id" AND uwp."userId" = upp."userId"
            INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" uo ON uwp."userId" = uo."userId" AND NEW."organizationId" = uo."organizationId"
                AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
            WHERE
            -- We need to make sure the new dates intersect with users work plan membership and workplan has a defined period for that range.
                NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(NEW."startDateTime", NEW."endDateTime"))
                -- Make sure that status is newly approved or taken out from approved
                AND (NEW."status" = 1 OR OLD."status" = 1);

            IF tstzRange(OLD."startDateTime", OLD."endDateTime") <> tstzRange(NEW."startDateTime", NEW."endDateTime") THEN
                INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
                (id, "userId", "organizationId", reason, "startDate")
                SELECT uuid_generate_v4(), upp."userId", NEW."organizationId", 16,
                    LOWER(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(LEAST(OLD."startDateTime", NEW."startDateTime"), GREATEST(OLD."endDateTime", NEW."endDateTime")))
                FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
                INNER JOIN "___ORGANIZATION_ID___"."workPlans" wp ON wp."id" = uwp."workPlanId"
                INNER JOIN "___ORGANIZATION_ID___"."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
                INNER JOIN "___ORGANIZATION_ID___"."userPPermissions" upp ON upp."ppermissionId" = NEW."id" AND uwp."userId" = upp."userId"
                INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" uo ON uwp."userId" = uo."userId" AND OLD."organizationId" = uo."organizationId"
                    AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
                WHERE 
                -- We need to make sure the old dates intersect with users work plan membership and workplan has a defined period for that range.
                    NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(LEAST(OLD."startDateTime", NEW."startDateTime"), GREATEST(OLD."endDateTime", NEW."endDateTime")))
                    -- Make sure that status is newly approved or taken out from approved
                    AND (NEW."status" = 1 OR OLD."status" = 1);
            END IF;
        END IF;
        RETURN NEW;
    ELSIF (TG_OP = 'DELETE') THEN
        UPDATE "___ORGANIZATION_ID___"."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
        FROM "___ORGANIZATION_ID___"."userPPermissions" upp
        WHERE upp."ppermissionId" = OLD."id" AND eld."userId" = upp."userId" AND eld."organizationId" = OLD."organizationId"
        AND OLD."startDateTime"::date <= now()::date
        -- Make sure that status is newly approved or taken out from approved
        AND OLD."status" = 1;

        INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
        (id, "userId", "organizationId", reason, "startDate")
        SELECT uuid_generate_v4(), upp."userId", OLD."organizationId", 16, lower(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(OLD."startDateTime", OLD."endDateTime"))
        FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
        INNER JOIN "___ORGANIZATION_ID___"."workPlans" wp ON wp."id" = uwp."workPlanId"
        INNER JOIN "___ORGANIZATION_ID___"."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
        INNER JOIN "___ORGANIZATION_ID___"."userPPermissions" upp ON upp."ppermissionId" = OLD."id" AND uwp."userId" = upp."userId"
        INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" uo ON uwp."userId" = uo."userId" AND OLD."organizationId" = uo."organizationId"
            AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
        WHERE 
        -- We need to make sure the old dates intersect with users work plan membership and workplan has a defined period for that range.
            NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(OLD."startDateTime", OLD."endDateTime"))
            -- Make sure that status is newly approved or taken out from approved
            AND OLD."status" = 1;

        RETURN OLD;
    END IF;
    END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".add_recalculate_records_for_ppermission_change()
        OWNER TO postgres;
        
    CREATE TRIGGER add_recalculate_records_for_ppermission_change
    BEFORE DELETE OR UPDATE 
    ON "___ORGANIZATION_ID___".ppermissions
    FOR EACH ROW
    EXECUTE PROCEDURE "___ORGANIZATION_ID___".add_recalculate_records_for_ppermission_change();
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) { }
exports.down = down;
