"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = ` ALTER TABLE "___ORGANIZATION_ID___".organizations 
                        DROP COLUMN IF EXISTS "smtpOptions", 
                        DROP COLUMN IF EXISTS "emailAddresses", 
                        DROP COLUMN IF EXISTS "scheduledJobParameters";
                        
                    ALTER TABLE "___ORGANIZATION_ID___".organizations 
                        ADD COLUMN IF NOT EXISTS "smsBalance" INTEGER DEFAULT 0;
                        `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = ` ALTER TABLE "___ORGANIZATION_ID___".organizations 
    ADD COLUMN IF NOT EXISTS "smtpOptions" json, 
    ADD COLUMN IF NOT EXISTS "emailAddresses" json, 
    DROP COLUMN IF EXISTS "scheduledJobParameters";
    
    ALTER TABLE "___ORGANIZATION_ID___".organizations 
        DROP COLUMN IF EXISTS "smsBalance";
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
