"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const publicQuery = `
        DROP FUNCTION IF EXISTS public.before_up_in_del_camera_actions ;
        DROP FUNCTION IF EXISTS public.before_up_in_delete_user_group_access_rule_sets ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_user_access_rights ;
        DROP FUNCTION IF EXISTS public.add_recalculate_records_for_user_ppermission_add_delete ;
        DROP FUNCTION IF EXISTS public.after_insert_terminal_change ;
        DROP FUNCTION IF EXISTS public.after_insert_terminal_transaction ;
        DROP FUNCTION IF EXISTS public.before_insert_terminal_change ;
        DROP FUNCTION IF EXISTS public.before_up_del_regions ;
        DROP FUNCTION IF EXISTS public.before_up_del_user ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_device_dry_contact_inputs ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_user_forbiddances ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_user_group_mapping ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_user_region_ticket_unit ;
        DROP FUNCTION IF EXISTS public.before_update_access_control_point ;
        DROP FUNCTION IF EXISTS public.before_up_in_delete_region_tickets ;
        DROP FUNCTION IF EXISTS public.update_terminaladmins ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_region_access_control_points ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_user_access_notification ;
        DROP FUNCTION IF EXISTS public.add_recalculate_records_for_ppermission_change ;
        DROP FUNCTION IF EXISTS public.add_recalculate_records_for_vacation_change ;
        DROP FUNCTION IF EXISTS public.after_in_up_del_anti_passback_state ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_o_auth_tokens ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_user_organization_sensor_notifications ;
        DROP FUNCTION IF EXISTS public.before_up_del_user_organizations ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_camera ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_device_readers ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_device_relays ;
        DROP FUNCTION IF EXISTS public.before_up_in_del_user_organization_credentials ;
        DROP FUNCTION IF EXISTS public.before_up_in_delete_access_rule_sets ;
        DROP FUNCTION IF EXISTS public.before_up_in_delete_access_rules ;
        DROP FUNCTION IF EXISTS public.before_up_in_user_rule_history ;
        DROP FUNCTION IF EXISTS public.before_update_devices ;
        DROP FUNCTION IF EXISTS public.gen_profile_text ;
        DROP FUNCTION IF EXISTS public.notify_pacs_live_recalculation CASCADE;
        DROP FUNCTION IF EXISTS public.process_recalculate_work_queue_start_date_time ;
        DROP FUNCTION IF EXISTS public.fauthorizeuserfor ;
        DROP FUNCTION IF EXISTS public.fgetorganizationunitdetailed ;
        DROP FUNCTION IF EXISTS public.fcollectusersforaccessreportfilter ;
        DROP FUNCTION IF EXISTS public.disable_trigger ;`;
    await client.query(publicQuery);
    const query = `
    
    UPDATE "___ORGANIZATION_ID___".organizations
        SET settings = settings || '{"userExpression": 1}'::jsonb;

    ALTER TABLE "___ORGANIZATION_ID___".notification_access ALTER COLUMN "targetUserId" DROP NOT NULL;
    ALTER TABLE "___ORGANIZATION_ID___".zz_notification_access ALTER COLUMN "targetUserId" DROP NOT NULL;

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".fgetorganizationunitdetailed(
        organization_id uuid,
        organization_unit_id uuid,
        is_system_administrator boolean,
        user_id uuid)
        RETURNS json
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE PARALLEL UNSAFE
        AS $BODY$
        DECLARE 
                _ri RECORD;
                _ji JSON;
                _result JSON;
                _parent JSON;
                _defaultAccessControlPoints JSON[];
            BEGIN	
            _result = null;
            _defaultAccessControlPoints = ARRAY[]::JSON[];
            
            SELECT json_build_object(
            'id', ou."id",
            'name', ou."name",
            'typeId', ou."typeId",
            'typeDefinition', oud.value,
            'ancestorIds', CASE WHEN ou."ancestorIds" = '[]' OR ou."ancestorIds" = '' OR ou."ancestorIds" IS null THEN ARRAY[]::uuid[] 
                        ELSE regexp_split_to_array(ou."ancestorIds", E',')::uuid[] END,
            'shortCode', ou."shortCode",
            'parent', CASE WHEN ou."parentId" IS NULL THEN NULL ELSE ( 
                SELECT json_build_object('id', pou."id", 'name', pou."name",
                'typeId', pou."typeId", 
                'typeDefinition', poud.value,
                'ancestorIds', CASE WHEN pou."ancestorIds" = '[]' OR pou."ancestorIds" = '' OR pou."ancestorIds" IS NULL THEN ARRAY[]::uuid[] 
                        ELSE regexp_split_to_array(pou."ancestorIds", E',')::uuid[] END,
                        'shortCode', pou."shortCode",
                        'parentId', pou."parentId"
                ) FROM "___ORGANIZATION_ID___"."organizationUnits" AS pou
                INNER JOIN "___ORGANIZATION_ID___"."organizationUserDefinedListValues" AS poud ON pou."typeId" = poud.id
                WHERE pou."id" = ou."parentId" AND pou."deletedAt" IS NULL) END,
                'defaultAccessControlPoints', ARRAY[]::JSON[]	
            )
            INTO _result 
            FROM "___ORGANIZATION_ID___"."organizationUnits" AS ou 
            INNER JOIN "___ORGANIZATION_ID___"."organizationUserDefinedListValues" AS oud ON ou."typeId" = oud.id
            WHERE ou."organizationId" = organization_id AND ou."id" = organization_unit_id AND ou."deletedAt" IS NULL;
            
            FOR _ri IN
            SELECT 
                acp."id", acp."name", acp."location", acp."remoteAvailable", acp."isRemoteDefault", acp."accessControlPointType" AS "type",
                (CASE WHEN uar."id" IS NULL AND is_system_administrator = FALSE THEN FALSE ELSE TRUE END) AS "managable", oudacp."defaultPrivileges"
            FROM "___ORGANIZATION_ID___"."organizationUnitDefaultAccessControlPoints" AS oudacp
            INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = oudacp."accessControlPointId"
            LEFT OUTER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = user_id AND uar."accessControlPointId" = acp."id" AND uar."deletedAt" IS NULL
            WHERE oudacp."deletedAt" IS NULL AND oudacp."organizationUnitId" = organization_unit_id AND acp."deletedAt" IS NULL
            ORDER BY acp."name"
            LOOP
                _defaultAccessControlPoints = _defaultAccessControlPoints || to_json(_ri);
            END LOOP;
            
            IF _result IS NULL
            THEN
                RAISE EXCEPTION '%', json_build_object('code', 404, 'message', 'The organization unit is not found!');
            END IF;
            
            SELECT json_append(_result, json_build_object('defaultAccessControlPoints', _defaultAccessControlPoints)) INTO _result;
                
            RETURN _result;
            END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".fgetorganizationunitdetailed(uuid, uuid, boolean, uuid)
        OWNER TO ${dbsuperuser};

        DROP TRIGGER IF EXISTS notify_pacs_live_recalculation_trigger
        ON "___ORGANIZATION_ID___"."employeeLiveDay";

        CREATE TRIGGER notify_pacs_live_recalculation_trigger
            AFTER UPDATE 
            ON "___ORGANIZATION_ID___"."employeeLiveDay"
            REFERENCING NEW TABLE AS newtab OLD TABLE AS oldtab
            FOR EACH STATEMENT
            EXECUTE FUNCTION "___ORGANIZATION_ID___".notify_pacs_live_recalculation();

    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
