"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const uuid = __importStar(require("uuid"));
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    const query = `
    
    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."accessControlPoints"
    ADD COLUMN IF NOT EXISTS "geoLocation" jsonb;

    CREATE TABLE IF NOT EXISTS "___ORGANIZATION_ID___".access_point_qr_code(
            id uuid NOT NULL,
            "accessPointId" uuid NOT NULL,
            "qrCodeData" character varying(255) UNIQUE NOT NULL,
            config jsonb NOT NULL,
            "remoteRelayId" uuid NULL,
            CONSTRAINT access_point_qr_code_pkey PRIMARY KEY (id),
            CONSTRAINT ap_qr_code_ap_id_aps_id_fkey FOREIGN KEY ("accessPointId")
                REFERENCES "___ORGANIZATION_ID___"."accessControlPoints" (id) MATCH SIMPLE
                ON UPDATE CASCADE
                ON DELETE CASCADE,
			CONSTRAINT ap_qr_code_remote_relay_id_fkey FOREIGN KEY ("remoteRelayId")
				REFERENCES "___ORGANIZATION_ID___"."deviceRelays" (id) MATCH SIMPLE
				ON UPDATE CASCADE
				ON DELETE CASCADE
        )
        TABLESPACE pg_default;

	ALTER TABLE "___ORGANIZATION_ID___"."access_point_qr_code"
		OWNER to ${dbsuperuser};
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    const organizationIds = (await client.query(` SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}";`)).rows.map((r) => r.id);
    if (organizationIds && organizationIds.length) {
        for (const organizationId of organizationIds) {
            const { rows, rowCount } = await client.query(`
            SELECT "stickerId", "accessControlPointId", "accessDirection" FROM "${organizationId}"."stickerAccessControlPointMappings"`);
            if (rowCount === 0) {
                continue;
            }
            for (const row of rows) {
                await client.query(`INSERT INTO "${organizationId}".access_point_qr_code
            (id, "accessPointId", "qrCodeData", config) VALUES ($1, $2, $3, $4)`, [
                    uuid.v4(),
                    row.accessControlPointId,
                    "rq/" + row.stickerId + "/" + row.accessDirection,
                    {
                        d: row.accessDirection ?? 0,
                        t: {
                            t: 2,
                            v: false,
                        },
                    },
                ]);
                await client.query(`DROP TABLE IF EXISTS "${organizationId}"."stickerAccessControlPointMappings"`);
            }
        }
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
    
    ALTER TABLE IF EXISTS "___ORGANIZATION_ID___"."accessControlPoints"
    DROP COLUMN IF EXISTS "geoLocation";

    CREATE TABLE IF NOT EXISTS "___ORGANIZATION_ID___"."stickerAccessControlPointMappings"
    (
        "stickerId" uuid NOT NULL,
        "accessControlPointId" uuid NOT NULL,
        "accessDirection" integer NOT NULL,
        CONSTRAINT "stickerAccessControlPointMappings_pkey" PRIMARY KEY ("stickerId"),
        CONSTRAINT "stickerAccessControlPointMappings_accessControlPointId_fkey" FOREIGN KEY ("accessControlPointId")
            REFERENCES "___ORGANIZATION_ID___"."accessControlPoints" (id) MATCH SIMPLE
            ON UPDATE CASCADE
            ON DELETE CASCADE,
        CONSTRAINT "stickerAccessControlPointMappings_accessDirection_check" CHECK ("accessDirection" = ANY (ARRAY[0, 1, 2]))
    )

    TABLESPACE pg_default;

    ALTER TABLE "___ORGANIZATION_ID___"."stickerAccessControlPointMappings"
        OWNER to ${dbsuperuser};
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    const organizationIds = (await client.query(` SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}";`)).rows.map((r) => r.id);
    if (organizationIds && organizationIds.length) {
        for (const organizationId of organizationIds) {
            await client.query(`INSERT INTO "${organizationId}"."notification"
		(id, "createdT", "createdByUserId", type, "receiverFilterId", settings, email, sms, web, "pushNotification") 
		VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10)`, [uuid.v4(), new Date(), null, 42, null, null, false, false, false, true]);
        }
    }
}
exports.down = down;
