"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dbLogger = exports.DBlogger = void 0;
const path_1 = __importDefault(require("path"));
const winston_1 = __importDefault(require("winston"));
const app_config_1 = require("../app.config");
class DBLogger {
    constructor() {
        this.logger = winston_1.default.createLogger({
            exitOnError: false,
            format: winston_1.default.format.combine(winston_1.default.format.splat(), winston_1.default.format.timestamp({
                format: "YYYY-MM-DD HH:mm:ss",
            }), winston_1.default.format.printf((error) => {
                return `[${error.timestamp}][${error.level}]${error.message}`;
            })),
            transports: [
                new winston_1.default.transports.Console({
                    level: "debug",
                }),
            ],
        });
        exports.dbLogger = this.logger;
    }
    init(logDirectory) {
        this.logger.add(new (require("winston-daily-rotate-file"))({
            filename: path_1.default.join(logDirectory, "%DATE%.db.log"),
            timestamp: () => new Date().toLocaleTimeString(),
            datePattern: "YYYY-MM-DD",
            prepend: true,
            level: app_config_1.appConfig.log.db.level || "error",
            handleExceptions: true,
            humanReadableUnhandledException: true,
        }));
        exports.dbLogger = this.logger;
    }
}
exports.DBlogger = new DBLogger();
