"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DalConstants = void 0;
const libAccessModels = __importStar(require("../lib/access-model"));
const dynamicFormCurrent_1 = require("../lib/es/models/dynamicFormCurrent");
const restapi_1 = require("../lib/es/models/restapi");
var DalConstants;
(function (DalConstants) {
    DalConstants.DefaultAvatar = "data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAMCAgICAgMCAgIDAwMDBAYEBAQEBAgGBgUGCQgKCgkICQkKDA8MCgsOCwkJDRENDg8QEBEQCgwSExIQEw8QEBD/2wBDAQMDAwQDBAgEBAgQCwkLEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBD/wAARCAAwADADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD9PaKKiu3aO1ldDhlQkH04oAq3WsQW7mNFMrDg4OAPxotdXguHEboY2bgZOQT9awaKAOtoqK0dpLWJ3OWZASfXipaAChlDKVYZBGCKKzrzWI4SY7dRI46k/dH+NAFK60i4icmBTJGemOo+tFrpFxK4M6mOMdc9T9Kik1S+kJPnlfZQBQmqX0ZB88t7MAaAOjACgKBgDgUVnWesRzER3CiNz0I+6f8ACtGgCG9JFnMQcHYf5VzFdVNGJoniJwHUrmsz+wP+nv8A8h//AF6AMiitf+wP+nv/AMh//Xo/sD/p7/8AIf8A9egDIrp7Ik2cJJydg/lWf/YH/T3/AOQ//r1pwxiGJIgchFC5oA//2Q==";
    DalConstants.imageThatUsedForArchivedData = "data:image/png;base64,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";
    DalConstants.defaultMobileAcpId = "06ba5170-d827-4ced-b356-f2e99afd3971";
    DalConstants.defaultArventoDriverAcpId = "336c2674-c66d-4359-a183-aac71be9e96a";
    DalConstants.SystemUserId = "9bdadbac-8f52-4f76-af3f-b54cf6b8f772";
    DalConstants.SystemUserName = "System";
    DalConstants.excelContentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    DalConstants.pdfContentType = "application/pdf";
    DalConstants.csvContentType = "text/csv";
    DalConstants.pngContentType = "image/png";
    DalConstants.helpDocumentId = "ebc8a278-083a-4567-b3ec-5241940a1066";
    DalConstants.SpecialRegionTicketNumber = -32768;
    DalConstants.armonPublicKey = "BH88QHS2nKyCdmPhygloC42sBssw8J5abri3Uxh7KTW9Bd/4tqwOBTb+ywlM9j+GPrAkhZMt/rE3I5Nynwn9M7s=";
    DalConstants.armonPrivateKey = "hse7eYZ7/MHOf76RNLhPv7IXxTEyw6z0dp8Olph6LnA=";
    DalConstants.maxDate = new Date(2099, 1, 1);
    DalConstants.minDate = new Date(1970, 1, 1);
    DalConstants.applicationModuleLimitExceedPercentageDefault = 10000;
    DalConstants.terminalBrands = [libAccessModels.V2.Enums.DeviceBrand.Armon, libAccessModels.V2.Enums.DeviceBrand.AssaAbloy, libAccessModels.V2.Enums.DeviceBrand.HikVision];
    DalConstants.terminalModels = ["M3", "V10", "AH40", "DS-K1T606MF", "DS-K1T804MF", "V6", "M5", "VPass", "V7", "S1"];
    DalConstants.batteryPoweredDeviceModels = ["H100", "L100", "C100", "KS100"];
    DalConstants.SupportedLocalesList = ["en", "tr"];
    DalConstants.SupportedLocales = {
        English: "en",
        Turkish: "tr",
    };
    DalConstants.scheduledJobTriggerNotifications = [
        restapi_1.NotificationType.ScheduledReport,
        restapi_1.NotificationType.PACSSelfAbsentEmployee,
        restapi_1.NotificationType.PACSSelfMissingWork,
        restapi_1.NotificationType.PPermissionWaitForSignatureReminder,
        restapi_1.NotificationType.PACSSelfOverworkedEmployee,
    ];
    DalConstants.eventTriggeredNotifications = [
        restapi_1.NotificationType.TerminalConnected,
        restapi_1.NotificationType.TerminalDisconnected,
        restapi_1.NotificationType.TerminalEmergencyStarted,
        restapi_1.NotificationType.TerminalEmergencyStopped,
        restapi_1.NotificationType.VisitorCame,
        restapi_1.NotificationType.VisitorInvitation,
        restapi_1.NotificationType.Announcement,
        restapi_1.NotificationType.CounterSensor,
        restapi_1.NotificationType.StatusSensor,
        restapi_1.NotificationType.EmploymentEnd,
        restapi_1.NotificationType.NewFeedback,
        restapi_1.NotificationType.FeedbackUpdate,
        restapi_1.NotificationType.HugeReport,
        restapi_1.NotificationType.IdentityAccess,
        restapi_1.NotificationType.NewFeedback,
        restapi_1.NotificationType.PPermissionApprovementToOwner,
        restapi_1.NotificationType.PPermissionWaitForApprovementToApprover,
        restapi_1.NotificationType.PPermissionWaitForSignature,
        restapi_1.NotificationType.RegionEmergencyStart,
        restapi_1.NotificationType.RegionEmergencyStopped,
        restapi_1.NotificationType.DoorOpenedByForce,
        restapi_1.NotificationType.ReportServiceError,
        restapi_1.NotificationType.AccessPointQrCodeUpdatedToUser,
        restapi_1.NotificationType.DeviceWasNotInformed,
        restapi_1.NotificationType.LicenseLimitReached,
        restapi_1.NotificationType.AccountCreated,
        restapi_1.NotificationType.AssaAbloyDeviceBatteryStatusChanged,
        restapi_1.NotificationType.VisitorExcelImportResultNotification,
        restapi_1.NotificationType.SMSBalance,
        restapi_1.NotificationType.WorkPlanExcelImportResultNotification,
        restapi_1.NotificationType.AccessLogExcelImportResultNotification,
        restapi_1.NotificationType.Custom,
    ];
    DalConstants.receiverFilterDeterminedWhenNotificationGenerated = [
        restapi_1.NotificationType.ScheduledReport,
        restapi_1.NotificationType.CounterSensor,
        restapi_1.NotificationType.StatusSensor,
        restapi_1.NotificationType.IdentityAccess,
        restapi_1.NotificationType.PACSSelfAbsentEmployee,
        restapi_1.NotificationType.PACSSelfMissingWork,
        restapi_1.NotificationType.VisitorExcelImportResultNotification,
        restapi_1.NotificationType.PACSSelfOverworkedEmployee,
    ];
    DalConstants.editableScheduledJobs = [
        19,
        32,
        31,
        49,
    ];
    DalConstants.organizationBaseModuleNotificationTypesWithSingleInstances = [
        restapi_1.NotificationType.Announcement,
        restapi_1.NotificationType.DoorOpenedByForce,
        restapi_1.NotificationType.FeedbackUpdate,
        restapi_1.NotificationType.HugeReport,
        restapi_1.NotificationType.NewFeedback,
        restapi_1.NotificationType.RegionEmergencyStart,
        restapi_1.NotificationType.RegionEmergencyStopped,
        restapi_1.NotificationType.ReportServiceError,
        restapi_1.NotificationType.TerminalConnected,
        restapi_1.NotificationType.TerminalDisconnected,
        restapi_1.NotificationType.TerminalEmergencyStarted,
        restapi_1.NotificationType.TerminalEmergencyStopped,
        restapi_1.NotificationType.EmploymentEnd,
        restapi_1.NotificationType.AccessPointQrCodeUpdatedToUser,
        restapi_1.NotificationType.DeviceWasNotInformed,
        restapi_1.NotificationType.LicenseLimitReached,
        restapi_1.NotificationType.AccountCreated,
        restapi_1.NotificationType.AssaAbloyDeviceBatteryStatusChanged,
        restapi_1.NotificationType.VisitorExcelImportResultNotification,
        restapi_1.NotificationType.SMSBalance,
        restapi_1.NotificationType.SendingVerificationToken,
        restapi_1.NotificationType.AccessLogExcelImportResultNotification,
    ];
    DalConstants.organizationBaseModuleNotificationTypes = [
        ...DalConstants.organizationBaseModuleNotificationTypesWithSingleInstances,
        restapi_1.NotificationType.IdentityAccess,
        restapi_1.NotificationType.SelfIdentityAccess,
        restapi_1.NotificationType.CounterSensor,
        restapi_1.NotificationType.StatusSensor,
        restapi_1.NotificationType.ScheduledReport,
        restapi_1.NotificationType.Custom,
    ];
    DalConstants.organizationPACSModuleNotificationTypesWithSingleInstances = [
        restapi_1.NotificationType.PPermissionApprovementToOwner,
        restapi_1.NotificationType.PPermissionWaitForApprovementToApprover,
        restapi_1.NotificationType.PPermissionWaitForSignature,
        restapi_1.NotificationType.PPermissionWaitForSignatureReminder,
        restapi_1.NotificationType.WorkPlanExcelImportResultNotification,
    ];
    DalConstants.organizationPACSModuleNotificationTypes = [
        ...DalConstants.organizationPACSModuleNotificationTypesWithSingleInstances,
        restapi_1.NotificationType.PACSSelfAbsentEmployee,
        restapi_1.NotificationType.PACSSelfMissingWork,
        restapi_1.NotificationType.PACSSelfOverworkedEmployee,
    ];
    DalConstants.organizationVisitorModuleNotificationTypes = [
        restapi_1.NotificationType.VisitorInvitation,
        restapi_1.NotificationType.VisitorCame,
        restapi_1.NotificationType.VisitorExcelImportResultNotification,
    ];
    DalConstants.libEnumsV1 = libAccessModels.V1.Enums;
    DalConstants.libConstsV1 = libAccessModels.V1.Consts;
    DalConstants.libEnumsV2 = libAccessModels.V2.Enums;
    DalConstants.libConstsV2 = libAccessModels.V2.Consts;
    DalConstants.libEnumsV3 = libAccessModels.V3.Enums;
    DalConstants.libConstsV3 = libAccessModels.V3.Consts;
    DalConstants.NotificationType = restapi_1.NotificationType;
    DalConstants.GeoLocationType = restapi_1.GeoLocationType;
    DalConstants.SoftwareUpdateInterfaceState = restapi_1.SoftwareUpdateInterfaceState;
    DalConstants.ServerConnectionCommand = restapi_1.ServerConnectionCommand;
    DalConstants.TerminalAction = restapi_1.TerminalAction;
    DalConstants.UserSelectionSessionAccessControlPointRightScope = restapi_1.UserSelectionSessionAccessControlPointRightScope;
    DalConstants.ArmonApplicationModule = restapi_1.ArmonApplicationModule;
    let ReportFormat;
    (function (ReportFormat) {
        ReportFormat[ReportFormat["Excel"] = 1] = "Excel";
        ReportFormat[ReportFormat["Pdf"] = 2] = "Pdf";
        ReportFormat[ReportFormat["Csv"] = 3] = "Csv";
    })(ReportFormat = DalConstants.ReportFormat || (DalConstants.ReportFormat = {}));
    let PacsWorkplanPeriodRoutineTypes;
    (function (PacsWorkplanPeriodRoutineTypes) {
        PacsWorkplanPeriodRoutineTypes[PacsWorkplanPeriodRoutineTypes["Day"] = 1] = "Day";
        PacsWorkplanPeriodRoutineTypes[PacsWorkplanPeriodRoutineTypes["Week"] = 2] = "Week";
    })(PacsWorkplanPeriodRoutineTypes = DalConstants.PacsWorkplanPeriodRoutineTypes || (DalConstants.PacsWorkplanPeriodRoutineTypes = {}));
    let SegmentConflictItemType;
    (function (SegmentConflictItemType) {
        SegmentConflictItemType[SegmentConflictItemType["Holiday"] = 1] = "Holiday";
        SegmentConflictItemType[SegmentConflictItemType["Permission"] = 2] = "Permission";
    })(SegmentConflictItemType = DalConstants.SegmentConflictItemType || (DalConstants.SegmentConflictItemType = {}));
    let WorkSummarySortType;
    (function (WorkSummarySortType) {
        WorkSummarySortType[WorkSummarySortType["Name"] = 1] = "Name";
        WorkSummarySortType[WorkSummarySortType["UniqueId"] = 2] = "UniqueId";
        WorkSummarySortType[WorkSummarySortType["LateStart"] = 3] = "LateStart";
        WorkSummarySortType[WorkSummarySortType["EarylLeave"] = 4] = "EarylLeave";
        WorkSummarySortType[WorkSummarySortType["FirstStart"] = 5] = "FirstStart";
        WorkSummarySortType[WorkSummarySortType["LastLeave"] = 6] = "LastLeave";
        WorkSummarySortType[WorkSummarySortType["ExtraWork"] = 7] = "ExtraWork";
        WorkSummarySortType[WorkSummarySortType["MissingWork"] = 8] = "MissingWork";
        WorkSummarySortType[WorkSummarySortType["Date"] = 9] = "Date";
    })(WorkSummarySortType = DalConstants.WorkSummarySortType || (DalConstants.WorkSummarySortType = {}));
    let BreakMethod;
    (function (BreakMethod) {
        BreakMethod[BreakMethod["Fixed"] = 1] = "Fixed";
        BreakMethod[BreakMethod["Claim"] = 2] = "Claim";
        BreakMethod[BreakMethod["ExtraWork"] = 3] = "ExtraWork";
    })(BreakMethod = DalConstants.BreakMethod || (DalConstants.BreakMethod = {}));
    let BreakUsedDurationType;
    (function (BreakUsedDurationType) {
        BreakUsedDurationType[BreakUsedDurationType["Automatically"] = 1] = "Automatically";
        BreakUsedDurationType[BreakUsedDurationType["Manually"] = 2] = "Manually";
    })(BreakUsedDurationType = DalConstants.BreakUsedDurationType || (DalConstants.BreakUsedDurationType = {}));
    let BreakType;
    (function (BreakType) {
        BreakType[BreakType["Lunch"] = 1] = "Lunch";
        BreakType[BreakType["Dinner"] = 2] = "Dinner";
        BreakType[BreakType["Free"] = 3] = "Free";
        BreakType[BreakType["Custom"] = 0] = "Custom";
    })(BreakType = DalConstants.BreakType || (DalConstants.BreakType = {}));
    let SortField;
    (function (SortField) {
        SortField[SortField["Date"] = 1] = "Date";
        SortField[SortField["UserName"] = 2] = "UserName";
        SortField[SortField["AccessControlPoint"] = 3] = "AccessControlPoint";
    })(SortField = DalConstants.SortField || (DalConstants.SortField = {}));
    let SortType;
    (function (SortType) {
        SortType[SortType["Descending"] = 1] = "Descending";
        SortType[SortType["Ascending"] = 2] = "Ascending";
    })(SortType = DalConstants.SortType || (DalConstants.SortType = {}));
    let DataFieldType;
    (function (DataFieldType) {
        DataFieldType[DataFieldType["String"] = 0] = "String";
        DataFieldType[DataFieldType["Integer"] = 1] = "Integer";
        DataFieldType[DataFieldType["Boolean"] = 2] = "Boolean";
        DataFieldType[DataFieldType["Date"] = 3] = "Date";
    })(DataFieldType = DalConstants.DataFieldType || (DalConstants.DataFieldType = {}));
    let NewDataCacheType;
    (function (NewDataCacheType) {
        NewDataCacheType[NewDataCacheType["CredentialOwner"] = 1] = "CredentialOwner";
        NewDataCacheType[NewDataCacheType["AccessPoint"] = 2] = "AccessPoint";
        NewDataCacheType[NewDataCacheType["UserBadge"] = 3] = "UserBadge";
        NewDataCacheType[NewDataCacheType["Region"] = 4] = "Region";
        NewDataCacheType[NewDataCacheType["UserNotificiation"] = 5] = "UserNotificiation";
        NewDataCacheType[NewDataCacheType["DeviceState"] = 6] = "DeviceState";
        NewDataCacheType[NewDataCacheType["DeviceNotificationInfo"] = 7] = "DeviceNotificationInfo";
        NewDataCacheType[NewDataCacheType["CameraProxyTerminal"] = 8] = "CameraProxyTerminal";
        NewDataCacheType[NewDataCacheType["HashedNotification"] = 9] = "HashedNotification";
        NewDataCacheType[NewDataCacheType["Organization"] = 10] = "Organization";
        NewDataCacheType[NewDataCacheType["DeviceRabbitMQConnectionName"] = 11] = "DeviceRabbitMQConnectionName";
        NewDataCacheType[NewDataCacheType["SnapshotSettings"] = 12] = "SnapshotSettings";
        NewDataCacheType[NewDataCacheType["ShiftRule"] = 13] = "ShiftRule";
    })(NewDataCacheType = DalConstants.NewDataCacheType || (DalConstants.NewDataCacheType = {}));
    let AccessLogSourceType;
    (function (AccessLogSourceType) {
        AccessLogSourceType[AccessLogSourceType["PhysicalAccess"] = 1] = "PhysicalAccess";
        AccessLogSourceType[AccessLogSourceType["Estimated"] = 2] = "Estimated";
        AccessLogSourceType[AccessLogSourceType["PPermissionDeclared"] = 3] = "PPermissionDeclared";
        AccessLogSourceType[AccessLogSourceType["Manuel"] = 4] = "Manuel";
    })(AccessLogSourceType = DalConstants.AccessLogSourceType || (DalConstants.AccessLogSourceType = {}));
    let AccessControlPointType;
    (function (AccessControlPointType) {
        AccessControlPointType[AccessControlPointType["Door"] = 0] = "Door";
        AccessControlPointType[AccessControlPointType["DropArmTripotTurnstile"] = 1] = "DropArmTripotTurnstile";
        AccessControlPointType[AccessControlPointType["ParkingGate"] = 2] = "ParkingGate";
        AccessControlPointType[AccessControlPointType["Barrier"] = 3] = "Barrier";
        AccessControlPointType[AccessControlPointType["Elevator"] = 4] = "Elevator";
        AccessControlPointType[AccessControlPointType["SecurityGate"] = 5] = "SecurityGate";
        AccessControlPointType[AccessControlPointType["TurnstileGate"] = 6] = "TurnstileGate";
        AccessControlPointType[AccessControlPointType["TripotTurnstile"] = 7] = "TripotTurnstile";
        AccessControlPointType[AccessControlPointType["AttendanceControl"] = 8] = "AttendanceControl";
        AccessControlPointType[AccessControlPointType["TicketControl"] = 9] = "TicketControl";
        AccessControlPointType[AccessControlPointType["VirtualMobileCheckin"] = 10] = "VirtualMobileCheckin";
    })(AccessControlPointType = DalConstants.AccessControlPointType || (DalConstants.AccessControlPointType = {}));
    let RegionState;
    (function (RegionState) {
        RegionState[RegionState["In"] = 1] = "In";
        RegionState[RegionState["Out"] = 2] = "Out";
    })(RegionState = DalConstants.RegionState || (DalConstants.RegionState = {}));
    let RegionReportSortType;
    (function (RegionReportSortType) {
        RegionReportSortType[RegionReportSortType["NameSurname"] = 1] = "NameSurname";
        RegionReportSortType[RegionReportSortType["LastAction"] = 2] = "LastAction";
        RegionReportSortType[RegionReportSortType["AccessControlPointName"] = 3] = "AccessControlPointName";
        RegionReportSortType[RegionReportSortType["State"] = 4] = "State";
    })(RegionReportSortType = DalConstants.RegionReportSortType || (DalConstants.RegionReportSortType = {}));
    let EmergencyState;
    (function (EmergencyState) {
        EmergencyState[EmergencyState["Normal"] = 1] = "Normal";
        EmergencyState[EmergencyState["Emergency"] = 2] = "Emergency";
    })(EmergencyState = DalConstants.EmergencyState || (DalConstants.EmergencyState = {}));
    DalConstants.AccessDirection = DalConstants.libEnumsV2.AccessDirection;
    DalConstants.DryContactTypeV2 = DalConstants.libEnumsV2.DryContactType;
    DalConstants.DryContactType = DalConstants.libEnumsV1.DryContactType;
    DalConstants.NotificationSensorType = DalConstants.libEnumsV2.NotificationSensorType;
    DalConstants.StatusSensorReason = DalConstants.libEnumsV2.StatusSensorReason;
    DalConstants.CounterSensorReason = DalConstants.libEnumsV2.CounterSensorReason;
    let DevicePowerState;
    (function (DevicePowerState) {
        DevicePowerState[DevicePowerState["NoInfo"] = 1] = "NoInfo";
        DevicePowerState[DevicePowerState["OnPower"] = 2] = "OnPower";
        DevicePowerState[DevicePowerState["OnBattery"] = 3] = "OnBattery";
    })(DevicePowerState = DalConstants.DevicePowerState || (DalConstants.DevicePowerState = {}));
    let TerminalWarningLevel;
    (function (TerminalWarningLevel) {
        TerminalWarningLevel[TerminalWarningLevel["Critical"] = 1] = "Critical";
        TerminalWarningLevel[TerminalWarningLevel["High"] = 2] = "High";
        TerminalWarningLevel[TerminalWarningLevel["Medium"] = 3] = "Medium";
    })(TerminalWarningLevel = DalConstants.TerminalWarningLevel || (DalConstants.TerminalWarningLevel = {}));
    let TerminalWarningType;
    (function (TerminalWarningType) {
        TerminalWarningType[TerminalWarningType["ConnectionLost"] = 1] = "ConnectionLost";
        TerminalWarningType[TerminalWarningType["TemperatureHigh"] = 2] = "TemperatureHigh";
        TerminalWarningType[TerminalWarningType["TemperatureLow"] = 3] = "TemperatureLow";
        TerminalWarningType[TerminalWarningType["LowDiskSpace"] = 4] = "LowDiskSpace";
        TerminalWarningType[TerminalWarningType["LowBattery"] = 5] = "LowBattery";
        TerminalWarningType[TerminalWarningType["OnBattery"] = 6] = "OnBattery";
    })(TerminalWarningType = DalConstants.TerminalWarningType || (DalConstants.TerminalWarningType = {}));
    DalConstants.DeviceChangeItemType = DalConstants.libEnumsV2.DeviceChangeItemType;
    DalConstants.StatusSensorState = DalConstants.libEnumsV1.StatusSensorState;
    let CounterSensorState;
    (function (CounterSensorState) {
        CounterSensorState[CounterSensorState["ReaderAccessOpenned"] = 1] = "ReaderAccessOpenned";
        CounterSensorState[CounterSensorState["ExitButtonOpenned"] = 2] = "ExitButtonOpenned";
        CounterSensorState[CounterSensorState["UnknownOpenned"] = 3] = "UnknownOpenned";
    })(CounterSensorState = DalConstants.CounterSensorState || (DalConstants.CounterSensorState = {}));
    DalConstants.CardDataFormat = DalConstants.libEnumsV2.CardDataFormat;
    let EmailType;
    (function (EmailType) {
        EmailType[EmailType["UserStateReport"] = 1] = "UserStateReport";
    })(EmailType = DalConstants.EmailType || (DalConstants.EmailType = {}));
    let OrganizationUsernamePolicy;
    (function (OrganizationUsernamePolicy) {
        OrganizationUsernamePolicy[OrganizationUsernamePolicy["MustEmailOrPhoneNumber"] = 1] = "MustEmailOrPhoneNumber";
        OrganizationUsernamePolicy[OrganizationUsernamePolicy["FreeAlphanumeric"] = 2] = "FreeAlphanumeric";
    })(OrganizationUsernamePolicy = DalConstants.OrganizationUsernamePolicy || (DalConstants.OrganizationUsernamePolicy = {}));
    DalConstants.CredentialType = DalConstants.libEnumsV2.CredentialType;
    DalConstants.mobileGeneratedCredentialTypes = [DalConstants.CredentialType.BLE, DalConstants.CredentialType.NFC, DalConstants.CredentialType.QrCode];
    DalConstants.credentialTypesWithMeaningfulData = [DalConstants.CredentialType.MiFare, DalConstants.CredentialType.ProximityCard, DalConstants.CredentialType.VehiclePlate, DalConstants.CredentialType.UHFRfid];
    DalConstants.ArmonControlPanelIntegrationType = DalConstants.libEnumsV2.ArmonControlPanelIntegrationType;
    DalConstants.AuthenticationFactor = DalConstants.libEnumsV2.AuthenticationFactor;
    let AuthenticationMethod;
    (function (AuthenticationMethod) {
        AuthenticationMethod[AuthenticationMethod["Native"] = 1] = "Native";
        AuthenticationMethod[AuthenticationMethod["CAS"] = 2] = "CAS";
        AuthenticationMethod[AuthenticationMethod["OAUTH2"] = 3] = "OAUTH2";
        AuthenticationMethod[AuthenticationMethod["NTLM"] = 4] = "NTLM";
        AuthenticationMethod[AuthenticationMethod["LDAP"] = 5] = "LDAP";
        AuthenticationMethod[AuthenticationMethod["OPENID"] = 6] = "OPENID";
        AuthenticationMethod[AuthenticationMethod["OPENID_CLIENT"] = 7] = "OPENID_CLIENT";
        AuthenticationMethod[AuthenticationMethod["SAML"] = 8] = "SAML";
    })(AuthenticationMethod = DalConstants.AuthenticationMethod || (DalConstants.AuthenticationMethod = {}));
    let AuthGrantType;
    (function (AuthGrantType) {
        AuthGrantType[AuthGrantType["UsernamePassword"] = 1] = "UsernamePassword";
        AuthGrantType[AuthGrantType["SSO"] = 2] = "SSO";
    })(AuthGrantType = DalConstants.AuthGrantType || (DalConstants.AuthGrantType = {}));
    let MobileAuthenticationFactor;
    (function (MobileAuthenticationFactor) {
        MobileAuthenticationFactor[MobileAuthenticationFactor["Bluetooth"] = 2] = "Bluetooth";
        MobileAuthenticationFactor[MobileAuthenticationFactor["AccessToken"] = 5] = "AccessToken";
        MobileAuthenticationFactor[MobileAuthenticationFactor["NFC"] = 8] = "NFC";
        MobileAuthenticationFactor[MobileAuthenticationFactor["QR_BarCode"] = 12] = "QR_BarCode";
    })(MobileAuthenticationFactor = DalConstants.MobileAuthenticationFactor || (DalConstants.MobileAuthenticationFactor = {}));
    let OrganizationEmailAddressType;
    (function (OrganizationEmailAddressType) {
        OrganizationEmailAddressType[OrganizationEmailAddressType["Report"] = 0] = "Report";
    })(OrganizationEmailAddressType = DalConstants.OrganizationEmailAddressType || (DalConstants.OrganizationEmailAddressType = {}));
    let UserSelectionSessionType;
    (function (UserSelectionSessionType) {
        UserSelectionSessionType[UserSelectionSessionType["UserGroup"] = 1] = "UserGroup";
        UserSelectionSessionType[UserSelectionSessionType["PPermission"] = 2] = "PPermission";
        UserSelectionSessionType[UserSelectionSessionType["WorkPlan"] = 3] = "WorkPlan";
        UserSelectionSessionType[UserSelectionSessionType["AccessControlPointGrant"] = 5] = "AccessControlPointGrant";
        UserSelectionSessionType[UserSelectionSessionType["RegionTicketTransaction"] = 6] = "RegionTicketTransaction";
        UserSelectionSessionType[UserSelectionSessionType["SystemMessage"] = 7] = "SystemMessage";
        UserSelectionSessionType[UserSelectionSessionType["UserWorkPlanAdd"] = 8] = "UserWorkPlanAdd";
        UserSelectionSessionType[UserSelectionSessionType["UserWorkPlanRemove"] = 9] = "UserWorkPlanRemove";
        UserSelectionSessionType[UserSelectionSessionType["AddUsersToOrganizationUnit"] = 10] = "AddUsersToOrganizationUnit";
    })(UserSelectionSessionType = DalConstants.UserSelectionSessionType || (DalConstants.UserSelectionSessionType = {}));
    let UserSelectionSessionAction;
    (function (UserSelectionSessionAction) {
        UserSelectionSessionAction[UserSelectionSessionAction["Unchanged"] = 1] = "Unchanged";
        UserSelectionSessionAction[UserSelectionSessionAction["Added"] = 2] = "Added";
        UserSelectionSessionAction[UserSelectionSessionAction["Removed"] = 3] = "Removed";
    })(UserSelectionSessionAction = DalConstants.UserSelectionSessionAction || (DalConstants.UserSelectionSessionAction = {}));
    let UserSelectionSessionFilterType;
    (function (UserSelectionSessionFilterType) {
        UserSelectionSessionFilterType[UserSelectionSessionFilterType["All"] = 0] = "All";
        UserSelectionSessionFilterType[UserSelectionSessionFilterType["JustChanged"] = 1] = "JustChanged";
        UserSelectionSessionFilterType[UserSelectionSessionFilterType["JustAdded"] = 2] = "JustAdded";
        UserSelectionSessionFilterType[UserSelectionSessionFilterType["JustRemoved"] = 3] = "JustRemoved";
        UserSelectionSessionFilterType[UserSelectionSessionFilterType["JustUnchanged"] = 4] = "JustUnchanged";
    })(UserSelectionSessionFilterType = DalConstants.UserSelectionSessionFilterType || (DalConstants.UserSelectionSessionFilterType = {}));
    DalConstants.AntiPassbackState = DalConstants.libEnumsV1.AntiPassbackState;
    let UserAgentDeviceType;
    (function (UserAgentDeviceType) {
        UserAgentDeviceType[UserAgentDeviceType["Desktop"] = 0] = "Desktop";
        UserAgentDeviceType[UserAgentDeviceType["TV"] = 1] = "TV";
        UserAgentDeviceType[UserAgentDeviceType["Tablet"] = 2] = "Tablet";
        UserAgentDeviceType[UserAgentDeviceType["Phone"] = 3] = "Phone";
        UserAgentDeviceType[UserAgentDeviceType["Bot"] = 4] = "Bot";
        UserAgentDeviceType[UserAgentDeviceType["Car"] = 5] = "Car";
        UserAgentDeviceType[UserAgentDeviceType["Unknown"] = 6] = "Unknown";
    })(UserAgentDeviceType = DalConstants.UserAgentDeviceType || (DalConstants.UserAgentDeviceType = {}));
    let CardActivityTimelineItemType;
    (function (CardActivityTimelineItemType) {
        CardActivityTimelineItemType[CardActivityTimelineItemType["AccessAttempt"] = 1] = "AccessAttempt";
        CardActivityTimelineItemType[CardActivityTimelineItemType["ExitButton"] = 2] = "ExitButton";
    })(CardActivityTimelineItemType = DalConstants.CardActivityTimelineItemType || (DalConstants.CardActivityTimelineItemType = {}));
    let AddRemoveAction;
    (function (AddRemoveAction) {
        AddRemoveAction[AddRemoveAction["Add"] = 1] = "Add";
        AddRemoveAction[AddRemoveAction["Remove"] = 2] = "Remove";
    })(AddRemoveAction = DalConstants.AddRemoveAction || (DalConstants.AddRemoveAction = {}));
    let ArmonApplicationModuleStatus;
    (function (ArmonApplicationModuleStatus) {
        ArmonApplicationModuleStatus[ArmonApplicationModuleStatus["Active"] = 1] = "Active";
        ArmonApplicationModuleStatus[ArmonApplicationModuleStatus["CredentialCountExceededLicence"] = 2] = "CredentialCountExceededLicence";
        ArmonApplicationModuleStatus[ArmonApplicationModuleStatus["LicenceExpired"] = 3] = "LicenceExpired";
        ArmonApplicationModuleStatus[ArmonApplicationModuleStatus["Passive"] = 4] = "Passive";
        ArmonApplicationModuleStatus[ArmonApplicationModuleStatus["Disabled"] = 5] = "Disabled";
    })(ArmonApplicationModuleStatus = DalConstants.ArmonApplicationModuleStatus || (DalConstants.ArmonApplicationModuleStatus = {}));
    let EmailFieldType;
    (function (EmailFieldType) {
        EmailFieldType[EmailFieldType["To"] = 1] = "To";
        EmailFieldType[EmailFieldType["Cc"] = 2] = "Cc";
        EmailFieldType[EmailFieldType["Bcc"] = 3] = "Bcc";
    })(EmailFieldType = DalConstants.EmailFieldType || (DalConstants.EmailFieldType = {}));
    let AdapterType;
    (function (AdapterType) {
        AdapterType[AdapterType["Aperio"] = 1] = "Aperio";
        AdapterType[AdapterType["HikVision"] = 2] = "HikVision";
    })(AdapterType = DalConstants.AdapterType || (DalConstants.AdapterType = {}));
    let CredentialExistance;
    (function (CredentialExistance) {
        CredentialExistance[CredentialExistance["NotExits"] = 0] = "NotExits";
        CredentialExistance[CredentialExistance["Member"] = 1] = "Member";
        CredentialExistance[CredentialExistance["Visitor"] = 2] = "Visitor";
        CredentialExistance[CredentialExistance["NotPermitted"] = 3] = "NotPermitted";
    })(CredentialExistance = DalConstants.CredentialExistance || (DalConstants.CredentialExistance = {}));
    let SyncAccessRightActionType;
    (function (SyncAccessRightActionType) {
        SyncAccessRightActionType[SyncAccessRightActionType["InsertAccessRight"] = 0] = "InsertAccessRight";
        SyncAccessRightActionType[SyncAccessRightActionType["UpdateAccessRight"] = 1] = "UpdateAccessRight";
        SyncAccessRightActionType[SyncAccessRightActionType["RemoveAccessRight"] = 2] = "RemoveAccessRight";
        SyncAccessRightActionType[SyncAccessRightActionType["RemoveCredential"] = 3] = "RemoveCredential";
        SyncAccessRightActionType[SyncAccessRightActionType["RegionState"] = 4] = "RegionState";
        SyncAccessRightActionType[SyncAccessRightActionType["RemoveRegionAvailableTimeIntervalsTemplate"] = 5] = "RemoveRegionAvailableTimeIntervalsTemplate";
        SyncAccessRightActionType[SyncAccessRightActionType["RegionUserGrantedAccessCountChanged"] = 6] = "RegionUserGrantedAccessCountChanged";
        SyncAccessRightActionType[SyncAccessRightActionType["RegionUserAvailableTimeIntervalsTemplateChanged"] = 7] = "RegionUserAvailableTimeIntervalsTemplateChanged";
        SyncAccessRightActionType[SyncAccessRightActionType["ChangeUserRegionTicket"] = 8] = "ChangeUserRegionTicket";
        SyncAccessRightActionType[SyncAccessRightActionType["ChangeUserGroup"] = 9] = "ChangeUserGroup";
        SyncAccessRightActionType[SyncAccessRightActionType["DecrementUserRegionTicket"] = 10] = "DecrementUserRegionTicket";
        SyncAccessRightActionType[SyncAccessRightActionType["AccessRegionRuleApplied"] = 11] = "AccessRegionRuleApplied";
    })(SyncAccessRightActionType = DalConstants.SyncAccessRightActionType || (DalConstants.SyncAccessRightActionType = {}));
    let IdentityStatusType;
    (function (IdentityStatusType) {
        IdentityStatusType[IdentityStatusType["All"] = 1] = "All";
        IdentityStatusType[IdentityStatusType["Enabled"] = 2] = "Enabled";
        IdentityStatusType[IdentityStatusType["Disabled"] = 3] = "Disabled";
    })(IdentityStatusType = DalConstants.IdentityStatusType || (DalConstants.IdentityStatusType = {}));
    let NotificationTokenType;
    (function (NotificationTokenType) {
        NotificationTokenType[NotificationTokenType["Expo"] = 1] = "Expo";
        NotificationTokenType[NotificationTokenType["FireBase"] = 2] = "FireBase";
        NotificationTokenType[NotificationTokenType["HuaweiPush"] = 3] = "HuaweiPush";
    })(NotificationTokenType = DalConstants.NotificationTokenType || (DalConstants.NotificationTokenType = {}));
    let WorkPlanType;
    (function (WorkPlanType) {
        WorkPlanType[WorkPlanType["REGULAR"] = 1] = "REGULAR";
        WorkPlanType[WorkPlanType["HALF_FLEXIBLE"] = 2] = "HALF_FLEXIBLE";
        WorkPlanType[WorkPlanType["FULL_FLEXIBLE"] = 3] = "FULL_FLEXIBLE";
        WorkPlanType[WorkPlanType["SHIFT"] = 4] = "SHIFT";
    })(WorkPlanType = DalConstants.WorkPlanType || (DalConstants.WorkPlanType = {}));
    let WorkPlanAccessCheckType;
    (function (WorkPlanAccessCheckType) {
        WorkPlanAccessCheckType[WorkPlanAccessCheckType["Region"] = 1] = "Region";
        WorkPlanAccessCheckType[WorkPlanAccessCheckType["FirstAndLastAccess"] = 2] = "FirstAndLastAccess";
    })(WorkPlanAccessCheckType = DalConstants.WorkPlanAccessCheckType || (DalConstants.WorkPlanAccessCheckType = {}));
    let UserDeputyType;
    (function (UserDeputyType) {
        UserDeputyType[UserDeputyType["Management"] = 1] = "Management";
        UserDeputyType[UserDeputyType["Project"] = 2] = "Project";
    })(UserDeputyType = DalConstants.UserDeputyType || (DalConstants.UserDeputyType = {}));
    let VacationType;
    (function (VacationType) {
        VacationType[VacationType["National"] = 1] = "National";
        VacationType[VacationType["BeforeNational"] = 2] = "BeforeNational";
        VacationType[VacationType["Religious"] = 3] = "Religious";
        VacationType[VacationType["BeforeReligious"] = 4] = "BeforeReligious";
    })(VacationType = DalConstants.VacationType || (DalConstants.VacationType = {}));
    let PredefinedPPermissionType;
    (function (PredefinedPPermissionType) {
        PredefinedPPermissionType[PredefinedPPermissionType["Annual"] = 1] = "Annual";
        PredefinedPPermissionType[PredefinedPPermissionType["Casual"] = 2] = "Casual";
        PredefinedPPermissionType[PredefinedPPermissionType["Other"] = 3] = "Other";
    })(PredefinedPPermissionType = DalConstants.PredefinedPPermissionType || (DalConstants.PredefinedPPermissionType = {}));
    let PPermissionFilterStatus;
    (function (PPermissionFilterStatus) {
        PPermissionFilterStatus[PPermissionFilterStatus["WaitingMyApproval"] = 1] = "WaitingMyApproval";
        PPermissionFilterStatus[PPermissionFilterStatus["Waiting"] = 2] = "Waiting";
        PPermissionFilterStatus[PPermissionFilterStatus["RejectedByMe"] = 3] = "RejectedByMe";
        PPermissionFilterStatus[PPermissionFilterStatus["Rejected"] = 4] = "Rejected";
        PPermissionFilterStatus[PPermissionFilterStatus["ApprovedByMe"] = 5] = "ApprovedByMe";
        PPermissionFilterStatus[PPermissionFilterStatus["Approved"] = 6] = "Approved";
    })(PPermissionFilterStatus = DalConstants.PPermissionFilterStatus || (DalConstants.PPermissionFilterStatus = {}));
    let PPermissionStatus;
    (function (PPermissionStatus) {
        PPermissionStatus[PPermissionStatus["Waiting"] = 0] = "Waiting";
        PPermissionStatus[PPermissionStatus["Approved"] = 1] = "Approved";
        PPermissionStatus[PPermissionStatus["Rejected"] = 2] = "Rejected";
    })(PPermissionStatus = DalConstants.PPermissionStatus || (DalConstants.PPermissionStatus = {}));
    let PPermissionExtendedStatus;
    (function (PPermissionExtendedStatus) {
        PPermissionExtendedStatus[PPermissionExtendedStatus["Waiting"] = 0] = "Waiting";
        PPermissionExtendedStatus[PPermissionExtendedStatus["Approved"] = 1] = "Approved";
        PPermissionExtendedStatus[PPermissionExtendedStatus["Rejected"] = 2] = "Rejected";
        PPermissionExtendedStatus[PPermissionExtendedStatus["WaitingMyApproval"] = 3] = "WaitingMyApproval";
        PPermissionExtendedStatus[PPermissionExtendedStatus["WaitingHRApproval"] = 4] = "WaitingHRApproval";
    })(PPermissionExtendedStatus = DalConstants.PPermissionExtendedStatus || (DalConstants.PPermissionExtendedStatus = {}));
    let PPermissionMaxValueBoundaryInterval;
    (function (PPermissionMaxValueBoundaryInterval) {
        PPermissionMaxValueBoundaryInterval[PPermissionMaxValueBoundaryInterval["Annual"] = 1] = "Annual";
        PPermissionMaxValueBoundaryInterval[PPermissionMaxValueBoundaryInterval["Monthly"] = 2] = "Monthly";
    })(PPermissionMaxValueBoundaryInterval = DalConstants.PPermissionMaxValueBoundaryInterval || (DalConstants.PPermissionMaxValueBoundaryInterval = {}));
    let AccessLogTimeEstimation;
    (function (AccessLogTimeEstimation) {
        AccessLogTimeEstimation[AccessLogTimeEstimation["None"] = 0] = "None";
        AccessLogTimeEstimation[AccessLogTimeEstimation["Start"] = 1] = "Start";
        AccessLogTimeEstimation[AccessLogTimeEstimation["End"] = 2] = "End";
    })(AccessLogTimeEstimation = DalConstants.AccessLogTimeEstimation || (DalConstants.AccessLogTimeEstimation = {}));
    DalConstants.AccessLogReason = DalConstants.libEnumsV2.AccessLogReason;
    DalConstants.TamperSwitchState = DalConstants.libEnumsV1.TamperSwitchState;
    let SoftwareType;
    (function (SoftwareType) {
        SoftwareType[SoftwareType["ArmonCpServer"] = 1] = "ArmonCpServer";
        SoftwareType[SoftwareType["NodeJs"] = 2] = "NodeJs";
        SoftwareType[SoftwareType["Sqlite"] = 3] = "Sqlite";
        SoftwareType[SoftwareType["ArmonCpUpdater"] = 4] = "ArmonCpUpdater";
    })(SoftwareType = DalConstants.SoftwareType || (DalConstants.SoftwareType = {}));
    DalConstants.SystemStatusNotificationReason = DalConstants.libEnumsV1.SystemStatusNotificationReason;
    let PPermissionValidationErrorCodes;
    (function (PPermissionValidationErrorCodes) {
        PPermissionValidationErrorCodes[PPermissionValidationErrorCodes["None"] = 0] = "None";
        PPermissionValidationErrorCodes[PPermissionValidationErrorCodes["WorkPlanError"] = 1] = "WorkPlanError";
        PPermissionValidationErrorCodes[PPermissionValidationErrorCodes["InvalidDateRange"] = 2] = "InvalidDateRange";
        PPermissionValidationErrorCodes[PPermissionValidationErrorCodes["HourlyScheduledPPermissionCanNotBeDaily"] = 3] = "HourlyScheduledPPermissionCanNotBeDaily";
        PPermissionValidationErrorCodes[PPermissionValidationErrorCodes["DailyScheduledCanNotBeHourly"] = 4] = "DailyScheduledCanNotBeHourly";
        PPermissionValidationErrorCodes[PPermissionValidationErrorCodes["PPermissionNotFound"] = 5] = "PPermissionNotFound";
        PPermissionValidationErrorCodes[PPermissionValidationErrorCodes["LimitError"] = 6] = "LimitError";
        PPermissionValidationErrorCodes[PPermissionValidationErrorCodes["Custom"] = 7] = "Custom";
        PPermissionValidationErrorCodes[PPermissionValidationErrorCodes["DeputyIntegrationProblem"] = 8] = "DeputyIntegrationProblem";
    })(PPermissionValidationErrorCodes = DalConstants.PPermissionValidationErrorCodes || (DalConstants.PPermissionValidationErrorCodes = {}));
    let OrganizationFormType;
    (function (OrganizationFormType) {
        OrganizationFormType[OrganizationFormType["Visit"] = 1] = "Visit";
        OrganizationFormType[OrganizationFormType["VisitorProfile"] = 2] = "VisitorProfile";
        OrganizationFormType[OrganizationFormType["UserOrganizationProfile"] = 3] = "UserOrganizationProfile";
    })(OrganizationFormType = DalConstants.OrganizationFormType || (DalConstants.OrganizationFormType = {}));
    let OrganizationVisitorStates;
    (function (OrganizationVisitorStates) {
        OrganizationVisitorStates[OrganizationVisitorStates["Expected"] = 3] = "Expected";
        OrganizationVisitorStates[OrganizationVisitorStates["Active"] = 2] = "Active";
        OrganizationVisitorStates[OrganizationVisitorStates["Forbidden"] = 5] = "Forbidden";
        OrganizationVisitorStates[OrganizationVisitorStates["TemporaryPermit"] = 4] = "TemporaryPermit";
        OrganizationVisitorStates[OrganizationVisitorStates["None"] = 1] = "None";
    })(OrganizationVisitorStates = DalConstants.OrganizationVisitorStates || (DalConstants.OrganizationVisitorStates = {}));
    let OrganizationFormFieldDataType;
    (function (OrganizationFormFieldDataType) {
        OrganizationFormFieldDataType[OrganizationFormFieldDataType["String"] = 1] = "String";
        OrganizationFormFieldDataType[OrganizationFormFieldDataType["Date"] = 2] = "Date";
        OrganizationFormFieldDataType[OrganizationFormFieldDataType["Integer"] = 3] = "Integer";
        OrganizationFormFieldDataType[OrganizationFormFieldDataType["Float"] = 4] = "Float";
        OrganizationFormFieldDataType[OrganizationFormFieldDataType["Boolean"] = 5] = "Boolean";
    })(OrganizationFormFieldDataType = DalConstants.OrganizationFormFieldDataType || (DalConstants.OrganizationFormFieldDataType = {}));
    let OrganizationFormFieldType;
    (function (OrganizationFormFieldType) {
        OrganizationFormFieldType[OrganizationFormFieldType["Text"] = 1] = "Text";
        OrganizationFormFieldType[OrganizationFormFieldType["TextArea"] = 2] = "TextArea";
        OrganizationFormFieldType[OrganizationFormFieldType["DatePicker"] = 3] = "DatePicker";
        OrganizationFormFieldType[OrganizationFormFieldType["TimePicker"] = 4] = "TimePicker";
        OrganizationFormFieldType[OrganizationFormFieldType["DateTimePicker"] = 5] = "DateTimePicker";
        OrganizationFormFieldType[OrganizationFormFieldType["Checkbox"] = 6] = "Checkbox";
        OrganizationFormFieldType[OrganizationFormFieldType["RadioGroup"] = 7] = "RadioGroup";
        OrganizationFormFieldType[OrganizationFormFieldType["Select"] = 8] = "Select";
    })(OrganizationFormFieldType = DalConstants.OrganizationFormFieldType || (DalConstants.OrganizationFormFieldType = {}));
    DalConstants.DayOfWeek = DalConstants.libEnumsV1.DayOfWeek;
    DalConstants.DayOfWeekForWorking = DalConstants.libEnumsV2.DayOfWeekForWorking;
    let AccessReportFilterAccessResultType;
    (function (AccessReportFilterAccessResultType) {
        AccessReportFilterAccessResultType[AccessReportFilterAccessResultType["All"] = 0] = "All";
        AccessReportFilterAccessResultType[AccessReportFilterAccessResultType["Success"] = 1] = "Success";
        AccessReportFilterAccessResultType[AccessReportFilterAccessResultType["Fail"] = 2] = "Fail";
    })(AccessReportFilterAccessResultType = DalConstants.AccessReportFilterAccessResultType || (DalConstants.AccessReportFilterAccessResultType = {}));
    DalConstants.pacsModuleScheduledJobsAndIntervals = [
        {
            type: 8,
            interval: 3,
            notificationType: DalConstants.NotificationType.PPermissionWaitForSignatureReminder,
        },
    ];
    let NotificationMedium;
    (function (NotificationMedium) {
        NotificationMedium[NotificationMedium["Web"] = 1] = "Web";
        NotificationMedium[NotificationMedium["Email"] = 2] = "Email";
        NotificationMedium[NotificationMedium["SMS"] = 3] = "SMS";
        NotificationMedium[NotificationMedium["PushNotification"] = 4] = "PushNotification";
    })(NotificationMedium = DalConstants.NotificationMedium || (DalConstants.NotificationMedium = {}));
    let UnterminatedVisitState;
    (function (UnterminatedVisitState) {
        UnterminatedVisitState[UnterminatedVisitState["Expected"] = 3] = "Expected";
        UnterminatedVisitState[UnterminatedVisitState["Active"] = 2] = "Active";
        UnterminatedVisitState[UnterminatedVisitState["All"] = 1] = "All";
    })(UnterminatedVisitState = DalConstants.UnterminatedVisitState || (DalConstants.UnterminatedVisitState = {}));
    let PPermissionHistoryActionType;
    (function (PPermissionHistoryActionType) {
        PPermissionHistoryActionType[PPermissionHistoryActionType["CreatedBySelf"] = 1] = "CreatedBySelf";
        PPermissionHistoryActionType[PPermissionHistoryActionType["CreatedByManager"] = 2] = "CreatedByManager";
        PPermissionHistoryActionType[PPermissionHistoryActionType["CreatedBySystem"] = 3] = "CreatedBySystem";
        PPermissionHistoryActionType[PPermissionHistoryActionType["Approved"] = 4] = "Approved";
        PPermissionHistoryActionType[PPermissionHistoryActionType["Rejected"] = 5] = "Rejected";
        PPermissionHistoryActionType[PPermissionHistoryActionType["UpdatedBySelf"] = 6] = "UpdatedBySelf";
        PPermissionHistoryActionType[PPermissionHistoryActionType["UpdatedByManager"] = 7] = "UpdatedByManager";
        PPermissionHistoryActionType[PPermissionHistoryActionType["UpdatedBySystem"] = 8] = "UpdatedBySystem";
        PPermissionHistoryActionType[PPermissionHistoryActionType["Deleted"] = 9] = "Deleted";
        PPermissionHistoryActionType[PPermissionHistoryActionType["Notification"] = 10] = "Notification";
        PPermissionHistoryActionType[PPermissionHistoryActionType["EmployeeListChanged"] = 11] = "EmployeeListChanged";
        PPermissionHistoryActionType[PPermissionHistoryActionType["UpdateDateTime"] = 12] = "UpdateDateTime";
        PPermissionHistoryActionType[PPermissionHistoryActionType["PPermissionSigned"] = 13] = "PPermissionSigned";
    })(PPermissionHistoryActionType = DalConstants.PPermissionHistoryActionType || (DalConstants.PPermissionHistoryActionType = {}));
    let CurrentPPermissionInfoType;
    (function (CurrentPPermissionInfoType) {
        CurrentPPermissionInfoType[CurrentPPermissionInfoType["WaitingApproval"] = 1] = "WaitingApproval";
        CurrentPPermissionInfoType[CurrentPPermissionInfoType["WaitingMyApproval"] = 2] = "WaitingMyApproval";
        CurrentPPermissionInfoType[CurrentPPermissionInfoType["HasPPermission"] = 3] = "HasPPermission";
    })(CurrentPPermissionInfoType = DalConstants.CurrentPPermissionInfoType || (DalConstants.CurrentPPermissionInfoType = {}));
    DalConstants.AccessRuleType = DalConstants.libEnumsV2.AccessRuleType;
    DalConstants.AccessRuleAcceptStatus = DalConstants.libEnumsV2.AccessRuleAcceptStatus;
    DalConstants.DeviceBrand = DalConstants.libEnumsV2.DeviceBrand;
    DalConstants.FormFieldType = dynamicFormCurrent_1.FormFieldType;
    DalConstants.DateDynamicValue = dynamicFormCurrent_1.DateDynamicValue;
    DalConstants.CheckboxFormFieldType = dynamicFormCurrent_1.CheckboxFormFieldType;
    DalConstants.TextFormFieldType = dynamicFormCurrent_1.TextFormFieldType;
    DalConstants.SelectFormFieldType = dynamicFormCurrent_1.SelectFormFieldType;
    DalConstants.FormTypeaheadSearchFilterOptionType = dynamicFormCurrent_1.FormTypeaheadSearchFilterOptionType;
    DalConstants.TextFormFieldTypeTransform = dynamicFormCurrent_1.TextFormFieldTypeTransform;
    let OrganizationFeedbackType;
    (function (OrganizationFeedbackType) {
        OrganizationFeedbackType[OrganizationFeedbackType["BlockingError"] = 1] = "BlockingError";
        OrganizationFeedbackType[OrganizationFeedbackType["MajorError"] = 2] = "MajorError";
        OrganizationFeedbackType[OrganizationFeedbackType["MinorError"] = 3] = "MinorError";
        OrganizationFeedbackType[OrganizationFeedbackType["Suggestion"] = 4] = "Suggestion";
        OrganizationFeedbackType[OrganizationFeedbackType["Feedback"] = 5] = "Feedback";
    })(OrganizationFeedbackType = DalConstants.OrganizationFeedbackType || (DalConstants.OrganizationFeedbackType = {}));
    let OrganizationFeedbackStatus;
    (function (OrganizationFeedbackStatus) {
        OrganizationFeedbackStatus[OrganizationFeedbackStatus["New"] = 1] = "New";
        OrganizationFeedbackStatus[OrganizationFeedbackStatus["Inspecting"] = 2] = "Inspecting";
        OrganizationFeedbackStatus[OrganizationFeedbackStatus["Read"] = 3] = "Read";
        OrganizationFeedbackStatus[OrganizationFeedbackStatus["Resolved"] = 4] = "Resolved";
        OrganizationFeedbackStatus[OrganizationFeedbackStatus["Rejected"] = 5] = "Rejected";
        OrganizationFeedbackStatus[OrganizationFeedbackStatus["Ignored"] = 6] = "Ignored";
    })(OrganizationFeedbackStatus = DalConstants.OrganizationFeedbackStatus || (DalConstants.OrganizationFeedbackStatus = {}));
    let OrganizationFeedbackOrigin;
    (function (OrganizationFeedbackOrigin) {
        OrganizationFeedbackOrigin[OrganizationFeedbackOrigin["System"] = 1] = "System";
        OrganizationFeedbackOrigin[OrganizationFeedbackOrigin["User"] = 2] = "User";
        OrganizationFeedbackOrigin[OrganizationFeedbackOrigin["UserError"] = 3] = "UserError";
    })(OrganizationFeedbackOrigin = DalConstants.OrganizationFeedbackOrigin || (DalConstants.OrganizationFeedbackOrigin = {}));
    let UserActionCategory;
    (function (UserActionCategory) {
        UserActionCategory[UserActionCategory["Main"] = 1] = "Main";
        UserActionCategory[UserActionCategory["PACS"] = 2] = "PACS";
        UserActionCategory[UserActionCategory["Visitor"] = 3] = "Visitor";
        UserActionCategory[UserActionCategory["Social"] = 4] = "Social";
    })(UserActionCategory = DalConstants.UserActionCategory || (DalConstants.UserActionCategory = {}));
    let UserVisitorActionType;
    (function (UserVisitorActionType) {
        UserVisitorActionType[UserVisitorActionType["NewVisit"] = 1] = "NewVisit";
        UserVisitorActionType[UserVisitorActionType["NewExpectedVisit"] = 2] = "NewExpectedVisit";
        UserVisitorActionType[UserVisitorActionType["TerminateVisit"] = 3] = "TerminateVisit";
        UserVisitorActionType[UserVisitorActionType["SetVisitorAsBlacklisted"] = 4] = "SetVisitorAsBlacklisted";
        UserVisitorActionType[UserVisitorActionType["SetVisitorAsTemporaryPermitted"] = 5] = "SetVisitorAsTemporaryPermitted";
        UserVisitorActionType[UserVisitorActionType["UnsetVisitorAsBlacklisted"] = 6] = "UnsetVisitorAsBlacklisted";
        UserVisitorActionType[UserVisitorActionType["UnsetVisitorAsTemporaryPermitted"] = 7] = "UnsetVisitorAsTemporaryPermitted";
        UserVisitorActionType[UserVisitorActionType["UpdateVisitorProfile"] = 8] = "UpdateVisitorProfile";
        UserVisitorActionType[UserVisitorActionType["InsertVisitorProfile"] = 9] = "InsertVisitorProfile";
        UserVisitorActionType[UserVisitorActionType["UpsertVisitorRegistrationPoint"] = 10] = "UpsertVisitorRegistrationPoint";
        UserVisitorActionType[UserVisitorActionType["MergeVisitorProfile"] = 11] = "MergeVisitorProfile";
        UserVisitorActionType[UserVisitorActionType["DeleteExpectedVisit"] = 12] = "DeleteExpectedVisit";
    })(UserVisitorActionType = DalConstants.UserVisitorActionType || (DalConstants.UserVisitorActionType = {}));
    let UserPACSActionType;
    (function (UserPACSActionType) {
    })(UserPACSActionType = DalConstants.UserPACSActionType || (DalConstants.UserPACSActionType = {}));
    let UserMainActionType;
    (function (UserMainActionType) {
        UserMainActionType[UserMainActionType["UpdateIdentity"] = 1] = "UpdateIdentity";
        UserMainActionType[UserMainActionType["InsertIdentity"] = 2] = "InsertIdentity";
        UserMainActionType[UserMainActionType["AddAccessRight"] = 3] = "AddAccessRight";
        UserMainActionType[UserMainActionType["RemoveAccessRight"] = 4] = "RemoveAccessRight";
        UserMainActionType[UserMainActionType["AddCredential"] = 5] = "AddCredential";
        UserMainActionType[UserMainActionType["RemoveCredential"] = 6] = "RemoveCredential";
        UserMainActionType[UserMainActionType["UpdateProfile"] = 7] = "UpdateProfile";
        UserMainActionType[UserMainActionType["AddForbiddenState"] = 8] = "AddForbiddenState";
        UserMainActionType[UserMainActionType["UpdateForbiddenState"] = 9] = "UpdateForbiddenState";
        UserMainActionType[UserMainActionType["RemoveForbiddenState"] = 10] = "RemoveForbiddenState";
        UserMainActionType[UserMainActionType["UpsertAccessRuleSet"] = 11] = "UpsertAccessRuleSet";
        UserMainActionType[UserMainActionType["UpsertAccessRule"] = 12] = "UpsertAccessRule";
        UserMainActionType[UserMainActionType["RemoveAccessRuleSet"] = 13] = "RemoveAccessRuleSet";
        UserMainActionType[UserMainActionType["RemoveAccessRule"] = 14] = "RemoveAccessRule";
        UserMainActionType[UserMainActionType["AssignUserGroupToAccessRule"] = 15] = "AssignUserGroupToAccessRule";
        UserMainActionType[UserMainActionType["UpdateCredential"] = 16] = "UpdateCredential";
        UserMainActionType[UserMainActionType["InsertAccessControlPoint"] = 17] = "InsertAccessControlPoint";
        UserMainActionType[UserMainActionType["UpdateAccessControlPoint"] = 18] = "UpdateAccessControlPoint";
        UserMainActionType[UserMainActionType["UpdateRelay"] = 19] = "UpdateRelay";
        UserMainActionType[UserMainActionType["UpdateStatusSensor"] = 20] = "UpdateStatusSensor";
        UserMainActionType[UserMainActionType["UpdateCounterSensor"] = 21] = "UpdateCounterSensor";
        UserMainActionType[UserMainActionType["UpdateReader"] = 22] = "UpdateReader";
        UserMainActionType[UserMainActionType["UpdateAccessControlPointMapping"] = 23] = "UpdateAccessControlPointMapping";
        UserMainActionType[UserMainActionType["AssignUserToOrganizationUnit"] = 24] = "AssignUserToOrganizationUnit";
        UserMainActionType[UserMainActionType["RemoveUserFromOrganizationUnit"] = 25] = "RemoveUserFromOrganizationUnit";
        UserMainActionType[UserMainActionType["UpdateUserOrganizationUnitRole"] = 26] = "UpdateUserOrganizationUnitRole";
        UserMainActionType[UserMainActionType["AssignUserToUserGroup"] = 27] = "AssignUserToUserGroup";
        UserMainActionType[UserMainActionType["RemoveUserFromUserGroup"] = 28] = "RemoveUserFromUserGroup";
        UserMainActionType[UserMainActionType["AccountDeleted"] = 29] = "AccountDeleted";
        UserMainActionType[UserMainActionType["UsernameUpdated"] = 30] = "UsernameUpdated";
        UserMainActionType[UserMainActionType["AccountCreated"] = 31] = "AccountCreated";
    })(UserMainActionType = DalConstants.UserMainActionType || (DalConstants.UserMainActionType = {}));
    let UserSocialActionType;
    (function (UserSocialActionType) {
    })(UserSocialActionType = DalConstants.UserSocialActionType || (DalConstants.UserSocialActionType = {}));
    DalConstants.AuthenticatorType = DalConstants.libEnumsV1.AuthenticatorType;
    DalConstants.AuthenticatorTypeV3 = DalConstants.libEnumsV3.AuthenticatorType;
    let OrganizationCaptionLineType;
    (function (OrganizationCaptionLineType) {
        OrganizationCaptionLineType[OrganizationCaptionLineType["userOrganizationProfile"] = 1] = "userOrganizationProfile";
        OrganizationCaptionLineType[OrganizationCaptionLineType["userGroup"] = 2] = "userGroup";
        OrganizationCaptionLineType[OrganizationCaptionLineType["organizationUnit"] = 3] = "organizationUnit";
        OrganizationCaptionLineType[OrganizationCaptionLineType["credentials"] = 4] = "credentials";
        OrganizationCaptionLineType[OrganizationCaptionLineType["warning"] = 5] = "warning";
        OrganizationCaptionLineType[OrganizationCaptionLineType["profilePhoto"] = 6] = "profilePhoto";
    })(OrganizationCaptionLineType = DalConstants.OrganizationCaptionLineType || (DalConstants.OrganizationCaptionLineType = {}));
    let ListVisitState;
    (function (ListVisitState) {
        ListVisitState[ListVisitState["All"] = 1] = "All";
        ListVisitState[ListVisitState["OnlyActive"] = 2] = "OnlyActive";
        ListVisitState[ListVisitState["OnlyTerminated"] = 3] = "OnlyTerminated";
    })(ListVisitState = DalConstants.ListVisitState || (DalConstants.ListVisitState = {}));
    let SegmentType;
    (function (SegmentType) {
        SegmentType[SegmentType["Day"] = 1] = "Day";
        SegmentType[SegmentType["Week"] = 2] = "Week";
        SegmentType[SegmentType["Month"] = 3] = "Month";
    })(SegmentType = DalConstants.SegmentType || (DalConstants.SegmentType = {}));
    DalConstants.AccessControlPointState = DalConstants.libEnumsV1.AccessControlPointState;
    let OrganizationUserDefinedListType;
    (function (OrganizationUserDefinedListType) {
        OrganizationUserDefinedListType[OrganizationUserDefinedListType["Brand"] = 1] = "Brand";
        OrganizationUserDefinedListType[OrganizationUserDefinedListType["Model"] = 2] = "Model";
        OrganizationUserDefinedListType[OrganizationUserDefinedListType["ColorCode"] = 3] = "ColorCode";
        OrganizationUserDefinedListType[OrganizationUserDefinedListType["VehicleType"] = 4] = "VehicleType";
        OrganizationUserDefinedListType[OrganizationUserDefinedListType["VisitorRegistrationPoint"] = 5] = "VisitorRegistrationPoint";
        OrganizationUserDefinedListType[OrganizationUserDefinedListType["OrganizationUnitType"] = 6] = "OrganizationUnitType";
    })(OrganizationUserDefinedListType = DalConstants.OrganizationUserDefinedListType || (DalConstants.OrganizationUserDefinedListType = {}));
    let OrganizationUserDefinedListDataType;
    (function (OrganizationUserDefinedListDataType) {
        OrganizationUserDefinedListDataType[OrganizationUserDefinedListDataType["String"] = 1] = "String";
        OrganizationUserDefinedListDataType[OrganizationUserDefinedListDataType["Number"] = 2] = "Number";
        OrganizationUserDefinedListDataType[OrganizationUserDefinedListDataType["Date"] = 3] = "Date";
        OrganizationUserDefinedListDataType[OrganizationUserDefinedListDataType["KeyValue"] = 4] = "KeyValue";
        OrganizationUserDefinedListDataType[OrganizationUserDefinedListDataType["JSON"] = 5] = "JSON";
    })(OrganizationUserDefinedListDataType = DalConstants.OrganizationUserDefinedListDataType || (DalConstants.OrganizationUserDefinedListDataType = {}));
    DalConstants.defaultUserProfileSettings = {
        captionLineFields: [
            {
                col: 12,
                name: "fullname",
                showInCaptionLines: true,
                type: DalConstants.OrganizationCaptionLineType.userOrganizationProfile,
                isExtension: false,
            },
            {
                col: 12,
                name: "uniqueId",
                showInCaptionLines: true,
                type: DalConstants.OrganizationCaptionLineType.userOrganizationProfile,
                isExtension: false,
            },
        ],
        maxCaptionLineRowNumber: 1,
    };
    DalConstants.FingerIndex = DalConstants.libEnumsV1.FingerIndex;
    let EmailTemplateType;
    (function (EmailTemplateType) {
        EmailTemplateType[EmailTemplateType["Visitor"] = 1] = "Visitor";
        EmailTemplateType[EmailTemplateType["UnitPerformanceReport"] = 2] = "UnitPerformanceReport";
        EmailTemplateType[EmailTemplateType["UserPerformanceReport"] = 3] = "UserPerformanceReport";
        EmailTemplateType[EmailTemplateType["FeedbackUpdate"] = 4] = "FeedbackUpdate";
        EmailTemplateType[EmailTemplateType["Feedback"] = 5] = "Feedback";
        EmailTemplateType[EmailTemplateType["SelfMissingWork"] = 6] = "SelfMissingWork";
        EmailTemplateType[EmailTemplateType["MissingWork"] = 7] = "MissingWork";
    })(EmailTemplateType = DalConstants.EmailTemplateType || (DalConstants.EmailTemplateType = {}));
    let SystemStatusLogType;
    (function (SystemStatusLogType) {
        SystemStatusLogType[SystemStatusLogType["TerminaleConnected"] = 1] = "TerminaleConnected";
        SystemStatusLogType[SystemStatusLogType["TerminalDisconnected"] = 2] = "TerminalDisconnected";
        SystemStatusLogType[SystemStatusLogType["TerminalHealth"] = 3] = "TerminalHealth";
        SystemStatusLogType[SystemStatusLogType["TerminalUserAction"] = 4] = "TerminalUserAction";
    })(SystemStatusLogType = DalConstants.SystemStatusLogType || (DalConstants.SystemStatusLogType = {}));
    DalConstants.UserCaptionKeys = {
        USER_FORBIDDEN: "USER_CAPTION.USER_FORBIDDEN",
        VISITOR_FORBIDDEN: "USER_CAPTION.VISITOR_FORBIDDEN",
        VISITOR_PERMITTED: "USER_CAPTION.VISITOR_PERMITTED",
    };
    DalConstants.UserCaptionColorCode = {
        code: "A00000",
    };
    let TerminalEventType;
    (function (TerminalEventType) {
        TerminalEventType[TerminalEventType["Connection"] = 1] = "Connection";
        TerminalEventType[TerminalEventType["UploadOfflineLogs"] = 2] = "UploadOfflineLogs";
        TerminalEventType[TerminalEventType["SystemHealthReceived"] = 3] = "SystemHealthReceived";
        TerminalEventType[TerminalEventType["StatusSensorLogReceived"] = 4] = "StatusSensorLogReceived";
        TerminalEventType[TerminalEventType["CounterSensorLogReceived"] = 5] = "CounterSensorLogReceived";
        TerminalEventType[TerminalEventType["TamperLogReceived"] = 6] = "TamperLogReceived";
        TerminalEventType[TerminalEventType["TerminalUserAction"] = 7] = "TerminalUserAction";
    })(TerminalEventType = DalConstants.TerminalEventType || (DalConstants.TerminalEventType = {}));
    let TerminalConnectionStatus;
    (function (TerminalConnectionStatus) {
        TerminalConnectionStatus[TerminalConnectionStatus["All"] = 1] = "All";
        TerminalConnectionStatus[TerminalConnectionStatus["Connected"] = 2] = "Connected";
        TerminalConnectionStatus[TerminalConnectionStatus["Disconnected"] = 3] = "Disconnected";
    })(TerminalConnectionStatus = DalConstants.TerminalConnectionStatus || (DalConstants.TerminalConnectionStatus = {}));
    let PacsNotificationType;
    (function (PacsNotificationType) {
        PacsNotificationType[PacsNotificationType["MissingWork"] = 1] = "MissingWork";
        PacsNotificationType[PacsNotificationType["LateEntrance"] = 2] = "LateEntrance";
        PacsNotificationType[PacsNotificationType["EarlyLeave"] = 3] = "EarlyLeave";
        PacsNotificationType[PacsNotificationType["EarlyEntrance"] = 4] = "EarlyEntrance";
        PacsNotificationType[PacsNotificationType["LateLeave"] = 5] = "LateLeave";
        PacsNotificationType[PacsNotificationType["OutOfWorkplanAccess"] = 6] = "OutOfWorkplanAccess";
    })(PacsNotificationType = DalConstants.PacsNotificationType || (DalConstants.PacsNotificationType = {}));
    DalConstants.DeviceToServerMessageTypes = DalConstants.libEnumsV2.DeviceToServerMessageTypes;
    DalConstants.ServerToDeviceMessageType = DalConstants.libEnumsV1.ServerToDeviceMessageType;
    DalConstants.ServerToDeviceRPCMessageType = DalConstants.libEnumsV2.ServerToDeviceRPCMessageType;
    DalConstants.NotificationPatternActionType = DalConstants.libEnumsV1.NotificationPatternActionType;
    DalConstants.NotificationPatternType = DalConstants.libEnumsV1.NotificationPatternType;
    let CameraActionType;
    (function (CameraActionType) {
        CameraActionType[CameraActionType["Auth"] = 1] = "Auth";
        CameraActionType[CameraActionType["Sensor"] = 2] = "Sensor";
        CameraActionType[CameraActionType["RemoteAccess"] = 3] = "RemoteAccess";
        CameraActionType[CameraActionType["View"] = 4] = "View";
    })(CameraActionType = DalConstants.CameraActionType || (DalConstants.CameraActionType = {}));
    let ResultStatus;
    (function (ResultStatus) {
        ResultStatus[ResultStatus["All"] = 1] = "All";
        ResultStatus[ResultStatus["Success"] = 2] = "Success";
        ResultStatus[ResultStatus["Fail"] = 3] = "Fail";
    })(ResultStatus = DalConstants.ResultStatus || (DalConstants.ResultStatus = {}));
    let SearchMethod;
    (function (SearchMethod) {
        SearchMethod[SearchMethod["Exact"] = 1] = "Exact";
        SearchMethod[SearchMethod["StartsWith"] = 2] = "StartsWith";
        SearchMethod[SearchMethod["Similar"] = 3] = "Similar";
    })(SearchMethod = DalConstants.SearchMethod || (DalConstants.SearchMethod = {}));
    DalConstants.CredentialCreateErrorReason = DalConstants.libEnumsV2.CredentialRegisterModeFailureReasonType;
    DalConstants.CredentialIndex = DalConstants.libEnumsV2.CredentialIndex;
    let EmployeeInfoSorting;
    (function (EmployeeInfoSorting) {
        EmployeeInfoSorting[EmployeeInfoSorting["Username"] = 1] = "Username";
        EmployeeInfoSorting[EmployeeInfoSorting["ExtraWork"] = 2] = "ExtraWork";
        EmployeeInfoSorting[EmployeeInfoSorting["MissedWork"] = 3] = "MissedWork";
        EmployeeInfoSorting[EmployeeInfoSorting["EntranceDate"] = 4] = "EntranceDate";
        EmployeeInfoSorting[EmployeeInfoSorting["ExitDate"] = 5] = "ExitDate";
        EmployeeInfoSorting[EmployeeInfoSorting["LateAccess"] = 6] = "LateAccess";
        EmployeeInfoSorting[EmployeeInfoSorting["EarlyLeave"] = 7] = "EarlyLeave";
    })(EmployeeInfoSorting = DalConstants.EmployeeInfoSorting || (DalConstants.EmployeeInfoSorting = {}));
    let EmployeeBinaryDistributionType;
    (function (EmployeeBinaryDistributionType) {
        EmployeeBinaryDistributionType[EmployeeBinaryDistributionType["Work"] = 1] = "Work";
        EmployeeBinaryDistributionType[EmployeeBinaryDistributionType["ExtraWork"] = 2] = "ExtraWork";
        EmployeeBinaryDistributionType[EmployeeBinaryDistributionType["MissingWork"] = 3] = "MissingWork";
        EmployeeBinaryDistributionType[EmployeeBinaryDistributionType["LateStart"] = 4] = "LateStart";
        EmployeeBinaryDistributionType[EmployeeBinaryDistributionType["EarlyLeave"] = 5] = "EarlyLeave";
        EmployeeBinaryDistributionType[EmployeeBinaryDistributionType["LateLeave"] = 6] = "LateLeave";
        EmployeeBinaryDistributionType[EmployeeBinaryDistributionType["EarlyStart"] = 7] = "EarlyStart";
        EmployeeBinaryDistributionType[EmployeeBinaryDistributionType["OffTimePermission"] = 8] = "OffTimePermission";
        EmployeeBinaryDistributionType[EmployeeBinaryDistributionType["DeclaredWork"] = 9] = "DeclaredWork";
        EmployeeBinaryDistributionType[EmployeeBinaryDistributionType["ShouldBeIgnoredWork"] = 10] = "ShouldBeIgnoredWork";
    })(EmployeeBinaryDistributionType = DalConstants.EmployeeBinaryDistributionType || (DalConstants.EmployeeBinaryDistributionType = {}));
    let EmployeeStatus;
    (function (EmployeeStatus) {
        EmployeeStatus[EmployeeStatus["AtBreak"] = 1] = "AtBreak";
        EmployeeStatus[EmployeeStatus["AtWorkingHours"] = 2] = "AtWorkingHours";
        EmployeeStatus[EmployeeStatus["AtHoliday"] = 3] = "AtHoliday";
        EmployeeStatus[EmployeeStatus["AtOffTimePermission"] = 4] = "AtOffTimePermission";
        EmployeeStatus[EmployeeStatus["AtOutOfWorkingHours"] = 5] = "AtOutOfWorkingHours";
    })(EmployeeStatus = DalConstants.EmployeeStatus || (DalConstants.EmployeeStatus = {}));
    let EmployeeCurrentStatusWarnings;
    (function (EmployeeCurrentStatusWarnings) {
        EmployeeCurrentStatusWarnings[EmployeeCurrentStatusWarnings["PastEntrance"] = 1] = "PastEntrance";
        EmployeeCurrentStatusWarnings[EmployeeCurrentStatusWarnings["PastExit"] = 2] = "PastExit";
    })(EmployeeCurrentStatusWarnings = DalConstants.EmployeeCurrentStatusWarnings || (DalConstants.EmployeeCurrentStatusWarnings = {}));
    let WorkStatusFilter;
    (function (WorkStatusFilter) {
        WorkStatusFilter[WorkStatusFilter["Came"] = 1] = "Came";
        WorkStatusFilter[WorkStatusFilter["NotCame"] = 2] = "NotCame";
        WorkStatusFilter[WorkStatusFilter["LateStart"] = 3] = "LateStart";
        WorkStatusFilter[WorkStatusFilter["EarlyLeave"] = 4] = "EarlyLeave";
        WorkStatusFilter[WorkStatusFilter["EarlyStart"] = 5] = "EarlyStart";
        WorkStatusFilter[WorkStatusFilter["LateLeave"] = 6] = "LateLeave";
    })(WorkStatusFilter = DalConstants.WorkStatusFilter || (DalConstants.WorkStatusFilter = {}));
    let LogHistoryType;
    (function (LogHistoryType) {
        LogHistoryType[LogHistoryType["AccessLog"] = 1] = "AccessLog";
        LogHistoryType[LogHistoryType["SummaryChange"] = 2] = "SummaryChange";
    })(LogHistoryType = DalConstants.LogHistoryType || (DalConstants.LogHistoryType = {}));
    let ArmonProductCode;
    (function (ArmonProductCode) {
        ArmonProductCode[ArmonProductCode["BaseModule"] = 1] = "BaseModule";
        ArmonProductCode[ArmonProductCode["PacsModule"] = 2] = "PacsModule";
        ArmonProductCode[ArmonProductCode["SocialAreaModule"] = 3] = "SocialAreaModule";
        ArmonProductCode[ArmonProductCode["VisitorModule"] = 4] = "VisitorModule";
        ArmonProductCode[ArmonProductCode["OrganizationCustomUserProfileForm"] = 5] = "OrganizationCustomUserProfileForm";
        ArmonProductCode[ArmonProductCode["OrganizationCustomExcelPdfReport"] = 6] = "OrganizationCustomExcelPdfReport";
        ArmonProductCode[ArmonProductCode["MobileCredential"] = 7] = "MobileCredential";
        ArmonProductCode[ArmonProductCode["OrganizationCustomVisitorForm"] = 8] = "OrganizationCustomVisitorForm";
        ArmonProductCode[ArmonProductCode["OrganizationExtraVisitorRegistrationPoint"] = 9] = "OrganizationExtraVisitorRegistrationPoint";
        ArmonProductCode[ArmonProductCode["OnPremiseServer"] = 10] = "OnPremiseServer";
        ArmonProductCode[ArmonProductCode["SmsNotificationPacketFor1000Sms"] = 11] = "SmsNotificationPacketFor1000Sms";
        ArmonProductCode[ArmonProductCode["SoldMainControlPanel"] = 12] = "SoldMainControlPanel";
        ArmonProductCode[ArmonProductCode["RentMainControlPanel"] = 13] = "RentMainControlPanel";
        ArmonProductCode[ArmonProductCode["SoldExtensionControlPanel"] = 14] = "SoldExtensionControlPanel";
        ArmonProductCode[ArmonProductCode["RentExtensionControlPanel"] = 15] = "RentExtensionControlPanel";
        ArmonProductCode[ArmonProductCode["SoldThirdPartyTerminal"] = 16] = "SoldThirdPartyTerminal";
        ArmonProductCode[ArmonProductCode["RentThirdPartyTerminal"] = 17] = "RentThirdPartyTerminal";
        ArmonProductCode[ArmonProductCode["SoldArmonV10"] = 18] = "SoldArmonV10";
        ArmonProductCode[ArmonProductCode["RentArmonV10"] = 19] = "RentArmonV10";
        ArmonProductCode[ArmonProductCode["WarrantyExtension"] = 20] = "WarrantyExtension";
        ArmonProductCode[ArmonProductCode["Adapter"] = 21] = "Adapter";
    })(ArmonProductCode = DalConstants.ArmonProductCode || (DalConstants.ArmonProductCode = {}));
    let Country;
    (function (Country) {
        Country[Country["Turkey"] = 90] = "Turkey";
    })(Country = DalConstants.Country || (DalConstants.Country = {}));
    let RecalculateWorkReason;
    (function (RecalculateWorkReason) {
        RecalculateWorkReason[RecalculateWorkReason["Standby"] = 1] = "Standby";
        RecalculateWorkReason[RecalculateWorkReason["NewAccessLog"] = 2] = "NewAccessLog";
        RecalculateWorkReason[RecalculateWorkReason["OfflineLogReceived"] = 4] = "OfflineLogReceived";
        RecalculateWorkReason[RecalculateWorkReason["ManuelLogChange"] = 8] = "ManuelLogChange";
        RecalculateWorkReason[RecalculateWorkReason["PermissionChange"] = 16] = "PermissionChange";
        RecalculateWorkReason[RecalculateWorkReason["UserWorkPlanChange"] = 32] = "UserWorkPlanChange";
        RecalculateWorkReason[RecalculateWorkReason["WorkPlanDefinitionChange"] = 64] = "WorkPlanDefinitionChange";
        RecalculateWorkReason[RecalculateWorkReason["ManuallyTriggered"] = 128] = "ManuallyTriggered";
        RecalculateWorkReason[RecalculateWorkReason["Holiday"] = 256] = "Holiday";
        RecalculateWorkReason[RecalculateWorkReason["Initialization"] = 512] = "Initialization";
        RecalculateWorkReason[RecalculateWorkReason["Processing"] = 1024] = "Processing";
    })(RecalculateWorkReason = DalConstants.RecalculateWorkReason || (DalConstants.RecalculateWorkReason = {}));
    let WorkPlanTimeRangeType;
    (function (WorkPlanTimeRangeType) {
        WorkPlanTimeRangeType[WorkPlanTimeRangeType["WorkingHours"] = 1] = "WorkingHours";
        WorkPlanTimeRangeType[WorkPlanTimeRangeType["Holiday"] = 2] = "Holiday";
        WorkPlanTimeRangeType[WorkPlanTimeRangeType["OutOfWorkingHours"] = 4] = "OutOfWorkingHours";
    })(WorkPlanTimeRangeType = DalConstants.WorkPlanTimeRangeType || (DalConstants.WorkPlanTimeRangeType = {}));
    let PPermissionType;
    (function (PPermissionType) {
        PPermissionType[PPermissionType["OffTime"] = 1] = "OffTime";
        PPermissionType[PPermissionType["DeclaredWork"] = 2] = "DeclaredWork";
        PPermissionType[PPermissionType["ShouldBeIgnoredWork"] = 3] = "ShouldBeIgnoredWork";
        PPermissionType[PPermissionType["ExtraWork"] = 4] = "ExtraWork";
    })(PPermissionType = DalConstants.PPermissionType || (DalConstants.PPermissionType = {}));
    let EmployeeTimeRangeType;
    (function (EmployeeTimeRangeType) {
        EmployeeTimeRangeType[EmployeeTimeRangeType["WorkingHours"] = 1] = "WorkingHours";
        EmployeeTimeRangeType[EmployeeTimeRangeType["FlexibleWorkingHours"] = 6] = "FlexibleWorkingHours";
        EmployeeTimeRangeType[EmployeeTimeRangeType["Holiday"] = 2] = "Holiday";
        EmployeeTimeRangeType[EmployeeTimeRangeType["Break"] = 3] = "Break";
        EmployeeTimeRangeType[EmployeeTimeRangeType["OutOfWorkingHours"] = 4] = "OutOfWorkingHours";
        EmployeeTimeRangeType[EmployeeTimeRangeType["OffTimePermission"] = 5] = "OffTimePermission";
    })(EmployeeTimeRangeType = DalConstants.EmployeeTimeRangeType || (DalConstants.EmployeeTimeRangeType = {}));
    let AttendanceTimeRangeType;
    (function (AttendanceTimeRangeType) {
        AttendanceTimeRangeType[AttendanceTimeRangeType["IgnoredPhysicalAttendance"] = 6] = "IgnoredPhysicalAttendance";
        AttendanceTimeRangeType[AttendanceTimeRangeType["AccountedPhysicalAttendance"] = 8] = "AccountedPhysicalAttendance";
        AttendanceTimeRangeType[AttendanceTimeRangeType["DeclaredAttendance"] = 7] = "DeclaredAttendance";
        AttendanceTimeRangeType[AttendanceTimeRangeType["Absent"] = 9] = "Absent";
    })(AttendanceTimeRangeType = DalConstants.AttendanceTimeRangeType || (DalConstants.AttendanceTimeRangeType = {}));
    let ToleranceType;
    (function (ToleranceType) {
        ToleranceType[ToleranceType["EarlyStart"] = 1] = "EarlyStart";
        ToleranceType[ToleranceType["LateStart"] = 2] = "LateStart";
        ToleranceType[ToleranceType["EarlyLeave"] = 3] = "EarlyLeave";
        ToleranceType[ToleranceType["LateLeave"] = 4] = "LateLeave";
    })(ToleranceType = DalConstants.ToleranceType || (DalConstants.ToleranceType = {}));
    let VisitorPhotoState;
    (function (VisitorPhotoState) {
        VisitorPhotoState[VisitorPhotoState["ActiveVisible"] = 3] = "ActiveVisible";
        VisitorPhotoState[VisitorPhotoState["ActiveHidden"] = 2] = "ActiveHidden";
        VisitorPhotoState[VisitorPhotoState["Passive"] = 1] = "Passive";
    })(VisitorPhotoState = DalConstants.VisitorPhotoState || (DalConstants.VisitorPhotoState = {}));
    let VisitorCommunicationMediumType;
    (function (VisitorCommunicationMediumType) {
        VisitorCommunicationMediumType[VisitorCommunicationMediumType["Email"] = 1] = "Email";
        VisitorCommunicationMediumType[VisitorCommunicationMediumType["PhoneNumber"] = 2] = "PhoneNumber";
    })(VisitorCommunicationMediumType = DalConstants.VisitorCommunicationMediumType || (DalConstants.VisitorCommunicationMediumType = {}));
    let VisitorQRCodeType;
    (function (VisitorQRCodeType) {
        VisitorQRCodeType[VisitorQRCodeType["Id"] = 1] = "Id";
        VisitorQRCodeType[VisitorQRCodeType["Trust"] = 2] = "Trust";
    })(VisitorQRCodeType = DalConstants.VisitorQRCodeType || (DalConstants.VisitorQRCodeType = {}));
    let CustomOrganizationReportFilterType;
    (function (CustomOrganizationReportFilterType) {
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["UserIdFromFreeSearch"] = 1] = "UserIdFromFreeSearch";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["WorkPlan"] = 2] = "WorkPlan";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["UserGroup"] = 3] = "UserGroup";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["OrganizationUnit"] = 4] = "OrganizationUnit";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["OrganizationUnitHierarchically"] = 5] = "OrganizationUnitHierarchically";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["Date"] = 6] = "Date";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["DateTime"] = 7] = "DateTime";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["DateRange"] = 8] = "DateRange";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["DateTimeRange"] = 9] = "DateTimeRange";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["DateMonth"] = 10] = "DateMonth";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["DateDay"] = 11] = "DateDay";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["AccessControlPoints"] = 12] = "AccessControlPoints";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["UserStatus"] = 13] = "UserStatus";
        CustomOrganizationReportFilterType[CustomOrganizationReportFilterType["Region"] = 14] = "Region";
    })(CustomOrganizationReportFilterType = DalConstants.CustomOrganizationReportFilterType || (DalConstants.CustomOrganizationReportFilterType = {}));
    let NotificationCancelReason;
    (function (NotificationCancelReason) {
        NotificationCancelReason[NotificationCancelReason["MaxAttemptCountReached"] = 1] = "MaxAttemptCountReached";
        NotificationCancelReason[NotificationCancelReason["Other"] = 99] = "Other";
    })(NotificationCancelReason = DalConstants.NotificationCancelReason || (DalConstants.NotificationCancelReason = {}));
    DalConstants.tolerance_value = 20 * 60 * 1000;
    let NotificationErrorCode;
    (function (NotificationErrorCode) {
        NotificationErrorCode[NotificationErrorCode["ConnectionError"] = 10000] = "ConnectionError";
        NotificationErrorCode[NotificationErrorCode["ResetDbCannotBeTrueInNonDevelopmentEnvironment"] = 10001] = "ResetDbCannotBeTrueInNonDevelopmentEnvironment";
        NotificationErrorCode[NotificationErrorCode["MigrationFileIsNotFound"] = 10002] = "MigrationFileIsNotFound";
        NotificationErrorCode[NotificationErrorCode["DropSchemaError"] = 10003] = "DropSchemaError";
        NotificationErrorCode[NotificationErrorCode["ScaffoldDbError"] = 10004] = "ScaffoldDbError";
        NotificationErrorCode[NotificationErrorCode["SeedCanBeAppliedOnlyNewScaffoldedDb"] = 10005] = "SeedCanBeAppliedOnlyNewScaffoldedDb";
        NotificationErrorCode[NotificationErrorCode["UnknownSeedType"] = 10006] = "UnknownSeedType";
        NotificationErrorCode[NotificationErrorCode["NotReadyToAccess"] = 10007] = "NotReadyToAccess";
        NotificationErrorCode[NotificationErrorCode["DataNotFound"] = 10008] = "DataNotFound";
        NotificationErrorCode[NotificationErrorCode["DataNotFoundInNotificationTable"] = 10009] = "DataNotFoundInNotificationTable";
        NotificationErrorCode[NotificationErrorCode["DataNotFoundInMediumSmtpTable"] = 10010] = "DataNotFoundInMediumSmtpTable";
        NotificationErrorCode[NotificationErrorCode["DataNotFoundInMediumSmsTable"] = 10011] = "DataNotFoundInMediumSmsTable";
        NotificationErrorCode[NotificationErrorCode["DataNotFoundInQueueTable"] = 10012] = "DataNotFoundInQueueTable";
        NotificationErrorCode[NotificationErrorCode["DataNotFoundInTemplatesTable"] = 10013] = "DataNotFoundInTemplatesTable";
        NotificationErrorCode[NotificationErrorCode["Unknown"] = 19999] = "Unknown";
    })(NotificationErrorCode = DalConstants.NotificationErrorCode || (DalConstants.NotificationErrorCode = {}));
    let VisitAnalysisVisitCountGenericFilterType;
    (function (VisitAnalysisVisitCountGenericFilterType) {
        VisitAnalysisVisitCountGenericFilterType[VisitAnalysisVisitCountGenericFilterType["ByVisitorId"] = 1] = "ByVisitorId";
        VisitAnalysisVisitCountGenericFilterType[VisitAnalysisVisitCountGenericFilterType["ByVisitReason"] = 2] = "ByVisitReason";
        VisitAnalysisVisitCountGenericFilterType[VisitAnalysisVisitCountGenericFilterType["ByVisitedPersonId"] = 3] = "ByVisitedPersonId";
        VisitAnalysisVisitCountGenericFilterType[VisitAnalysisVisitCountGenericFilterType["ByLicensePlate"] = 4] = "ByLicensePlate";
    })(VisitAnalysisVisitCountGenericFilterType = DalConstants.VisitAnalysisVisitCountGenericFilterType || (DalConstants.VisitAnalysisVisitCountGenericFilterType = {}));
    let PPermissionInsertRole;
    (function (PPermissionInsertRole) {
        PPermissionInsertRole[PPermissionInsertRole["HR"] = 0] = "HR";
        PPermissionInsertRole[PPermissionInsertRole["Manager"] = 1] = "Manager";
        PPermissionInsertRole[PPermissionInsertRole["Self"] = 2] = "Self";
    })(PPermissionInsertRole = DalConstants.PPermissionInsertRole || (DalConstants.PPermissionInsertRole = {}));
    let PPermissionEditableStatus;
    (function (PPermissionEditableStatus) {
        PPermissionEditableStatus[PPermissionEditableStatus["Editable"] = 1] = "Editable";
        PPermissionEditableStatus[PPermissionEditableStatus["CreatorHasHigherPrivilege"] = 2] = "CreatorHasHigherPrivilege";
        PPermissionEditableStatus[PPermissionEditableStatus["AlreadyApprovedByHigherPrivilegedUser"] = 3] = "AlreadyApprovedByHigherPrivilegedUser";
        PPermissionEditableStatus[PPermissionEditableStatus["PermissionHasUnlistedUsers"] = 4] = "PermissionHasUnlistedUsers";
        PPermissionEditableStatus[PPermissionEditableStatus["UnspecifiedReason"] = 9] = "UnspecifiedReason";
    })(PPermissionEditableStatus = DalConstants.PPermissionEditableStatus || (DalConstants.PPermissionEditableStatus = {}));
    let DeviceConnectionState;
    (function (DeviceConnectionState) {
        DeviceConnectionState[DeviceConnectionState["Connected"] = 1] = "Connected";
        DeviceConnectionState[DeviceConnectionState["Disconnected"] = 2] = "Disconnected";
    })(DeviceConnectionState = DalConstants.DeviceConnectionState || (DalConstants.DeviceConnectionState = {}));
    let WorkPlanNotificationType;
    (function (WorkPlanNotificationType) {
        WorkPlanNotificationType[WorkPlanNotificationType["MissingWork"] = 1] = "MissingWork";
        WorkPlanNotificationType[WorkPlanNotificationType["Absent"] = 2] = "Absent";
    })(WorkPlanNotificationType = DalConstants.WorkPlanNotificationType || (DalConstants.WorkPlanNotificationType = {}));
    let PPermissionClaimProfile;
    (function (PPermissionClaimProfile) {
        PPermissionClaimProfile[PPermissionClaimProfile["Manual"] = 1] = "Manual";
        PPermissionClaimProfile[PPermissionClaimProfile["Auto"] = 2] = "Auto";
    })(PPermissionClaimProfile = DalConstants.PPermissionClaimProfile || (DalConstants.PPermissionClaimProfile = {}));
    let MonthlySummaryReportDateFilterGroup;
    (function (MonthlySummaryReportDateFilterGroup) {
        MonthlySummaryReportDateFilterGroup[MonthlySummaryReportDateFilterGroup["Weekly"] = 1] = "Weekly";
        MonthlySummaryReportDateFilterGroup[MonthlySummaryReportDateFilterGroup["Monthly"] = 2] = "Monthly";
        MonthlySummaryReportDateFilterGroup[MonthlySummaryReportDateFilterGroup["Annually"] = 3] = "Annually";
        MonthlySummaryReportDateFilterGroup[MonthlySummaryReportDateFilterGroup["Whole"] = 4] = "Whole";
    })(MonthlySummaryReportDateFilterGroup = DalConstants.MonthlySummaryReportDateFilterGroup || (DalConstants.MonthlySummaryReportDateFilterGroup = {}));
    let PPermissionFilterSortType;
    (function (PPermissionFilterSortType) {
        PPermissionFilterSortType[PPermissionFilterSortType["PPermissionStart"] = 1] = "PPermissionStart";
        PPermissionFilterSortType[PPermissionFilterSortType["PPermissionEnd"] = 2] = "PPermissionEnd";
        PPermissionFilterSortType[PPermissionFilterSortType["PPermissionDuration"] = 3] = "PPermissionDuration";
        PPermissionFilterSortType[PPermissionFilterSortType["PPermissionType"] = 4] = "PPermissionType";
        PPermissionFilterSortType[PPermissionFilterSortType["PPermissionApproval"] = 5] = "PPermissionApproval";
        PPermissionFilterSortType[PPermissionFilterSortType["PPermissionRequestDate"] = 6] = "PPermissionRequestDate";
    })(PPermissionFilterSortType = DalConstants.PPermissionFilterSortType || (DalConstants.PPermissionFilterSortType = {}));
    let DurationInRegionOverviewSortType;
    (function (DurationInRegionOverviewSortType) {
        DurationInRegionOverviewSortType[DurationInRegionOverviewSortType["UserName"] = 1] = "UserName";
        DurationInRegionOverviewSortType[DurationInRegionOverviewSortType["Duration"] = 2] = "Duration";
    })(DurationInRegionOverviewSortType = DalConstants.DurationInRegionOverviewSortType || (DalConstants.DurationInRegionOverviewSortType = {}));
    let DurationInRegionDetailSortType;
    (function (DurationInRegionDetailSortType) {
        DurationInRegionDetailSortType[DurationInRegionDetailSortType["Date"] = 1] = "Date";
        DurationInRegionDetailSortType[DurationInRegionDetailSortType["Duration"] = 2] = "Duration";
    })(DurationInRegionDetailSortType = DalConstants.DurationInRegionDetailSortType || (DalConstants.DurationInRegionDetailSortType = {}));
    let ReportTemplateType;
    (function (ReportTemplateType) {
        ReportTemplateType[ReportTemplateType["AccessLogs"] = 1] = "AccessLogs";
        ReportTemplateType[ReportTemplateType["PACSDailyWorkingDetailsForEmployees"] = 8] = "PACSDailyWorkingDetailsForEmployees";
        ReportTemplateType[ReportTemplateType["RegionState"] = 3] = "RegionState";
        ReportTemplateType[ReportTemplateType["DurationInRegionReportOverview"] = 40] = "DurationInRegionReportOverview";
        ReportTemplateType[ReportTemplateType["EntryByUnit"] = 41] = "EntryByUnit";
        ReportTemplateType[ReportTemplateType["FirstAndLastAccessLogs"] = 20] = "FirstAndLastAccessLogs";
        ReportTemplateType[ReportTemplateType["FirstAndLastAccessLogsForSingleUser"] = 21] = "FirstAndLastAccessLogsForSingleUser";
        ReportTemplateType[ReportTemplateType["InstantAttendanceStatus"] = 27] = "InstantAttendanceStatus";
        ReportTemplateType[ReportTemplateType["PACSWorkingDetailsForEmployeesInDateRange"] = 30] = "PACSWorkingDetailsForEmployeesInDateRange";
        ReportTemplateType[ReportTemplateType["PACSWorkingDetailsForSingleEmployeeDateRange"] = 24] = "PACSWorkingDetailsForSingleEmployeeDateRange";
        ReportTemplateType[ReportTemplateType["CustomReport"] = 99] = "CustomReport";
    })(ReportTemplateType = DalConstants.ReportTemplateType || (DalConstants.ReportTemplateType = {}));
    let LicenseControlPolicy;
    (function (LicenseControlPolicy) {
        LicenseControlPolicy[LicenseControlPolicy["Disabled"] = 1] = "Disabled";
        LicenseControlPolicy[LicenseControlPolicy["Instant"] = 2] = "Instant";
    })(LicenseControlPolicy = DalConstants.LicenseControlPolicy || (DalConstants.LicenseControlPolicy = {}));
    let HistoryActionType;
    (function (HistoryActionType) {
        HistoryActionType[HistoryActionType["Add"] = 1] = "Add";
        HistoryActionType[HistoryActionType["Update"] = 2] = "Update";
        HistoryActionType[HistoryActionType["Delete"] = 3] = "Delete";
    })(HistoryActionType = DalConstants.HistoryActionType || (DalConstants.HistoryActionType = {}));
    DalConstants.WellKnownSmtpServices = {
        MailJet: "Mailjet",
    };
    let SourceType;
    (function (SourceType) {
        SourceType[SourceType["User"] = 1] = "User";
        SourceType[SourceType["Integration"] = 2] = "Integration";
        SourceType[SourceType["System"] = 3] = "System";
    })(SourceType = DalConstants.SourceType || (DalConstants.SourceType = {}));
    let WorkPlanImportTemplateType;
    (function (WorkPlanImportTemplateType) {
        WorkPlanImportTemplateType[WorkPlanImportTemplateType["DateRange"] = 1] = "DateRange";
        WorkPlanImportTemplateType[WorkPlanImportTemplateType["Cyclical"] = 2] = "Cyclical";
    })(WorkPlanImportTemplateType = DalConstants.WorkPlanImportTemplateType || (DalConstants.WorkPlanImportTemplateType = {}));
})(DalConstants = exports.DalConstants || (exports.DalConstants = {}));
