"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PSQLDalAccessNotifications = void 0;
const libAccessModels = __importStar(require("../../../lib/access-model"));
const crypto_1 = __importDefault(require("crypto"));
const luxon_1 = require("luxon");
const uuid_1 = __importDefault(require("uuid"));
const api_error_1 = require("../../../api/api.error");
const app_constants_1 = require("../../../app.constants");
const app_enums_1 = require("../../../app.enums");
const business_main_1 = require("../../../business/business.main");
const generator_1 = require("../../../business/notification/generator");
const restapi_1 = require("../../../lib/es/models/restapi");
const dal_constants_1 = require("../../dal.constants");
const dal_manager_1 = require("../../dal.manager");
const dal_db_armon_schema_1 = require("../../db/armon/dal.db.armon.schema");
const dal_access_error_1 = require("../dal.access.error");
const dal_memcache_1 = require("../dal.memcache");
const dal_access_rdb_notifications_1 = require("../rdb/dal.access.rdb.notifications");
const dal_utils_1 = require("../../dal.utils");
const Cursor = require("pg-cursor");
class PSQLDalAccessNotifications extends dal_access_rdb_notifications_1.RDBDalAccessNotifications {
    constructor(knex, pgPool) {
        super(knex, pgPool);
    }
    async getAccessNotificationEvents(organizationId, deviceId, trx) {
        let qb = this.dbClient
            .withSchema(organizationId)
            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints + " as acp")
            .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints + " as racp", "acp.id", "racp.accessControlPointId")
            .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.notificationAccess + " as uoan", "uoan.regionId", "racp.regionId")
            .where("acp.deviceId", deviceId)
            .select("uoan.id", "uoan.targetUserId", "uoan.regionId", this.dbClient.raw(`uoan.options->'direction' as direction`), this.dbClient.raw(`uoan.options->'success' as success`));
        if (trx) {
            qb.transacting(trx);
        }
        return qb;
    }
    async getAccessNotificationEventsWithPagination(organizationId, deviceId, pagination, trx) {
        let qb = this.dbClient
            .withSchema(organizationId)
            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints + " as acp")
            .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints + " as racp", "acp.id", "racp.accessControlPointId")
            .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.notificationAccess + " as uoan", "uoan.regionId", "racp.regionId")
            .where("acp.deviceId", deviceId);
        if (trx) {
            qb.transacting(trx);
        }
        let paginationResponse = {
            take: pagination.take,
            skip: pagination.skip,
            total: parseInt((await qb.clone().count().first()).count),
        };
        if (pagination.take) {
            qb.limit(pagination.take);
        }
        if (pagination.skip) {
            qb.offset(pagination.skip);
        }
        let events = await qb
            .orderBy("uoan.id", "desc")
            .select("uoan.id", "uoan.targetUserId", "uoan.regionId", this.dbClient.raw(`uoan.options->'direction' as direction`), this.dbClient.raw(`uoan.options->'success' as success`));
        return Promise.resolve({
            pagination: paginationResponse,
            events: events,
        });
    }
    async getUnreadNotificationsCount(params) {
        const { rows } = await params.trx.query(`SELECT COUNT(*)::INTEGER AS C FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}			
				WHERE "receiverUserId" = $1 
				AND state = $2
				AND medium = $3`, [params.userId, 4, restapi_1.NotificationMedium.Web]);
        return rows[0].c;
    }
    async listDeviceSensorNotifications(organizationId, deviceId, trx) {
        let result = [];
        let transactionScope = async (trx) => {
            const dbResult = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.notificationSensor + " as ns")
                .innerJoin("accessControlPoints as acp", "acp.id", "ns.accessControlPointId")
                .whereNull("acp.deletedAt")
                .where("acp.deviceId", deviceId)
                .select("ns.id", "ns.accessControlPointId", "ns.options", "ns.sensorType", "ns.deviceDryContactInputId");
            const mappingResult = dbResult.map((row) => {
                return {
                    id: row.id,
                    accessControlPointId: row.accessControlPointId,
                    statusSensorInfo: row.sensorType === dal_constants_1.DalConstants.libEnumsV2.NotificationSensorType.Status
                        ? {
                            ...row.options,
                            statusSensorId: row.deviceDryContactInputId,
                        }
                        : undefined,
                    counterSensorInfo: row.sensorType === dal_constants_1.DalConstants.libEnumsV2.NotificationSensorType.Counter
                        ? {
                            ...row.options,
                            counterSensorId: row.deviceDryContactInputId,
                        }
                        : undefined,
                    sensorType: row.sensorType,
                };
            });
            return mappingResult;
        };
        if (trx) {
            result = await transactionScope(trx);
        }
        else {
            result = await this.dbClient.transaction(transactionScope);
        }
        return Promise.resolve(result);
    }
    async uploadAttachment(organizationId, fileName) {
        let id = uuid_1.default.v4();
        await this.dbClient.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.notificationAttachments).insert({
            id: id,
            name: fileName,
            actionUtc: new Date(),
        });
        return Promise.resolve(id);
    }
    async removeAttachment(organizationId, attachmentId) {
        let affectedRowCount = 0;
        await this.dbClient
            .withSchema(organizationId)
            .table(dal_db_armon_schema_1.ArmonSchema.tableNames.notificationAttachments)
            .where("id", attachmentId)
            .del()
            .then((result) => (affectedRowCount = result));
        return Promise.resolve(affectedRowCount > 0);
    }
    async getAttachment(organizationId, attachmentId) {
        let result = await this.dbClient.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.notificationAttachments).where("id", attachmentId).select("name").first();
        if (!result) {
            (0, dal_access_error_1.throwDbAccessNotFoundError)("attachment not found");
        }
        return Promise.resolve(result.name);
    }
    async listAttachments(organizationId, attachmentIds) {
        return await this.dbClient.withSchema(organizationId).table(dal_db_armon_schema_1.ArmonSchema.tableNames.notificationAttachments).whereIn("id", attachmentIds).select("id", "name as filename");
    }
    async setAllNotificationInstancesOfUserAsRead(params) {
        const { rows, rowCount } = await params.trx.query(`SELECT "mediumGroupId" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}"
			 WHERE state = $1 
			 AND medium = $2 
			 AND "receiverUserId" = $3`, [4, params.medium, params.userId]);
        if (rowCount === 0)
            return;
        await params.trx.query(`UPDATE "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}"
			 	SET state = $1
			 WHERE "mediumGroupId" = ANY($2::uuid[]) 
			 AND (medium = $3 OR medium = $4)`, [5, rows.map((row) => row.mediumGroupId), app_enums_1.enums.NotificationMedium.PushNotification, app_enums_1.enums.NotificationMedium.Web]);
    }
    async updateNotificationInstanceStates(params) {
        const qb = [];
        let q = `UPDATE "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}
				 	SET state = $1
				 WHERE "eventId" = $2
				 AND state = ANY ($3::smallint[])`;
        qb.push(params.newState, params.eventId, params.currentStates);
        if (params.notIncludeFailedAndNoNeedToRetryInstances) {
            q += ` AND (note->'errorCode')::smallint = ANY($4::smallint[]) `;
            qb.push(app_constants_1.retryNotificationErrorCodes);
        }
        await params.trx.query(q, qb);
    }
    async setNotificationInstanceState(params) {
        const { rows, rowCount } = await params.trx.query(`SELECT id, state, note, "mediumGroupId" FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance} 
				WHERE id = $1`, [params.instanceId]);
        if (rowCount === 0)
            (0, dal_access_error_1.throwDbAccessNotFoundError)(`Notification instance is not found [${params.instanceId}]`);
        const instance = rows[0];
        let qx = 1;
        const qb = [];
        const qs = [`state = $${qx++}`];
        qb.push(params.state);
        if (params.actionNote) {
            qs.push(`note = $${qx++}`);
            let notes = instance.note;
            if (notes) {
                notes.push(params.actionNote);
            }
            else {
                notes = [params.actionNote];
            }
            qb.push(JSON.stringify(notes));
        }
        let q = "";
        if (params.state === 5) {
            q = `UPDATE "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}
					SET ${qs.join(",")}
				 WHERE "mediumGroupId" = $${qx++} 
				 AND (medium = $${qx++} OR medium = $${qx++})`;
            qb.push(instance.mediumGroupId, app_enums_1.enums.NotificationMedium.PushNotification, app_enums_1.enums.NotificationMedium.Web);
        }
        else {
            q = `UPDATE "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}
					SET ${qs.join(",")}
				 WHERE id = $${qx++}`;
            qb.push(params.instanceId);
        }
        await params.trx.query(q, qb);
    }
    async listDeletedNotifications(organizationId, params, trx) {
        const { filter, pagination } = params;
        const qb = [];
        let qx = 1;
        let qfrom = `			
			FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification} zn
			LEFT JOIN "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_access} zna
				ON zn.id = zna.id AND zn.action = $${qx} AND zna.action = $${qx++}
		`;
        const qw = [];
        qb.push(dal_constants_1.DalConstants.HistoryActionType.Delete);
        if (filter?.ids?.length > 0) {
            const qi = [];
            for (const i of filter.ids) {
                qi.push(`$${qx++}`);
                qb.push(i);
            }
            qw.push(`zn.id = ANY({${qi.join(",")}}::uuid[])`);
        }
        if (filter?.types?.length > 0) {
            const qt = [];
            for (const t of filter.types) {
                qt.push(`$${qx++}`);
                qb.push(t);
            }
            qw.push(`zn.type IN (${qt.join(",")}::INTEGER)`);
        }
        if (filter?.mediums?.email) {
            qw.push(`zn.email = TRUE`);
        }
        if (filter?.mediums?.web) {
            qw.push(`zn.web = TRUE`);
        }
        if (filter?.mediums?.sms) {
            qw.push(`zn.sms = TRUE`);
        }
        if (filter?.mediums?.pushNotification) {
            qw.push(`zn."pushNotification" = TRUE`);
        }
        if (filter?.createdBySystem) {
            qw.push(`zn."createdByUserId" IS NULL`);
        }
        else if (filter?.createdBySystem === false && !filter?.createdByUserId) {
            qw.push(`zn."createdByUserId" IS NOT NULL`);
        }
        else if (filter?.createdByUserId) {
            qw.push(`zn."createdByUserId" = $${qx++}`);
            qb.push(filter?.createdByUserId);
        }
        if (params.filter?.when) {
            const qt = [];
            if (params.filter.when === 1) {
                for (const t of dal_constants_1.DalConstants.eventTriggeredNotifications) {
                    qt.push(`$${qx++}`);
                    qb.push(t);
                }
            }
            else if (params.filter.when === 2) {
                for (const t of dal_constants_1.DalConstants.scheduledJobTriggerNotifications) {
                    qt.push(`$${qx++}`);
                    qb.push(t);
                }
            }
            qw.push(`zn.type IN (${qt.join(",")}::smallint)`);
        }
        let qws = "";
        if (qw.length > 0) {
            qws =
                `
				WHERE ` + qw.join(" AND ");
        }
        const qtotal = `SELECT COUNT(*) AS C ` + qfrom + qws;
        const totalResult = await trx.query(qtotal, qb);
        const result = {
            pagination: {
                total: totalResult.rowCount > 0 ? parseInt(totalResult.rows[0].c) : 0,
                skip: pagination.skip || 0,
                take: pagination.take || 100,
            },
            items: [],
        };
        if (result.pagination.total === 0) {
            return result;
        }
        qfrom += `
			LEFT JOIN "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.viewNames.vwUserFilter} AS f
			ON f.id = zn."receiverFilterId"
			LEFT JOIN
			(SELECT T1."notificationId", json_build_object('id', T1.id, 
									'createdT', T1."createdT", 
									'instanceData', T1."instanceData", 
									'receiverCount', T1.rc::integer, 
									'mediumStateCounts', T2.agg) AS "lastEventRaw" FROM
			(SELECT zne.id, zne."createdT", zne."instanceData", zne."notificationId", count(distinct(zoni."receiverUserId")) as rc
			FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_event} zne
			INNER JOIN "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_instance} zoni 
				ON zoni."eventId" = zne.id AND zoni."createdT" = zne."createdT" AND zne.action = $${qx} AND zoni.action = $${qx}
			GROUP BY zne.id, zne."createdT", zne."instanceData", zne."notificationId") AS T1 
			INNER JOIN 
			(SELECT id, json_agg(json_build_object('medium', "medium", 
									'state', "state",
										'count', "cc"
									)) as agg
			FROM (
			SELECT zne.id, zoni."medium", zonis."state", count(*) as cc	
			FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_event} as zne
			INNER JOIN "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_instance} as zoni 
				ON zoni."eventId" = zne.id AND zoni."createdT" = zne."createdT" AND zne.action = $${qx} AND zoni.action = $${qx}
			LEFT JOIN (
                SELECT DISTINCT ON (id) id, state
                FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_instance_state} zonis
                ORDER BY id, "actionT" DESC
            ) zonis ON zonis.id = zoni.id
			GROUP BY zne.id, zne."createdT", zoni."medium", zonis."state") AS T
			GROUP BY id) AS T2 ON T1.id = T2.id
			ORDER BY "createdT" DESC) AS le ON le."notificationId" = zn.id AND zn.action = $${qx++}
		`;
        qb.push(dal_constants_1.DalConstants.HistoryActionType.Delete);
        let q = qfrom + qws + ` ORDER BY zn.id, ("lastEventRaw"->>'createdT')::timestamp with time zone DESC `;
        if (pagination?.skip > 0) {
            q += ` OFFSET $${qx++} `;
            qb.push(pagination.skip);
        }
        q += ` LIMIT $${qx++} `;
        qb.push(pagination.take || 100);
        q =
            `SELECT DISTINCT ON (zn.id) zn.id, zn.type, f.filter as "receiverFilter", zn."settings", le."lastEventRaw", 
			json_build_object('sms', zn.sms, 'email', zn.email, 'web', zn.web, 'pushNotification', zn."pushNotification") as mediums,
			zn."createdByUserId", zn."createdT" AS "createdAt", zna."targetUserId"
			` + q;
        const { rows } = await trx.query(q, qb);
        const contents = await trx.query(`SELECT DISTINCT ON (id) id, "notificationId", content FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_instance}"
			 WHERE "notificationId" = ANY($1::uuid[]) AND action = $2 AND medium = $3
			 ORDER BY id, "actionT" DESC`, [rows.map((row) => row.id), dal_constants_1.DalConstants.HistoryActionType.Delete, restapi_1.NotificationMedium.Web]);
        for (const row of rows) {
            let settings;
            if (row.type === restapi_1.NotificationType.IdentityAccess) {
                const targetUser = row.targetUserId
                    ? {
                        id: row.targetUserId,
                        caption: (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId, userId: row.targetUserId, trx })).caption,
                    }
                    : null;
                settings = {
                    targetUser,
                };
            }
            const createdBy = row.createdByUserId
                ? {
                    id: row.createdByUserId,
                    caption: (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId, userId: row.createdByUserId, trx })).caption,
                }
                : undefined;
            row.createdByUserId = undefined;
            let lastEvent = undefined;
            if (row.lastEventRaw) {
                const mediums = {};
                const states = {};
                for (const agg of row.lastEventRaw.mediumStateCounts) {
                    if (!mediums[agg.medium]) {
                        mediums[agg.medium] = {};
                    }
                    if (agg.state) {
                        if (!mediums[agg.medium][agg.state]) {
                            mediums[agg.medium][agg.state] = agg.count;
                        }
                        else {
                            mediums[agg.medium][agg.state] += agg.count;
                        }
                    }
                    if (!states[agg.state]) {
                        states[agg.state] = agg.count;
                    }
                    else {
                        states[agg.state]++;
                    }
                }
                lastEvent = {
                    mediums: mediums,
                    notificationId: row.id,
                    receiverCount: row.lastEventRaw.receiverCount,
                    states: states,
                    archived: true,
                    content: contents.rows.find((contentRow) => contentRow.notificationId === row.id)?.content,
                    createdT: row.lastEventRaw.createdT,
                    id: row.lastEventRaw.id,
                };
            }
            result.items.push({
                id: row.id,
                createdT: row.createdT,
                receiverFilter: row.receiverFilter,
                mediums: row.mediums,
                type: row.type,
                settings,
                createdBy,
                lastEvent,
                archived: true,
            });
        }
        return result;
    }
    async listNotifications(organizationId, requesterUserId, params, trx) {
        const { filter, pagination } = params;
        const qb = [];
        let qx = 1;
        let qfrom = `			
			FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notification} n
			LEFT OUTER JOIN public."${dal_db_armon_schema_1.ArmonSchema.tableNames.scheduled_job}" as sj ON sj."notificationId" = n.id		
			LEFT OUTER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.reportScheduledJobs}" rsj ON sj.id = rsj.id	
			LEFT OUTER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.reportTemplates}" rt ON rt.id = rsj."reportTemplateId"
			LEFT OUTER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationAccess}" na ON n.id = na.id
			LEFT OUTER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationSensor}" ns ON n.id = ns.id
			LEFT OUTER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.customReports}" cr ON rt."customReportId" = cr.id
		`;
        const qw = [];
        if (filter?.ids?.length > 0) {
            const qi = [];
            for (const i of filter.ids) {
                qi.push(`$${qx++}`);
                qb.push(i);
            }
            qw.push(`n.id = ANY({${qi.join(",")}}::uuid[])`);
        }
        if (filter?.types?.length > 0) {
            const qt = [];
            for (const t of filter.types) {
                qt.push(`$${qx++}`);
                qb.push(t);
            }
            qw.push(`n.type IN (${qt.join(",")}::INTEGER)`);
        }
        if (filter?.mediums?.email) {
            qw.push(`n.email = TRUE`);
        }
        if (filter?.mediums?.web) {
            qw.push(`n.web = TRUE`);
        }
        if (filter?.mediums?.sms) {
            qw.push(`n.sms = TRUE`);
        }
        if (filter?.mediums?.pushNotification) {
            qw.push(`n."pushNotification" = TRUE`);
        }
        if (filter?.createdBySystem) {
            qw.push(`n."createdByUserId" IS NULL`);
        }
        else if (filter?.createdBySystem === false && !filter?.createdByUserId) {
            qw.push(`n."createdByUserId" IS NOT NULL`);
        }
        else if (filter?.createdByUserId) {
            qw.push(`n."createdByUserId" = $${qx++}`);
            qb.push(filter?.createdByUserId);
        }
        if (params.filter?.when) {
            const qt = [];
            if (params.filter.when === 1) {
                for (const t of dal_constants_1.DalConstants.eventTriggeredNotifications) {
                    qt.push(`$${qx++}`);
                    qb.push(t);
                }
            }
            else if (params.filter.when === 2) {
                for (const t of dal_constants_1.DalConstants.scheduledJobTriggerNotifications) {
                    qt.push(`$${qx++}`);
                    qb.push(t);
                }
            }
            qw.push(`n.type IN (${qt.join(",")}::smallint)`);
        }
        let qws = "";
        if (qw.length > 0) {
            qws =
                `
				WHERE ` + qw.join(" AND ");
        }
        const qtotal = `SELECT COUNT(*) AS C ` + qfrom + qws;
        const totalResult = await trx.query(qtotal, qb);
        const result = {
            pagination: {
                total: totalResult.rowCount > 0 ? parseInt(totalResult.rows[0].c) : 0,
                skip: pagination.skip || 0,
                take: pagination.take || 100,
            },
            items: [],
        };
        if (result.pagination.total === 0) {
            return result;
        }
        qfrom += `
			LEFT JOIN "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.userFilter} AS uf
				ON uf.id = n."receiverFilterId"
			LEFT OUTER JOIN
			(SELECT T1."notificationId", json_build_object('id', T1.id, 
									'createdT', T1."createdT", 
									'instanceData', T1."instanceData", 
									'receiverCount', T1.rc::integer, 
									'mediumStateCounts', T2.agg) AS "lastEventRaw" FROM
			(SELECT ne.id, ne."createdT", ne."instanceData", ne."notificationId", count(distinct(oni."receiverUserId")) as rc
			FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent} as ne
			INNER JOIN "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance} as oni on oni."eventId" = ne.id 
			AND oni."createdT" = ne."createdT"
			GROUP BY ne.id, ne."createdT") AS T1 
			INNER JOIN 
			(SELECT id, json_agg(json_build_object('medium', "medium", 
									'state', "state",
										'count', "cc"
									)) as agg
			FROM (
			SELECT ne.id, oni."medium", oni."state", count(*) as cc	
			FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent} as ne
			INNER JOIN "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance} as oni 
				ON oni."eventId" = ne.id
			AND oni."createdT" = ne."createdT"
			GROUP BY ne.id, ne."createdT", oni."medium", oni."state") AS T
			GROUP BY id) AS T2 ON T1.id = T2.id
			ORDER BY "createdT" DESC) AS le ON le."notificationId" = n.id
		`;
        let q = qfrom + qws + ` ORDER BY n.id, ("lastEventRaw"->>'createdT')::timestamp with time zone DESC `;
        if (pagination?.skip > 0) {
            q += ` OFFSET $${qx++} `;
            qb.push(pagination.skip);
        }
        q += ` LIMIT $${qx++} `;
        qb.push(pagination.take || 100);
        q =
            `
			SELECT	DISTINCT ON (n.id) n.id, 
					n.type, 
					CASE WHEN uf.id IS NOT NULL THEN jsonb_build_object('id', uf.id, 'name', uf.name) END  as "receiverFilter", 
					n."settings", 
					le."lastEventRaw", 
					json_build_object('sms', n.sms, 'email', n.email, 'web', n.web, 'pushNotification', n."pushNotification") as mediums,
					n."createdByUserId", 
					n."createdT" AS "createdAt",
					sj.id as "scheduledJobId", 
					rsj."reportTemplateId",
					rt.name as "reportTemplateName", 
					rt.type as "reportType", 
					na."targetUserId", 
					na."regionId", 
					na.options as "accessOptions", 
					cr.id as "customReportId",
					ns."accessControlPointId", 
					ns."deviceDryContactInputId", 
					ns."sensorType", 
					ns.options as "sensorOptions"
			` + q;
        const { rows } = await trx.query(q, qb);
        for (const row of rows) {
            let settings;
            if (row.type === restapi_1.NotificationType.ScheduledReport) {
                settings = {
                    ...row.settings,
                    templateName: row.reportTemplateName,
                    reportType: row.reportType,
                    customReportId: row.customReportId ?? undefined,
                    templateId: row.reportTemplateId,
                };
            }
            else if (row.type === restapi_1.NotificationType.IdentityAccess) {
                const targetUser = row.targetUserId
                    ? {
                        id: row.targetUserId,
                        caption: (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId, userId: row.targetUserId, trx })).caption,
                    }
                    : null;
                settings = {
                    ...row.settings,
                    targetUser,
                    regionId: row.regionId,
                    options: row.accessOptions,
                };
            }
            else if (row.type === restapi_1.NotificationType.SelfIdentityAccess) {
                settings = {
                    message: row.settings.m,
                    regionId: row.regionId,
                    options: row.accessOptions,
                };
            }
            else if (row.type === restapi_1.NotificationType.StatusSensor) {
                settings = {
                    accessControlPointId: row.accessControlPointId,
                    deviceDryContactInputId: row.deviceDryContactInputId,
                    options: row.sensorOptions,
                    sensorType: row.sensorType,
                };
            }
            else if (row.type === restapi_1.NotificationType.CounterSensor) {
                settings = {
                    accessControlPointId: row.accessControlPointId,
                    deviceDryContactInputId: row.deviceDryContactInputId,
                    options: row.sensorOptions,
                    sensorType: row.sensorType,
                };
            }
            const createdBy = row.createdByUserId
                ? {
                    id: row.createdByUserId,
                    caption: (await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId, userId: row.createdByUserId, trx })).caption,
                }
                : undefined;
            row.createdByUserId = undefined;
            let lastEvent = undefined;
            if (row.lastEventRaw) {
                const mediums = {};
                const states = {};
                for (const agg of row.lastEventRaw.mediumStateCounts) {
                    if (!mediums[agg.medium]) {
                        mediums[agg.medium] = {};
                    }
                    if (agg.state) {
                        if (!mediums[agg.medium][agg.state]) {
                            mediums[agg.medium][agg.state] = agg.count;
                        }
                        else {
                            mediums[agg.medium][agg.state] += agg.count;
                        }
                    }
                    if (!states[agg.state]) {
                        states[agg.state] = agg.count;
                    }
                    else {
                        states[agg.state]++;
                    }
                }
                lastEvent = {
                    mediums: mediums,
                    notificationId: row.id,
                    receiverCount: row.lastEventRaw.receiverCount,
                    states: states,
                    archived: false,
                    content: (await (0, generator_1.generateNotificationContent)({
                        medium: app_enums_1.enums.NotificationMedium.Web,
                        organizationId,
                        notification: {
                            createdT: row.lastEventRaw.createdT,
                            notificationId: row.id,
                            type: row.type,
                        },
                        trx,
                        receiverUser: await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId, userId: requesterUserId, trx }),
                        instanceData: row.lastEventRaw.instanceData,
                        forListing: true,
                    })),
                    createdT: row.lastEventRaw.createdT,
                    id: row.lastEventRaw.id,
                };
            }
            result.items.push({
                id: row.id,
                createdT: row.createdT,
                receiverFilter: row.receiverFilter,
                mediums: row.mediums,
                type: row.type,
                settings: settings,
                scheduledJobId: row.scheduledJobId,
                createdBy,
                lastEvent,
                archived: false,
            });
        }
        return result;
    }
    async addNotification(params) {
        const orgSettings = await (0, dal_memcache_1.getCacheOrganizationSettings)(params.organizationId, params.trx);
        if (!orgSettings.notification.enabledTypes.includes(params.data.type)) {
            throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.INTERNAL_ERROR, "ERRORS.NOTIFICATION.TYPENOTENABLED", null, true);
        }
        const id = uuid_1.default.v4();
        const receiverFilterId = params.data.receiverFilterId;
        const settingsFromParams = params.data.settings;
        const utype = params.data.type;
        if (utype === 1 ||
            utype === 3 ||
            utype === 2) {
            params.data.settings = null;
        }
        await params.trx.query(`INSERT INTO "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notification}"
        (id, "createdT", type, "receiverFilterId", "settings", email, sms, "pushNotification", web, "createdByUserId")
        VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10)
        `, [
            id,
            new Date(),
            params.data.type,
            receiverFilterId,
            params.data.settings,
            params.data.mediums.email || false,
            params.data.mediums.sms || false,
            params.data.mediums.pushNotification || false,
            params.data.mediums.web || false,
            params.createdByUserId || null,
        ]);
        if (utype === 1 || utype === 45) {
            const settings = settingsFromParams;
            await params.trx.query(`INSERT INTO "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationAccess}"
				(id, "targetUserId", "regionId", options) 
				VALUES ($1,$2,$3,$4)`, [id, settings.targetUserId, settings.regionId, settings.options]);
        }
        else if (utype === 3 || utype === 2) {
            const settings = settingsFromParams;
            await params.trx.query(`INSERT INTO "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationSensor}"
				(id, "accessControlPointId", "sensorType", "deviceDryContactInputId", options) 
				VALUES ($1,$2,$3,$4,$5)`, [id, settings.accessControlPointId, settings.sensorType, settings.deviceDryContactInputId, settings.options]);
        }
        return id;
    }
    async updateNotification(params) {
        const notification = await this.getNotification(params.organizationId, params.id, params.trx);
        if (!notification) {
            (0, dal_access_error_1.throwDbAccessNotFoundError)("Notification is not found");
        }
        const settingsFromParams = params.data.settings;
        const utype = notification.type;
        if (utype === 1 ||
            utype === 3 ||
            utype === 2) {
            params.data.settings = null;
        }
        let q = `UPDATE "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notification} SET `;
        let qsets = [];
        let qx = 1;
        const qb = [];
        if (params.data.mediums) {
            if (params.data.mediums.email !== undefined) {
                qsets.push(`email = $${qx++}`);
                qb.push(params.data.mediums.email);
            }
            if (params.data.mediums.sms !== undefined) {
                qsets.push(`sms = $${qx++}`);
                qb.push(params.data.mediums.sms);
            }
            if (params.data.mediums.pushNotification !== undefined) {
                qsets.push(`"pushNotification" = $${qx++}`);
                qb.push(params.data.mediums.pushNotification);
            }
            if (params.data.mediums.web !== undefined) {
                qsets.push(`web = $${qx++}`);
                qb.push(params.data.mediums.web);
            }
        }
        if (params.data.receiverFilterId) {
            qsets.push(`"receiverFilterId" = $${qx++}`);
            qb.push(params.data.receiverFilterId);
        }
        if (params.data.settings) {
            qsets.push(`"settings" = $${qx++}`);
            qb.push(params.data.settings);
        }
        q += qsets.join(",") + ` WHERE id = $${qx++}`;
        qb.push(params.id);
        await params.trx.query(q, qb);
        if (notification.type === app_enums_1.enums.NotificationType.IdentityAccess || notification.type === app_enums_1.enums.NotificationType.SelfIdentityAccess) {
            const instanceContext = settingsFromParams;
            await params.trx.query(`UPDATE "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationAccess}"
					SET "targetUserId" = $1,
						"regionId" = $2,
						options = $3
					WHERE id = $4
			`, [instanceContext.targetUserId, instanceContext.regionId, instanceContext.options, notification.id]);
        }
        else if (notification.type === app_enums_1.enums.NotificationType.CounterSensor || notification.type === app_enums_1.enums.NotificationType.StatusSensor) {
            const instanceContext = settingsFromParams;
            await params.trx.query(`UPDATE "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationSensor}"
				SET "accessControlPointId" = $1, 
					"sensorType" = $2, 
					"deviceDryContactInputId" = $3, 
					options = $4
				WHERE id = $5 
				`, [instanceContext.accessControlPointId, instanceContext.sensorType, instanceContext.deviceDryContactInputId, instanceContext.options, notification.id]);
        }
    }
    async getNotificationOfEvent(params) {
        const { rows, rowCount } = await (params.trx ?? this._pgPool).query(`SELECT n.id as "notificationId", ne."createdT", n.type, f.filter, 
					n.email, n.sms, n."pushNotification", n.web 
			FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent} AS ne
			INNER JOIN "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notification} AS n
				ON ne."notificationId" = n.id
			LEFT JOIN "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.viewNames.vwUserFilter} as f 
				ON f.id = ne."receiverFilterId"
			WHERE ne.id = $1`, [params.eventId]);
        return rowCount > 0 ? rows[0] : null;
    }
    async getNotification(organizationId, id, trx) {
        const { rows, rowCount } = await trx.query(`SELECT n.id, n."createdT", n.type, f.filter, 
			n."settings", n.email, n.sms, n."pushNotification", n.web 
			FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notification} AS n
			LEFT JOIN "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.viewNames.vwUserFilter} as f 
			ON f.id = n."receiverFilterId"
            WHERE n.id = $1`, [id]);
        if (rowCount > 0) {
            const row = rows[0];
            return row;
        }
        else {
            return null;
        }
    }
    async deleteNotification(params) {
        await params.trx.query(`DELETE FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notification}
            WHERE id = $1`, [params.id]);
    }
    async addNotificationInstance(organizationId, params, trx) {
        await trx.query(`INSERT INTO "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance} (
				id, "createdT", "mediumGroupId", medium, "notificationId", "receiverUserId", content, "eventId", state)
			VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9)`, [params.id, params.createdT, params.mediumGroupId, params.medium, params.notificationId, params.receiverUserId, params.content, params.eventId, params.state]);
    }
    async createNotificationInstancesForUserFilter(organizationId, params, trx) {
        const bindings = [
            params.notification.createdT,
            params.notification.notificationId,
            params.eventId,
            params.state,
            [app_enums_1.enums.NotificationMedium.Web, app_enums_1.enums.NotificationMedium.Email, app_enums_1.enums.NotificationMedium.SMS, app_enums_1.enums.NotificationMedium.PushNotification],
            [params.notification.web, params.notification.email, params.notification.sms, params.notification.pushNotification],
        ];
        let query = `
			INSERT INTO "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}
			(id, "createdT", "mediumGroupId", medium, "notificationId", "receiverUserId", "eventId", state)
			SELECT
				gen_random_uuid() as id,
				$1 as "createdT",
				"mediumGroupId",
				medium,
				$2 as "notificationId",
				"userId" as "receiverUserId",
				$3 as "eventId",
				$4 as state
			FROM (
				SELECT
					"userId",
					"mediumGroupId",
					unnest($5::smallint[]) as medium,
					unnest($6::boolean[]) as notification_type_setting,
					unnest(ARRAY[custom_settings->'web',
								custom_settings->'sms',
								custom_settings->'pushNotification',
								custom_settings->'email']::boolean[]) as custom_setting,
					unnest(ARRAY[general_settings->'web',
								general_settings->'sms',
								general_settings->'pushNotification',
								general_settings->'email']::boolean[]) as general_setting
				FROM (
					SELECT ufr."userId",
						uo.settings->'notification'->'mediumSettings'->'custom'->'19' as custom_settings,
						uo.settings->'notification'->'mediumSettings'->'general' as general_settings,
						gen_random_uuid() as "mediumGroupId"
					FROM(
						`;
        if (params.userIds) {
            bindings.push(params.userIds);
            query += `SELECT unnest($${bindings.length}::uuid[]) as "userId"`;
        }
        else {
            query += (0, dal_utils_1.generateUserFilterQuery)(organizationId, params.notification.filter.id, bindings);
        }
        query += `
					)ufr
					INNER JOIN "${organizationId}"."userOrganizations" uo
						ON uo."userId" = ufr."userId"
				)sq
			) sq2
			WHERE notification_type_setting AND COALESCE(custom_setting, true) AND COALESCE(general_setting, true)`;
        await trx.query(query, bindings);
    }
    async fetchPendingNotificationInstanceOfEvent(organizationId, params, trx) {
        const { rows } = await trx.query(`UPDATE "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}
				SET state = $1
			 WHERE "eventId" = $2 
				AND state = $3 
				AND "createdT" = $4
				AND content IS NULL
			RETURNING id, "createdT", medium, "receiverUserId"`, [2, params.eventId, 1, params.createdT]);
        return rows;
    }
    async getHashedNotifications(trx, onData) {
        const organizationList = await dal_manager_1.dbManager.accessOrganization.listOrganizations(trx);
        const q = organizationList
            .map((organizationId) => {
            return `
			SELECT id, json_build_object(
				'regionId', "regionId",
				'targetUserId', "targetUserId",
				'options', "options"
			) as data, ${app_enums_1.enums.NotificationType.IdentityAccess} AS type FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationAccess}
			UNION ALL
			SELECT id, json_build_object(
				'accessControlPointId', "accessControlPointId",
				'sensorId', "deviceDryContactInputId",
				'options', "options"
			) as data, 
			(CASE WHEN "sensorType" = ${app_enums_1.enums.NotificationSensorType.Status} THEN ${app_enums_1.enums.NotificationType.StatusSensor}
			ELSE ${app_enums_1.enums.NotificationType.CounterSensor} END) AS type FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationSensor}
			`;
        })
            .join(" UNION ALL ");
        const cursor = await trx.query(new Cursor(q, []));
        while (true) {
            const rows = await new Promise((resolve, reject) => {
                cursor.read(100, (err, rows) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(rows);
                    }
                });
            });
            await onData(rows.map((row) => {
                let entropy = null;
                switch (row.type) {
                    case app_enums_1.enums.NotificationType.IdentityAccess:
                        entropy = {
                            direction: row.data.options?.direction ?? null,
                            success: row.data.options?.success ?? null,
                            regionId: row.data.regionId,
                            targetUserId: row.data.targetUserId,
                        };
                        break;
                    case app_enums_1.enums.NotificationType.StatusSensor:
                        entropy = {
                            ...row.data.options,
                            statusSensorId: row.data.sensorId,
                            accessControlPointId: row.data.accessControlPointId,
                        };
                        break;
                    case app_enums_1.enums.NotificationType.CounterSensor:
                        entropy = {
                            ...row.data.options,
                            counterSensorId: row.data.sensorId,
                            accessControlPointId: row.data.accessControlPointId,
                        };
                        break;
                    default:
                        break;
                }
                return {
                    id: row.id,
                    hashKey: this.generateHashKeyFromEntropy(entropy, row.type),
                };
            }));
            if (rows.length < 100) {
                break;
            }
        }
        cursor.close();
    }
    generateHashKeyFromEntropy(hashEntropy, type) {
        let hashKey = "";
        switch (type) {
            case app_enums_1.enums.NotificationType.CounterSensor:
                hashKey = libAccessModels.V3.Utils.generateHashForCounterSensorNotification(hashEntropy);
                break;
            case app_enums_1.enums.NotificationType.StatusSensor:
                hashKey = libAccessModels.V3.Utils.generateHashForStatusSensorNotification(hashEntropy);
                break;
            case app_enums_1.enums.NotificationType.IdentityAccess:
                hashKey = libAccessModels.V3.Utils.generateHashForAccessNotification(hashEntropy);
                break;
        }
        return hashKey;
    }
    async registerTerminalGeneratedNotificationToCache(notificationId, hashKey) {
        if (!hashKey || !notificationId) {
            return;
        }
        let cachedValue = await dal_manager_1.dbManager.accessRedisCache.getValue(hashKey);
        if (cachedValue) {
            let cachedNotificationIds = JSON.parse(cachedValue);
            if (!cachedNotificationIds.includes(notificationId)) {
                cachedNotificationIds.push(notificationId);
            }
            cachedValue = JSON.stringify(cachedNotificationIds);
        }
        else {
            cachedValue = JSON.stringify([notificationId]);
        }
        await dal_manager_1.dbManager.accessRedisCache.setValue(hashKey, cachedValue);
    }
    async unregisterTerminalGeneratedNotificationFromCache(notificationId, hashKey) {
        if (!hashKey || !notificationId) {
            return;
        }
        let cachedValue = await dal_manager_1.dbManager.accessRedisCache.getValue(hashKey);
        if (cachedValue) {
            let cachedNotificationIds = JSON.parse(cachedValue);
            if (!cachedNotificationIds.includes(notificationId)) {
                return;
            }
            else if (cachedNotificationIds.length === 1) {
                await dal_manager_1.dbManager.accessRedisCache.delValue(hashKey);
            }
            else {
                cachedNotificationIds = cachedNotificationIds.filter((f) => f !== notificationId);
                cachedValue = JSON.stringify(cachedNotificationIds);
                await dal_manager_1.dbManager.accessRedisCache.setValue(hashKey, cachedValue);
            }
        }
    }
    async setNotificationContent(organizationId, params, trx) {
        await trx.query(`UPDATE "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance} 
				SET content = $1
			 WHERE "createdT" = $2 AND id = $3`, [params.content, params.createdT, params.id]);
    }
    async getAccessNotificationSettings(params) {
        const dbResult = (await (params.trx || this._pgPool).query(`
			SELECT "targetUserId", "regionId", "options" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationAccess}"
			WHERE id = $1
		`, [params.notificationId])).rows;
        if (dbResult && dbResult.length > 0) {
            return dbResult[0];
        }
        return null;
    }
    async getAccessNotification(params) {
        const { rows, rowCount } = await params.trx.query(`SELECT na."targetUserId", na."regionId", na."options", n.type, n.settings FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationAccess}" na
				 INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notification}" n
				 	USING(id)
				 WHERE id = $1`, [params.notificationId]);
        return rowCount > 0 ? rows[0] : null;
    }
    async listNotificationInstance(organizationId, params, trx) {
        const result = {
            pagination: {
                total: 0,
                take: params.pagination?.take ?? 100,
                skip: params.pagination?.skip ?? 0,
            },
            items: [],
        };
        const filter = params.filter;
        const isArchived = !!filter.archived;
        const bindings = [];
        const baseTable = isArchived ? dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification : dal_db_armon_schema_1.ArmonSchema.tableNames.notification;
        const eventTable = isArchived ? dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_event : dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent;
        const instanceTable = isArchived ? dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_instance : dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance;
        let query = `
		WITH t AS (
			SELECT oni."receiverUserId", 
				ne."createdT", 
				n.id as "notificationId",
				ne.id as "eventId",
				n.type, 
				json_agg(
					jsonb_build_object(
						'notificationInstanceId', oni.id, 
						${isArchived ? "'state', onis.state" : "'state', oni.state"}, 
						'medium', oni.medium, 
						'content', oni.content,
						'createdT', oni."createdT",
						${isArchived ? "'state', onis.note" : "'state', oni.note"}
					)
				) as instances
				FROM "${organizationId}"."${baseTable}" n
				INNER JOIN "${organizationId}"."${eventTable}" ne
					ON ne."notificationId" = n.id AND ne."createdT" > n."createdT"
				INNER JOIN "${organizationId}"."${instanceTable}" oni
					ON ne.id = oni."eventId" AND ne."createdT" = oni."createdT" 
				`;
        if (isArchived) {
            const del = dal_constants_1.DalConstants.HistoryActionType.Delete;
            bindings.push(del, del, del);
            query += `
			AND n.action = $${bindings.length - 2}
			AND ne.action = $${bindings.length - 1}
			AND oni.action = $${bindings.length}`;
            query += `
				LEFT JOIN (
					SELECT DISTINCT ON (id) id, state, note
					FROM "${organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_instance_state} onis
					ORDER BY id, "actionT" DESC
				) onis ON onis.id = oni.id
			`;
        }
        const conditions = [];
        const pushCondition = (condition, value) => {
            if (value !== undefined) {
                bindings.push(value);
                conditions.push(condition.replace("$$", `$${bindings.length}`));
            }
        };
        pushCondition(`n.type = ANY($$)`, filter.types?.length ? filter.types : undefined);
        if (filter.eventTime?.start) {
            pushCondition(`ne."createdT" >= $$`, luxon_1.DateTime.fromISO(filter.eventTime.start).toSQL());
        }
        if (filter.eventTime?.end) {
            pushCondition(`ne."createdT" < $$`, luxon_1.DateTime.fromISO(filter.eventTime.end).toSQL());
        }
        if (filter.when === 1) {
            pushCondition(`n.type = ANY($$)`, dal_constants_1.DalConstants.eventTriggeredNotifications);
        }
        else if (filter.when === 2) {
            pushCondition(`n.type = ANY($$)`, dal_constants_1.DalConstants.scheduledJobTriggerNotifications);
        }
        if (params.filter?.userIds) {
            pushCondition(`oni."receiverUserId" = ANY($$)`, params.filter?.userIds ?? []);
        }
        if (params.filter?.userGroupIds) {
            query += `
			INNER JOIN 	
			(	SELECT  "userId",
						"userGroupId" 
				FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" as uo 
				INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userGroupUserOrganizations}" as uguo
					ON uguo."userOrganizationId" = uo."id" 
				WHERE 	uo."deletedAt" IS NULL 
						AND uguo."deletedAt" IS NULL
			) subq_uguo 
			 	ON subq_uguo."userId" = oni."receiverUserId"
			`;
            bindings.push(params.filter?.userGroupIds);
            conditions.push(`subq_uguo."userGroupId" = ANY($${bindings.length})`);
        }
        if (params.filter?.organizationUnitIds) {
            let subq = `
				SELECT  "userId",
						"organizationUnitId",
						ou."ancestorIds"
				FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" as uo 
				INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationOrganizationUnits}" as uoou
					ON uoou."userOrganizationId" = uo."id" 
				INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" as ou
					ON ou.id = uoou."organizationUnitId"
				WHERE	uo."deletedAt" IS NULL
					  	AND uoou."deletedAt" IS NULL
			`;
            bindings.push(params.filter?.organizationUnitIds);
            if (params.filter?.filterOrganizationUnitMembersHierarchically === true) {
                conditions.push(`(subq_uoou."organizationUnitId" = ANY($${bindings.length}) OR subq_uoou."ancestorIds" similar to '%(' || '${params.filter?.organizationUnitIds.join("|")}' || ')%' )`);
            }
            else {
                conditions.push(`subq_uoou."organizationUnitId" = ANY($${bindings.length})`);
            }
            query += `
			INNER JOIN 	
			(	
				${subq}
			) subq_uoou 
			 	ON subq_uoou."userId" = oni."receiverUserId"
			`;
        }
        if (params.filter?.mediums) {
            const qt = [];
            if (params.filter.mediums.web) {
                qt.push(app_enums_1.enums.NotificationMedium.Web);
            }
            if (params.filter.mediums.sms) {
                qt.push(app_enums_1.enums.NotificationMedium.SMS);
            }
            if (params.filter.mediums.pushNotification) {
                qt.push(app_enums_1.enums.NotificationMedium.PushNotification);
            }
            if (params.filter.mediums.email) {
                qt.push(app_enums_1.enums.NotificationMedium.Email);
            }
            if (qt.length > 0) {
                pushCondition(`oni.medium = ANY($$)`, qt);
            }
        }
        if (params.filter?.states?.length > 0) {
            pushCondition(`oni.state = ANY($$)`, filter.states?.length ? filter.states : undefined);
        }
        if (conditions.length > 0) {
            query +=
                `
			WHERE (` +
                    conditions.join(") AND (") +
                    `)`;
        }
        query += `
			GROUP BY ne.id, ne."createdT", n.id, n.type, oni."receiverUserId"
		)
		SELECT
		(SELECT count(*) FROM t)::integer as count,
		(
			SELECT json_agg(tt.*) FROM (
				SELECT * FROM t
				ORDER BY ${params.sorting?.field && params.sorting.field === "type" ? "type" : `"createdT"`} ${["ASC", "DESC"].includes(params.sorting?.order) ? params.sorting?.order : "DESC"}
				OFFSET ${params.pagination?.skip ?? 0} LIMIT ${params.pagination?.take ?? 100}
			) as tt
		) AS data;`;
        const dbResult = await trx.query(query, bindings);
        result.pagination.total = dbResult.rows[0].count;
        const rawRows = dbResult.rows[0].data ?? [];
        const allUserIds = [...new Set(rawRows.map((r) => r.receiverUserId))];
        const badges = await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCacheBulk({
            organizationId,
            userIds: allUserIds,
            trx,
        });
        for (const row of dbResult.rows[0].data ?? []) {
            const userBadge = {
                id: row.receiverUserId,
                caption: badges.find((b) => b.id === row.receiverUserId)?.caption ?? [],
            };
            row.instances.forEach((instance) => {
                instance.message = (0, business_main_1.transformNotificationHistoryActionsLocalizedMessages)(params.locale, instance.medium, instance.state, instance.note);
                delete instance.note;
            });
            row.receiverUserId = undefined;
            result.items.push({
                userBadge,
                archived: isArchived,
                ...row,
            });
        }
        return result;
    }
    async addNotificationEvent(params) {
        const id = uuid_1.default.v4();
        await params.trx.query(` INSERT INTO "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent} 
		(id, "createdT", "receiverFilterId", "notificationId", "instanceData") VALUES ($1, $2, $3, $4, $5)`, [id, params.createdT, params.receiverFilterId, params.notificationId, params.instanceData]);
        return id;
    }
    async getNotificationReceiverFilter(params) {
        const { rows, rowCount } = await params.trx.query(`SELECT id, "filter" FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.viewNames.vwUserFilter} 
			 WHERE id = (SELECT "receiverFilterId" FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notification} 
			 WHERE id = $1)`, [params.notificationId]);
        return rowCount ? rows[0].filter : null;
    }
    async listDeletedNotificationEvents(params) {
        let qx = 1;
        const qb = [];
        let wni = "";
        let wnt = "";
        const tqw = [];
        if (params.filter?.ids?.length) {
            const qi = [];
            for (const id of params.filter.ids) {
                qi.push(`$${qx++}`);
                qb.push(id);
            }
            tqw.push(`zne."id" IN (${qi.join(",")}::uuid)`);
            wni = ` AND zne.id IN (${qi.join(",")}::uuid) `;
        }
        if (params.filter?.types?.length > 0) {
            const qt = [];
            for (const t of params.filter.types) {
                qt.push(`$${qx++}`);
                qb.push(t);
            }
            tqw.push(`zn.type IN (${qt.join(",")}::integer)`);
            wnt = ` AND zn.type IN (${qt.join(",")}::integer) `;
        }
        if (params.filter?.notificationIds?.length) {
            const qi = [];
            for (const id of params.filter.notificationIds) {
                qi.push(`$${qx++}`);
                qb.push(id);
            }
            tqw.push(`zn."id" IN (${qi.join(",")}::uuid)`);
            wni += ` AND zne."notificationId" IN (${qi.join(",")}::uuid) `;
        }
        if (params.filter?.eventTime) {
            if (params.filter.eventTime.start) {
                tqw.push(`zne."createdT" >= $${qx}`);
                qb.push(params.filter?.eventTime.start);
                wni += ` AND zne."createdT" >= $${qx++} `;
            }
            if (params.filter.eventTime.end) {
                tqw.push(`zne."createdT" < $${qx}`);
                qb.push(params.filter.eventTime.end);
                wni += ` AND zne."createdT" < $${qx++} `;
            }
        }
        if (params.filter?.when) {
        }
        let qws = "";
        if (tqw.length > 0) {
            qws =
                `
				WHERE ` + tqw.join(" AND ");
        }
        const qtotal = `SELECT COUNT(*) AS C 
				FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_event}" AS zne
				INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification}" AS zn 
					ON zn.id = zne."notificationId" AND zn.action = $${qx} AND zne.action = $${qx}
		` + qws;
        qb.push(dal_constants_1.DalConstants.HistoryActionType.Delete);
        const totalResult = await params.trx.query(qtotal, qb);
        const result = {
            items: [],
            pagination: {
                total: parseInt(totalResult.rows[0].c) || 0,
                skip: params.pagination?.skip || 0,
                take: params.pagination?.take || 100,
            },
        };
        if (!result.pagination.total) {
            return result;
        }
        const order = ["ASC", "DESC"].includes(params.sorting?.order) ? params.sorting?.order : "DESC";
        let rq = `SELECT T1.id, T1."createdT", T1."instanceData", T1."notificationId", zn.type, T1.rc::SMALLINT, T2.agg FROM
		(SELECT zne.id, zne."createdT", zne."instanceData", zne."notificationId", count(distinct(zoni."receiverUserId")) AS rc
		FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_event} zne
		INNER JOIN "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_instance} zoni 
			ON zoni."eventId" = zne.id AND zne."createdT" = zoni."createdT" AND zoni.action = $${qx} AND zne.action = $${qx}
		${wni}
		LEFT JOIN (
            SELECT DISTINCT ON (id) id, state
            FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_instance_state} zonis
            ORDER BY id, "actionT" DESC
        ) zonis ON zonis.id = zoni.id
		GROUP BY zne.id, zne."createdT", zne."instanceData", zne."notificationId") AS T1 
		INNER JOIN 
		( SELECT id, json_agg(json_build_object('medium', "medium", 
								   'state', "state",
									'count', "cc"	
								  )) AS agg
		FROM (
		SELECT zne.id, zoni."medium", zonis."state", count(*) as cc	
		FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_event} zne
		INNER JOIN "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_instance} zoni 
			ON zoni."eventId" = zne.id AND zne."createdT" = zoni."createdT" AND zne.action = $${qx} AND zoni.action = $${qx}
		${wni}
		LEFT JOIN (
            SELECT DISTINCT ON (id) id, state
            FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_instance_state} zonis
            ORDER BY id, "actionT" DESC
        ) zonis ON zonis.id = zoni.id
		GROUP BY zne.id, zne."createdT", zoni."medium", zonis."state") AS T
		GROUP BY id) AS T2 ON T1.id = T2.id
		INNER JOIN "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification} zn 
			ON T1."notificationId" = zn.id AND zn.action = $${qx++} ${wnt}
		ORDER BY "createdT" ${order}
		OFFSET $${qx++} LIMIT $${qx++}`;
        qb.push(result.pagination.skip);
        qb.push(result.pagination.take);
        const datas = await params.trx.query(rq, qb);
        const contents = await params.trx.query(`SELECT DISTINCT ON ("eventId") "eventId", content FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.zz_notification_instance}"
			 WHERE "eventId" = ANY($1::uuid[]) AND action = $2 AND medium = $3
			 ORDER BY "eventId", "actionT" desc`, [datas.rows.map((row) => row.id), dal_constants_1.DalConstants.HistoryActionType.Delete, restapi_1.NotificationMedium.Web]);
        result.items = await Promise.all(datas.rows.map(async (m) => {
            const mediums = {};
            const states = {};
            for (const agg of m.agg) {
                if (!mediums[agg.medium]) {
                    mediums[agg.medium] = {};
                }
                if (agg.state) {
                    if (!mediums[agg.medium][agg.state]) {
                        mediums[agg.medium][agg.state] = agg.count;
                    }
                    else {
                        mediums[agg.medium][agg.state] += agg.count;
                    }
                }
                if (!states[agg.state]) {
                    states[agg.state] = agg.count;
                }
                else {
                    states[agg.state]++;
                }
            }
            return {
                mediums: mediums,
                notificationId: m.notificationId,
                receiverCount: m.rc,
                states: states,
                content: contents.rows.find((contentRow) => contentRow.eventId === m.id)?.content,
                createdT: m.createdT,
                id: m.id,
                archived: true,
            };
        }));
        return result;
    }
    async listNotificationEvents(params) {
        let qx = 1;
        const qb = [];
        let wni = "";
        let wnt = "";
        const tqw = [];
        if (params.filter?.ids?.length) {
            const qi = [];
            for (const id of params.filter.ids) {
                qi.push(`$${qx++}`);
                qb.push(id);
            }
            tqw.push(`ne."id" IN (${qi.join(",")}::uuid)`);
            wni = ` AND ne.id IN (${qi.join(",")}::uuid) `;
        }
        if (params.filter?.types?.length > 0) {
            const qt = [];
            for (const t of params.filter.types) {
                qt.push(`$${qx++}`);
                qb.push(t);
            }
            tqw.push(`n.type IN (${qt.join(",")}::integer)`);
            wnt = ` AND n.type IN (${qt.join(",")}::uuid) `;
        }
        if (params.filter?.notificationIds?.length) {
            const qi = [];
            for (const id of params.filter.notificationIds) {
                qi.push(`$${qx++}`);
                qb.push(id);
            }
            tqw.push(`n."id" IN (${qi.join(",")}::uuid)`);
            wni += ` AND ne."notificationId" IN (${qi.join(",")}::uuid) `;
        }
        if (params.filter?.eventTime) {
            if (params.filter.eventTime.start) {
                tqw.push(`ne."createdT" >= $${qx}`);
                qb.push(params.filter?.eventTime.start);
                wni += ` AND ne."createdT" >= $${qx++} `;
            }
            if (params.filter.eventTime.end) {
                tqw.push(`ne."createdT" < $${qx}`);
                qb.push(params.filter.eventTime.end);
                wni += ` AND ne."createdT" < $${qx++} `;
            }
        }
        if (params.filter?.when) {
        }
        let qws = "";
        if (tqw.length > 0) {
            qws =
                `
				WHERE ` + tqw.join(" AND ");
        }
        const qtotal = `SELECT COUNT(*) AS C 
				FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent}" AS ne
				INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notification}" AS n 
					ON n.id = ne."notificationId" ` + qws;
        const totalResult = await params.trx.query(qtotal, qb);
        const result = {
            items: [],
            pagination: {
                total: parseInt(totalResult.rows[0].c) || 0,
                skip: params.pagination?.skip || 0,
                take: params.pagination?.take || 100,
            },
        };
        if (!result.pagination.total) {
            return result;
        }
        const order = ["ASC", "DESC"].includes(params.sorting?.order) ? params.sorting?.order : "DESC";
        let rq = `SELECT T1.id, T1."createdT", T1."instanceData", T1."notificationId", n.type, T1.rc::SMALLINT, T2.agg FROM
		(SELECT ne.id, ne."createdT", ne."instanceData", ne."notificationId", count(distinct(ni."receiverUserId")) as rc
		FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent} as ne
		INNER JOIN "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance} as ni 
			ON ni."eventId" = ne.id AND ne."createdT" = ni."createdT"
		${wni}
		GROUP BY ne.id, ne."createdT") AS T1 
		INNER JOIN 
		(SELECT id, json_agg(json_build_object('medium', "medium", 
								   'state', "state",
									'count', "cc"	
								  )) as agg
		FROM (
		SELECT ne.id, ni."medium", ni."state", count(*) as cc	
		FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent} as ne
		INNER JOIN "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance} as ni 
			ON ni."eventId" = ne.id AND ne."createdT" = ni."createdT"
		${wni}
		GROUP BY ne.id, ne."createdT", ni."medium", ni."state") AS T
		GROUP BY id) AS T2 ON T1.id = T2.id
		INNER JOIN "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notification} as n 
			ON T1."notificationId" = n.id ${wnt}
		ORDER BY "createdT" ${order}
		OFFSET $${qx++} LIMIT $${qx++}`;
        qb.push(result.pagination.skip);
        qb.push(result.pagination.take);
        const datas = await params.trx.query(rq, qb);
        result.items = await Promise.all(datas.rows.map(async (m) => {
            const mediums = {};
            const states = {};
            for (const agg of m.agg) {
                if (!mediums[agg.medium]) {
                    mediums[agg.medium] = {};
                }
                if (agg.state) {
                    if (!mediums[agg.medium][agg.state]) {
                        mediums[agg.medium][agg.state] = agg.count;
                    }
                    else {
                        mediums[agg.medium][agg.state] += agg.count;
                    }
                }
                if (!states[agg.state]) {
                    states[agg.state] = agg.count;
                }
                else {
                    states[agg.state]++;
                }
            }
            return {
                mediums: mediums,
                notificationId: m.notificationId,
                receiverCount: m.rc,
                archived: false,
                states: states,
                content: (await (0, generator_1.generateNotificationContent)({
                    medium: app_enums_1.enums.NotificationMedium.Web,
                    organizationId: params.organizationId,
                    notification: {
                        createdT: m.createdT,
                        notificationId: m.notificationId,
                        type: m.type,
                    },
                    trx: params.trx,
                    receiverUser: await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId: params.organizationId, userId: params.requesterUserId, trx: params.trx }),
                    instanceData: m.instanceData,
                    forListing: true,
                })),
                createdT: m.createdT,
                id: m.id,
            };
        }));
        return result;
    }
    async setSmsBalance(params) {
        await params.trx.query(`	UPDATE "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.organizations}
					SET "smsBalance" = "smsBalance" - $1
				WHERE id = $2`, [params.used, params.organizationId]);
    }
    async getSmsBalance(params) {
        const { rows, rowCount } = await params.trx.query(`	SELECT "smsBalance" FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.organizations}
					WHERE id = $1`, [params.organizationId]);
        return rowCount > 0 ? rows[0].smsBalance : 0;
    }
    async getNotificationInstancesOfEventMarkedAsSending(params) {
        const { rows, rowCount } = await params.trx.query(`SELECT ni.id, ni."createdT", ni.medium, ni."receiverUserId", ni.content, ni."eventId", ni.note, n.type
			 FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}" ni
			 INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notification}" n
				ON n.id = ni."notificationId"
			 WHERE ni."eventId" = $1
			 AND ni.state = ANY($2::INTEGER[])`, [params.notificationEventId, [2]]);
        return rowCount > 0 ? rows : [];
    }
    async prepareNotificationUnsubsribeToken(params) {
        const typeToken = crypto_1.default.randomBytes(32).toString("hex");
        const generalToken = crypto_1.default.randomBytes(32).toString("hex");
        const { rows } = await params.trx.query(`WITH input_rows("userId", "type", "token") AS (
				VALUES
				($1::uuid, $2::smallint, $3),
				($1::uuid, null, $4)
			),
			inserted_rows AS (
				INSERT INTO "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationUnsubscribe} (
					"userId", "type", "token") 
				SELECT i."userId", i.type, i.token FROM input_rows as i
				LEFT JOIN "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationUnsubscribe} nu
					ON i."userId" = nu."userId" AND i.type IS NOT DISTINCT FROM nu.type
				WHERE nu.token IS NULL
				ON CONFLICT DO NOTHING
				RETURNING "userId", "type", "token"
			)
			SELECT "type", "token" FROM inserted_rows
			UNION ALL 
			SELECT i."type", nu."token" FROM input_rows i
			INNER JOIN "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationUnsubscribe} nu 
				ON nu."userId" = i."userId" AND nu."type" IS NOT DISTINCT FROM i.type`, [params.userId, params.type, typeToken, generalToken]);
        return {
            generalToken: rows.find((row) => row.type === null).token,
            typeToken: rows.find((row) => row.type === params.type).token,
        };
    }
    async getUnsubsribeUserFromToken(params) {
        const { rows, rowCount } = await params.trx.query(`SELECT "userId", type FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationUnsubscribe}"
				WHERE token = $1`, [params.token]);
        return rowCount > 0 ? rows[0] : null;
    }
    async anonymiseMFAVerificationNotification(params) {
        const { rows } = await params.trx.query(`SELECT ni.content, ni.id as "instanceId", ne."instanceData" FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent} ne
			 INNER JOIN "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance} ni
			 	ON ni."eventId" = ne.id
			WHERE ne.id = $1`, [params.notificationEventId]);
        const data = rows[0];
        const token = data.instanceData.t;
        data.content.html = data.content.html.replace(token, "****");
        params.trx.query(`UPDATE "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}
			 SET content = $2
			 WHERE id = $1`, [data.instanceId, data.content]);
        data.instanceData.t = "****";
        params.trx.query(`UPDATE "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent}
				 SET "instanceData" = $1
				 WHERE id = $2`, [data.instanceData, params.notificationEventId]);
    }
    async anonymiseAccountCreatedNotification(params) {
        const { rows } = await params.trx.query(`SELECT ni.content, ni.id as "instanceId", ne."instanceData" FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent} ne
			 INNER JOIN "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance} ni
			 	ON ni."eventId" = ne.id
			WHERE ne.id = $1`, [params.notificationEventId]);
        const data = rows[0];
        const username = data.instanceData.u;
        const password = data.instanceData.p;
        data.content.html = data.content.html.replace(password, "****").replace(username, "****");
        params.trx.query(`UPDATE "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}
			 SET content = $2
			 WHERE id = $1`, [data.instanceId, data.content]);
        data.instanceData.u = "****";
        data.instanceData.p = "****";
        params.trx.query(`UPDATE "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationEvent}
				 SET "instanceData" = $1
				 WHERE id = $2`, [data.instanceData, params.notificationEventId]);
    }
}
exports.PSQLDalAccessNotifications = PSQLDalAccessNotifications;
