"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PSQLDalAccessFunctions = void 0;
const dal_access_rdb_functions_1 = require("../rdb/dal.access.rdb.functions");
class PSQLDalAccessFunctions extends dal_access_rdb_functions_1.RDBDalAccessFunctions {
    async dbFuncCollectUsersForAccessReportFilter(options) {
        let _organizationUnitIds = options.organizationUnitIds && options.organizationUnitIds.length > 0 ? "'" + options.organizationUnitIds.join("'::uuid,'") + "'::uuid" : "";
        let _userIds = options.userIds && options.userIds.length > 0 ? "'" + options.userIds.join("'::uuid,'") + "'::uuid" : "";
        let _userGroupIds = options.userGroupIds && options.userGroupIds.length > 0 ? "'" + options.userGroupIds.join("'::uuid,'") + "'::uuid" : "";
        let query = `
            SELECT "${options.organizationId}".fcollectusersforaccessreportfilter(
                '${options.organizationId}'::uuid, 
                ARRAY[${_organizationUnitIds}]::uuid[],
                ${options.filterOrganizationUnitMembersHierarchically ? "TRUE," : "FALSE,"}
                ARRAY[${_userIds}]::uuid[],
                ARRAY[${_userGroupIds}]::uuid[]
            );`;
        let result;
        await this.dbClient.raw(query).then((results) => (result = results.rows[0].fcollectusersforaccessreportfilter));
        return Promise.resolve(result);
    }
    async dbFuncGetOrganizationUnitDetailed(organizationId, organizationUnitId, isSystemAdministrator, userId) {
        let query = `
            SELECT "${organizationId}".fgetorganizationunitdetailed(
                '${organizationId}'::uuid, 
                '${organizationUnitId}'::uuid, 
                '${isSystemAdministrator ? "TRUE" : "FALSE"}'::BOOLEAN,
                '${userId}'::uuid
            );`;
        let result;
        await this.dbClient.raw(query).then((results) => (result = results.rows[0].fgetorganizationunitdetailed));
        return Promise.resolve(result);
    }
    async dbFuncAuthorizeUserFor(options) {
        let _organizationUnitIds = options.organizationUnitIds && options.organizationUnitIds.length > 0 ? "'" + options.organizationUnitIds.join("'::uuid,'") + "'::uuid" : "";
        let _accessControlPointIds = options.accessControlPointIds && options.accessControlPointIds.length > 0 ? "'" + options.accessControlPointIds.join("'::uuid,'") + "'::uuid" : "";
        let _userIds = options.userIds && options.userIds.length > 0 ? "'" + options.userIds.join("'::uuid,'") + "'::uuid" : "";
        let _userGroupIds = options.userGroupIds && options.userGroupIds.length > 0 ? "'" + options.userGroupIds.join("'::uuid,'") + "'::uuid" : "";
        let _regionIds = options.regionIds && options.regionIds.length > 0 ? "'" + options.regionIds.join("'::uuid,'") + "'::uuid" : "";
        let query = `
            SELECT "${options.organizationId}".fauthorizeuserfor(
                '${options.organizationId}'::uuid, 
                '${options.userId}'::uuid, 
                ARRAY[${_organizationUnitIds}]::uuid[],
                ARRAY[${_accessControlPointIds}]::uuid[],
                ARRAY[${_userIds}]::uuid[],
                ARRAY[${_userGroupIds}]::uuid[],
                ARRAY[${_regionIds}]::uuid[]
            );`;
        let result;
        await this.dbClient.raw(query).then((results) => (result = results.rows[0].fauthorizeuserfor));
        return Promise.resolve(result);
    }
}
exports.PSQLDalAccessFunctions = PSQLDalAccessFunctions;
