"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getReportUserFilterForPgClient = void 0;
const dal_constants_1 = require("../../dal.constants");
function getReportUserFilterForPgClient(params) {
    let bindingKeyNum = params.bindingKeys.length + 1;
    let bindingKeys = [...params.bindingKeys];
    let q = `
    SELECT DISTINCT ${params.specificSelectItems ? params.specificSelectItems.map((m) => 'TDIFF."' + m + '"').join(",") : "*"} FROM(
        SELECT T1."userId" AS "requesterUserId", T2."userId", T2."userOrganizationId", T2."organizationId", T2."organizationUnitIds",
        T2."name", T2."surname", T2."uniqueId", T2."isDisabled" FROM
        (
            --requesterUser
    SELECT "userOrganizationId", "userId", "organizationId", "organizationUnitId", "isOrganizationWide"
    FROM
                (SELECT uo."id" AS "userOrganizationId", uo."userId", uo."organizationId",
                    r."permissions", NULL:: text AS "organizationUnitId", TRUE AS "isOrganizationWide"
    FROM "${params.organizationId}"."userOrganizations" AS uo
    INNER JOIN "${params.organizationId}"."roles" AS r ON r."id" = uo."roleId" AND r."deletedAt" IS NULL
    WHERE `;
    let organizationWidePermissions = "";
    if (params.requesterUserId !== dal_constants_1.DalConstants.SystemUserId && params.requiredOrganizationWidePermissions && params.requiredOrganizationWidePermissions.length > 0) {
        organizationWidePermissions = " ( ";
        let pa = [];
        for (const p of params.requiredOrganizationWidePermissions) {
            pa.push(` POSITION($${bindingKeyNum++}:: text IN "permissions") > 0 `);
            bindingKeys.push(p);
        }
        organizationWidePermissions += pa.join(" AND ") + " ) AND ";
    }
    q += organizationWidePermissions;
    q += `
    uo."deletedAt" IS NULL
    AND uo."userId" = $${bindingKeyNum++} AND uo."organizationId" = $${bindingKeyNum++} `;
    bindingKeys.push(params.requesterUserId, params.organizationId);
    q += `UNION
    SELECT uo."id" AS "userOrganizationId", uo."userId", uo."organizationId",
    r."permissions", uoou."organizationUnitId":: text AS "organizationUnitId", FALSE AS "isOrganizationWide"
    FROM "${params.organizationId}"."userOrganizations" AS uo
    INNER JOIN "${params.organizationId}"."userOrganizationOrganizationUnits" AS uoou ON uoou."userOrganizationId" = uo."id" AND uoou."deletedAt" IS NULL
    INNER JOIN "${params.organizationId}"."roles" AS r ON r."id" = uoou."roleId" AND r."deletedAt" IS NULL
    WHERE `;
    let organizationUnitWidePermissions = "";
    if (params.requesterUserId !== dal_constants_1.DalConstants.SystemUserId && params.requiredOrganizationUnitWidePermissions && params.requiredOrganizationUnitWidePermissions.length > 0) {
        organizationUnitWidePermissions = " ( ";
        let pa = [];
        for (const p of params.requiredOrganizationUnitWidePermissions) {
            pa.push(` POSITION($${bindingKeyNum++} IN "permissions") > 0 `);
            bindingKeys.push(p);
        }
        organizationUnitWidePermissions += pa.join(" AND ") + " ) AND ";
    }
    q += organizationUnitWidePermissions;
    q += `uo."deletedAt" IS NULL
    AND uo."userId" = $${bindingKeyNum++} AND uo."organizationId" = $${bindingKeyNum++}
    `;
    bindingKeys.push(params.requesterUserId, params.organizationId);
    q += ` ) AS TPERMISSION) AS T1
    INNER JOIN
    --requesting users
    (SELECT TUSERS."userOrganizationId", TUSERS."userId", TUSERS."organizationUnitPath", TUSERS."organizationUnitIds",
    TUSERS."organizationId", uop."name", uop."surname", uop."uniqueId", TUSERS."isDisabled"
    FROM
        (SELECT uo."id" AS "userOrganizationId", uo."userId", uo."organizationId", uo."isDisabled", ARRAY_AGG(uoou."organizationUnitId") as "organizationUnitIds",
            STRING_AGG((CASE WHEN ou."ancestorIds" IS NULL THEN ou."id":: text ELSE ou."id":: text || ',' || ou."ancestorIds" END), ',') AS "organizationUnitPath"
    FROM "${params.organizationId}"."userOrganizations" AS uo
    LEFT JOIN "${params.organizationId}"."userOrganizationOrganizationUnits" AS uoou ON uoou."userOrganizationId" = uo."id" AND uoou."deletedAt" IS NULL
    LEFT JOIN "${params.organizationId}"."organizationUnits" AS ou ON uoou."organizationUnitId" = ou."id" AND ou."deletedAt" IS NULL
    LEFT JOIN "${params.organizationId}"."userWorkPlans" AS uwp ON uwp."userId" = uo."userId"
    `;
    let userGroupJoin = "";
    if (params.idBasedUserFilter.userGroupIds && params.idBasedUserFilter.userGroupIds.length > 0) {
        userGroupJoin = `
        INNER JOIN "${params.organizationId}"."userGroupUserOrganizations" AS uguo ON uguo."userOrganizationId" = uo."id" AND uguo."deletedAt" IS NULL
    `;
    }
    q += userGroupJoin;
    q += ` WHERE uo."organizationId" = $${bindingKeyNum++}`;
    bindingKeys.push(params.organizationId);
    q += ` AND uo."deletedAt" IS NULL `;
    let userOrganizationIsDisabledFilter = "";
    if (params.idBasedUserFilter.userOrganizationStatus && params.idBasedUserFilter.userOrganizationStatus !== dal_constants_1.DalConstants.IdentityStatusType.All) {
        userOrganizationIsDisabledFilter =
            params.idBasedUserFilter.userOrganizationStatus === dal_constants_1.DalConstants.IdentityStatusType.Enabled
                ? (userOrganizationIsDisabledFilter = `AND uo."isDisabled" = false `)
                : (userOrganizationIsDisabledFilter = `AND uo."isDisabled" = true `);
    }
    q += userOrganizationIsDisabledFilter;
    if (params.idBasedUserFilter.userIds && params.idBasedUserFilter.userIds.length > 0) {
        q += ` AND ( uo."userId" = ANY($${bindingKeyNum++})) `;
        bindingKeys.push(params.idBasedUserFilter.userIds);
    }
    if (params.idBasedUserFilter.userGroupIds && params.idBasedUserFilter.userGroupIds.length > 0) {
        q += `AND ( uguo."userGroupId" = ANY($${bindingKeyNum++})) `;
        bindingKeys.push(params.idBasedUserFilter.userGroupIds);
    }
    if (params.idBasedUserFilter.workPlanIds && params.idBasedUserFilter.workPlanIds.length > 0) {
        q += ` AND ( uwp."workPlanId" = ANY($${bindingKeyNum++})) `;
        bindingKeys.push(params.idBasedUserFilter.workPlanIds);
    }
    let organizationUnitIds = "";
    if (params.idBasedUserFilter.organizationUnitIds && params.idBasedUserFilter.organizationUnitIds.length > 0) {
        organizationUnitIds = " AND ( ";
        let ou = [];
        for (const organizationUnitId of params.idBasedUserFilter.organizationUnitIds) {
            if (params.idBasedUserFilter.applyOrganizationUnitFilterHierarchically) {
                ou.push(` POSITION($${bindingKeyNum++} IN TUSERS."organizationUnitPath") > 0 `);
            }
            else {
                ou.push(` ou."id" = $${bindingKeyNum++} `);
            }
            bindingKeys.push(organizationUnitId);
        }
        organizationUnitIds += ou.join(" OR ") + " ) ";
    }
    q += `${!params.idBasedUserFilter.applyOrganizationUnitFilterHierarchically ? organizationUnitIds : ""}
    GROUP BY uo."id") AS TUSERS
    INNER JOIN "${params.organizationId}"."userOrganizationProfiles" AS uop ON uop."userOrganizationId" = TUSERS."userOrganizationId" AND uop."deletedAt" IS NULL
    ${params.idBasedUserFilter.applyOrganizationUnitFilterHierarchically ? organizationUnitIds : ""}
        ) AS T2
    ON T1."isOrganizationWide" = TRUE OR POSITION(T1."organizationUnitId" IN T2."organizationUnitPath") > 0
    ) AS TDIFF
`;
    return {
        query: q,
        bindingKeys: bindingKeys,
    };
}
exports.getReportUserFilterForPgClient = getReportUserFilterForPgClient;
