"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PSQLDalAccessAccessControlPoint = void 0;
const uuid_1 = __importDefault(require("uuid"));
const lodash_1 = __importDefault(require("lodash"));
const api_error_1 = require("../../../api/api.error");
const dal_constants_1 = require("../../dal.constants");
const dal_manager_1 = require("../../dal.manager");
const dal_db_armon_schema_1 = require("../../db/armon/dal.db.armon.schema");
const dal_access_error_1 = require("../dal.access.error");
const dal_access_rdb_accessControlPoint_1 = require("../rdb/dal.access.rdb.accessControlPoint");
const libModels = __importStar(require("../../../lib/access-model"));
const predefined_roles_1 = require("../../db/predefined/predefined.roles");
const i18n_1 = __importDefault(require("i18n"));
const app_logs_1 = require("../../../app.logs");
const restapi_1 = require("../../../lib/es/models/restapi");
const app_enums_1 = require("../../../app.enums");
const moment_1 = __importDefault(require("moment"));
const dal_access_psql_organization_1 = require("./dal.access.psql.organization");
const Cursor = require("pg-cursor");
const libEnumsV2 = libModels.V2.Enums;
class PSQLDalAccessAccessControlPoint extends dal_access_rdb_accessControlPoint_1.RDBDalAccessAccessControlPoint {
    constructor(knex, pgPool) {
        super(knex, pgPool);
    }
    async getAccessPointRedisPersistentData(params) {
        const { rows, rowCount } = await (params.trx || this._pgPool).query(`
		SELECT name as n FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}"
		WHERE id = $1 AND "deletedAt" IS NULL
	`, [params.accessPointId]);
        if (rowCount < 1) {
            return null;
        }
        return rows[0];
    }
    async getAccessPointRedisPersistentDatasOfOrganization(params) {
        const query = `
			  SELECT
			  id, name as n
			  FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}"
		  `;
        const trxx = params.trx ?? (await this._pgPool.connect());
        const cursor = trxx.query(new Cursor(query));
        let rows = [];
        while (true) {
            try {
                rows = await new Promise((resolve, reject) => {
                    cursor.read(100, async (err, r) => {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve(r);
                        }
                    });
                });
                await params.onData(rows);
            }
            catch (error) {
                app_logs_1.logger.error("Error while fetch credentials data with cursor!");
            }
            if (rows.length < 100) {
                break;
            }
        }
        try {
            await new Promise((resolve, reject) => {
                cursor.close((err) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            });
            if (!params.trx) {
                trxx.release();
            }
        }
        catch (error) {
            if (!params.trx) {
                trxx?.release(error);
            }
            app_logs_1.logger.error(error);
        }
    }
    async getUserMobileCheckinInformation(organizationId, userId, accessControlPointId) {
        return dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            const queryResult = (await trx.query(`
			SELECT $4 as "userId", acp.id as "accessControlPointId", uar.id as "accessRightId", acp.name as "accessControlPointName",
				CASE WHEN acp.id = $1 THEN true ELSE COALESCE(uar."access", false) END as "hasAccessRight",
				(
					SELECT COUNT(uwp.id) > 0
					FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userWorkPlans}" uwp
					INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}" wp
						ON wp."deletedAt" IS NULL AND uwp."userId" = $4 AND wp.id = uwp."workPlanId"
					WHERE tstzrange(uwp."startDateTime", uwp."endDateTime") && tstzrange($2, $3)
					AND wp."allowMobileCheckins"
				) as "hasMobileWp"
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" acp
			LEFT JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" uar
				ON uar."userId" = $4 AND uar."accessControlPointId" = acp.id AND uar."deletedAt" IS NULL
			WHERE acp."deletedAt" IS NULL 
			AND acp."id" = $5
			`, [
                dal_constants_1.DalConstants.defaultMobileAcpId,
                (0, moment_1.default)().startOf("day").toDate(),
                (0, moment_1.default)().add(1, "day").startOf("day"),
                userId,
                accessControlPointId ? accessControlPointId : dal_constants_1.DalConstants.defaultMobileAcpId,
            ])).rows[0];
            if (queryResult) {
                queryResult.userRoleId = (await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId, userId, trx })).r;
            }
            return queryResult;
        });
    }
    async createMobileAccessControlPointAndSetAdmin(organizationId, userId) {
        return dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            let mobileAcp = (await trx.query(`
            	SELECT * FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" acp WHERE "deletedAt" IS NULL AND acp."id" = $1
				`, [dal_constants_1.DalConstants.defaultMobileAcpId])).rows[0];
            let existingRights = undefined;
            if (!mobileAcp) {
                const { l: locale } = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId, userId, trx });
                let mobileAcpNAme = i18n_1.default.__({ phrase: "PACS.MOBILE_ACP_NAME", locale });
                let defaultPrivileges = {
                    read: true,
                    grant: false,
                    config: false,
                    access: true,
                    remoteAccess: false,
                    snapshot: false,
                };
                mobileAcp = (await trx.query(`
                	INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}"
                	("id", "createdAt", "name", "remoteAvailable", "isRemoteDefault", "organizationId", "accessControlPointType", "defaultPrivileges")
                	VALUES ($1, $2, $3, $4, $5, $6, $7, $8) RETURNING *;
                	`, [
                    dal_constants_1.DalConstants.defaultMobileAcpId,
                    new Date(),
                    mobileAcpNAme,
                    false,
                    false,
                    organizationId,
                    dal_constants_1.DalConstants.AccessControlPointType.VirtualMobileCheckin,
                    defaultPrivileges,
                ])).rows[0];
            }
            else {
                existingRights = (await trx.query(`SELECT id FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" WHERE "userId" = $1 AND "accessControlPointId" = $2 AND "deletedAt" IS NULL
					`, [userId, mobileAcp.id])).rows[0];
            }
            let now = new Date();
            if (existingRights) {
                await trx.query(`
                UPDATE "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}"
                SET ("updatedAt", "remoteAccess", "read", "access", "config", "grant", "snapshot")
                = ($1, $2, $3, $4, $5, $6, $7)
                WHERE "userId" = $8 AND "accessControlPointId" = $9 AND "deletedAt" IS NOT NULL;
                `, [now, false, true, true, true, true, false, userId, mobileAcp.id]);
            }
            else {
                await trx.query(`
                INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}"
                (id, "createdAt", "deletedAt", "updatedAt", "userId", "accessControlPointId", "markedAsFavorite", "remoteAccess", "read", "access", "config", "grant", "snapshot")
                VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13);
                `, [uuid_1.default.v4(), now, null, now, userId, mobileAcp.id, false, false, true, true, true, true, false]);
            }
        });
    }
    async getUserAccessControlPointRights(organizationId, userId) {
        return this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights)
            .where("userId", userId)
            .whereNull("deletedAt")
            .select("accessControlPointId", "access", "read", "config", "grant", "remoteAccess", "snapshot");
    }
    async getUsersHasRightWithAcpId(organizationId, acpId, rights) {
        let queryParamIndex = 1;
        let queryParams = [];
        let query = `SELECT "userId" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}"
                WHERE "deletedAt" IS NULL`;
        if (rights.read) {
            query += `
                AND read = $${queryParamIndex++}`;
            queryParams.push(rights.read);
        }
        if (rights.access) {
            query += `
                AND access = $${queryParamIndex++}`;
            queryParams.push(rights.access);
        }
        if (rights.config) {
            query += `
                AND config = $${queryParamIndex++}`;
            queryParams.push(rights.config);
        }
        if (rights.grant) {
            query += ` 
                AND grant = $${queryParamIndex++}`;
            queryParams.push(rights.grant);
        }
        if (rights.remoteAccess) {
            query += `
                AND "remoteAccess" = $${queryParamIndex++}`;
            queryParams.push(rights.remoteAccess);
        }
        query += `
            AND "accessControlPointId" = $${queryParamIndex++}`;
        queryParams.push(acpId);
        const { rows, rowCount } = await this._pgPool.query(query, queryParams);
        if (rowCount < 1) {
            return null;
        }
        return rows.map((i) => i.userId);
    }
    async getUsersHasRightOnAcpFromTerminalId(organizationId, terminalId, rights) {
        let queryParamIndex = 1;
        let queryParams = [];
        let query = `SELECT distinct uar."userId" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" uar
                INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" acp
                ON uar."accessControlPointId" = acp.id
                WHERE uar."deletedAt" IS NULL
                AND acp."deletedAt" IS NULL`;
        if (rights.read) {
            query += `
                AND uar.read = $${queryParamIndex++}`;
            queryParams.push(rights.read);
        }
        if (rights.access) {
            query += `
                AND  uar.access = $${queryParamIndex++}`;
            queryParams.push(rights.access);
        }
        if (rights.config) {
            query += `
                AND  uar.config = $${queryParamIndex++}`;
            queryParams.push(rights.config);
        }
        if (rights.grant) {
            query += ` 
                AND  uar.grant = $${queryParamIndex++}`;
            queryParams.push(rights.grant);
        }
        if (rights.remoteAccess) {
            query += `
                AND  uar."remoteAccess" = $${queryParamIndex++}`;
            queryParams.push(rights.remoteAccess);
        }
        query += `
            AND "deviceId" = $${queryParamIndex++}`;
        queryParams.push(terminalId);
        const { rows, rowCount } = await this._pgPool.query(query, queryParams);
        if (rowCount < 1) {
            return null;
        }
        return rows.map((i) => i.userId);
    }
    async getUsersHasRightOnAcpFromTerminalIds(organizationId, terminalIds, rights) {
        let qx = 1;
        const qb = [];
        const rqb = [];
        let query = `SELECT DISTINCT uar."userId" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" uar
                INNER JOIN "${organizationId}"."accessControlPoints" acp
                ON uar."accessControlPointId" = acp.id
                WHERE uar."deletedAt" IS NULL
                AND acp."deletedAt" IS NULL
				AND acp."deviceId" = ANY($${qx++}::uuid[])
				`;
        qb.push(terminalIds);
        if (rights.read) {
            rqb.push(`uar.read = $${qx++}`);
            qb.push(rights.read);
        }
        if (rights.access) {
            rqb.push(`uar.access = $${qx++}`);
            qb.push(rights.access);
        }
        if (rights.config) {
            rqb.push(`uar.config = $${qx++}`);
            qb.push(rights.config);
        }
        if (rights.grant) {
            rqb.push(`uar.grant = $${qx++}`);
            qb.push(rights.grant);
        }
        if (rights.remoteAccess) {
            rqb.push(`"uar.remoteAccess" = $${qx++}`);
            qb.push(rights.remoteAccess);
        }
        if (rqb.length > 0) {
            query += " AND " + rqb.join(" AND ");
        }
        const { rows } = await this._pgPool.query(query, qb);
        return rows.map((i) => i.userId);
    }
    async getUsersAccessControlPointRights(organizationId, userIds) {
        const { rows } = await this._pgPool.query(`SELECT "userId", 
                        json_build_object('accessControlPointId', "accessControlPointId",
                            'access', "access", 
                            'read', "read", 
                            'config', "config",
                            'grant', "grant",
                            'remoteAccess', "remoteAccess",
                            'snapshot', "snapshot") AS "accessRights"
                        FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}"
                        WHERE "userId" = ANY($1::uuid[])
                        AND "deletedAt" IS NULL`, [userIds]);
        return rows.map((row) => {
            return {
                userId: row.userId,
                accessRights: row.accessRights,
            };
        });
    }
    async getAccessControlPointBasicWithUserRights(organizationId, accessControlPointIds, userId, trx) {
        const dbResults = await trx.query(`SELECT
				acp.id, acp.name, acp.location, acp."remoteAvailable",
				acp."isRemoteDefault", acp."accessControlPointType",
				acp."defaultPrivileges", acp."deviceId", acp.states,
				uar.read, uar.access, uar.grant,
				uar.config, uar."remoteAccess", uar.snapshot
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" acp
			LEFT JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" uar
				ON acp."deletedAt" IS NULL AND uar."deletedAt" IS NULL
				AND uar."accessControlPointId" = acp.id AND uar."userId" = $2
			WHERE acp.id = ANY($1);`, [accessControlPointIds, userId]);
        const result = [];
        for (const row of dbResults.rows) {
            result.push({
                id: row.id,
                name: row.name,
                location: row.location,
                remoteAvailable: row.remoteAvailable,
                isRemoteDefault: row.isRemoteDefault,
                type: row.accessControlPointType,
                cameraInfo: await dal_manager_1.dbManager.accessCamera.getCameraForAccessControlPoint(organizationId, row.id),
                deviceId: row.deviceId,
                states: row.states,
                userRights: {
                    access: row.access ? row.access : false,
                    remoteAccess: row.remoteAccess ? row.remoteAccess : false,
                    grant: row.grant ? row.grant : false,
                    config: row.config ? row.config : false,
                    read: row.read ? row.read : false,
                    snapshot: row.snapshot ? row.snapshot : false,
                },
                defaultPrivileges: row.defaultPrivileges,
            });
        }
        return result;
    }
    async getAccessControlPointIdName(organizationId, accessControlPointIds) {
        return this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints).whereIn("id", accessControlPointIds).whereNull("deletedAt").select("id", "name");
    }
    async getAccessControlPointBasic(organizationId, accessControlPointId) {
        const { rows, rowCount } = await this._pgPool.query(`
        SELECT id, name, location, "remoteAvailable", "isRemoteDefault", "accessControlPointType", "deviceId", states, "defaultPrivileges" 
            FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}"
                WHERE id = $1 
                AND "organizationId" = $2
                AND "deletedAt" IS NULL
        `, [accessControlPointId, organizationId]);
        if (rowCount === 0) {
            (0, dal_access_error_1.throwDbAccessNotFoundError)("Access control point is not found!");
        }
        const row = rows[0];
        return {
            id: row.id,
            name: row.name,
            location: row.location,
            remoteAvailable: row.remoteAvailable,
            isRemoteDefault: row.isRemoteDefault,
            type: row.accessControlPointType,
            cameraInfo: await dal_manager_1.dbManager.accessCamera.getCameraForAccessControlPoint(organizationId, row.id),
            deviceId: row.deviceId,
            states: row.states,
            defaultPrivileges: row.defaultPrivileges,
        };
    }
    async getAccessControlPointBasics(organizationId, accessControlPointIds) {
        const { rows } = await this._pgPool.query(`
        SELECT id, name, location, "remoteAvailable", "isRemoteDefault", "accessControlPointType", "deviceId", "defaultPrivileges"
         FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" as acp
            WHERE acp.id = ANY($1::uuid[])
            AND acp."organizationId" = $2
            AND acp."deletedAt" IS NULL`, [accessControlPointIds, organizationId]);
        return rows;
    }
    async genericSearchAccessControlPoint(organizationId, requestedUserId, options) {
        let result = {
            total: 0,
            items: [],
        };
        const acpIds = await dal_manager_1.dbManager.accessAccessControlPoint.getAcpIdsUserHasAccessRight(organizationId, requestedUserId, {
            read: true,
        });
        let qb = this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints + " as acp")
            .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights + " as uar", "uar.accessControlPointId", "acp.id")
            .where("acp.organizationId", "=", organizationId)
            .where("uar.userId", requestedUserId)
            .whereNull("acp.deletedAt")
            .whereNull("uar.deletedAt")
            .where("uar.read", true)
            .whereIn("acp.id", acpIds);
        let filterExists = options.filter && options.filter.length > 0;
        let regexList = [];
        if (filterExists) {
            qb.whereWrapped((q) => {
                let filterTokens = options.filter.split(" ");
                for (const filterToken of filterTokens) {
                    let token = filterToken.trim();
                    regexList.push(new RegExp(options.filter.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&"), "ig"));
                    if (token.length > 0) {
                        token = "%" + token + "%";
                        q.orWhereRaw("acp.name ilike ?", token);
                        q.orWhereRaw("acp.location ilike ?", token);
                    }
                }
            });
        }
        if (options.access) {
            qb.where("uar.access", true);
        }
        if (options.grant) {
            qb.where("uar.grant", true);
        }
        if (options.config) {
            qb.where("uar.config", true);
        }
        if (options.remoteAccess) {
            qb.where("uar.remoteAccess", true);
        }
        if (options.snapshot) {
            qb.where("uar.snapshot", true);
        }
        let columns = ["acp.id", "acp.name", "acp.location"];
        let qbCount = qb.clone();
        result.total = await qbCount.count("acp.id as c").then((rows) => {
            return parseInt(rows[0].c);
        });
        if (result.total === 0) {
            return Promise.resolve(result);
        }
        qb.orderByRaw("acp.name").column(columns).select().offset(options.skip).limit(options.take);
        result.items = await qb.then((rows) => {
            let regex = filterExists ? new RegExp(options.filter, "ig") : null;
            return rows.map((t) => {
                let name = t["name"];
                let location = t["location"];
                let captionLines = [name];
                if (location) {
                    captionLines.push(location);
                }
                let matchItem = null;
                if (filterExists) {
                    for (const regex of regexList) {
                        if (name && name.search(regex) >= 0) {
                            matchItem = name;
                            break;
                        }
                        else if (location && location.search(regex) >= 0) {
                            matchItem = location;
                            break;
                        }
                    }
                }
                return {
                    id: t["id"],
                    captionLines: captionLines,
                    matchItem: matchItem,
                };
            });
        });
        return Promise.resolve(result);
    }
    async listOrganizationAccessControlPoints(organizationId, trx) {
        let qb = this.dbClient.withSchema(organizationId).from("accessControlPoints as acp").whereNull("acp.deletedAt");
        if (trx)
            qb.transacting(trx);
        let result = await qb.select("id", "name", "location", "remoteAvailable", "isRemoteDefault", "accessControlPointType", "deviceId");
        return Promise.resolve(result.map((r) => {
            return {
                deviceId: r.deviceId,
                id: r.id,
                cameraInfo: null,
                location: r.location,
                isRemoteDefault: r.isRemoteDefault,
                name: r.name,
                remoteAvailable: r.remoteAvailable,
                type: r.type,
            };
        }));
    }
    async listAccessControlPoints(organizationId, requestUserId, args) {
        let result = {
            pagination: {
                take: args.take,
                skip: args.skip,
                total: 0,
            },
            items: [],
        };
        let qb = this.dbClient
            .withSchema(organizationId)
            .from("accessControlPoints as acp")
            .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights + " as uar", "uar.accessControlPointId", "acp.id")
            .where("acp.organizationId", "=", organizationId)
            .where("uar.userId", requestUserId)
            .whereIn("acp.id", args.accessControlPointIds)
            .whereNull("uar.deletedAt")
            .where("uar.read", true)
            .whereNull("acp.deletedAt");
        if (args.access) {
            qb.where("uar.access", true);
        }
        if (args.grant) {
            qb.where("uar.grant", true);
        }
        if (args.config) {
            qb.where("uar.config", true);
        }
        if (args.snapshot) {
            qb.where("uar.snapshot", true);
        }
        if (args.remoteAccess) {
            qb.where("uar.remoteAccess", true);
        }
        if (args.read) {
            qb.where("uar.read", true);
        }
        result.pagination.total = await qb
            .clone()
            .count("acp.id as c")
            .then((rows) => {
            return parseInt(rows[0].c);
        });
        if (result.pagination.total === 0) {
            return Promise.resolve(result);
        }
        if (args.take) {
            qb.limit(args.take);
        }
        if (args.skip) {
            qb.offset(args.skip);
        }
        await qb
            .orderByRaw("acp.name")
            .select("acp.id", "acp.name", "acp.location")
            .then((rows) => {
            for (let row of rows) {
                let name = row.name;
                let location = row.location;
                let captionLines = [name];
                if (location) {
                    captionLines.push(location);
                }
                result.items.push({
                    id: row.id,
                    captionLines: captionLines,
                });
            }
        });
        return Promise.resolve(result);
    }
    async searchAccessGrantedAccessControlPointsByAuth(params) {
        let qx = 1;
        const qb = [];
        const qw = [];
        const qfrom = `
			FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" acp
			INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" uar ON acp.id = uar."accessControlPointId"
			LEFT JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.devices}" d ON d.id = acp."deviceId"
		`;
        if (params.filter?.filter) {
            const filterTokens = params.filter.filter.split(" ");
            const qt = [];
            for (const filterToken of filterTokens) {
                let token = filterToken.trim();
                if (token.length > 0) {
                    qt.push(`acp.name ilike $${qx}`, `acp.location ilike $${qx++}`);
                    qb.push("%" + token + "%");
                }
            }
            qw.push(`( ${qt.join(" OR ")} )`);
        }
        if (params.filter?.onlyMarkedAsFavorites) {
            qw.push(`uar."markedAsFavorite" IS TRUE`);
        }
        if (params.filter.accessControlPointType !== null && params.filter.accessControlPointType !== undefined) {
            qw.push(`acp."accessControlPointType" = $${qx++}`);
            qb.push(params.filter.accessControlPointType);
        }
        if (params.filter?.authenticationFactors?.length > 0) {
            const qf = [];
            for (const factor of params.filter.authenticationFactors) {
                qf.push(`"authenticationFactors"::text ilike '%"factor":' || $${qx++}::text || '%'::text`);
                qb.push(factor);
            }
            if (params.filter.remoteAvailable) {
                qf.push(`acp."remoteAvailable" IS TRUE `);
            }
            qw.push(`( ${qf.join(" OR ")} )`);
        }
        else {
            if (params.filter.remoteAvailable) {
                qw.push(`acp."remoteAvailable" IS TRUE`);
            }
        }
        const qwo = [];
        if (params.filter.includeMobileAccessPoints) {
            qwo.push(`acp."accessControlPointType" = $${qx++}`);
            qb.push(dal_constants_1.DalConstants.AccessControlPointType.VirtualMobileCheckin);
        }
        let qws = `WHERE acp."deletedAt" IS NULL
					AND uar."deletedAt" IS NULL
					AND uar."userId" = $${qx++}
					AND (uar.access = TRUE OR uar."remoteAccess" = TRUE)`;
        qb.push(params.userId);
        if (qw.length > 0) {
            qws += ` AND ( ${qw.join(" AND ")}`;
            if (qwo.length > 0) {
                qws += ` OR ${qwo.join(" AND ")} )`;
            }
            else {
                qws += " ) ";
            }
        }
        const qtotal = `SELECT COUNT(*)::SMALLINT AS c ` + qfrom + qws;
        const totalResult = await params.trx.query(qtotal, qb);
        const result = {
            total: totalResult.rowCount > 0 ? totalResult.rows[0].c : 0,
            skip: params.filter.skip || 0,
            take: params.filter.take || 100,
            items: [],
        };
        let q = `
			SELECT
			"acp"."id",
			"acp"."deviceId",
			"acp"."typedGeoLocation",
			"uar"."access",
			"uar"."read",
			"uar"."config",
			"uar"."grant",
			"uar"."remoteAccess",
			"uar"."snapshot",
			"acp"."remoteAvailable",
			"acp"."name",
			"acp"."location",
			"uar"."markedAsFavorite",
			"acp"."accessControlPointType",
			"acp"."states",
			"acp"."authenticationFactors",
			(	SELECT json_agg(json_build_object('id', d."id", 'brand', d."brand",
							'model', d."model", 'name', d."name", 'location', d."location", 'publicKey',d."publicKey"))
				FROM "${params.organizationId}"."devices" as d where d."deletedAt" is null
				AND acp."deviceId" = d."id"
			) as device,
			(SELECT json_agg(json_build_object('id', cpr."id", 'number', cpr."number",
							'driveDuration', cpr."driveDuration", 'name', cpr."name", 'direction', cpr."direction"))
				FROM "${params.organizationId}"."deviceRelays" as cpr where cpr."deletedAt" is null
				AND cpr."accessControlPointId" = acp."id"
			) as relays,
			(SELECT json_agg(json_build_object('id', cprd."id", 'number', cprd."number",
							'location', cprd."location", 'name', cprd."name", 'direction', cprd."direction",
							'dataFormat', cprd."dataFormat", 'credentialType', cprd."credentialType"))
				FROM "${params.organizationId}"."deviceReaders" as cprd where cprd."deletedAt" is null
				AND cprd."accessControlPointId" = acp."id"
			) as readers
		` +
            qfrom +
            qws +
            `
		ORDER BY acp.name`;
        if (params.filter?.skip > 0) {
            q += `
                OFFSET $${qx++}`;
            qb.push(params.filter.skip);
        }
        q += `
			LIMIT $${qx++}`;
        qb.push(params.filter.take || 100);
        const { rows } = await params.trx.query(q, qb);
        for (let row of rows) {
            result.items.push({
                id: row.id,
                deviceId: row.deviceId,
                name: row.name,
                location: row.location,
                markedAsFavorite: row.markedAsFavorite,
                remoteAvailable: row.remoteAvailable,
                accessControlPointType: row.accessControlPointType,
                relays: row.relays,
                readers: row.readers,
                cameraInfo: await dal_manager_1.dbManager.accessCamera.getCameraForAccessControlPoint(params.organizationId, row.id),
                states: row.states,
                authenticationFactors: row.authenticationFactors,
                deviceInfo: row.device && row.device.length > 0 ? row.device[0] : null,
                userRights: {
                    access: row.access ? row.access : false,
                    remoteAccess: row.remoteAccess ? row.remoteAccess : false,
                    grant: row.grant ? row.grant : false,
                    config: row.config ? row.config : false,
                    read: row.read ? row.read : false,
                    snapshot: row.snapshot ? row.snapshot : false,
                },
                geoLocation: row.typedGeoLocation && row.typedGeoLocation.t === dal_constants_1.DalConstants.GeoLocationType.Circle
                    ? {
                        latitude: row.typedGeoLocation.la,
                        longitude: row.typedGeoLocation.lo,
                        radius: row.typedGeoLocation.r,
                    }
                    : undefined,
                typedGeoLocation: row.typedGeoLocation
                    ? row.typedGeoLocation.t === dal_constants_1.DalConstants.GeoLocationType.Circle
                        ? {
                            type: row.typedGeoLocation.t,
                            latitude: row.typedGeoLocation.la,
                            longitude: row.typedGeoLocation.lo,
                            radius: row.typedGeoLocation.r,
                        }
                        : {
                            type: row.typedGeoLocation.t,
                            points: row.typedGeoLocation.p?.map((point) => {
                                return {
                                    latitude: point.la,
                                    longitude: point.lo,
                                };
                            }),
                        }
                    : undefined,
                qrCodes: await this.listQRCodesForAccessPoint({
                    id: row.id,
                    organizationId: params.organizationId,
                    request: { pagination: { skip: 0, take: 5 } },
                    trx: params.trx,
                }),
            });
        }
        return result;
    }
    async searchRemoteAccessGrantedAccessControlPoints(organizationId, userId, filter) {
        let result = {
            total: 0,
            skip: filter.skip,
            take: filter.take,
            items: [],
        };
        let qb = this.dbClient
            .withSchema(organizationId)
            .from("accessControlPoints as acp")
            .innerJoin("userAccessRights as uar", "acp.id", "uar.accessControlPointId")
            .whereNull("acp.deletedAt")
            .where("acp.remoteAvailable", true)
            .whereNull("uar.deletedAt")
            .where("acp.organizationId", organizationId)
            .where("uar.userId", userId)
            .where("uar.remoteAccess", true);
        if (filter.filter) {
            qb.whereWrapped((q) => {
                let filterTokens = filter.filter.split(" ");
                for (const filterToken of filterTokens) {
                    let token = filterToken.trim();
                    if (token.length > 0) {
                        token = "%" + token + "%";
                        q.orWhereRaw("acp.name ilike ?", token);
                        q.orWhereRaw("acp.location ilike ?", token);
                    }
                }
            });
        }
        if (filter.onlyMarkedAsFavorites) {
            qb.where("uar.markedAsFavorite", true);
        }
        if (filter.accessControlPointType !== null && filter.accessControlPointType !== undefined) {
            qb.where("acp.accessControlPointType", filter.accessControlPointType);
        }
        let qbCount = qb.clone();
        result.total = await qbCount.count("acp.id as c").then((rows) => {
            return parseInt(rows[0].c);
        });
        if (result.total === 0) {
            return Promise.resolve(result);
        }
        qb.select("acp.id", "acp.deviceId", "uar.access", "uar.read", "uar.config", "uar.grant", "uar.remoteAccess", "uar.snapshot", "acp.name", "acp.location", "uar.markedAsFavorite", "acp.accessControlPointType", "acp.states", this.dbClient.raw(`            
            (select json_agg(json_build_object('id', cpr."id", 'number', cpr."number", 
                            'driveDuration', cpr."driveDuration", 'name', cpr."name", 'direction', cpr."direction"))
            from "${organizationId}"."deviceRelays" as cpr where cpr."deletedAt" is null 
            and cpr."accessControlPointId" = acp."id") as relays
`))
            .orderBy("acp.name")
            .offset(filter.skip)
            .limit(filter.take);
        await qb.then(async (rows) => {
            for (let row of rows) {
                result.items.push({
                    id: row.id,
                    deviceId: row.deviceId,
                    name: row.name,
                    location: row.location,
                    markedAsFavorite: row.markedAsFavorite,
                    accessControlPointType: row.accessControlPointType,
                    relays: row.relays,
                    cameraInfo: await dal_manager_1.dbManager.accessCamera.getCameraForAccessControlPoint(organizationId, row.id),
                    states: row.states,
                    userRights: {
                        access: row.access ? row.access : false,
                        remoteAccess: row.remoteAccess ? row.remoteAccess : false,
                        grant: row.grant ? row.grant : false,
                        config: row.config ? row.config : false,
                        read: row.read ? row.read : false,
                        snapshot: row.snapshot ? row.snapshot : false,
                    },
                });
            }
        });
        return Promise.resolve(result);
    }
    async listRegionsAccesControlPointIds(organizationId, regionIds, trx) {
        const query = `
			SELECT "accessControlPointId"
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}"
			WHERE "regionId" = ANY($1)
		`;
        const { rows } = await trx.query(query, [regionIds]);
        return rows.map((row) => row.accessControlPointId);
    }
    async getRegionsAccesControlPointIds(organizationId, regionIds) {
        return (await this._pgPool.query(`SELECT "accessControlPointId" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.regionAccessControlPoints}"
            WHERE "regionId" = ANY($1::uuid[])`, [regionIds])).rows.map((r) => r.accessControlPointId);
    }
    async listOrganizationAccessControlPointIds(organizationId) {
        return await this.dbClient
            .withSchema(organizationId)
            .from("accessControlPoints")
            .whereNull("deletedAt")
            .where("organizationId", organizationId)
            .select("id")
            .then((rows) => {
            if (rows) {
                return rows.map((r) => r.id);
            }
        });
    }
    async searchAccessControlPoint(organizationId, filter, hasSystemRead, userId) {
        let result = {
            take: filter.take,
            skip: filter.skip,
            items: [],
            total: 0,
        };
        let userAccessRights = await dal_manager_1.dbManager.accessAccessControlPoint.getUserAccessControlPointRights(organizationId, userId);
        let qb = this.dbClient.withSchema(organizationId).table("accessControlPoints as acp").where("organizationId", organizationId).whereNull("acp.deletedAt");
        if (filter.filter)
            qb.where("name", "ilike", "%" + filter.filter.trim() + "%");
        qb.whereIn("acp.id", userAccessRights.filter((a) => a.read).map((a) => a.accessControlPointId));
        if (filter.accessControlPointType)
            qb.where("acp.accessControlPointType", filter.accessControlPointType);
        result.total = await qb
            .clone()
            .count()
            .then((r) => parseInt(r[0].count));
        if (filter.skip)
            qb.offset(filter.skip);
        if (filter.take)
            qb.limit(filter.take);
        await qb
            .orderBy("name", "ASC")
            .select("acp.id", "acp.isRemoteDefault", "acp.accessControlPointType", "acp.states", "acp.name", "acp.remoteAvailable", "acp.location", "acp.typedGeoLocation")
            .then(async (rows) => {
            for (let row of rows) {
                let userRights = userAccessRights.find((a) => a.accessControlPointId == row.id);
                result.items.push({
                    id: row.id,
                    isRemoteDefault: row.isRemoteDefault,
                    managable: true,
                    states: row.states,
                    remoteAvailable: row.remoteAvailable,
                    type: row.accessControlPointType,
                    name: row.name,
                    location: row.location,
                    cameraInfo: await dal_manager_1.dbManager.accessCamera.getCameraForAccessControlPoint(organizationId, row.id),
                    userRights: {
                        access: userRights ? userRights.access : false,
                        remoteAccess: userRights ? userRights.remoteAccess : false,
                        grant: userRights ? userRights.grant : false,
                        config: userRights ? userRights.config : false,
                        read: userRights ? userRights.read : false,
                        snapshot: userRights ? userRights.snapshot : false,
                    },
                    geoLocation: row.typedGeoLocation && row.typedGeoLocation.t === dal_constants_1.DalConstants.GeoLocationType.Circle
                        ? {
                            latitude: row.typedGeoLocation.la,
                            longitude: row.typedGeoLocation.lo,
                            radius: row.typedGeoLocation.r,
                        }
                        : undefined,
                    typedGeoLocation: row.typedGeoLocation
                        ? row.typedGeoLocation.t === dal_constants_1.DalConstants.GeoLocationType.Circle
                            ? {
                                type: row.typedGeoLocation.t,
                                latitude: row.typedGeoLocation.la,
                                longitude: row.typedGeoLocation.lo,
                                radius: row.typedGeoLocation.r,
                            }
                            : {
                                type: row.typedGeoLocation.t,
                                points: row.typedGeoLocation.p?.map((point) => {
                                    return {
                                        latitude: point.la,
                                        longitude: point.lo,
                                    };
                                }),
                            }
                        : undefined,
                    qrCodes: await this.listQRCodesForAccessPoint({
                        id: row.id,
                        organizationId: organizationId,
                        request: { pagination: { skip: 0, take: 5 } },
                    }),
                });
            }
        });
        return Promise.resolve(result);
    }
    async upsertUserAccessControlPointGrantsBySelectionSession(organizationId, params, trx) {
        let queryParamIndex = 0;
        await trx.query(`
            UPDATE "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" AS uar
            SET "deletedAt" = now()
            FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userSelectionSessionActions}" AS "ussa"
            WHERE uar."userId" = ussa."userId" AND
                uar."deletedAt" IS NULL AND
                uar."accessControlPointId" = $${++queryParamIndex} AND
                "ussa"."sessionId" = $${++queryParamIndex} AND
                "ussa"."action" = $${++queryParamIndex}
            `, [params.accessControlPointId, params.userSelectionSessionId, dal_constants_1.DalConstants.UserSelectionSessionAction.Removed]);
        let acp = await dal_manager_1.dbManager.accessAccessControlPoint.getAccessControlPointBasic(organizationId, params.accessControlPointId);
        let defaultPrivileges = {
            read: acp.defaultPrivileges && acp.defaultPrivileges.read ? true : false,
            grant: acp.defaultPrivileges && acp.defaultPrivileges.grant ? true : false,
            config: acp.defaultPrivileges && acp.defaultPrivileges.config ? true : false,
            access: acp.defaultPrivileges && acp.defaultPrivileges.access ? true : false,
            remoteAccess: acp.defaultPrivileges && acp.defaultPrivileges.remoteAccess ? true : false,
            snapshot: acp.defaultPrivileges && acp.defaultPrivileges.snapshot ? true : false,
        };
        if (params.privileges?.accessRights) {
            defaultPrivileges = {
                read: params.privileges.accessRights.read ? true : false,
                access: params.privileges.accessRights.access ? true : false,
                config: params.privileges.accessRights.config ? true : false,
                remoteAccess: params.privileges.accessRights.remoteAccess ? true : false,
                grant: params.privileges.accessRights.grant ? true : false,
                snapshot: params.privileges.accessRights.snapshot ? true : false,
            };
        }
        if (params.privileges?.scope &&
            (params.privileges.scope === dal_constants_1.DalConstants.UserSelectionSessionAccessControlPointRightScope.InsertNewExpandCurrent ||
                params.privileges.scope === dal_constants_1.DalConstants.UserSelectionSessionAccessControlPointRightScope.InsertNewOverrideCurrent)) {
            let updateParamIndex = 0;
            let updateQueryForPreviouslyGrantedRights = `
				UPDATE "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}"
			`;
            if (params.privileges.scope === dal_constants_1.DalConstants.UserSelectionSessionAccessControlPointRightScope.InsertNewExpandCurrent) {
                updateQueryForPreviouslyGrantedRights += `
				SET "remoteAccess" = "remoteAccess" OR $${++updateParamIndex}, "read" = "read" OR $${++updateParamIndex}, "access" = "access" OR $${++updateParamIndex}, 
				"config" = "config" OR $${++updateParamIndex}, "grant" = "grant" OR $${++updateParamIndex}, "snapshot" = "snapshot" OR $${++updateParamIndex}
				`;
            }
            else {
                updateQueryForPreviouslyGrantedRights += `
				SET "remoteAccess" = $${++updateParamIndex}, "read" = $${++updateParamIndex}, "access" = $${++updateParamIndex}, 
				"config" = $${++updateParamIndex}, "grant" = $${++updateParamIndex}, "snapshot" = $${++updateParamIndex}
				`;
            }
            updateQueryForPreviouslyGrantedRights += `
				WHERE "userId" IN (
					SELECT ussa."userId" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userSelectionSessionActions}" AS ussa
					WHERE ussa."action" = $${++updateParamIndex} AND ussa."sessionId" = $${++updateParamIndex}
				) AND "deletedAt" IS NULL 
				AND "accessControlPointId" = $${++updateParamIndex}
				
			`;
            await trx.query(updateQueryForPreviouslyGrantedRights, [
                defaultPrivileges.remoteAccess,
                defaultPrivileges.read,
                defaultPrivileges.access,
                defaultPrivileges.config,
                defaultPrivileges.grant,
                defaultPrivileges.snapshot,
                dal_constants_1.DalConstants.UserSelectionSessionAction.Unchanged,
                params.userSelectionSessionId,
                params.accessControlPointId,
            ]);
        }
        queryParamIndex = 0;
        await trx.query(`
            INSERT INTO "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}"
            (id, "createdAt", "updatedAt", "deletedAt", "userId", "accessControlPointId", "remoteAccess", "read", "access", "config", "grant", "snapshot")
            (
                SELECT uuid_generate_v4(), now(), now(), null, ussa."userId", $${++queryParamIndex}, $${++queryParamIndex}, $${++queryParamIndex}, $${++queryParamIndex}, $${++queryParamIndex}, $${++queryParamIndex} , $${++queryParamIndex}
                FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userSelectionSessionActions}" AS ussa
				WHERE ussa."action" = $${++queryParamIndex} AND ussa."sessionId" = $${++queryParamIndex})
                ON CONFLICT("userId", "accessControlPointId", "deletedAt") DO UPDATE
                SET "updatedAt" = now(), "remoteAccess" = $${++queryParamIndex}, "read" = $${++queryParamIndex}, "access" = $${++queryParamIndex}, "config" = $${++queryParamIndex}, "grant" = $${++queryParamIndex}, "snapshot" = $${++queryParamIndex}
`, [
            params.accessControlPointId,
            defaultPrivileges.remoteAccess,
            defaultPrivileges.read,
            defaultPrivileges.access,
            defaultPrivileges.config,
            defaultPrivileges.grant,
            defaultPrivileges.snapshot,
            dal_constants_1.DalConstants.UserSelectionSessionAction.Added,
            params.userSelectionSessionId,
            defaultPrivileges.remoteAccess,
            defaultPrivileges.read,
            defaultPrivileges.access,
            defaultPrivileges.config,
            defaultPrivileges.grant,
            defaultPrivileges.snapshot,
        ]);
        let countOfGranters = (await trx.query(`
            SELECT COUNT(*) 
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" as uar
			INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" AS u
				ON u."userId" = uar."userId"
            WHERE	uar."deletedAt" IS NULL AND
            		"read" = TRUE AND
            		"grant" = TRUE AND
					u."isDisabled" = FALSE AND
            		"accessControlPointId" = $1
    `, [params.accessControlPointId])).rows[0].count;
        if (countOfGranters < 1) {
            throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.INVALID_ACCESS_CONTROL_POINT_RIGHTS, "ERRORS.GENERAL.LASTUSERWITHGRANT", null, true);
        }
        let countOfConfigers = (await trx.query(`
            SELECT COUNT(*) 
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" as uar
			INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" AS u 
				ON u."userId" = uar."userId"
            WHERE 	uar."deletedAt" IS NULL AND
					u."deletedAt" IS NULL AND
            		"read" = TRUE AND
            		"config" = TRUE AND
					u."isDisabled" = FALSE AND
            		"accessControlPointId" = $1
    `, [params.accessControlPointId])).rows[0].count;
        await trx.query(`
                DELETE FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userSelectionSessions}"
                    WHERE "id" = $1
            `, [params.userSelectionSessionId]);
        if (countOfConfigers < 1) {
            throw (0, api_error_1.generateTranslatedError)(app_enums_1.enums.HttpStatusCode.INVALID_ACCESS_CONTROL_POINT_RIGHTS, "ERRORS.GENERAL.LASTUSERWITHCONFIG", null, true);
        }
    }
    async getWiegandInfoById(organizationId, accessControlPointId, wiegandReaderId, trx) {
        let qb = this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders)
            .whereNull("deletedAt")
            .where("accessControlPointId", accessControlPointId)
            .where("id", wiegandReaderId);
        if (trx)
            qb.transacting(trx);
        return await qb.first();
    }
    async getAccessControlPointDetailesByDeviceId(organizationId, deviceId) {
        let acp = await this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
            .where("deviceId", deviceId)
            .where("organizationId", organizationId)
            .first("id");
        if (!acp) {
            throw (0, api_error_1.generateNotFoundApiError)({
                message: "No access control point for device",
            });
        }
        return this.getAccessControlPointDetailes(organizationId, acp.id);
    }
    async getAccessControlPointDetailes(organizationId, accessControlPointId) {
        let accessControlPointBasic = await this.getAccessControlPointBasic(organizationId, accessControlPointId);
        return await this.dbClient.transaction(async (trx) => {
            let mainDevice = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelMSeriesSettings)
                .where("deviceId", accessControlPointBasic.deviceId)
                .first();
            let deviceIds = [];
            if (!mainDevice) {
                deviceIds.push(accessControlPointBasic.deviceId);
            }
            else {
                deviceIds.push(mainDevice.deviceId);
                let extensionDevicesIds = (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.controlPanelESeriesSettings).where("mainControlPanelId", mainDevice.deviceId).select("deviceId")).map((e) => e.deviceId);
                deviceIds.push(...extensionDevicesIds);
            }
            let accessControlPointInfo = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
                .first("id", "name", "authenticationFactors", "deviceId", "states")
                .whereNull("deletedAt")
                .where("id", accessControlPointId));
            if (accessControlPointBasic.deviceId) {
                let relays = (await trx
                    .withSchema(organizationId)
                    .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                    .whereNull("deletedAt")
                    .whereIn("deviceId", deviceIds)
                    .where("accessControlPointId", accessControlPointId)
                    .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name", "deviceId"));
                let wiegandReaders = (await trx
                    .withSchema(organizationId)
                    .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders)
                    .whereNull("deletedAt")
                    .whereIn("deviceId", deviceIds)
                    .where("accessControlPointId", accessControlPointId)
                    .select("id", "name", "accessControlPointId", "location", "model", "deviceId", "direction", "dataFormat", "number", "relayId", "recurrentAttemptTimeout", "authenticationFactor"));
                let dryContactInputs = (await trx
                    .withSchema(organizationId)
                    .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                    .whereNull("deletedAt")
                    .whereIn("deviceId", deviceIds)
                    .where("accessControlPointId", accessControlPointId)
                    .select("id", "name", "accessControlPointId", "deviceId", "number", "nc", "type", "settings"));
                let hikVisionLicencePlateCameraLanes = await trx
                    .withSchema(organizationId)
                    .from(dal_db_armon_schema_1.ArmonSchema.tableNames.hikVisionLicencePlateCameraLanes + " as l")
                    .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations + " as de", "de.integratingDeviceId", "l.deviceId")
                    .whereIn("de.integratedDeviceId", deviceIds)
                    .where("l.accessControlPointId", accessControlPointId)
                    .where("de.type", dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionLicencePlateReader)
                    .select("l.id", "l.name", "l.number", "l.direction");
                let impinjSpeedWayGateWayAntennas = await trx
                    .withSchema(organizationId)
                    .from(dal_db_armon_schema_1.ArmonSchema.tableNames.impinjSpeedWayGateWayAntennas + " as l")
                    .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations + " as de", "de.integratingDeviceId", "l.deviceId")
                    .whereIn("de.integratedDeviceId", deviceIds)
                    .where("l.accessControlPointId", accessControlPointId)
                    .where("de.type", dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.ImpinjSpeedWayRs485)
                    .select("l.id", "l.name", "l.number", "l.direction");
                return Promise.resolve({
                    id: accessControlPointId,
                    name: accessControlPointBasic.name,
                    location: accessControlPointBasic.location,
                    deviceId: accessControlPointBasic.deviceId,
                    accessControlPointType: accessControlPointBasic.type,
                    remoteAvailable: accessControlPointBasic.remoteAvailable,
                    isRemoteDefault: accessControlPointBasic.isRemoteDefault,
                    authenticationFactors: accessControlPointInfo.authenticationFactors,
                    hikVisionLicencePlateReaderLanes: hikVisionLicencePlateCameraLanes,
                    impinjSpeedWayGateWayAntennas: impinjSpeedWayGateWayAntennas,
                    relays: relays.map((r) => {
                        return {
                            controlPanelId: accessControlPointBasic.deviceId,
                            direction: r.direction,
                            driveDuration: r.driveDuration,
                            id: r.id,
                            managesTo: r.name,
                            number: r.number,
                        };
                    }),
                    wiegandReaders: wiegandReaders.map((w) => {
                        return {
                            id: w.id,
                            controlPanelId: w.deviceId,
                            controlPanelRelayId: w.relayId,
                            dataFormat: w.dataFormat,
                            direction: w.direction,
                            location: w.location,
                            name: w.name,
                            readerWiegandInputNumber: w.number,
                        };
                    }),
                    exitButtons: dryContactInputs
                        .filter((d) => d.type == libEnumsV2.DryContactType.ExitButton)
                        .map((d) => {
                        return {
                            controlPanelId: d.deviceId,
                            id: d.id,
                            controlPanelRelayId: d.settings ? d.settings.relayId : null,
                            dryContactInputNumber: d.number,
                            nc: d.nc,
                        };
                    }),
                    statusSensors: dryContactInputs
                        .filter((d) => d.type == libEnumsV2.DryContactType.StatusSensor)
                        .map((d) => {
                        return {
                            controlPanelId: d.deviceId,
                            id: d.id,
                            controlPanelRelayId: d.settings ? d.settings.relayId : null,
                            timeOut: d.settings ? d.settings.timeOut : null,
                            dryContactInputNumber: d.number,
                            senseTo: d.name,
                            nc: d.nc,
                        };
                    }),
                    counterSensors: dryContactInputs
                        .filter((d) => d.type == libEnumsV2.DryContactType.CounterSensor)
                        .map((d) => {
                        return {
                            controlPanelId: d.deviceId,
                            id: d.id,
                            controlPanelRelayId: d.settings ? d.settings.relayId : null,
                            dryContactInputNumber: d.number,
                            countsTo: d.name,
                            nc: d.nc,
                        };
                    }),
                });
            }
            else {
                return Promise.resolve({
                    id: accessControlPointId,
                    name: accessControlPointBasic.name,
                    location: accessControlPointBasic.location,
                    deviceId: accessControlPointBasic.deviceId,
                    accessControlPointType: accessControlPointBasic.type,
                    remoteAvailable: accessControlPointBasic.remoteAvailable,
                    isRemoteDefault: accessControlPointBasic.isRemoteDefault,
                    authenticationFactors: accessControlPointInfo.authenticationFactors,
                });
            }
        });
    }
    async getAccessControlPointDetailesV2(organizationId, accessControlPointId) {
        let accessControlPointBasic = await this.getAccessControlPointBasic(organizationId, accessControlPointId);
        return await this.dbClient.transaction(async (trx) => {
            let accessControlPointInfo = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
                .first("id", "name", "authenticationFactors", "deviceId", "states")
                .whereNull("deletedAt")
                .where("id", accessControlPointId));
            let relays = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                .whereNull("deletedAt")
                .where("accessControlPointId", accessControlPointId)
                .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name", "deviceId"));
            let wiegandReaders = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders)
                .whereNull("deletedAt")
                .where("accessControlPointId", accessControlPointId)
                .select("id", "name", "accessControlPointId", "location", "model", "deviceId", "direction", "dataFormat", "number", "relayId", "recurrentAttemptTimeout", "authenticationFactor"));
            let dryContactInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereNull("deletedAt")
                .where("accessControlPointId", accessControlPointId)
                .select("id", "name", "accessControlPointId", "deviceId", "number", "nc", "type", "settings"));
            let hikVisionLicencePlateCameraLanes = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.hikVisionLicencePlateCameraLanes + " as l")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations + " as de", "de.integratingDeviceId", "l.deviceId")
                .where("l.accessControlPointId", accessControlPointId)
                .where("de.type", dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionLicencePlateReader)
                .select("l.id", "l.name", "l.number", "l.direction");
            let impinjSpeedWayGateWayAntennas = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.impinjSpeedWayGateWayAntennas + " as l")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations + " as de", "de.integratingDeviceId", "l.deviceId")
                .where("l.accessControlPointId", accessControlPointId)
                .where("de.type", dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.ImpinjSpeedWayRs485)
                .select("l.id", "l.name", "l.number", "l.direction");
            return Promise.resolve({
                id: accessControlPointId,
                name: accessControlPointBasic.name,
                location: accessControlPointBasic.location,
                deviceId: accessControlPointBasic.deviceId,
                accessControlPointType: accessControlPointBasic.type,
                remoteAvailable: accessControlPointBasic.remoteAvailable,
                isRemoteDefault: accessControlPointBasic.isRemoteDefault,
                authenticationFactors: accessControlPointInfo.authenticationFactors,
                hikVisionLicencePlateReaderLanes: hikVisionLicencePlateCameraLanes,
                impinjSpeedWayGateWayAntennas: impinjSpeedWayGateWayAntennas,
                relays: relays.map((r) => {
                    return {
                        deviceId: accessControlPointBasic.deviceId,
                        direction: r.direction,
                        driveDuration: r.driveDuration,
                        id: r.id,
                        managesTo: r.name,
                        number: r.number,
                    };
                }),
                wiegandReaders: wiegandReaders.map((w) => {
                    return {
                        id: w.id,
                        deviceId: w.deviceId,
                        deviceRelayId: w.relayId,
                        dataFormat: w.dataFormat,
                        direction: w.direction,
                        location: w.location,
                        name: w.name,
                        readerWiegandInputNumber: w.number,
                    };
                }),
                exitButtons: dryContactInputs
                    .filter((d) => d.type == libEnumsV2.DryContactType.ExitButton)
                    .map((d) => {
                    return {
                        deviceId: d.deviceId,
                        id: d.id,
                        deviceRelayId: d.settings ? d.settings.relayId : null,
                        dryContactInputNumber: d.number,
                        nc: d.nc,
                    };
                }),
                statusSensors: dryContactInputs
                    .filter((d) => d.type == libEnumsV2.DryContactType.StatusSensor)
                    .map((d) => {
                    return {
                        deviceId: d.deviceId,
                        id: d.id,
                        deviceRelayId: d.settings ? d.settings.relayId : null,
                        timeOut: d.settings ? d.settings.timeOut : null,
                        dryContactInputNumber: d.number,
                        senseTo: d.name,
                        nc: d.nc,
                    };
                }),
                counterSensors: dryContactInputs
                    .filter((d) => d.type == libEnumsV2.DryContactType.CounterSensor)
                    .map((d) => {
                    return {
                        deviceId: d.deviceId,
                        id: d.id,
                        deviceRelayId: d.settings ? d.settings.relayId : null,
                        dryContactInputNumber: d.number,
                        countsTo: d.name,
                        nc: d.nc,
                    };
                }),
            });
        });
    }
    async getAccessControlPointDetailesV3(organizationId, userId, accessControlPointId) {
        let accessControlPointBasic = await this.getAccessControlPointBasic(organizationId, accessControlPointId);
        return await this.dbClient.transaction(async (trx) => {
            let accessControlPointInfo = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
                .first("id", "name", "authenticationFactors", "deviceId", "states", "defaultPrivileges", "typedGeoLocation")
                .whereNull("deletedAt")
                .where("id", accessControlPointId));
            let relays = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                .whereNull("deletedAt")
                .where("accessControlPointId", accessControlPointId)
                .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name", "deviceId"));
            let readers = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders)
                .whereNull("deletedAt")
                .where("accessControlPointId", accessControlPointId)
                .select("id", "name", "accessControlPointId", "location", "model", "deviceId", "direction", "dataFormat", "number", "relayId", "recurrentAttemptTimeout", "credentialType", "readerOutputType"));
            let dryContactInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereNull("deletedAt")
                .where("accessControlPointId", accessControlPointId)
                .select("id", "name", "accessControlPointId", "deviceId", "number", "nc", "type", "settings"));
            let userRights = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights)
                .where("accessControlPointId", accessControlPointId)
                .where("userId", userId)
                .whereNull("deletedAt")
                .first("access", "read", "config", "grant", "remoteAccess", "snapshot");
            let cameras = await dal_manager_1.dbManager.accessCamera.getCameraForAccessControlPoint(organizationId, accessControlPointId);
            return Promise.resolve({
                id: accessControlPointId,
                name: accessControlPointBasic.name,
                location: accessControlPointBasic.location,
                deviceId: accessControlPointBasic.deviceId,
                accessControlPointType: accessControlPointBasic.type,
                remoteAvailable: accessControlPointBasic.remoteAvailable,
                authenticationFactors: accessControlPointInfo.authenticationFactors,
                cameraInfo: cameras,
                states: accessControlPointInfo.states,
                defaultPrivileges: {
                    read: accessControlPointInfo.defaultPrivileges?.read ?? false,
                    access: accessControlPointInfo.defaultPrivileges?.access ?? false,
                    config: accessControlPointInfo.defaultPrivileges?.config ?? false,
                    grant: accessControlPointInfo.defaultPrivileges?.grant ?? false,
                    remoteAccess: accessControlPointInfo.defaultPrivileges?.remoteAccess ?? false,
                    snapshot: accessControlPointInfo.defaultPrivileges?.snapshot ?? false,
                },
                userRights: userRights,
                relays: relays.map((r) => {
                    return {
                        deviceId: accessControlPointBasic.deviceId,
                        direction: r.direction,
                        driveDuration: r.driveDuration,
                        id: r.id,
                        managesTo: r.name,
                        number: r.number,
                    };
                }),
                readers: readers.map((w) => {
                    return {
                        id: w.id,
                        deviceId: w.deviceId,
                        deviceRelayId: w.relayId,
                        dataFormat: w.dataFormat,
                        direction: w.direction,
                        location: w.location,
                        name: w.name,
                        accessControlPointId: w.accessControlPointId,
                        credentialType: w.credentialType,
                        model: w.model,
                        number: w.number,
                        readerOutputType: w.readerOutputType,
                        recurrentAttemptTimeout: w.recurrentAttemptTimeout,
                    };
                }),
                exitButtons: dryContactInputs
                    .filter((d) => d.type == libEnumsV2.DryContactType.ExitButton)
                    .map((d) => {
                    return {
                        deviceId: d.deviceId,
                        id: d.id,
                        deviceRelayId: d.settings ? d.settings.relayId : null,
                        dryContactInputNumber: d.number,
                        nc: d.nc,
                    };
                }),
                statusSensors: dryContactInputs
                    .filter((d) => d.type == libEnumsV2.DryContactType.StatusSensor)
                    .map((d) => {
                    return {
                        deviceId: d.deviceId,
                        id: d.id,
                        deviceRelayId: d.settings ? d.settings.relayId : null,
                        timeOut: d.settings ? d.settings.timeOut : null,
                        dryContactInputNumber: d.number,
                        senseTo: d.name,
                        nc: d.nc,
                    };
                }),
                counterSensors: dryContactInputs
                    .filter((d) => d.type == libEnumsV2.DryContactType.CounterSensor)
                    .map((d) => {
                    return {
                        deviceId: d.deviceId,
                        id: d.id,
                        deviceRelayId: d.settings ? d.settings.relayId : null,
                        dryContactInputNumber: d.number,
                        countsTo: d.name,
                        nc: d.nc,
                    };
                }),
                geoLocation: accessControlPointInfo.typedGeoLocation && accessControlPointInfo.typedGeoLocation.t === dal_constants_1.DalConstants.GeoLocationType.Circle
                    ? {
                        radius: accessControlPointInfo.typedGeoLocation.r,
                        latitude: accessControlPointInfo.typedGeoLocation.la,
                        longitude: accessControlPointInfo.typedGeoLocation.lo,
                    }
                    : null,
                typedGeoLocation: accessControlPointInfo.typedGeoLocation
                    ? accessControlPointInfo.typedGeoLocation.t === dal_constants_1.DalConstants.GeoLocationType.Circle
                        ? {
                            type: accessControlPointInfo.typedGeoLocation.t,
                            radius: accessControlPointInfo.typedGeoLocation.r,
                            latitude: accessControlPointInfo.typedGeoLocation.la,
                            longitude: accessControlPointInfo.typedGeoLocation.lo,
                        }
                        : {
                            type: accessControlPointInfo.typedGeoLocation.t,
                            points: accessControlPointInfo.typedGeoLocation.p?.map((p) => {
                                return {
                                    latitude: p.la,
                                    longitude: p.lo,
                                };
                            }),
                        }
                    : null,
                qrCodes: await this.listQRCodesForAccessPoint({
                    id: accessControlPointId,
                    organizationId: organizationId,
                    request: { pagination: { skip: 0, take: 5 } },
                }),
            });
        });
    }
    async logAcpUpdate(organizationId, requestUserId, oldAcp, newAcp) {
        let changedItems = [];
        Object.keys(newAcp).forEach(async (prop) => {
            switch (prop) {
                case "name":
                    if (newAcp.name !== oldAcp.name) {
                        changedItems.push({
                            f: prop,
                            o: oldAcp.name,
                            n: newAcp.name,
                            i: true,
                        });
                    }
                    break;
                case "location":
                    if (JSON.stringify(newAcp.location) !== JSON.stringify(oldAcp.location)) {
                        changedItems.push({
                            f: prop,
                            o: oldAcp.location,
                            n: newAcp.location,
                            i: true,
                        });
                    }
                    break;
                case "accessControlPointType":
                    if (newAcp.accessControlPointType !== oldAcp.accessControlPointType) {
                        changedItems.push({
                            f: prop,
                            o: oldAcp.accessControlPointType,
                            n: newAcp.accessControlPointType,
                            i: true,
                        });
                    }
                    break;
                case "states":
                    if (!oldAcp.states && newAcp.states) {
                        changedItems.push({
                            f: prop,
                            n: newAcp.states[0],
                            i: true,
                        });
                    }
                    else if (!oldAcp.states && newAcp.states) {
                        changedItems.push({
                            f: prop,
                            o: oldAcp.states[0],
                            i: true,
                        });
                    }
                    else if (!oldAcp.states && !newAcp.states) {
                        break;
                    }
                    else if (newAcp.states[0].direction !== oldAcp.states[0].direction || newAcp.states[0].state !== oldAcp.states[0].state) {
                        changedItems.push({
                            f: prop,
                            o: oldAcp.states[0],
                            n: newAcp.states[0],
                            i: true,
                        });
                    }
                    break;
                case "authenticationFactors":
                    if (JSON.stringify(newAcp.authenticationFactors) !== JSON.stringify(oldAcp.authenticationFactors)) {
                        let len = Math.max(newAcp.authenticationFactors.length, oldAcp.authenticationFactors.length);
                        for (let i = 0; i < len; i++) {
                            if (oldAcp.authenticationFactors[i] &&
                                newAcp.authenticationFactors[i] &&
                                JSON.stringify(newAcp.authenticationFactors[i].and) !== JSON.stringify(oldAcp.authenticationFactors[i].and)) {
                                changedItems.push({
                                    f: prop,
                                    o: oldAcp.authenticationFactors[i].and,
                                    n: newAcp.authenticationFactors[i].and,
                                    i: true,
                                });
                            }
                            else if (!oldAcp.authenticationFactors[i] && newAcp.authenticationFactors[i]) {
                                changedItems.push({
                                    f: prop,
                                    n: newAcp.authenticationFactors[i].and,
                                    i: true,
                                });
                            }
                            else if (!newAcp.authenticationFactors[i] && oldAcp.authenticationFactors[i]) {
                                changedItems.push({
                                    f: prop,
                                    o: oldAcp.authenticationFactors[i].and,
                                    i: true,
                                });
                            }
                        }
                    }
            }
        });
        if (changedItems.length > 0) {
            await dal_manager_1.dbManager.accessLog.addUserActionHistoryItem({
                oId: organizationId,
                o: requestUserId,
                u: new Date(),
                c: dal_constants_1.DalConstants.UserActionCategory.Main,
                tg: ["UpdateAccessControlPoint"],
                t: dal_constants_1.DalConstants.UserMainActionType.UpdateAccessControlPoint,
                d: {
                    id: newAcp.id,
                    c: JSON.stringify(changedItems),
                },
            });
        }
    }
    async addAccessControlPoint(params) {
        const accessPointId = uuid_1.default.v4();
        const now = new Date();
        await params.trx.query(`
		INSERT INTO "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}"(
			id, "createdAt", "updatedAt", name, location, "remoteAvailable", 
			"isRemoteDefault", "organizationId", "accessControlPointType", "authenticationFactors",
			"deviceId", "defaultPrivileges", "typedGeoLocation")
			VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13)
		`, [
            accessPointId,
            now,
            now,
            params.request.name,
            params.request.location,
            params.request.remoteAvailable,
            params.request.isRemoteDefault,
            params.organizationId,
            params.request.accessControlPointType,
            params.request.authenticationFactors ? JSON.stringify(params.request.authenticationFactors) : null,
            params.request.deviceId,
            params.request.defaultPrivileges,
            params.request.typedGeoLocation
                ? params.request.typedGeoLocation.type === dal_constants_1.DalConstants.GeoLocationType.Circle
                    ? {
                        t: params.request.typedGeoLocation.type,
                        la: params.request.typedGeoLocation.latitude,
                        lo: params.request.typedGeoLocation.longitude,
                        r: params.request.typedGeoLocation.radius,
                    }
                    : {
                        t: params.request.typedGeoLocation.type,
                        p: params.request.typedGeoLocation.points?.map((point) => {
                            return {
                                la: point.latitude,
                                lo: point.longitude,
                            };
                        }),
                    }
                : null,
        ]);
        const roleIds = (await params.trx.query(`
			SELECT id 
			FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}" 
			WHERE "typeId" = $1
			`, [predefined_roles_1.PredefinedRoles.SystemAdministrator.id])).rows.map((r) => r.id);
        const isUserFilterAccessRightActivated = await (0, dal_access_psql_organization_1.getOrganizationUserFilterAccessRightActivationStatus)(params.organizationId, params.trx);
        if (isUserFilterAccessRightActivated) {
            const filterId = await dal_manager_1.dbManager.accessUserFilter.insertUserFilter(params.organizationId, {
                name: params.request.name + " Yönetici Filtresi",
                description: "Sistem Yöneticileri otomatik olarak bu filtre ile ilişkilendirilir",
                usageType: restapi_1.UserFilterUsageType.USER_ACCESS_RIGHTS,
                allIncluded: false,
                combinator: restapi_1.UserFilterCombinator.AND,
                settings: { roleIds: roleIds },
            }, params.trx);
            await dal_manager_1.dbManager.accessUserFilter.updateUserFilterAccessControlPointMappings(params.organizationId, {
                filterId: filterId,
                accessControlPoints: [{ id: accessPointId, read: true, grant: true, config: true, access: false, remoteAccess: false, snapshot: true }],
            }, params.trx);
        }
        else {
            const userAccessRights = [];
            const systemAdmins = (await params.trx.query(`
				SELECT DISTINCT uo."userId" FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" uo
				INNER JOIN "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}" r ON r.id = uo."roleId"
				WHERE uo."deletedAt" IS NULL AND
				(uo."isDisabled" IS FALSE OR uo."isDisabled" IS NULL)
				AND r."deletedAt" IS NULL
				AND r."typeId" = $1
				`, [predefined_roles_1.PredefinedRoles.SystemAdministrator.id])).rows.map((r) => r.userId);
            for (const admin of systemAdmins) {
                const { rows: accessRights } = await params.trx.query(`
				SELECT id FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}"
				WHERE "deletedAt" IS NULL
				AND "accessControlPointId" = $1
				AND "userId" = $2
			`, [accessPointId, admin]);
                if (accessRights.length < 1)
                    userAccessRights.push({
                        id: uuid_1.default.v4(),
                        createdAt: now,
                        updatedAt: now,
                        deletedAt: null,
                        userId: admin,
                        accessControlPointId: accessPointId,
                        remoteAccess: false,
                        markedAsFavorite: false,
                        read: true,
                        grant: true,
                        access: false,
                        config: true,
                        snapshot: true,
                    });
                else {
                    await params.trx.query(`
						UPDATE "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}"
						SET = "updatedAt" = $1,
							   read = $2,
							   grant = $3,
							   config = $4,
							   snapshot = $5,
							   "remoteAccess" = $6
						WHERE id = ANY($7::uuid[])
				`, [now, true, true, true, true, true, accessRights.map((a) => a.id)]);
                }
            }
            const qi = [];
            const qb = [];
            let qx = 1;
            let q = `INSERT INTO "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}"(
				id, "createdAt", "updatedAt", "deletedAt", "userId", "accessControlPointId", "remoteAccess", "markedAsFavorite", read, "grant", access, config, snapshot)`;
            for (const userAccessRight of userAccessRights) {
                qi.push(`($${qx++}, $${qx++}, $${qx++}, $${qx++}, $${qx++}, $${qx++}, $${qx++}, $${qx++}, $${qx++}, $${qx++}, $${qx++}, $${qx++}, $${qx++})`);
                qb.push(userAccessRight.id, userAccessRight.createdAt, userAccessRight.updatedAt, userAccessRight.deletedAt, userAccessRight.userId, userAccessRight.accessControlPointId, userAccessRight.remoteAccess, userAccessRight.markedAsFavorite, userAccessRight.read, userAccessRight.grant, userAccessRight.access, userAccessRight.config, userAccessRight.snapshot);
            }
            q = q + " VALUES " + qi.join(" , ");
            await params.trx.query(q, qb);
        }
        await dal_manager_1.dbManager.accessLog.addUserActionHistoryItem({
            oId: params.organizationId,
            o: params.requestUserId,
            u: new Date(),
            c: dal_constants_1.DalConstants.UserActionCategory.Main,
            tg: ["InsertAccessControlPoint"],
            t: dal_constants_1.DalConstants.UserMainActionType.InsertAccessControlPoint,
            d: {
                id: accessPointId,
            },
        });
        return accessPointId;
    }
    async updateAccessControlPoint(params) {
        const oldAcpDetails = await this.getAccessControlPointDetailesV3(params.organizationId, params.requestUserId, params.request.id);
        const typedGeoLocationParam = params.request.typedGeoLocation;
        const updatedAcp = {
            name: params.request?.name ?? oldAcpDetails?.name,
            location: params.request?.location,
            typedGeoLocation: typedGeoLocationParam
                ? typedGeoLocationParam.type === restapi_1.GeoLocationType.Circle
                    ? {
                        t: typedGeoLocationParam.type,
                        r: typedGeoLocationParam.radius,
                        la: typedGeoLocationParam.latitude,
                        lo: typedGeoLocationParam.longitude,
                    }
                    : {
                        t: typedGeoLocationParam.type,
                        p: typedGeoLocationParam.points?.map((point) => {
                            return {
                                la: point.latitude,
                                lo: point.longitude,
                            };
                        }),
                    }
                : null,
            accessControlPointType: params.request?.accessControlPointType ?? oldAcpDetails.accessControlPointType,
            remoteAvailable: params.request?.remoteAvailable ?? oldAcpDetails.remoteAvailable,
            defaultPrivileges: params.request?.defaultPrivileges ?? oldAcpDetails.defaultPrivileges,
            authenticationFactors: params.request?.authenticationFactors ?? null,
            isRemoteDefault: params.request?.isRemoteDefault ?? oldAcpDetails.isRemoteDefault,
        };
        await params.trx.query(`
			UPDATE "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}"
			SET name = $1,
				location = $2,
				"remoteAvailable" = $3,
				"isRemoteDefault" = $4,
				"accessControlPointType" = $5,
				"defaultPrivileges" = $6,
				"updatedAt" = $7,
				"authenticationFactors" = $8,
				"typedGeoLocation" = $9::jsonb
			WHERE id = $10
			`, [
            updatedAcp.name,
            updatedAcp.location,
            updatedAcp.remoteAvailable,
            updatedAcp.isRemoteDefault,
            updatedAcp.accessControlPointType,
            updatedAcp.defaultPrivileges,
            new Date(),
            updatedAcp.authenticationFactors ? JSON.stringify(updatedAcp.authenticationFactors) : null,
            updatedAcp.typedGeoLocation,
            params.request.id,
        ]);
        let newAcpDetails = lodash_1.default.cloneDeep(oldAcpDetails);
        newAcpDetails = { ...params.request, ...newAcpDetails };
        await this.logAcpUpdate(params.organizationId, params.requestUserId, oldAcpDetails, newAcpDetails);
        return params.request.id;
    }
    async addQRCodeForAccessPoint(params) {
        const id = uuid_1.default.v4();
        const qrCodeDataResult = await params.trx.query(`SELECT "qrCodeData" FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.accessPointQRCode}`);
        const qrCodeData = qrCodeDataResult.rows.map((qr) => qr.qrCodeData);
        const { l: locale } = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId: params.organizationId, userId: params.userId, trx: params.trx });
        if (qrCodeData.includes(params.request.qrCodeData)) {
            (0, dal_access_error_1.throwDbAccessConflictErrorTr)(i18n_1.default.__({ phrase: "ERRORS.GENERAL.QRDATAALREADYINUSE", locale }), null, true);
        }
        let config;
        if (params.request.config.trigger.type === restapi_1.QrCodeTrigger.Bluetooth) {
            const data = params.request.config.trigger;
            config = {
                d: params.request.config.direction ?? restapi_1.AccessDirection.All,
                t: {
                    t: data.type,
                },
            };
        }
        else if (params.request.config.trigger.type === restapi_1.QrCodeTrigger.Remote) {
            const data = params.request.config.trigger;
            config = {
                d: params.request.config.direction ?? restapi_1.AccessDirection.All,
                t: {
                    t: data.type,
                    v: data.validateGeoLocation ?? true,
                },
            };
        }
        else if (params.request.config.trigger.type === restapi_1.QrCodeTrigger.RemoteThenBluetooth || params.request.config.trigger.type === restapi_1.QrCodeTrigger.BluetoothThenRemote) {
            const data = params.request.config.trigger;
            config = {
                d: params.request.config.direction ?? restapi_1.AccessDirection.All,
                t: {
                    t: data.type,
                    v: data.validateGeoLocation ?? true,
                    u: data.userCanChangeTrigger ?? false,
                },
            };
        }
        await params.trx.query(`INSERT INTO "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.accessPointQRCode}
				(id, "qrCodeData", "accessPointId", config) VALUES ($1, $2, $3, $4)`, [id, params.request.qrCodeData, params.request.accessPointId, config]);
        return id;
    }
    async updateQRCodeForAccessPoint(params) {
        const { rows: oldAcpConfigRows, rowCount: oldAcpRowCount } = await params.trx.query(`SELECT config, "accessPointId" FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.accessPointQRCode}
			WHERE id = $1`, [params.id]);
        if (oldAcpRowCount === 0) {
            (0, api_error_1.generateNotFoundApiError)({ message: "Data Not Found" });
        }
        let newConfig;
        if (params.request.config.trigger.type === restapi_1.QrCodeTrigger.Bluetooth) {
            const data = params.request.config.trigger;
            newConfig = {
                d: params.request.config.direction ?? restapi_1.AccessDirection.All,
                t: {
                    t: data.type,
                },
            };
        }
        else if (params.request.config.trigger.type === restapi_1.QrCodeTrigger.Remote) {
            const data = params.request.config.trigger;
            newConfig = {
                d: params.request.config.direction ?? restapi_1.AccessDirection.All,
                t: {
                    t: data.type,
                    v: data.validateGeoLocation ?? true,
                },
            };
        }
        else if (params.request.config.trigger.type === restapi_1.QrCodeTrigger.RemoteThenBluetooth || params.request.config.trigger.type === restapi_1.QrCodeTrigger.BluetoothThenRemote) {
            const data = params.request.config.trigger;
            newConfig = {
                d: params.request.config.direction ?? restapi_1.AccessDirection.All,
                t: {
                    t: data.type,
                    v: data.validateGeoLocation ?? true,
                    u: data.userCanChangeTrigger ?? false,
                },
            };
        }
        const oldConfig = oldAcpConfigRows[0];
        const updatedData = {
            d: params.request.config.direction ?? oldConfig.d,
            t: {
                t: params.request.config.trigger.type ?? oldConfig.t.t,
                u: params.request.config.trigger?.userCanChangeTrigger ??
                    oldConfig.t?.u,
                v: params.request.config.trigger?.validateGeoLocation ?? oldConfig.t?.v,
            },
        };
        await params.trx.query(`UPDATE "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.accessPointQRCode}
				SET config = $1
				WHERE id = $2`, [updatedData, params.id]);
        return oldAcpConfigRows[0].accessPointId;
    }
    async deleteQRCodeForAccessPoint(params) {
        const { rows, rowCount } = await params.trx.query(`DELETE FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.accessPointQRCode}
			WHERE id = $1 RETURNING "accessPointId"
		`, [params.id]);
        return rowCount > 0 ? rows[0].accessPointId : null;
    }
    async getQRCodeForAccessPoint(params) {
        const { rows, rowCount } = await params.trx.query(`SELECT id, "qrCodeData", "accessPointId", config FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.accessPointQRCode}
			WHERE id = $1`, [params.id]);
        if (rowCount > 0) {
            const row = rows[0];
            const config = {
                direction: row.config.d,
                trigger: {
                    type: row.config.t.t,
                    userCanChangeTrigger: row.config.t?.u,
                    validateGeoLocation: row.config.t?.v,
                },
            };
            delete row.config;
            return {
                ...row,
                config,
            };
        }
        else {
            return null;
        }
    }
    async listQRCodesForAccessPoint(params) {
        const qb = [];
        let qx = 1;
        const trxx = params.trx ?? this._pgPool;
        const qfrom = `
			FROM "${params.organizationId}".${dal_db_armon_schema_1.ArmonSchema.tableNames.accessPointQRCode}
			WHERE "accessPointId" = $${qx++}
		`;
        qb.push(params.id);
        const totalResult = await trxx.query(`SELECT count(*)::SMALLINT as c ` + qfrom, qb);
        const result = {
            pagination: {
                total: totalResult.rowCount > 0 ? totalResult.rows[0].c : 0,
                skip: params.request.pagination.skip || 0,
                take: params.request.pagination.take || 100,
            },
            items: [],
        };
        if (totalResult.rowCount === 0) {
            return result;
        }
        const q = `SELECT id, "qrCodeData", "accessPointId", config ${qfrom}
			ORDER BY "qrCodeData"
			OFFSET $${qx++}
			LIMIT $${qx++}`;
        qb.push(params.request.pagination.skip ?? 0, params.request.pagination.take || 100);
        const { rows } = await trxx.query(q, qb);
        for (const row of rows) {
            const config = {
                direction: row.config.d,
                trigger: {
                    type: row.config.t.t,
                    userCanChangeTrigger: row.config.t?.u,
                    validateGeoLocation: row.config.t?.v,
                },
            };
            delete row.config;
            result.items.push({
                ...row,
                config,
            });
        }
        return result;
    }
    async updateAccessControlPointState(organizationId, accessControlPointId, stateList) {
        await this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints)
            .where("id", accessControlPointId)
            .update({
            updatedAt: new Date(),
            states: JSON.stringify(stateList),
        });
        return Promise.resolve();
    }
    async deleteAccessControlPoint(organizationId, accessControlPointId) {
        return await this.dbClient.transaction(async (trx) => {
            let now = new Date();
            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs).where("accessControlPointId", accessControlPointId).update({
                accessControlPointId: null,
                updatedAt: now,
            });
            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).where("accessControlPointId", accessControlPointId).update({
                accessControlPointId: null,
                updatedAt: now,
            });
            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).where("accessControlPointId", accessControlPointId).update({
                accessControlPointId: null,
                updatedAt: now,
            });
            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints).where("id", accessControlPointId).update({
                deletedAt: now,
            });
            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.userFilterAccessControlPoints).where("accessControlPointId", accessControlPointId).delete();
            await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights)
                .where("accessControlPointId", accessControlPointId)
                .update({
                deletedAt: now,
            })
                .whereNull("deletedAt");
            return (await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints).where("id", accessControlPointId).first("deviceId")).deviceId;
        });
    }
    async updateAccessControlPointMapping(organizationId, accessControlPointId, request, requestUserId) {
        await this.dbClient.transaction(async (trx) => {
            let now = new Date();
            await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders)
                .whereIn("id", request.unmappedWiegandReaderIds)
                .where("accessControlPointId", accessControlPointId)
                .update({
                accessControlPointId: null,
                updatedAt: now,
            });
            await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders)
                .whereIn("id", request.unmappedWiegandReaderIds)
                .where("accessControlPointId", accessControlPointId)
                .update({
                accessControlPointId: null,
                updatedAt: now,
            });
            await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereIn("id", request.unmappedExitButtonIds.concat(request.unmappedStatusSensorIds).concat(request.unmappedCounterSensorIds))
                .where("accessControlPointId", accessControlPointId)
                .update({
                accessControlPointId: null,
                updatedAt: now,
            });
            await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                .whereIn("id", request.unmappedRelayIds)
                .where("accessControlPointId", accessControlPointId)
                .update({
                accessControlPointId: null,
                updatedAt: now,
            });
            await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.hikVisionLicencePlateCameraLanes)
                .whereIn("id", request.unmappedHikVisionLicencePlateReaderLaneId)
                .where("accessControlPointId", accessControlPointId)
                .update({
                accessControlPointId: null,
            });
            await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.impinjSpeedWayGateWayAntennas)
                .whereIn("id", request.unmappedImpinjSpeedWayGateWayAntennaId)
                .where("accessControlPointId", accessControlPointId)
                .update({
                accessControlPointId: null,
            });
            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders).whereIn("id", request.mappedWiegandReaderIds).update({
                accessControlPointId: accessControlPointId,
                updatedAt: now,
            });
            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).whereIn("id", request.mappedWiegandReaderIds).update({
                accessControlPointId: accessControlPointId,
                updatedAt: now,
            });
            await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereIn("id", request.mappedExitButtonIds.concat(request.mappedStatusSensorIds).concat(request.mappedCounterSensorIds))
                .update({
                accessControlPointId: accessControlPointId,
                updatedAt: now,
            });
            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).whereIn("id", request.mappedRelayIds).update({
                accessControlPointId: accessControlPointId,
                updatedAt: now,
            });
            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.hikVisionLicencePlateCameraLanes).whereIn("id", request.mappedHikVisionLicencePlateReaderLaneId).update({
                accessControlPointId: accessControlPointId,
            });
            await trx.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.impinjSpeedWayGateWayAntennas).whereIn("id", request.mappedImpinjSpeedWayGateWayAntennaId).update({
                accessControlPointId: accessControlPointId,
            });
        });
        const isMapping = request.mappedCounterSensorIds ||
            request.mappedExitButtonIds ||
            request.mappedHikVisionLicencePlateReaderLaneId ||
            request.mappedImpinjSpeedWayGateWayAntennaId ||
            request.mappedRelayIds ||
            request.mappedStatusSensorIds ||
            request.mappedWiegandReaderIds
            ? true
            : false;
        await dal_manager_1.dbManager.accessLog.addUserActionHistoryItem({
            oId: organizationId,
            o: requestUserId,
            u: new Date(),
            c: dal_constants_1.DalConstants.UserActionCategory.Main,
            tg: ["UpdateAccessControlPointMapping"],
            t: dal_constants_1.DalConstants.UserMainActionType.UpdateAccessControlPointMapping,
            d: {
                id: accessControlPointId,
                m: isMapping,
            },
        });
        return await this.getAccessControlPointDetailes(organizationId, accessControlPointId);
    }
    async updateRelay(organizationId, deviceId, relayId, request, requestUserId) {
        await this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays).where("id", relayId).where("deviceId", deviceId).whereNull("deletedAt").update({
            name: request.name,
            driveDuration: request.driveDuration,
            updatedAt: new Date(),
        });
        await dal_manager_1.dbManager.accessLog.addUserActionHistoryItem({
            oId: organizationId,
            o: requestUserId,
            u: new Date(),
            c: dal_constants_1.DalConstants.UserActionCategory.Main,
            tg: ["UpdateRelay"],
            t: dal_constants_1.DalConstants.UserMainActionType.UpdateRelay,
            d: {
                id: deviceId,
                sid: relayId,
            },
        });
    }
    async updateImpinjSpeedWayGateWayAntennaInfo(organizationId, deviceId, integratingDeviceId, request) {
        await this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.impinjSpeedWayGateWayAntennas).where("id", integratingDeviceId).update({
            name: request.name,
            number: request.number,
            recurrentAttemptTimeout: request.recurrentAttemptTimeout,
        });
    }
    async updateHikVisionLicensePlateCameraLaneInfo(organizationId, deviceId, integratingDeviceId, request) {
        await this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.hikVisionLicencePlateCameraLanes).where("id", integratingDeviceId).update({
            name: request.name,
            number: request.number,
            recurrentAttemptTimeout: request.recurrentAttemptTimeout,
        });
    }
    async updateStatusSensor(organizationId, deviceId, statusSensorId, request, requestUserId) {
        return this.dbClient.transaction(async (trx) => {
            let sensor = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .where("id", statusSensorId)
                .where("deviceId", deviceId)
                .whereNull("deletedAt")
                .first("settings");
            if (sensor) {
                let settings = sensor.settings;
                settings.timeOut = request.timeOut;
                await trx
                    .withSchema(organizationId)
                    .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                    .where("id", statusSensorId)
                    .where("deviceId", deviceId)
                    .whereNull("deletedAt")
                    .update({
                    updatedAt: new Date(),
                    name: request.name,
                    settings: settings,
                });
                await dal_manager_1.dbManager.accessLog.addUserActionHistoryItem({
                    oId: organizationId,
                    o: requestUserId,
                    u: new Date(),
                    c: dal_constants_1.DalConstants.UserActionCategory.Main,
                    tg: ["UpdateStatusSensor"],
                    t: dal_constants_1.DalConstants.UserMainActionType.UpdateStatusSensor,
                    d: {
                        id: deviceId,
                        sid: statusSensorId,
                    },
                });
            }
            else {
                (0, dal_access_error_1.throwDbAccessNotFoundError)("Statıs sensor is not found");
            }
        });
    }
    async updateCounterSensor(organizationId, deviceId, counterSensorId, request, requestUserId) {
        await this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
            .where("id", counterSensorId)
            .where("deviceId", deviceId)
            .whereNull("deletedAt")
            .update({
            name: request.name,
            updatedAt: new Date(),
        });
        await dal_manager_1.dbManager.accessLog.addUserActionHistoryItem({
            oId: organizationId,
            o: requestUserId,
            u: new Date(),
            c: dal_constants_1.DalConstants.UserActionCategory.Main,
            tg: ["UpdateCounterSensor"],
            t: dal_constants_1.DalConstants.UserMainActionType.UpdateCounterSensor,
            d: {
                id: deviceId,
                sid: counterSensorId,
            },
        });
    }
    async updateWiegandReader(organizationId, deviceId, wiegandReaderId, request, requestUserId) {
        await this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders)
            .where("id", wiegandReaderId)
            .where("deviceId", deviceId)
            .whereNull("deletedAt")
            .update({
            name: request.name,
            location: request.location,
            recurrentAttemptTimeout: request.recurrentAttemptTimeout,
            updatedAt: new Date(),
        });
        await this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders).where("id", wiegandReaderId).where("deviceId", deviceId).whereNull("deletedAt").update({
            name: request.name,
            location: request.location,
            recurrentAttemptTimeout: request.recurrentAttemptTimeout,
            updatedAt: new Date(),
        });
        await dal_manager_1.dbManager.accessLog.addUserActionHistoryItem({
            oId: organizationId,
            o: requestUserId,
            u: new Date(),
            c: dal_constants_1.DalConstants.UserActionCategory.Main,
            tg: ["UpdateReader"],
            t: dal_constants_1.DalConstants.UserMainActionType.UpdateReader,
            d: {
                id: deviceId,
                sid: wiegandReaderId,
            },
        });
    }
    async getAccessControlPointSummaryReport(organizationId, accessControlPointId, userId, request, hasOrganizationWideRight, jwt) {
        let accessControlPointDetailed = await this.getAccessControlPointDetailesV3(organizationId, userId, accessControlPointId);
        return await dal_manager_1.dbManager.accessLog.getAccessControlPointSummaryReport(organizationId, accessControlPointId, request, accessControlPointDetailed);
    }
    async getAccessGrantedIdentitiesForAccessControlPoint(organizationId, accessControlPointId) {
        let userOrganizationIds = (await this.dbClient
            .withSchema(organizationId)
            .from("userAccessRights as uar")
            .innerJoin("userOrganizations as uo", "uo.userId", "uar.userId")
            .whereNull("uo.deletedAt")
            .where("uo.organizationId", organizationId)
            .where("accessControlPointId", accessControlPointId)
            .where("uar.access", true)
            .whereNull("uar.deletedAt")
            .select("uo.id")).map((u) => u.id);
        let users = (await this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationProfiles)
            .whereNull("deletedAt")
            .whereIn("userOrganizationId", userOrganizationIds)
            .orderBy("name")
            .select("userId", "name", "surname", "uniqueId", "extensionFields"));
        return Promise.resolve(users.map((p) => {
            return {
                id: p.userId,
                name: p.name,
                surname: p.surname,
                uniqueId: p.uniqueId,
                extensionFields: p.extensionFields,
                organizationUnits: [],
                userGroups: [],
            };
        }));
    }
    async listUsersOnAccessPoint(organizationId, accessControlPointId) {
        let users = await dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
            let dbRes = (await trx.query(`
			SELECT	uop."uniqueId",
					uop.name,
					uop.surname
			FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" as uar 
			INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" as uo
				ON uo."userId" = uar."userId"
			INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationProfiles}" as uop
				ON uop."userOrganizationId" = uo.id
			WHERE uar."accessControlPointId"= $1
				  AND uar."deletedAt" IS NULL AND uop."deletedAt" IS NULL AND uo."deletedAt" IS NULL 
			ORDER BY uop.name
			`, [accessControlPointId])).rows;
            return dbRes;
        });
        return users;
    }
    async markRemoteAccessGrantedAccessControlPointAsFavorited(organizationId, userId, accessControlPointId, option) {
        let results = await this.dbClient
            .withSchema(organizationId)
            .from("userAccessRights")
            .where("accessControlPointId", accessControlPointId)
            .whereNull("deletedAt")
            .where("userId", userId)
            .where("access", true)
            .where("remoteAccess", true)
            .select();
        if (!results[0] || results[0] === 0) {
            throw (0, api_error_1.generateNotFoundApiError)({
                message: "Access control point that you try to mark it as favorite is not found!",
            });
        }
        await this.dbClient
            .withSchema(organizationId)
            .from("userAccessRights")
            .where("accessControlPointId", accessControlPointId)
            .whereNull("deletedAt")
            .where("userId", userId)
            .where("access", true)
            .where("remoteAccess", true)
            .update({
            markedAsFavorite: option,
        });
        return Promise.resolve();
    }
    async listAccessControlPointDetails(organizationId, accessControlPanelIds) {
        let result = [];
        await this.dbClient.transaction(async (trx) => {
            let accessControlPoints = await this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints).whereIn("id", accessControlPanelIds).select();
            let relays = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays)
                .whereNull("deletedAt")
                .whereIn("accessControlPointId", accessControlPanelIds)
                .select("id", "driveDuration", "accessControlPointId", "number", "direction", "name", "deviceId"));
            let wiegandReaders = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceWiegandReaders)
                .whereNull("deletedAt")
                .whereIn("accessControlPointId", accessControlPanelIds)
                .select("id", "name", "accessControlPointId", "location", "model", "deviceId", "direction", "dataFormat", "number", "relayId", "recurrentAttemptTimeout", "authenticationFactor"));
            let dryContactInputs = (await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs)
                .whereNull("deletedAt")
                .whereIn("accessControlPointId", accessControlPanelIds)
                .select("id", "name", "accessControlPointId", "deviceId", "number", "nc", "type", "settings"));
            let hikVisionLicencePlateCameraLanes = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.hikVisionLicencePlateCameraLanes + " as l")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations + " as de", "de.integratingDeviceId", "l.deviceId")
                .whereIn("l.accessControlPointId", accessControlPanelIds)
                .where("de.type", dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.HikVisionLicencePlateReader)
                .select("l.id", "l.name", "l.number", "l.direction");
            let impinjSpeedWayGateWayAntennas = await trx
                .withSchema(organizationId)
                .from(dal_db_armon_schema_1.ArmonSchema.tableNames.impinjSpeedWayGateWayAntennas + " as l")
                .innerJoin(dal_db_armon_schema_1.ArmonSchema.tableNames.deviceIntegrations + " as de", "de.integratingDeviceId", "l.deviceId")
                .whereIn("l.accessControlPointId", accessControlPanelIds)
                .where("de.type", dal_constants_1.DalConstants.ArmonControlPanelIntegrationType.ImpinjSpeedWayRs485)
                .select("l.id", "l.name", "l.number", "l.direction");
            for (const accessControlPointBasic of accessControlPoints) {
                result.push({
                    id: accessControlPointBasic.id,
                    name: accessControlPointBasic.name,
                    location: accessControlPointBasic.location,
                    deviceId: accessControlPointBasic.deviceId,
                    accessControlPointType: accessControlPointBasic.type,
                    remoteAvailable: accessControlPointBasic.remoteAvailable,
                    isRemoteDefault: accessControlPointBasic.isRemoteDefault,
                    authenticationFactors: accessControlPointBasic.authenticationFactors,
                    hikVisionLicencePlateReaderLanes: hikVisionLicencePlateCameraLanes,
                    impinjSpeedWayGateWayAntennas: impinjSpeedWayGateWayAntennas,
                    relays: relays
                        .filter((r) => r.accessControlPointId == accessControlPointBasic.id)
                        .map((r) => {
                        return {
                            deviceId: accessControlPointBasic.deviceId,
                            direction: r.direction,
                            driveDuration: r.driveDuration,
                            id: r.id,
                            managesTo: r.name,
                            number: r.number,
                        };
                    }),
                    wiegandReaders: wiegandReaders
                        .filter((r) => r.accessControlPointId == accessControlPointBasic.id)
                        .map((w) => {
                        return {
                            id: w.id,
                            deviceId: w.deviceId,
                            deviceRelayId: w.relayId,
                            dataFormat: w.dataFormat,
                            direction: w.direction,
                            location: w.location,
                            name: w.name,
                            readerWiegandInputNumber: w.number,
                        };
                    }),
                    exitButtons: dryContactInputs
                        .filter((r) => r.accessControlPointId == accessControlPointBasic.id)
                        .filter((d) => d.type == libEnumsV2.DryContactType.ExitButton)
                        .map((d) => {
                        return {
                            deviceId: d.deviceId,
                            id: d.id,
                            deviceRelayId: d.settings ? d.settings.relayId : null,
                            dryContactInputNumber: d.number,
                            nc: d.nc,
                        };
                    }),
                    statusSensors: dryContactInputs
                        .filter((r) => r.accessControlPointId == accessControlPointBasic.id)
                        .filter((d) => d.type == libEnumsV2.DryContactType.StatusSensor)
                        .map((d) => {
                        return {
                            deviceId: d.deviceId,
                            id: d.id,
                            deviceRelayId: d.settings ? d.settings.relayId : null,
                            timeOut: d.settings ? d.settings.timeOut : null,
                            dryContactInputNumber: d.number,
                            senseTo: d.name,
                            nc: d.nc,
                        };
                    }),
                    counterSensors: dryContactInputs
                        .filter((r) => r.accessControlPointId == accessControlPointBasic.id)
                        .filter((d) => d.type == libEnumsV2.DryContactType.CounterSensor)
                        .map((d) => {
                        return {
                            deviceId: d.deviceId,
                            id: d.id,
                            deviceRelayId: d.settings ? d.settings.relayId : null,
                            dryContactInputNumber: d.number,
                            countsTo: d.name,
                            nc: d.nc,
                        };
                    }),
                });
            }
        });
        return Promise.resolve(result);
    }
    async listAccessRightsByAccessControlPoints(organizationId, accessControlPointIds) {
        let items = await this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights)
            .whereIn("accessControlPointId", accessControlPointIds)
            .whereNull("deletedAt")
            .select("accessControlPointId as id", "access", "read", "config", "grant", "remoteAccess", "userId", "snapshot");
        return Promise.resolve(items.map((i) => {
            return {
                id: i.id,
                userId: i.userId,
                userAccessRights: {
                    read: i.read,
                    grant: i.grant,
                    config: i.config,
                    remoteAccess: i.remoteAccess,
                    access: i.access,
                    snapshot: i.snapshot,
                },
            };
        }));
    }
    async listUserAccessRights(organizationId, userId) {
        let items = await this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights)
            .where("userId", userId)
            .whereNull("deletedAt")
            .select("accessControlPointId", "access", "read", "config", "grant", "remoteAccess", "snapshot");
        return Promise.resolve(items.map((i) => {
            return {
                accessControlPointId: i.id,
                userAccessRights: {
                    read: i.read,
                    grant: i.grant,
                    config: i.config,
                    remoteAccess: i.remoteAccess,
                    access: i.access,
                    snapshot: i.snapshot,
                },
            };
        }));
    }
    async listPrivilegedUsersForAccessControlPoint(organizationId, accessControlPointId, args) {
        let result = {
            take: args.take,
            skip: args.skip,
            total: 0,
            users: [],
        };
        let queryParamIndex = 1;
        let queryParams = [];
        let query = `SELECT uar."userId", uar."accessControlPointId", uar.access, uar.read, uar.config, uar.grant, uar."remoteAccess", uar.snapshot 
        FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" uar
        INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" uo
        ON uar."userId" = uo."userId"
        WHERE "accessControlPointId" = $${queryParamIndex++}
        AND uo."organizationId" = $${queryParamIndex++}
        AND uar."deletedAt" IS NULL
        AND uo."deletedAt" IS NULL
        AND uo."isDisabled" IS False`;
        queryParams.push(accessControlPointId, organizationId);
        if (args.read) {
            query += `
        AND uar.read = $${queryParamIndex++} `;
            queryParams.push(true);
        }
        if (args.config) {
            query += `
        AND uar.config = $${queryParamIndex++} `;
            queryParams.push(true);
        }
        if (args.grant) {
            query += `
        AND uar.grant = $${queryParamIndex++} `;
            queryParams.push(true);
        }
        if (args.snapshot) {
            query += `
        AND uar.snapshot = $${queryParamIndex++} `;
            queryParams.push(true);
        }
        if (args.remoteAccess) {
            query += `
        AND uar.remoteAccess = $${queryParamIndex++} `;
            queryParams.push(true);
        }
        result.total = parseInt((await this._pgPool.query("SELECT COUNT(*) FROM (" + query + ")q1", queryParams)).rows[0].count);
        if (args.skip) {
            query += `
        OFFSET $${queryParamIndex++} `;
            queryParams.push(args.skip);
        }
        if (args.take) {
            query += `
        LIMIT $${queryParamIndex++} `;
            queryParams.push(args.take);
        }
        let items = (await this._pgPool.query(query, queryParams)).rows;
        let userIds = items.map((u) => u.userId);
        let userCaptions = await dal_manager_1.dbManager.accessUser.getUserOrganizationCaptionLines(organizationId, userIds);
        let userInfoList = await dal_manager_1.dbManager.accessUser.getBasicUserInfoList(organizationId, userIds);
        for (const item of items) {
            let userInfo = userInfoList.find((u) => u.id == item.userId);
            let captions = userCaptions.find((u) => u.id == item.userId);
            result.users.push({
                id: item.userId,
                fullname: userInfo ? userInfo.fullname : "",
                userCaptions: captions ? captions.captionLines : [],
                privilege: {
                    access: item.access,
                    read: item.read,
                    grant: item.grant,
                    config: item.config,
                    remoteAccess: item.remoteAccess,
                    snapshot: item.snapshot,
                },
            });
        }
        return Promise.resolve(result);
    }
    async listUserAccessRightsWithPagination(organizationId, userId, pagination, accessControlPointIds) {
        let result = {
            paginationResponse: {
                take: pagination.take,
                skip: pagination.skip,
                total: 0,
            },
            items: [],
        };
        let qb = this.dbClient.withSchema(organizationId).from(dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints).where("organizationId", organizationId).whereNull("deletedAt");
        if (accessControlPointIds && accessControlPointIds.length > 0) {
            qb.whereIn("id", accessControlPointIds);
        }
        result.paginationResponse.total = parseInt((await qb.clone().first().count()).count);
        if (pagination.skip) {
            qb.offset(pagination.skip);
        }
        if (pagination.take) {
            qb.limit(pagination.take);
        }
        let items = await qb.select("id", "name").orderBy("name");
        let userRights = await this.dbClient
            .withSchema(organizationId)
            .from(dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights)
            .where("userId", userId)
            .whereNull("deletedAt")
            .select("accessControlPointId", "access", "read", "config", "grant", "remoteAccess", "snapshot");
        for (const item of items) {
            let userRight = userRights.find((u) => u.accessControlPointId == item.id);
            if (userRight) {
                result.items.push({
                    id: item.id,
                    name: item.name,
                    privilege: {
                        read: userRight.read,
                        grant: userRight.grant,
                        config: userRight.config,
                        remoteAccess: userRight.remoteAccess,
                        access: userRight.access,
                        snapshot: userRight.snapshot,
                    },
                });
            }
            else {
                result.items.push({
                    id: item.id,
                    name: item.name,
                    privilege: {
                        read: false,
                        grant: false,
                        config: false,
                        remoteAccess: false,
                        access: false,
                        snapshot: false,
                    },
                });
            }
        }
        return Promise.resolve(result);
    }
    async listAccessControlPointDetailesV3(organizationId, userId, accessControlPointIds, trx) {
        let queryParams = [];
        let queryParamIndex = 0;
        let query = `

        SELECT acp.id,
            acp.name,
            acp.location,
            acp."deviceId",
                acp."accessControlPointType",
                    acp."remoteAvailable",
                        acp."isRemoteDefault",
                            acp."authenticationFactors",
                                acp."defaultPrivileges",
                                    acp."deviceId",
                                        acp."states",
                                            COALESCE(rel.relays, '[]') AS relays,
                                                COALESCE(rdrs.readers, '[]') AS readers,
                                                    json_agg(json_build_object(
                                                        'access', uar.access,
                                                        'read', uar."read",
                                                        'config', uar."config",
                                                        'grant', uar."grant",
                                                        'remoteAccess', uar."remoteAccess"
                                                    )) AS "userRights",
                                                        COALESCE(dry_exit."exitButtons", '[]') AS "exitButtons",
                                                            COALESCE(dry_status."statusSensors", '[]') AS "statusSensors",
                                                                COALESCE(dry_counter."counterSensors", '[]') AS "counterSensors",
                                                                    COALESCE(cams."cameras", '[]') AS "cameraInfo"
        FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}" AS acp
        INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}" AS uar
        ON uar."accessControlPointId" = acp.id
        LEFT JOIN(
            SELECT "accessControlPointId", jsonb_agg(jsonb_build_object(
                'id', id,
                'driveDuration', "driveDuration",
                'accessControlPointId', "accessControlPointId",
                'number', "number",
                'direction', "direction",
                'managesTo', "name"
            )) AS relays
                    FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceRelays}"
                    WHERE "deletedAt" IS NULL
                    GROUP BY 1
        ) rel  on(rel."accessControlPointId" = acp.id)
        LEFT JOIN LATERAL(
            SELECT "accessControlPointId", jsonb_agg(jsonb_build_object(
                'id', id,
                'name', "name",
                'accessControlPointId', "accessControlPointId",
                'location', "location",
                'model', "model",
                'deviceId', "deviceId",
                'direction', "direction",
                'dataFormat', "dataFormat",
                'number', "number",
                'deviceRelayId', "relayId",
                'recurrentAttemptTimeout', "recurrentAttemptTimeout",
                'credentialType', "credentialType",
                'readerOutputType', "readerOutputType"
            )) as readers
                    FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceReaders}"
                    WHERE "deletedAt" IS NULL
                    GROUP BY 1
        ) rdrs on(rdrs."accessControlPointId" = acp.id)
        LEFT JOIN LATERAL(
            SELECT "accessControlPointId", jsonb_agg(jsonb_build_object(
                'deviceId', "deviceId",
                'id', "id",
                'deviceRelayId', ("settings") ->> 'relayId',
                'dryContactInputNumber', "number",
                'nc', "nc"
            )) as "exitButtons"
                    FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs}"
                    WHERE type = ${libEnumsV2.DryContactType.ExitButton}
                    AND "deletedAt" IS NULL
                    GROUP BY 1
        ) dry_exit on(dry_exit."accessControlPointId" = acp.id)
        LEFT JOIN LATERAL(
            SELECT "accessControlPointId", jsonb_agg(jsonb_build_object(
                'deviceId', "deviceId",
                'id', "id",
                'deviceRelayId', ("settings") ->> 'relayId',
                'timeOut', ("settings") ->> 'timeOut',
                'dryContactInputNumber', "number",
                'senseTo', "name",
                'nc', "nc"
            )) as "statusSensors"
                    FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs}"
                    WHERE type = ${libEnumsV2.DryContactType.StatusSensor}
                    AND "deletedAt" IS NULL
                    GROUP BY 1
        ) dry_status on(dry_status."accessControlPointId" = acp.id)
        LEFT JOIN LATERAL(
            SELECT "accessControlPointId", jsonb_agg(jsonb_build_object(
                'deviceId', "deviceId",
                'id', "id",
                'deviceRelayId', ("settings") ->> 'relayId',
                'dryContactInputNumber', "number",
                'countsTo', name,
                'nc', "nc"
            )) as "counterSensors"
                    FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.deviceDryContactInputs}"
                    WHERE type = ${libEnumsV2.DryContactType.CounterSensor}
                    AND "deletedAt" IS NULL
                    GROUP BY 1
        ) dry_counter on(dry_counter."accessControlPointId" = acp.id)
        LEFT JOIN LATERAL(
            SELECT ca."accessControlPointId", jsonb_agg(jsonb_build_object(
                'id', c.id,
                'organizationId', c."organizationId",
                'name', c."name",
                'userName', c."userName",
                'password', c."password",
                'streamUrl', c."streamUrl",
                'proxyUrl', c."proxyUrl",
                'snapshotUrl', c."snapshotUrl"
            )) as "cameras"
                    FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.cameras}" AS c
                    INNER JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.cameraActions}" AS ca ON ca."cameraId" = c.id
                    WHERE ca.type = ${dal_constants_1.DalConstants.CameraActionType.View}
                    AND c. "deletedAt" IS NULL
                    GROUP BY 1
        ) cams on(cams."accessControlPointId" = acp.id)
        WHERE uar."deletedAt" IS NULL
        AND uar.read = TRUE
        AND uar."userId" = $${++queryParamIndex}
        AND acp."organizationId" = $${++queryParamIndex} `;
        queryParams.push(userId, organizationId);
        if (accessControlPointIds && accessControlPointIds.length > 0) {
            query += `
        AND acp.id = ANY($${++queryParamIndex}:: UUID[])
                `;
            queryParams.push(accessControlPointIds);
        }
        query += `
GROUP BY acp.id, rel.relays, rdrs.readers, dry_exit."exitButtons", dry_status."statusSensors", dry_counter."counterSensors", cams."cameras"
    `;
        let result = [];
        if (trx) {
            result = (await trx.query(query, queryParams)).rows;
        }
        else {
            result = await dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
                let dbRes = (await trx.query(query, queryParams)).rows;
                return dbRes;
            });
        }
        return result;
    }
    async getAcpIdsUserHasAccessRight(organizationId, userId, rights) {
        let queryParamIndex = 1;
        let queryParams = [];
        let query = `SELECT "accessControlPointId" FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userAccessRights}"
					WHERE "userId" = $${queryParamIndex++}
					AND "deletedAt" IS NULL`;
        queryParams.push(userId);
        if (rights.read) {
            query += `
			AND read = $${queryParamIndex++} `;
            queryParams.push(rights.read);
        }
        if (rights.access) {
            query += `
			AND access = $${queryParamIndex++} `;
            queryParams.push(rights.access);
        }
        if (rights.config) {
            query += `
			AND config = $${queryParamIndex++} `;
            queryParams.push(rights.config);
        }
        if (rights.grant) {
            query += `
			AND grant = $${queryParamIndex++} `;
            queryParams.push(rights.grant);
        }
        if (rights.remoteAccess) {
            query += `
			AND "remoteAccess" = $${queryParamIndex++} `;
            queryParams.push(rights.remoteAccess);
        }
        const { rows } = await this._pgPool.query(query, queryParams);
        return rows.map((i) => i.accessControlPointId);
    }
    async mobileAccessReadCard(organizationId, credentialData, accessControlPointId) {
        let { userId, fullName } = await dal_manager_1.dbManager.accessUser.getUserInfoByCredentialData({ organizationId, credentialData });
        let acpList = await this.getUserAccessControlPointRights(organizationId, userId);
        let AccessControlPointRights = acpList.filter((acp) => acp.accessControlPointId === accessControlPointId);
        if (!AccessControlPointRights || !AccessControlPointRights[0].access) {
            return null;
        }
        return {
            fullname: fullName,
            userId: userId,
            userCaption: await dal_manager_1.dbManager.accessUser.getSingleUserOrganizationCaptionLines(organizationId, userId),
        };
    }
    async getAllAccessControlPointsRedisPersistentData(params) {
        const query = `
		SELECT id, name as n FROM "${params.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}"
		WHERE "deletedAt" IS NULL
	`;
        const trxx = params.trx ?? (await this._pgPool.connect());
        const cursor = trxx.query(new Cursor(query));
        let rows = [];
        while (true) {
            try {
                rows = await new Promise((resolve, reject) => {
                    cursor.read(100, async (err, r) => {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve(r);
                        }
                    });
                });
                await params.onData(rows);
            }
            catch (error) {
                app_logs_1.logger.error("Error while fetching access point cache data with cursor!");
            }
            if (rows.length < 100) {
                break;
            }
        }
        try {
            await new Promise((resolve, reject) => {
                cursor.close((err) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve();
                    }
                });
            });
            if (!params.trx) {
                trxx.release();
            }
        }
        catch (error) {
            if (!params.trx) {
                trxx?.release(error);
            }
            app_logs_1.logger.error(error);
        }
    }
}
exports.PSQLDalAccessAccessControlPoint = PSQLDalAccessAccessControlPoint;
