"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throwProxyAuthRequiredErrorTr = exports.throwInternalErrorTr = exports.throwReportNotificationErrorTr = exports.throwReportTimeoutErrorTr = exports.DbAccessErrorTr = exports.throwDbResourceExpiredError = exports.throwDbAccessConflictErrorTr = exports.throwDbAccessConflictError = exports.throwDbAccessBadRequestErrorTr = exports.throwDbAccessBadRequestError = exports.throwDbAccessNotFoundErrorTr = exports.throwDbAccessNotFoundError = exports.throwDbAccessUnauthorizedErrorTr = exports.throwDbAccessUnauthorizedError = exports.throwDbAccessAuthorizationErrorTr = exports.throwDbAccessAuthorizationError = exports.DbAccessError = exports.DbAccessErrorCode = void 0;
var DbAccessErrorCode;
(function (DbAccessErrorCode) {
    DbAccessErrorCode[DbAccessErrorCode["BAD_REQUEST"] = 400] = "BAD_REQUEST";
    DbAccessErrorCode[DbAccessErrorCode["UNAUTHORIZATION_ERROR"] = 401] = "UNAUTHORIZATION_ERROR";
    DbAccessErrorCode[DbAccessErrorCode["PAYMENT_REQUIRED"] = 402] = "PAYMENT_REQUIRED";
    DbAccessErrorCode[DbAccessErrorCode["AUTHORIZATION_ERROR"] = 403] = "AUTHORIZATION_ERROR";
    DbAccessErrorCode[DbAccessErrorCode["NOT_FOUND"] = 404] = "NOT_FOUND";
    DbAccessErrorCode[DbAccessErrorCode["PROXY_AUTHENTICATION_REQUIRED"] = 407] = "PROXY_AUTHENTICATION_REQUIRED";
    DbAccessErrorCode[DbAccessErrorCode["EXPIRED"] = 408] = "EXPIRED";
    DbAccessErrorCode[DbAccessErrorCode["CONFLICT"] = 409] = "CONFLICT";
    DbAccessErrorCode[DbAccessErrorCode["INTERNAL_ERROR"] = 500] = "INTERNAL_ERROR";
    DbAccessErrorCode[DbAccessErrorCode["SERVICE_UNAVAILABLE"] = 503] = "SERVICE_UNAVAILABLE";
    DbAccessErrorCode[DbAccessErrorCode["ARMON_REPORT_WILL_BE_SENT_BY_NOTIFICATION"] = 826] = "ARMON_REPORT_WILL_BE_SENT_BY_NOTIFICATION";
})(DbAccessErrorCode = exports.DbAccessErrorCode || (exports.DbAccessErrorCode = {}));
class DbAccessError extends Error {
}
exports.DbAccessError = DbAccessError;
function throwDbAccessAuthorizationError(message) {
    let error = new DbAccessError(message);
    error.errorCode = DbAccessErrorCode.AUTHORIZATION_ERROR;
    throw error;
}
exports.throwDbAccessAuthorizationError = throwDbAccessAuthorizationError;
function throwDbAccessAuthorizationErrorTr(phrase, replacements, noReport) {
    let error = new DbAccessErrorTr(phrase, replacements);
    error.errorCode = DbAccessErrorCode.NOT_FOUND;
    error.noReport = !noReport ? true : false;
    throw error;
}
exports.throwDbAccessAuthorizationErrorTr = throwDbAccessAuthorizationErrorTr;
function throwDbAccessUnauthorizedError(message) {
    let error = new DbAccessError(message);
    error.errorCode = DbAccessErrorCode.UNAUTHORIZATION_ERROR;
    throw error;
}
exports.throwDbAccessUnauthorizedError = throwDbAccessUnauthorizedError;
function throwDbAccessUnauthorizedErrorTr(phrase, replacements, noReport) {
    let error = new DbAccessErrorTr(phrase, replacements);
    error.errorCode = DbAccessErrorCode.UNAUTHORIZATION_ERROR;
    error.noReport = !noReport ? true : false;
    throw error;
}
exports.throwDbAccessUnauthorizedErrorTr = throwDbAccessUnauthorizedErrorTr;
function throwDbAccessNotFoundError(message) {
    let error = new DbAccessError(message);
    error.errorCode = DbAccessErrorCode.NOT_FOUND;
    throw error;
}
exports.throwDbAccessNotFoundError = throwDbAccessNotFoundError;
function throwDbAccessNotFoundErrorTr(phrase, replacements, noReport) {
    let error = new DbAccessErrorTr(phrase, replacements);
    error.errorCode = DbAccessErrorCode.NOT_FOUND;
    error.noReport = !noReport ? true : false;
    throw error;
}
exports.throwDbAccessNotFoundErrorTr = throwDbAccessNotFoundErrorTr;
function throwDbAccessBadRequestError(message) {
    let error = new DbAccessError(message);
    error.errorCode = DbAccessErrorCode.BAD_REQUEST;
    throw error;
}
exports.throwDbAccessBadRequestError = throwDbAccessBadRequestError;
function throwDbAccessBadRequestErrorTr(phrase, replacements, noReport, showAsModal) {
    const error = new DbAccessErrorTr(phrase, replacements);
    error.errorCode = DbAccessErrorCode.BAD_REQUEST;
    error.noReport = !noReport ? true : false;
    error.showAsModal = showAsModal ?? false;
    throw error;
}
exports.throwDbAccessBadRequestErrorTr = throwDbAccessBadRequestErrorTr;
function throwDbAccessConflictError(message) {
    let error = new DbAccessError(message);
    error.errorCode = DbAccessErrorCode.CONFLICT;
    throw error;
}
exports.throwDbAccessConflictError = throwDbAccessConflictError;
function throwDbAccessConflictErrorTr(phrase, replacements, noReport) {
    let error = new DbAccessErrorTr(phrase, replacements);
    error.errorCode = DbAccessErrorCode.CONFLICT;
    error.noReport = !noReport ? true : false;
    throw error;
}
exports.throwDbAccessConflictErrorTr = throwDbAccessConflictErrorTr;
function throwDbResourceExpiredError(message) {
    let error = new DbAccessError(message);
    error.errorCode = DbAccessErrorCode.EXPIRED;
    throw error;
}
exports.throwDbResourceExpiredError = throwDbResourceExpiredError;
class DbAccessErrorTr extends DbAccessError {
    constructor(phrase, replacements, noReport, showAsModal) {
        super("");
        this.phrase = phrase;
        this.replacements = replacements;
        this.noReport = noReport;
        this.showAsModal = showAsModal ?? false;
    }
}
exports.DbAccessErrorTr = DbAccessErrorTr;
function throwReportTimeoutErrorTr() {
    let error = new DbAccessErrorTr("ERRORS.REPORT.TIMEOUT");
    error.errorCode = DbAccessErrorCode.SERVICE_UNAVAILABLE;
    error.noReport = false;
    throw error;
}
exports.throwReportTimeoutErrorTr = throwReportTimeoutErrorTr;
function throwReportNotificationErrorTr() {
    let error = new DbAccessErrorTr("ERRORS.REPORT.NOTIFICATION");
    error.errorCode = DbAccessErrorCode.ARMON_REPORT_WILL_BE_SENT_BY_NOTIFICATION;
    error.noReport = false;
    throw error;
}
exports.throwReportNotificationErrorTr = throwReportNotificationErrorTr;
function throwInternalErrorTr() {
    let error = new DbAccessErrorTr("ERRORS.INTERNAL");
    error.errorCode = DbAccessErrorCode.INTERNAL_ERROR;
    error.noReport = false;
    throw error;
}
exports.throwInternalErrorTr = throwInternalErrorTr;
function throwProxyAuthRequiredErrorTr(phrase, replacements) {
    let error = new DbAccessErrorTr(phrase, replacements);
    error.errorCode = DbAccessErrorCode.PROXY_AUTHENTICATION_REQUIRED;
    error.noReport = true;
    throw error;
}
exports.throwProxyAuthRequiredErrorTr = throwProxyAuthRequiredErrorTr;
