"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const elastic_apm_node_1 = __importDefault(require("elastic-apm-node"));
if (process.env.ELASTIC_APM_SERVER_URL &&
    process.env.ELASTIC_APM_SECRET_TOKEN &&
    process.env.ELASTIC_APM_PREFIX &&
    ((process.env.ELASTIC_APM_VERIFY_SERVER_CERT === "true" && process.env.ELASTIC_APM_SERVER_CA_CERT_FILE) || process.env.ELASTIC_APM_VERIFY_SERVER_CERT === "false")) {
    elastic_apm_node_1.default.start({
        serviceName: `${process.env.ELASTIC_APM_PREFIX}-tablet`,
        serverUrl: process.env.ELASTIC_APM_SERVER_URL,
        secretToken: process.env.ELASTIC_APM_SECRET_TOKEN,
        environment: "production",
        serverCaCertFile: process.env.ELASTIC_APM_SERVER_CA_CERT_FILE ?? null,
        verifyServerCert: process.env.ELASTIC_APM_VERIFY_SERVER_CERT === "true",
    });
}
else {
    console.warn(`Elastic APM is not enabled. Please set ELASTIC_APM_SERVER_URL, ELASTIC_APM_SECRET_TOKEN, ELASTIC_APM_PREFIX, ELASTIC_APM_VERIFY_SERVER_CERT, and ELASTIC_APM_SERVER_CA_CERT_FILE environment variables.`);
}
const tablet_config_1 = __importDefault(require("./tablet.config"));
const app_logs_1 = require("../../app.logs");
const express_1 = __importDefault(require("express"));
const fs_1 = __importDefault(require("fs"));
const http_1 = __importDefault(require("http"));
const https_1 = __importDefault(require("https"));
const app_config_1 = require("../../app.config");
const app_constants_1 = require("../../app.constants");
const dal_access_cache_client_1 = __importDefault(require("../../dal/access/redis/dal.access.cache.client"));
const dal_access_cache_redis_1 = require("../../dal/access/redis/dal.access.cache.redis");
const express_body_parser_error_handler_1 = __importDefault(require("express-body-parser-error-handler"));
const tablet_config_2 = __importDefault(require("./tablet.config"));
const controller_v1_1 = require("./controller.v1");
const dal_manager_1 = require("../../dal/dal.manager");
class TabletApp {
    constructor() { }
    async start() {
        try {
            app_config_1.appConfig.init(app_constants_1.ServiceNames.Tablet);
            app_logs_1.appLogger.init(tablet_config_2.default.LOG_DIRECTORY);
            await dal_manager_1.dbManager.init({
                environment: app_config_1.appConfig.nodeEnv,
                log: app_config_1.appConfig.db.log,
                logDirectory: app_config_1.appConfig.dbLogDirectory,
                main: app_config_1.appConfig.db.main,
                redis: app_config_1.appConfig.db.redis,
            }, true, false, false, false);
            this.pool = dal_manager_1.dbManager.poolMain;
            this.redisCache = new dal_access_cache_redis_1.RedisCache(await dal_access_cache_client_1.default.connect({
                url: `redis://${app_config_1.appConfig.db.redis.host}:${app_config_1.appConfig.db.redis.port}`,
            }));
            this.expressApp = (0, express_1.default)();
            this.expressApp.use(express_1.default.json({ limit: "100mb" }));
            this.expressApp.use((0, express_body_parser_error_handler_1.default)({
                errorMessage(err) {
                    return `Invalid JSON value at request, please check request body`;
                },
            }));
            if (tablet_config_1.default.HTTP_PROTOCOL === "https" && app_config_1.appConfig.httpServer.ssl?.keyFileName && app_config_1.appConfig.httpServer.ssl?.certFileName) {
                this.server = https_1.default.createServer({
                    key: fs_1.default.readFileSync(app_config_1.appConfig.httpServer.ssl?.keyFileName, "utf8"),
                    cert: fs_1.default.readFileSync(app_config_1.appConfig.httpServer.ssl?.certFileName, "utf8"),
                }, this.expressApp);
            }
            else {
                this.server = http_1.default.createServer(this.expressApp);
            }
            this.server.listen(tablet_config_1.default.TABLET_HTTP_PORT);
            app_logs_1.logger.info("tablet server started listening on port " + tablet_config_1.default.TABLET_HTTP_PORT + " with protocol " + tablet_config_1.default.HTTP_PROTOCOL);
            new controller_v1_1.TabletConrollerV1(this.expressApp);
        }
        catch (error) {
            app_logs_1.logger.error(error || error.message);
            process.exit(1);
        }
    }
}
const app = new TabletApp();
app.start();
