"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setScheduledJobMemoryCache = exports.prepareScheduledJobsMemoryCache = exports.scheduledJobsMemoryCache = void 0;
const app_logs_1 = require("../../../app.logs");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_utils_1 = require("../../../dal/dal.utils");
const messageBroker_server_to_server_pub_1 = require("../../../messageBroker/messageBroker.server-to-server.pub");
exports.scheduledJobsMemoryCache = {};
const MAX_DELAY_AMOUNT = Math.pow(2, 31) - 1;
const prepareScheduledJobsMemoryCache = async () => {
    const onScheduledJobData = async (jobs) => {
        for (const job of jobs) {
            (0, exports.setScheduledJobMemoryCache)(job);
        }
    };
    await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        return dal_manager_1.dbManager.accessSystem.getScheduledJobsCursor({ trx, onData: onScheduledJobData });
    });
};
exports.prepareScheduledJobsMemoryCache = prepareScheduledJobsMemoryCache;
const setScheduledJobMemoryCache = (job) => {
    const nextExecutionDate = (0, dal_utils_1.calculateNextExecutionDateOfScheduledJob)(job.interval, job.firstExecutionDate);
    const delayAmount = nextExecutionDate.getTime() - new Date().getTime();
    if (delayAmount > MAX_DELAY_AMOUNT) {
        setTimeout(() => {
            (0, exports.setScheduledJobMemoryCache)(job);
        }, MAX_DELAY_AMOUNT);
        return;
    }
    exports.scheduledJobsMemoryCache[job.id] = setTimeout(() => {
        const now = new Date();
        if (now < job.nextExecutionDate) {
            (0, exports.setScheduledJobMemoryCache)(job);
            app_logs_1.logger.debug(`Scheduled job ${job.id} tries to run before schedule, delaying the scheduled job for ${job.nextExecutionDate.getTime() - now.getTime()} ms!!!!!`);
        }
        else {
            messageBroker_server_to_server_pub_1.amqpServerToServerPub.sendToScheduledJobQueue({
                i: job.id,
                a: job.interval,
                f: job.firstExecutionDate,
            });
        }
    }, delayAmount);
};
exports.setScheduledJobMemoryCache = setScheduledJobMemoryCache;
