"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.listenPg = void 0;
const app_logs_1 = require("../../../app.logs");
const dal_manager_1 = require("../../../dal/dal.manager");
const messageBroker_server_to_app_pub_1 = require("../../../messageBroker/messageBroker.server-to-app.pub");
const messageBroker_server_to_app_sub_1 = require("../../../messageBroker/messageBroker.server-to-app.sub");
const ws_usernsp_1 = require("../../../ws/ws.usernsp");
const schedule_1 = require("./schedule");
const dal_utils_1 = require("../../../dal/dal.utils");
const listenPg = async () => {
    const client = await (0, dal_utils_1.listenClientWrapperWithRetry)("PG-RABBIT", dal_manager_1.dbManager.poolMain);
    client.on("notification", async (msg) => {
        switch (msg.channel) {
            case "scheduled_job_upsert":
                {
                    const scheduledJobIb = msg.payload;
                    const job = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                        return dal_manager_1.dbManager.accessSystem.getScheduledJob({ id: scheduledJobIb, trx });
                    });
                    clearTimeout(schedule_1.scheduledJobsMemoryCache[job.id]);
                    (0, schedule_1.setScheduledJobMemoryCache)(job);
                }
                break;
            case "webrtc_ice_servers":
                {
                    const data = JSON.parse(msg.payload);
                    const organizationSettings = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                        return dal_manager_1.dbManager.accessOrganization.getOrganizationSettings({ organizationId: data.id, trx });
                    });
                    messageBroker_server_to_app_pub_1.amqpServerToAppPub.sendToExchange(data.id + "." + ws_usernsp_1.room.systemStatus + ".*", {
                        e: messageBroker_server_to_app_sub_1.amqpServerToAppSubUserEventNames.organizationSettingsChanged,
                        p: {},
                    });
                    messageBroker_server_to_app_pub_1.amqpServerToAppPub.sendToExchange(`${data.id}`, {
                        e: messageBroker_server_to_app_sub_1.amqpServerToAppSubUserEventNames.webRTCIceServers,
                        p: organizationSettings.webRtc,
                    });
                }
                break;
            default:
                return;
        }
    });
    client.on("error", (err) => {
        app_logs_1.logger.error("LISTEN PG-RABBIT connections error: " + err);
    });
    client.on("end", () => {
        app_logs_1.logger.info("LISTEN PG-RABBIT connections terminated... Restarting...");
        client.release();
        (0, exports.listenPg)();
    });
    await client.query("LISTEN scheduled_job_upsert");
    await client.query("LISTEN webrtc_ice_servers");
    app_logs_1.logger.info("LISTEN PG-RABBIT connections started.");
};
exports.listenPg = listenPg;
