"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const elastic_apm_node_1 = __importDefault(require("elastic-apm-node"));
if (process.env.ELASTIC_APM_SERVER_URL &&
    process.env.ELASTIC_APM_SECRET_TOKEN &&
    process.env.ELASTIC_APM_PREFIX &&
    ((process.env.ELASTIC_APM_VERIFY_SERVER_CERT === "true" && process.env.ELASTIC_APM_SERVER_CA_CERT_FILE) || process.env.ELASTIC_APM_VERIFY_SERVER_CERT === "false")) {
    elastic_apm_node_1.default.start({
        serviceName: `${process.env.ELASTIC_APM_PREFIX}-pgrabbit`,
        serverUrl: process.env.ELASTIC_APM_SERVER_URL,
        secretToken: process.env.ELASTIC_APM_SECRET_TOKEN,
        environment: "production",
        serverCaCertFile: process.env.ELASTIC_APM_SERVER_CA_CERT_FILE ?? null,
        verifyServerCert: process.env.ELASTIC_APM_VERIFY_SERVER_CERT === "true",
    });
}
else {
    console.warn(`Elastic APM is not enabled. Please set ELASTIC_APM_SERVER_URL, ELASTIC_APM_SECRET_TOKEN, ELASTIC_APM_PREFIX, ELASTIC_APM_VERIFY_SERVER_CERT, and ELASTIC_APM_SERVER_CA_CERT_FILE environment variables.`);
}
const app_config_1 = require("../../app.config");
const app_constants_1 = require("../../app.constants");
const app_logs_1 = require("../../app.logs");
const dal_manager_1 = require("../../dal/dal.manager");
const messageBroker_manager_1 = require("../../messageBroker/messageBroker.manager");
const listen_pg_1 = require("./services/listen-pg");
const schedule_1 = require("./services/schedule");
async function start() {
    try {
        app_config_1.appConfig.init(app_constants_1.ServiceNames.PGRabbitService);
        app_logs_1.appLogger.init(app_config_1.appConfig.appLogDirectory);
        app_logs_1.logger.info("DBs are initializing...");
        await dal_manager_1.dbManager.init({
            main: app_config_1.appConfig.db.main,
            log: app_config_1.appConfig.db.log,
            environment: app_config_1.appConfig.nodeEnv,
            logDirectory: app_config_1.appConfig.dbLogDirectory,
            redis: app_config_1.appConfig.db.redis,
            targetMigration: null,
        }, false, false, false, false);
        app_logs_1.logger.info("Rabbitmq is initializing...");
        await messageBroker_manager_1.messageBrokerManager.initForPgRabbitService();
        await (0, schedule_1.prepareScheduledJobsMemoryCache)();
        await (0, listen_pg_1.listenPg)();
        app_logs_1.logger.info("armon-pgrabbit started");
    }
    catch (error) {
        app_logs_1.logger.error(error || error.message);
        process.exit(1);
    }
}
start();
