"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const joi_1 = __importDefault(require("joi"));
const processors_1 = require("xml2js/lib/processors");
const utils_1 = require("../../lib/v8/utils");
const cliConfigFileSchema = joi_1.default.object({
    ...utils_1.baseConfigJoi,
    ...{
        PGAPPNAME: joi_1.default.custom((value) => {
            process.env.PGAPPNAME = value;
            return value;
        }).default(() => {
            process.env.PGAPPNAME = "monitor_application";
            return process.env.PGAPPNAME;
        }),
        SMTP_API_KEY: joi_1.default.string().max(1023).optional(),
        SMTP_API_SECRET: joi_1.default.string().max(1023).optional(),
        SMTP_HOST: joi_1.default.custom((value) => {
            const error = joi_1.default.string().domain().validate(value).error;
            if (error) {
                throw error;
            }
            process.env.SMTP_HOST = value;
            return value;
        }).optional(),
        SMTP_PORT: joi_1.default.custom((value) => {
            const smtpPort = parseInt(value);
            const error = joi_1.default.number().port().validate(smtpPort).error;
            if (error) {
                throw error;
            }
            process.env.SMTP_HOST = value;
            return smtpPort;
        }).optional(),
        SMTP_REQUIRE_TLS: joi_1.default.custom((value) => {
            const smtpRequireTls = (0, processors_1.parseBooleans)(value);
            const error = joi_1.default.boolean().validate(smtpRequireTls).error;
            if (error) {
                throw error;
            }
            process.env.SMTP_HOST = value;
            return smtpRequireTls;
        }).optional(),
        SMTP_SECURE: joi_1.default.custom((value) => {
            const smtpSecure = (0, processors_1.parseBooleans)(value);
            const error = joi_1.default.boolean().validate(smtpSecure).error;
            if (error) {
                throw error;
            }
            process.env.SMTP_SECURE = value;
            return smtpSecure;
        }).optional(),
        SMTP_AUTH_USER: joi_1.default.custom((value) => {
            const error = joi_1.default.string().max(255).validate(value).error;
            if (error) {
                throw error;
            }
            process.env.SMTP_AUTH_USER = value;
            return value;
        }).optional(),
        SMTP_AUTH_PASS: joi_1.default.custom((value) => {
            const error = joi_1.default.string().max(127).validate(value).error;
            if (error) {
                throw error;
            }
            process.env.SMTP_AUTH_PASS = value;
            return value;
        }).optional(),
        SMTP_CLIENT_TLS_REJECT_UNAUTHORIZED: joi_1.default.custom((value) => {
            const smtpClientTlsRejectUnauthorized = (0, processors_1.parseBooleans)(value);
            const error = joi_1.default.boolean().validate(smtpClientTlsRejectUnauthorized).error;
            if (error) {
                throw error;
            }
            process.env.SMTP_CLIENT_TLS_REJECT_UNAUTHORIZED = value;
            return smtpClientTlsRejectUnauthorized;
        }).optional(),
        SMTP_CLIENT_TLS_CERT: joi_1.default.custom((value) => {
            const error = joi_1.default.custom(utils_1.joiFileExistsValidation).validate(value).error;
            if (error) {
                throw error;
            }
            process.env.SMTP_CLIENT_TLS_CERT = value;
            return value;
        }).optional(),
        SMTP_CLIENT_TLS_KEY: joi_1.default.custom((value) => {
            const error = joi_1.default.custom(utils_1.joiFileExistsValidation).validate(value).error;
            if (error) {
                throw error;
            }
            process.env.SMTP_CLIENT_TLS_KEY = value;
            return value;
        }).optional(),
        SMTP_CLIENT_TLS_CA: joi_1.default.custom((value) => {
            const error = joi_1.default.custom(utils_1.joiFileExistsValidation).validate(value).error;
            if (error) {
                throw error;
            }
            process.env.SMTP_CLIENT_TLS_CA = value;
            return value;
        }).optional(),
        SMTP_FROM: joi_1.default.custom((value) => {
            const error = joi_1.default.string().email().validate(value).error;
            if (error) {
                throw error;
            }
            process.env.SMTP_FROM = value;
            return value;
        }).default(() => {
            process.env.SMTP_FROM = "notify@armongate.com";
            return process.env.SMTP_FROM;
        }),
        EMAIL_RECEIVERS: joi_1.default.custom((value) => {
            const array = JSON.parse(value);
            if (!array || !(array instanceof Array)) {
                throw new Error("EMAIL_RECEIVERS are in wrong format!");
            }
            process.env.EMAIL_RECEIVERS = value;
            return value;
        }).default(() => {
            process.env.EMAIL_RECEIVERS = '["ender.erel@armongate.com", "devrim.ada@armongate.com", "erinc.cakir@armongate.com"]';
            return JSON.parse(process.env.EMAIL_RECEIVERS);
        }),
        AMQP_MANAGEMENT_AUTH: joi_1.default.custom((value) => {
            const error = joi_1.default.string().min(1).max(127).validate(value).error;
            if (error) {
                throw error;
            }
            process.env.AMQP_MANAGEMENT_AUTH = value;
            return value;
        }),
        LOCALE: joi_1.default.custom((value) => {
            const error = joi_1.default.string().valid("tr", "en").validate(value).error;
            if (error) {
                throw error;
            }
            process.env.LOCALE = value;
            return value;
        }).default(() => {
            process.env.LOCALE = "tr";
            return process.env.LOCALE;
        }),
        DEAD_LETTER_CHECK_INTERVAL_IN_SECONDS: joi_1.default.custom((value) => {
            const intVal = parseInt(value);
            const error = joi_1.default.number().validate(intVal).error;
            if (error) {
                throw error;
            }
            process.env.DEAD_LETTER_CHECK_INTERVAL_IN_SECONDS = value;
            return intVal;
        }).default(() => {
            process.env.DEAD_LETTER_CHECK_INTERVAL_IN_SECONDS = `${60 * 60}`;
            return 60 * 60;
        }),
        DEAD_LETTER_CHECK_DURATION_IN_SECONDS: joi_1.default.custom((value) => {
            const intVal = parseInt(value);
            const error = joi_1.default.number().validate(intVal).error;
            if (error) {
                throw error;
            }
            process.env.DEAD_LETTER_CHECK_DURATION_IN_SECONDS = value;
            return intVal;
        }).default(() => {
            process.env.DEAD_LETTER_CHECK_DURATION_IN_SECONDS = `${60}`;
            return 60;
        }),
    },
}).or("SMTP_AUTH_USER", "SMTP_API_KEY");
class MonitorConfig {
    constructor() {
        const validation = cliConfigFileSchema.validate(process.env, {
            allowUnknown: true,
        });
        if (validation.error) {
            throw validation.error;
        }
        const data = validation.value;
        Object.assign(this, data);
    }
}
const monitorConfig = new MonitorConfig();
exports.default = monitorConfig;
