"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskFactory = exports.TaskBase = void 0;
const integration_base_1 = require("../integrations/integration.base");
const app_logs_1 = require("../../../app.logs");
class TaskBase {
    async execute(trx, token, taskId, data) {
        return integration_base_1.OperationStatus.Failure;
    }
}
exports.TaskBase = TaskBase;
class TaskFactory {
    constructor() {
        this.taskRegistry = {};
    }
    registerTaskType(type, ctor) {
        if (this.taskRegistry[type]) {
            throw new Error("Task type " + type + " is already registered");
        }
        else {
            this.taskRegistry[type] = ctor;
        }
    }
    createTask(type) {
        const creator = this.taskRegistry[type];
        if (creator) {
            return creator();
        }
        else {
            app_logs_1.logger.error("Task type " + type + " is not registered");
            return null;
        }
    }
}
exports.TaskFactory = TaskFactory;
