"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Log = void 0;
const api_validatorhelper_1 = require("../../../../api/api.validatorhelper");
const app_enums_1 = require("../../../../app.enums");
const app_logs_1 = require("../../../../app.logs");
const cli_queries_1 = require("../../../../dal/access/psql/cli-queries");
const dal_db_armon_schema_1 = require("../../../../dal/db/armon/dal.db.armon.schema");
const integration_config_1 = __importDefault(require("../../integration.config"));
class Log {
    async log(req, res, pool, tkOrgId, apiToken) {
        const body = req.body;
        try {
            const validator = new api_validatorhelper_1.ValidatorHelper();
            this.validateLogRequest(body, validator);
            validator.finalize();
        }
        catch (error) {
            return res.status(400).send(error);
        }
        try {
            let qrAcp;
            let user;
            await (0, cli_queries_1.systemTransaction)(pool, async (trx) => {
                let qrCodeDataRegex = "^(https://(app|sdk).armongate.com/)?(rq|bd|o|s)/([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})(/)?([0-2])?$";
                let qrCodeDataParserRegex = "(rq|bd|o|s)/([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})(/)?([0-2])?$";
                let matchedPart = body.qrData.match(qrCodeDataRegex)?.[0];
                if (matchedPart === body.qrData) {
                    let qrDataPart = body.qrData.match(qrCodeDataParserRegex)?.[0];
                    qrAcp = (await trx.query(`SELECT id, config, "accessPointId"
						FROM "${integration_config_1.default.INTEGRATION_ORGANIZATION}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessPointQRCode}"
						WHERE "qrCodeData" = $1`, [qrDataPart])).rows[0];
                }
                else {
                    return res.status(app_enums_1.enums.HttpStatusCode.BAD_REQUEST).send();
                }
                user = (await trx.query(`SELECT "userId"
						FROM "${integration_config_1.default.INTEGRATION_ORGANIZATION}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationProfiles}"
						WHERE "uniqueId" = $1`, [body.uniqueId])).rows[0];
            });
            if (!qrAcp || !user) {
                return res.status(app_enums_1.enums.HttpStatusCode.NOT_FOUND).send();
            }
            let reqBody = {
                accessControlPointId: qrAcp.accessPointId,
                direction: qrAcp.config.d,
                qr: true,
                userId: user.userId,
            };
            const taskdata = {
                uniqueId: tkOrgId,
                taskid: "instant",
            };
            const response = await apiToken.httpRequest(taskdata, "POST", `/u/v1/${integration_config_1.default.INTEGRATION_ORGANIZATION}/system/remotecontrol`, reqBody);
            if (response.status === 200) {
                let resData = response.data;
                return res.status(app_enums_1.enums.HttpStatusCode.SUCCESS).send(resData);
            }
            else {
                app_logs_1.logger.error(response);
                return res.status(app_enums_1.enums.HttpStatusCode.INTERNAL_ERROR).send();
            }
        }
        catch (error) {
            app_logs_1.logger.error("Error while executing task:");
            app_logs_1.logger.error(error);
            return res.status(app_enums_1.enums.HttpStatusCode.INTERNAL_ERROR).send(error);
        }
    }
    validateLogRequest(raw, v) {
        v.validateString({ field: `uniqueId`, optional: false, input: raw.uniqueId, maxLength: 50 });
        v.validateString({ field: `qrData`, optional: false, input: raw.qrData, maxLength: 100 });
    }
}
exports.Log = Log;
