"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultOrganizationUnitTask = void 0;
const app_enums_1 = require("../../../../app.enums");
const app_logs_1 = require("../../../../app.logs");
const dal_db_armon_schema_1 = require("../../../../dal/db/armon/dal.db.armon.schema");
const integration_config_1 = __importDefault(require("../../integration.config"));
const integration_base_1 = require("../../integrations/integration.base");
class DefaultOrganizationUnitTask {
    static create() {
        return new DefaultOrganizationUnitTask();
    }
    async execute(trx, token, taskId, unitData) {
        app_logs_1.logger.info("Executing task for: " + unitData.id);
        const taskdata = {
            uniqueId: unitData.id,
            taskid: taskId,
        };
        const typeIds = await trx.query(`SELECT vals.id, (vals.value)::jsonb->>'caption_tr' as name
                FROM "${integration_config_1.default.INTEGRATION_ORGANIZATION}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUserDefinedLists}" list
                INNER JOIN "${integration_config_1.default.INTEGRATION_ORGANIZATION}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUserDefinedListValues}" vals
                    ON vals."userDefinedListId" = list.id
                WHERE list.type = $1`, [app_enums_1.enums.OrganizationUserDefinedListType.OrganizationUnitType]);
        const unitIdOfBirim = typeIds.rows.find((r) => r.name === "Birim").id;
        if (unitIdOfBirim) {
            DefaultOrganizationUnitTask.unitTypeId = typeIds.rows.find((r) => r.name === "Birim").id;
        }
        else {
            DefaultOrganizationUnitTask.unitTypeId = typeIds.rows[0].id;
        }
        if (!unitData.parentId) {
            delete unitData.parentId;
        }
        else {
            const parentUnit = await trx.query(`SELECT "id", "name"
					FROM "${integration_config_1.default.INTEGRATION_ORGANIZATION}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" u
					WHERE u."shortCode" = $1`, [unitData.parentId]);
            unitData.parentId = parentUnit.rows[0].id;
        }
        if (!unitData.managerId) {
            delete unitData.managerId;
        }
        else {
            const manager = (await trx.query(`SELECT uop.*, uo."isDisabled", uo."roleId"
					FROM "${integration_config_1.default.INTEGRATION_ORGANIZATION}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationProfiles}" uop
					INNER JOIN "${integration_config_1.default.INTEGRATION_ORGANIZATION}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" uo
						ON uop."userOrganizationId" = uo."id"
					WHERE uop."uniqueId" = $1 AND uo."deletedAt" IS NULL AND uop."deletedAt" IS NULL;`, [unitData.managerId])).rows[0];
            unitData.managerId = manager.userId;
        }
        const internalids = (await trx.query(`SELECT ids."armonId", ids."extId", units.name, units."shortCode", units."parentId"
                FROM "${integration_config_1.default.INTEGRATION_ORGANIZATION}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.integration_idmap}" ids
                INNER JOIN "${integration_config_1.default.INTEGRATION_ORGANIZATION}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" units
                    ON ids.type = $1 AND units.id = ids."armonId" AND units."deletedAt" IS NULL
                WHERE "extId" = $2`, [integration_base_1.IntegrationEntityType.OrganizationUnit, unitData.id])).rows;
        const counterpart = internalids.find((i) => unitData.id === i.extId);
        if (!counterpart) {
            const reqBody = {
                name: unitData.name,
                shortCode: unitData.id,
                parentId: unitData.parentId,
                managerUserId: unitData.managerId,
                typeId: DefaultOrganizationUnitTask.unitTypeId,
            };
            let response;
            try {
                response = await token.httpRequest(taskdata, "POST", `/u/v1/${integration_config_1.default.INTEGRATION_ORGANIZATION}/organizationunit`, reqBody);
            }
            catch (error) {
                app_logs_1.logger.error("Could not insert organization unit: " + error.status + " - " + error.message);
                throw error;
            }
            if (response.data && response?.status === 200) {
                app_logs_1.logger.info(`Unit ${unitData.name} successfully upserted with id: ${response.data.id}`);
                await trx.query(`INSERT INTO "${integration_config_1.default.INTEGRATION_ORGANIZATION}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.integration_idmap}"
                        ("armonId", "extId", type) VALUES ($1, $2, $3);`, [response.data.id, unitData.id, integration_base_1.IntegrationEntityType.OrganizationUnit]);
            }
        }
        else {
            if (counterpart.name !== unitData.name || counterpart.shortCode !== unitData.id) {
                const reqBody = {
                    id: counterpart.armonId,
                    name: unitData.name,
                    shortCode: unitData.id,
                    parentId: unitData.parentId,
                    managerUserId: unitData.managerId,
                    typeId: DefaultOrganizationUnitTask.unitTypeId,
                };
                let response;
                try {
                    response = await token.httpRequest(taskdata, "POST", `/u/v1/${integration_config_1.default.INTEGRATION_ORGANIZATION}/organizationunit`, reqBody);
                }
                catch (error) {
                    app_logs_1.logger.error("Could not update leave: " + error.status + " - " + error.message);
                    throw error;
                }
            }
            else {
                app_logs_1.logger.error(`Unit ${unitData.name} could not be updated`);
                return integration_base_1.OperationStatus.Failure;
            }
        }
        return integration_base_1.OperationStatus.Success;
    }
}
exports.DefaultOrganizationUnitTask = DefaultOrganizationUnitTask;
DefaultOrganizationUnitTask.id = "3a51e606-17bb-4aa2-aee9-7306fed24d3c";
