"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAmqpConnection = exports.connectAmqpWithProcessEnv = void 0;
const amqp_connection_manager_1 = __importDefault(require("amqp-connection-manager"));
const fs_1 = __importDefault(require("fs"));
const app_logs_1 = require("../app.logs");
let connection;
async function connectAmqpWithProcessEnv(config, initiatorFileName) {
    return new Promise((resolve, reject) => {
        try {
            connection = amqp_connection_manager_1.default.connect([`amqps://${config.AMQP_HOSTNAME}:${config.AMQP_PORT}${config.AMQP_VHOST}`], {
                heartbeatIntervalInSeconds: config.AMQPS_CONN_HEARTBEAT,
                reconnectTimeInSeconds: config.AMQPS_CONN_HEARTBEAT,
                connectionOptions: {
                    servername: config.AMQP_HOSTNAME,
                    keepAlive: true,
                    credentials: {
                        password: null,
                        username: null,
                        mechanism: "EXTERNAL",
                        response: () => {
                            return Buffer.from("");
                        },
                    },
                    timeout: config.AMQPS_CONN_HEARTBEAT * 1000,
                    cert: fs_1.default.readFileSync(config.AMQPS_CLIENT_TLS_CERT),
                    key: fs_1.default.readFileSync(config.AMQPS_CLIENT_TLS_KEY),
                    ca: [fs_1.default.readFileSync(config.AMQPS_CLIENT_TLS_CA)],
                },
            });
            connection.on("disconnect", async ({ err }) => {
                app_logs_1.logger.info(`[${initiatorFileName}] lost the connection. Retry in ${config.AMQPS_CONN_HEARTBEAT} secs. ${err}`);
            });
            connection.on("blocked", () => {
                app_logs_1.logger.info(`[${initiatorFileName}] RabbitMQ connection has been blocked disk full!!`);
            });
            connection.on("connect", () => {
                app_logs_1.logger.info(`[${initiatorFileName}] RabbitMQ connection has been established`);
                resolve(connection);
            });
            connection.on("unblocked", () => {
                app_logs_1.logger.info(`[${initiatorFileName}] RabbitMQ connection has been ublocked!`);
            });
            return connection;
        }
        catch (error) {
            app_logs_1.logger.error("Error while connecting to rabbitmq %s", error.message);
        }
    });
}
exports.connectAmqpWithProcessEnv = connectAmqpWithProcessEnv;
function getAmqpConnection() {
    return connection;
}
exports.getAmqpConnection = getAmqpConnection;
