"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const pg_1 = require("pg");
const cli_config_1 = __importDefault(require("./cli.config"));
const fs_1 = __importDefault(require("fs"));
const cli_queries_1 = require("../../dal/access/psql/cli-queries");
let pool = new pg_1.Pool({
    user: cli_config_1.default.PGSUPERUSER,
    application_name: "cli-application",
    max: 100,
});
async function runSql(sqlFilePath) {
    try {
        await (0, cli_queries_1.systemTransaction)(pool, async (trx) => {
            const fileContents = fs_1.default.readFileSync(sqlFilePath, { encoding: "utf8" });
            const sqlQueries = fileContents.split(`/\r?\n/`);
            for (const query of sqlQueries) {
                try {
                    console.log(`Query to run: ${query}`);
                    const dbResult = await trx.query(query);
                    console.table(dbResult.rows);
                }
                catch (error) {
                    console.error(`Error while running query ${query}`);
                    console.error(error);
                }
            }
        });
    }
    catch (error) {
        console.error(error);
    }
}
runSql(process.argv[2]);
