"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const cli_config_1 = __importDefault(require("../../cli.config"));
const app_logs_1 = require("../../../../app.logs");
const messageBroker_amqp_to_cli_sub_1 = require("../../../../messageBroker/messageBroker.amqp-to-cli.sub");
const common_utils_1 = require("../../../common.utils");
async function initMessageBrokerForCliService(cb) {
    app_logs_1.logger.info("Starting AMQP for cli service");
    try {
        const connection = await (0, common_utils_1.connectAmqpWithProcessEnv)(cli_config_1.default, "cli.messageBroker.manager.ts");
        await (0, messageBroker_amqp_to_cli_sub_1.amqpToDeadLetterInit)(connection, cb);
    }
    catch (error) {
        app_logs_1.logger.error(`Amqp for cli service could not initialized` + error);
    }
}
exports.default = initMessageBrokerForCliService;
