"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteOneTimeUsedUserFilters = void 0;
const app_logs_1 = require("../../../../app.logs");
const deleteOneTimeUsedUserFilters = async (client) => {
    const organizationIds = (await client.query(`SELECT id FROM public."organizationList"`)).rows.map((row) => row.id);
    await Promise.all(organizationIds.map(async (organizationId) => {
        const filterIds = (await client.query(`SELECT DISTINCT "receiverFilterId" FROM "${organizationId}".zz_notification WHERE "receiverFilterId" IS NOT NULL`)).rows.map((row) => row.receiverFilterId);
        const { rowCount } = await client.query(`DELETE FROM "${organizationId}"."user_filter"
                WHERE "id" <> all($1::uuid[])`, [filterIds]);
        await client.query(`DELETE FROM "${organizationId}"."user_filter_user"
                WHERE "filterId" <> all($1::uuid[])`, [filterIds]);
        await client.query(`DELETE FROM "${organizationId}"."user_filter_group"
                WHERE "filterId" <> all($1::uuid[])`, [filterIds]);
        await client.query(`DELETE FROM "${organizationId}"."user_filter_work_plan"
                WHERE "filterId" <> all($1::uuid[])`, [filterIds]);
        await client.query(`DELETE FROM "${organizationId}"."user_filter_unit_role"
                WHERE "filterId" <> all($1::uuid[])`, [filterIds]);
        await client.query(`DELETE FROM "${organizationId}"."user_filter_unit"
                WHERE "filterId" <> all($1::uuid[])`, [filterIds]);
        await client.query(`DELETE FROM "${organizationId}"."user_filter_organization_role"
                WHERE "filterId" <> all($1::uuid[])`, [filterIds]);
        app_logs_1.logger.debug(`Deleted userFilter for organization[${organizationId}] is ${rowCount}`);
    }));
};
exports.deleteOneTimeUsedUserFilters = deleteOneTimeUsedUserFilters;
