"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaSheet = void 0;
const crypto_1 = __importDefault(require("crypto"));
class MetaSheet {
    constructor(sheetId, organizationId, preRegistration, createdAt, headers) {
        this._sheetId = sheetId;
        this._organizationId = organizationId;
        this._preRegistration = preRegistration;
        this._createdAt = createdAt;
        this._headers = headers;
    }
    write(ws) {
        ws.addRow(Object.values(this._headers));
        ws.addRow(Object.keys(this._headers));
        ws.getCell("A3").value = this._organizationId;
        ws.getCell("A4").value = this._createdAt;
        ws.getCell("A5").value = this._preRegistration;
        ws.getCell("A6").value = this._hash;
    }
    generateHash() {
        let excelData = Object.values(this._headers).join("");
        excelData += Object.keys(this._headers).join("");
        excelData += this._organizationId;
        excelData += this._createdAt;
        excelData += this._preRegistration;
        this._hash = crypto_1.default.createHmac("sha512", "visitor-excel").update(excelData).digest("hex");
    }
    validateHash(hash) {
        if (!this._hash)
            this.generateHash();
        return hash == this._hash;
    }
}
exports.MetaSheet = MetaSheet;
