"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PdfSensorEvents = void 0;
const translate = __importStar(require("i18n"));
const report_util_1 = require("../report.util");
const moment_1 = __importDefault(require("moment"));
const app_enums_1 = require("../../../app.enums");
const report_pdf_report_creator_1 = require("../report-helpers/report.pdf-report-creator");
const report_pdf_cell_1 = require("../report-helpers/report.pdf-cell");
const report_filter_1 = require("../report-helpers/report.filter");
const dal_manager_1 = require("../../../dal/dal.manager");
const app_logs_1 = require("../../../app.logs");
const business_report_export_1 = require("../business.report.export");
const generator_1 = require("../generator");
const report_pdf_cell_bar_1 = require("../report-helpers/report.pdf-cell-bar");
class PdfSensorEvents extends generator_1.ReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._options = request.filter;
        this.locale = this._locale;
    }
    async generateReport() {
        this._data = await (0, business_report_export_1.getSensorEventsReport)({ organizationId: this._request.organizationId, filter: this._options, requesterUserId: this._request.requesterUserId });
        let locale = this.locale;
        this.pdfReportCreator = new report_pdf_report_creator_1.PDFReportCreator(this.locale);
        this.createColumns();
        this.createRows();
        await this.createFilters();
        app_logs_1.logger.debug("Sensor events pdf report is on process...");
        return await this.pdfReportCreator.createPdf(this._data.organization.name, this._data.organization.logo, app_enums_1.enums.ReportCode.SensorEvents, ["auto", "auto", "auto", "auto", 200]);
    }
    createColumns() {
        let locale = this.locale;
        let columns = [];
        columns.push(translate.__({ phrase: "PDF-REPORT.date", locale }));
        columns.push(translate.__({ phrase: "PDF-REPORT.sensor", locale }));
        columns.push(translate.__({ phrase: "PDF-REPORT.status", locale }));
        columns.push(translate.__({ phrase: "PDF-REPORT.terminal", locale }));
        columns.push(translate.__({ phrase: "PDF-REPORT.last_action", locale }));
        this.pdfReportCreator.addColumns(columns);
    }
    createRows() {
        this._data.result.items.forEach((record) => {
            let cells = [];
            let cellForDate = this.createCellDate(record);
            let cellForSensor = this.createCellSensor(record);
            let cellForStatus = this.createCellStatus(record);
            let cellForTerminal = this.createCellTerminal(record);
            let cellForLastAction = this.createCellForLastAction(record);
            cells.push(this.createPdfReportCell(cellForDate, false, null, null));
            cells.push(this.createPdfReportCell(cellForSensor, false, null, null));
            cells.push(this.createPdfReportCell(cellForStatus, false, null, null));
            cells.push(this.createPdfReportCell(cellForTerminal, false, null, null));
            cells.push(this.createPdfReportCell(cellForLastAction, false, null, null));
            this.pdfReportCreator.addRow(cells);
        });
    }
    createPdfReportCell(text, isCaption, fontSize, color) {
        let cell = new report_pdf_cell_1.PdfReportCell();
        cell.text = text;
        if (fontSize != null)
            cell.fontSize = fontSize;
        if (color != null)
            cell.color = color;
        cell.isCaption = isCaption;
        return cell;
    }
    createPdfReportCellBar(text, alignment, barColor, width) {
        let cell = new report_pdf_cell_bar_1.PdfReportCellBar();
        if (text)
            cell.text = text;
        if (alignment)
            cell.alignment = alignment;
        if (barColor)
            cell.barColor = barColor;
        cell.width = width;
        return cell;
    }
    createFilterObject(title, value) {
        let filter = new report_filter_1.PdfReportFilter();
        filter.title = title;
        filter.value = value;
        return filter;
    }
    async createFilters() {
        let locale = this.locale;
        let filters = [];
        let filterResult = await dal_manager_1.dbManager.accessReport.collectSensorEventsInfo(this._request.organizationId, this._options.sensorIds, this._options.terminalDeviceIds);
        if (this._options.type != null) {
            let type = this.getTypeText(this._options.type);
            let state;
            let reason;
            if (this._options.state != null) {
                state = this.getStateText(this._options.type, this._options.state);
            }
            else {
                state = "PDF-REPORT.All";
            }
            if (this._options.reason != null) {
                reason = this.getReasonText(this._options.type, this._options.reason);
            }
            else {
                reason = "PDF-REPORT.All";
            }
            filters.push(this.createFilterObject(translate.__({ phrase: "PDF-REPORT.SENSOR_TYPE", locale }), translate.__({ phrase: type, locale })));
            filters.push(this.createFilterObject(translate.__({ phrase: "PDF-REPORT.SENSOR_STATE", locale }), translate.__({ phrase: state, locale })));
            filters.push(this.createFilterObject(translate.__({ phrase: "PDF-REPORT.REASON", locale }), translate.__({ phrase: reason, locale })));
        }
        else {
            filters.push(this.createFilterObject(translate.__({ phrase: "PDF-REPORT.SENSOR_TYPE", locale }), translate.__({ phrase: "PDF-REPORT.All", locale })));
        }
        this.pdfReportCreator.addFilters(filters);
    }
    createCellDate(record) {
        let locale = this.locale;
        if (record.lastAction != null && record.lastAction.actionDateTime != null)
            return (0, moment_1.default)(record.lastAction.actionDateTime).locale(locale).format("HH:mm:ss") + "\n" + (0, moment_1.default)(record.lastAction.actionDateTime).locale(locale).format("LL");
        else
            return "";
    }
    createCellSensor(record) {
        let text = "";
        if (record.input != null && record.input.name != null) {
            text += record.input.name + "\n";
        }
        if (record.input != null && record.input.typeName != null) {
            text += record.input.typeName;
        }
        return text;
    }
    createCellStatus(record) {
        let locale = this.locale;
        let result = "";
        if (record.lastAction != null) {
            if (record.lastAction.stateBeforeAction != null) {
                result += translate.__({ phrase: this.getStateText(record.input.type, record.lastAction.stateBeforeAction), locale });
            }
            else {
                result += translate.__({ phrase: "PDF-REPORT.no_record", locale });
            }
            result += " => ";
            if (record.lastAction.state != null) {
                result += translate.__({ phrase: this.getStateText(record.input.type, record.lastAction.state), locale });
            }
            else {
                result += translate.__({ phrase: "PDF-REPORT.no_record", locale });
            }
        }
        return result;
    }
    createCellTerminal(record) {
        let text = "";
        if (record.terminal != null && record.terminal.name != null) {
            text += record.terminal.name + "\n";
        }
        if (record.terminal != null && record.terminal.serialNumber != null) {
            text += record.terminal.serialNumber + "\n";
        }
        if (record.terminal != null && record.terminal.model != null) {
            text += record.terminal.model;
        }
        return text;
    }
    createCellForLastAction(record) {
        let locale = this.locale;
        let result = "";
        if (record.input != null && record.input.type != null && record.lastAction != null && record.lastAction.state != null && record.lastAction.reason != null) {
            result =
                translate.__({ phrase: "PDF-REPORT.NEW_STATE", locale }) +
                    ": " +
                    translate.__({ phrase: this.getStateText(record.input.type, record.lastAction.state), locale }) +
                    "\n" +
                    translate.__({ phrase: "PDF-REPORT.REASON", locale }) +
                    ": " +
                    translate.__({ phrase: this.getReasonText(record.input.type, record.lastAction.reason), locale });
        }
        let accessLog = null;
        if (record.lastAction != null && record.lastAction.accessLog != null)
            accessLog = record.lastAction.accessLog;
        let users = "";
        if (accessLog != null) {
            if (accessLog.user != null) {
                let _res = "";
                accessLog.user.forEach((item, index) => {
                    _res += "";
                    if (item.text != null && item.text != "__avatar") {
                        item.text.forEach((element) => {
                            if (element != null)
                                _res += element + (index < accessLog.user.length - 1 ? " " : "");
                        });
                    }
                    _res += index < accessLog.user.length - 1 ? "\r\n" : "";
                });
                users = _res;
                result += "\n" + users;
            }
            let state = "";
            let reason = "";
            if (record.input != null && accessLog != null && accessLog.state != null)
                state = translate.__({ phrase: this.getStateText(record.input.type, accessLog.state), locale });
            if (record.input != null && accessLog != null && accessLog.reason != null)
                reason = translate.__({ phrase: this.getReasonText(record.input.type, accessLog.reason), locale });
            if (state != null && state != "")
                result += "\n" + translate.__({ phrase: "PDF-REPORT.NEW_STATE" }) + ": " + state;
            if (reason != null && reason != "")
                result += "\n" + translate.__({ phrase: "PDF-REPORT.REASON" }) + ": " + reason;
        }
        return result;
    }
    getTypeText(type) {
        let typeText = report_util_1.ReportConstants.SensorTypes.find((sensor) => sensor.type == type)?.description;
        if (typeText == null)
            return "";
        return typeText;
    }
    getStateText(type, state) {
        let stateText;
        switch (type) {
            case app_enums_1.enums.DryContactTypeV2.StatusSensor:
                stateText = report_util_1.ReportConstants.StatusSensorStates.find((statusState) => statusState.type == state)?.description;
                break;
            case app_enums_1.enums.DryContactTypeV2.CounterSensor:
                stateText = report_util_1.ReportConstants.CounterSensorStates.find((counterState) => counterState.type == state)?.description;
                break;
            case app_enums_1.enums.DryContactTypeV2.TamperSwitch:
                stateText = report_util_1.ReportConstants.TamperSwitchStates.find((tamperState) => tamperState.type == state)?.description;
                break;
            default:
                "";
        }
        if (stateText == null)
            return "";
        return stateText;
    }
    getReasonText(type, reason) {
        let stateText;
        switch (type) {
            case app_enums_1.enums.DryContactTypeV2.StatusSensor:
                stateText = report_util_1.ReportConstants.StatusSensorReasons.find((statusReason) => statusReason.type == reason)?.description;
                break;
            case app_enums_1.enums.DryContactTypeV2.CounterSensor:
                stateText = report_util_1.ReportConstants.CounterSensorReasons.find((counterReason) => counterReason.type == reason)?.description;
                break;
            case app_enums_1.enums.DryContactTypeV2.TamperSwitch:
                stateText = "";
                break;
            default:
                "";
        }
        if (stateText == null)
            return "";
        return stateText;
    }
}
exports.PdfSensorEvents = PdfSensorEvents;
