"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PdfReportPermissionManagement = void 0;
const translate = __importStar(require("i18n"));
const report_util_1 = require("../report.util");
const moment_1 = __importDefault(require("moment"));
const dal_manager_1 = require("../../../dal/dal.manager");
const report_pdf_report_creator_1 = require("../report-helpers/report.pdf-report-creator");
const report_pdf_cell_1 = require("../report-helpers/report.pdf-cell");
const report_filter_1 = require("../report-helpers/report.filter");
const business_report_export_1 = require("../business.report.export");
const generator_1 = require("../generator");
const report_pdf_cell_bar_1 = require("../report-helpers/report.pdf-cell-bar");
const app_enums_1 = require("../../../app.enums");
class PdfReportPermissionManagement extends generator_1.ReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._options = request.filter;
    }
    async generateReport() {
        let locale = this._locale;
        this._data = await (0, business_report_export_1.generateListPPermissionsData)(this._request.organizationId, this._request.requesterUserId, this._options);
        this.pdfReportCreator = new report_pdf_report_creator_1.PDFReportCreator(locale);
        this.createColumns();
        this.createRows();
        await this.createFilters();
        return await this.pdfReportCreator.createPdf(this._data.organization.name, this._data.organization.logo, app_enums_1.enums.ReportCode.PermissionManagement, [
            "auto",
            "auto",
            "auto",
            "auto",
            "auto",
            "auto",
        ]);
    }
    createColumns() {
        let columns = [];
        columns.push(translate.__({ phrase: "EXCEL-REPORT.EMPLOYEE", locale: this._locale }));
        columns.push(translate.__({ phrase: "EXCEL-REPORT.PERMISSION_START_DATE", locale: this._locale }));
        columns.push(translate.__({ phrase: "EXCEL-REPORT.PERMISSION_END_DATE", locale: this._locale }));
        columns.push(translate.__({ phrase: "EXCEL-REPORT.PERMISSION_TYPE", locale: this._locale }));
        columns.push(translate.__({ phrase: "EXCEL-REPORT.ACCEPTANCE_STATUS", locale: this._locale }));
        columns.push(translate.__({ phrase: "EXCEL-REPORT.NOTE", locale: this._locale }));
        this.pdfReportCreator.addColumns(columns);
    }
    createPdfReportCell(text, isCaption, fontSize, color) {
        let cell = new report_pdf_cell_1.PdfReportCell();
        cell.text = text;
        if (fontSize != null)
            cell.fontSize = fontSize;
        if (color != null)
            cell.color = color;
        cell.isCaption = isCaption;
        return cell;
    }
    createPdfReportCellBar(text, alignment, barColor, width) {
        let cell = new report_pdf_cell_bar_1.PdfReportCellBar();
        if (text)
            cell.text = text;
        if (alignment)
            cell.alignment = alignment;
        if (barColor)
            cell.barColor = barColor;
        cell.width = width;
        return cell;
    }
    createFilterObject(title, value) {
        let filter = new report_filter_1.PdfReportFilter();
        filter.title = title;
        filter.value = value;
        return filter;
    }
    createRows() {
        let locale = this._locale;
        for (const record of this._data.ppermissions) {
            let cells = [];
            let cellForIdentity;
            if (record.userCount > 1) {
                cellForIdentity = translate.__({ phrase: "EXCEL-REPORT.PPERMISSION_MULTIUSER", locale });
                cells.push(this.createPdfReportCell(cellForIdentity, false, null, null));
            }
            else if (record.userPPermissionInfo[0] && record.userPPermissionInfo[0].userAndDeputyInfo && record.userPPermissionInfo[0].userAndDeputyInfo.userCaptions) {
                cellForIdentity = (0, report_util_1.parseCaption)(record.userPPermissionInfo[0].userAndDeputyInfo.userCaptions);
                cells.push(this.createPdfReportCell(cellForIdentity, true, null, null));
            }
            let startDate = (0, moment_1.default)(record.dateRange.startDateTime).locale(locale).format("DD/MM/YYYY HH:mm");
            let endDate = (0, moment_1.default)(record.dateRange.endDateTime).locale(locale).format("DD/MM/YYYY HH:mm");
            let approvalInfo = "";
            let userInfo = record.userPPermissionInfo[0];
            let isRequiredApprovement = false;
            if (userInfo.approvementInfo && userInfo.approvementInfo.length > 0) {
                isRequiredApprovement = true;
            }
            if (isRequiredApprovement) {
                switch (userInfo.status) {
                    case 0:
                        approvalInfo = translate.__({ phrase: "EXCEL-REPORT.PPERMISSION_STATUS_WAITING", locale });
                        break;
                    case 1:
                        approvalInfo = translate.__({ phrase: "EXCEL-REPORT.PPERMISSION_STATUS_ACCEPTED", locale });
                        break;
                    case 2:
                        approvalInfo = translate.__({ phrase: "EXCEL-REPORT.PPERMISSION_STATUS_REJECTED", locale });
                        break;
                    default:
                        break;
                }
            }
            else {
                approvalInfo = translate.__({ phrase: "EXCEL-REPORT.PPERMISSION_STATUS_NO_APPROVEMENT", locale });
            }
            let note = "";
            if (record.note)
                note = record.note;
            cells.push(this.createPdfReportCell(startDate, false, null, null));
            cells.push(this.createPdfReportCell(endDate, false, null, null));
            cells.push(this.createPdfReportCell(record.ppermissionType.name, false, null, null));
            cells.push(this.createPdfReportCell(approvalInfo, false, null, null));
            cells.push(this.createPdfReportCell(note, false, null, null));
            this.pdfReportCreator.addRow(cells);
        }
    }
    async createFilters() {
        let locale = this._locale;
        let filterResult = await dal_manager_1.dbManager.accessReport.collectPermissionManagementFilterInfo(this._options.ppermissionTypeId, this._options.userIds, this._request.organizationId);
        let filters = [];
        if (filterResult.userCaptions != null && filterResult.userCaptions.length > 0) {
            filters.push(this.createFilterObject(translate.__({ phrase: "PDF-REPORT.IDENTITES", locale }), (0, report_util_1.parseCaptionForPdfFilter)(filterResult.userCaptions)));
        }
        if (this._options.status) {
            let key = report_util_1.ReportConstants.PacsPPermissionStatusFilterOptionList.filter((item) => this._options.status === item.value);
            let acceptanceStatus = translate.__({ phrase: key[0].i18nName, locale });
            filters.push(this.createFilterObject(translate.__({ phrase: "EXCEL-REPORT.ACCEPTANCE_STATUS", locale }), acceptanceStatus));
        }
        let permissionDate = "";
        if (this._options.startDateTime)
            permissionDate += (0, moment_1.default)(this._options.startDateTime).locale(locale).format("DD/MM/YYYY HH:mm");
        if (this._options.startDateTime && this._options.endDateTime) {
            permissionDate += " - " + (0, moment_1.default)(this._options.endDateTime).locale(locale).format("DD/MM/YYYY HH:mm");
        }
        if (!this._options.startDateTime && this._options.endDateTime) {
            permissionDate += (0, moment_1.default)(this._options.endDateTime).locale(locale).format("DD/MM/YYYY HH:mm");
        }
        filters.push(this.createFilterObject(translate.__({ phrase: "EXCEL-REPORT.PERMISSION_START_DATE", locale }), permissionDate));
        this.pdfReportCreator.addFilters(filters);
    }
}
exports.PdfReportPermissionManagement = PdfReportPermissionManagement;
