"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExcelReportWorkSummaryOfEmployee = void 0;
const i18n_1 = __importDefault(require("i18n"));
const moment_1 = __importDefault(require("moment"));
const app_enums_1 = require("../../../app.enums");
const app_logs_1 = require("../../../app.logs");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_db_armon_schema_1 = require("../../../dal/db/armon/dal.db.armon.schema");
const excel_report_column_extractor_1 = __importStar(require("../excel.report.column.extractor"));
const excel_report_refactory_1 = require("../excel.report.refactory");
const generator_1 = require("../generator");
const luxon_1 = require("luxon");
const reportGeneralDef = {
    dataColumns: [
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.Date,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.AttendanceStatusText,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.UsedPermissions,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.EntrancePenaltyTime,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExitPenaltyTime,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.MissingWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExtraWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.FirstInTime,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.LastOutTime,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.WorkplanText,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExpectedEntrance,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExpectedLeave,
    ],
};
const reportWorkingDurationdDef = {
    dataColumns: [
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.Date,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExpectedWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.NormalWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExtraWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.MissingWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.TotalWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.AccountedOffTimePermissionDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.UsedHolidayDuration,
    ],
};
class ExcelReportWorkSummaryOfEmployee extends generator_1.ReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._accessLogIds = [];
        this._permissionData = [];
        this._accessLogData = [];
        this._workplansWithPeriods = [];
        this._ppermissions = [];
        this._holidays = [];
        this._options = request.filter;
        this._options.dateRange.endDateTime = (0, moment_1.default)(this._options.dateRange.endDateTime).endOf("day").toDate();
        this._reportFactory = new excel_report_refactory_1.ReportFactory(this._request.organizationId, this._locale);
    }
    async onDataCallbackFunctionReader(rows) {
        app_logs_1.logger.debug("Fetch reader data %s rows", rows.length);
        const wps = new Set();
        const leaveIds = new Set();
        const accessLogIds = new Set();
        const holidayIds = new Set();
        const userIds = [];
        for (const row of rows) {
            userIds.push(row.userId);
            row.data.w.forEach((w) => {
                wps.add(w);
            });
            row.data.p.forEach((leave) => {
                leaveIds.add(leave.p);
            });
            row.data.h.forEach((holiday) => {
                holidayIds.add(holiday.h);
            });
            row.data.c.forEach((segment) => {
                if (segment.ad && segment.ad.a) {
                    if (segment.ad.a.si) {
                        accessLogIds.add(segment.ad.a.si);
                    }
                    if (segment.ad.a.ei) {
                        accessLogIds.add(segment.ad.a.ei);
                    }
                }
            });
            this._accessLogIds = Array.from(accessLogIds);
        }
        await this._reportFactory.appendToUserInfo(userIds);
        await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            if (wps.size !== 0) {
                const workplansWithPeriods = (await trx.query(`SELECT wp.id, wp.name , wpp."details"
							FROM "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}" wp
							LEFT JOIN "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.viewNames.vW_WorkPlanPeriodTstzrange}" wpp ON wpp."workPlanId" = wp.id
							WHERE wp."id" = ANY($1)`, [Array.from(wps)])).rows;
                this._workplansWithPeriods = [...this._workplansWithPeriods, ...workplansWithPeriods];
            }
            if (leaveIds.size !== 0) {
                const ppermissions = (await trx.query(`SELECT p."id" as pid, pt."id" as ptid, pt."name", p."status", p."startDateTime", p."endDateTime"
						FROM "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.ppermissionTypes}" pt
						INNER JOIN "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.ppermissions}" p ON p."ppermissionTypeId" = pt.id
						WHERE p."id" = ANY($1)`, [Array.from(leaveIds)])).rows;
                this._ppermissions = [...this._ppermissions, ...ppermissions];
            }
            this._holidays = (await trx.query(`SELECT id, title, "startDateTime", "endDateTime"
  					 FROM "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.vacations}"
   					 WHERE "id" = ANY($1)`, [Array.from(holidayIds)])).rows;
            let totalRow = {
                cells: [
                    {
                        value: "Toplam",
                        font: { bold: true },
                        border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                        alignment: {
                            horizontal: "right",
                            wrapText: true,
                        },
                    },
                ],
            };
            await this.setLeavesData(rows);
            await this.setAccessLogData();
            let sheetInfo = [
                {
                    sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: this._locale }),
                    data: [],
                },
                {
                    sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.WORKING_DURATION", locale: this._locale }),
                    data: [],
                },
                {
                    sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.ACCESS_LOGS", locale: this._locale }),
                    data: this._accessLogData,
                },
                {
                    sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.LEAVES", locale: this._locale }),
                    data: this._permissionData,
                },
            ];
            for (const row of rows) {
                let context = {
                    workplans: this._workplansWithPeriods,
                    leaves: this._ppermissions,
                    holidays: this._holidays,
                    user: {
                        id: row.userId,
                        name: row.name,
                        surname: row.surname,
                        uniqueId: row.uniqueId,
                    },
                    date: row.date,
                    locale: this._locale,
                };
                let generatedGeneralColumns = [];
                let generatedWorkingDurationColumns = [];
                if (row.data) {
                    for (const element of reportGeneralDef.dataColumns) {
                        generatedGeneralColumns.push(excel_report_column_extractor_1.default.invoke(element, row.data, context, trx));
                    }
                    sheetInfo[0].data.push({
                        cells: generatedGeneralColumns,
                    });
                    for (const element of reportWorkingDurationdDef.dataColumns) {
                        generatedWorkingDurationColumns.push(excel_report_column_extractor_1.default.invoke(element, row.data, context, trx));
                    }
                    sheetInfo[1].data.push({
                        cells: generatedWorkingDurationColumns,
                    });
                }
                else {
                    sheetInfo[0].data.push({
                        cells: [
                            {
                                value: i18n_1.default.__({ phrase: "EXCEL-REPORT.STILL_CALCULATING", locale: context.locale }),
                                border: generator_1.ReportGenerator.Constants.Styling.AllDotted,
                            },
                        ],
                    });
                }
            }
            let hsFmt;
            if (this._locale === "tr") {
                hsFmt = generator_1.ReportGenerator.Constants.hsFmtTr;
            }
            else {
                hsFmt = generator_1.ReportGenerator.Constants.hsFmtEng;
            }
            const maps = [{ B: 2 }, { C: 3 }, { D: 4 }, { E: 5 }, { F: 6 }, { G: 7 }, { H: 8 }];
            for (const m of maps) {
                let cell = {
                    value: {
                        formula: "SUM(" + Object.keys(m)[0] + "2:" + Object.keys(m)[0] + (sheetInfo[1].data.length + 1) + ") ",
                    },
                    numFmt: hsFmt,
                    border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                    alignment: {
                        horizontal: "center",
                        wrapText: true,
                    },
                };
                totalRow.cells.push(cell);
            }
            sheetInfo[1].data.push(totalRow);
            this._reportFactory.appendData(sheetInfo);
        });
        return Promise.resolve();
    }
    async generateReport() {
        app_logs_1.logger.debug("Generating Employee Personnel Work Report xlsx");
        let fileObj;
        const sheetInfo = [
            {
                sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: this._locale }),
                headers: this.getGeneralHeaders(),
            },
            {
                sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.WORKING_DURATION", locale: this._locale }),
                headers: this.getWorkingDurationHeaders(),
            },
            {
                sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.ACCESS_LOGS", locale: this._locale }),
                headers: this.getAccessLogHeaders(),
                data: this._accessLogData,
            },
            {
                sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.LEAVES", locale: this._locale }),
                headers: this.getPermissionsHeaders(),
                data: this._permissionData,
            },
        ];
        const reportInfoSheetData = {
            reportNameValue: i18n_1.default.__({ phrase: "REPORT.PACS_USER_DAILY_TITLE", locale: this._locale }),
            filters: {
                userIds: [this._options.userId],
                dateTimeRange: {
                    startDateTime: this._options.dateRange.startDateTime,
                    endDateTime: this._options.dateRange.endDateTime,
                },
            },
        };
        await this._reportFactory.initialize({
            requesterUserId: this._request.requesterUserId,
            reportInfoSheetData,
            sheetInfo,
            profileColumnsIndex: 0,
        });
        await dal_manager_1.dbManager.accessPacs2.getEmployeeDaysFiltered(this._request.organizationId, this._request.requesterUserId, {
            startDate: new Date(this._options.dateRange.startDateTime),
            endDate: new Date(this._options.dateRange.endDateTime),
            userIds: [this._options.userId],
            workStatusFilter: this._options.workStatusFilter,
            sortType: 1,
            sortOrder: "ASC",
            take: null,
            skip: null,
        }, this.onDataCallbackFunctionReader.bind(this));
        fileObj = await this._reportFactory.finalize(reportInfoSheetData);
        return {
            format: app_enums_1.enums.ReportFormat.Excel,
            preparedReportId: fileObj.fileId,
            filePath: fileObj.filePath,
            notificationType: undefined,
            reportType: app_enums_1.enums.ReportCode.PacsEmployeeWorkingHoursSummary,
            sendFileInAttachments: undefined,
        };
    }
    getGeneralHeaders() {
        return [
            {
                phrase: "EXCEL-REPORT.DATE",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.STATUS",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.USED_PERMISSION",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.LATE_ARRIVAL",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.EARLY_LEFT",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.MISSING_WORK",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.EXTRA_WORK",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.FIRST_START",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.LAST_LEAVE",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.WORKPLAN",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.EXPECTED_ENTRANCE",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.EXPECTED_EXIT",
                cellWidth: 30,
            },
        ];
    }
    getWorkingDurationHeaders() {
        return [
            {
                phrase: "EXCEL-REPORT.DATE",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.EXPECTED_WORK",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.ACTUAL_WORK",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.EXTRA_WORK",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.MISSING_WORK",
                cellWidth: 30,
            },
            {
                phrase: "PDF-REPORT.total_work_duration",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.PERMITTED_WORK",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.PUBLİC_HOLİDAY",
                cellWidth: 30,
            },
        ];
    }
    getAccessLogHeaders() {
        return [
            {
                phrase: "EXCEL-REPORT.DATE",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.HOUR",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.ACCESS_LOGS_ACCESS_POINT",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.DIRECTION",
                cellWidth: 30,
            },
        ];
    }
    getPermissionsHeaders() {
        return [
            {
                phrase: "PACS.USER_PPERMISSION_START_DATE",
                cellWidth: 30,
            },
            {
                phrase: "PACS.USER_PPERMISSION_END_DATE",
                cellWidth: 30,
            },
            {
                phrase: "PACS.PPERMISSION_TYPE_LABEL",
                cellWidth: 30,
            },
            {
                phrase: "REPORT.DATE",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL_REPORT.USED_DURATION",
                cellWidth: 30,
            },
        ];
    }
    async setAccessLogData() {
        await dal_manager_1.dbManager.accessLogPacs.getAccessLogsById({
            dateRange: this._options.dateRange,
            onData: this.onAccessLogData.bind(this),
            organizationId: this._request.organizationId,
            accessLogIds: this._accessLogIds,
        });
    }
    onAccessLogData(rows) {
        let accessLogRows = [];
        for (const row of rows) {
            let log = row[0];
            let date = (0, moment_1.default)(log.u);
            let logRow = {
                cells: [],
            };
            logRow.cells.push({
                value: {
                    formula: "DATE(" + date.year() + "," + (date.month() + 1) + "," + date.date() + ")",
                },
                numFmt: generator_1.ReportGenerator.Constants.DateFormat,
                border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                alignment: {
                    horizontal: "center",
                    vertical: "bottom",
                    wrapText: true,
                },
            });
            logRow.cells.push({
                value: {
                    formula: "TIME(" + date.hour() + "," + date.minute() + "," + date.second() + ")",
                },
                numFmt: generator_1.ReportGenerator.Constants.Time,
                border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                alignment: {
                    horizontal: "center",
                    vertical: "bottom",
                    wrapText: true,
                },
            });
            logRow.cells.push({
                value: log.an,
                border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                alignment: {
                    horizontal: "center",
                    vertical: "bottom",
                    wrapText: true,
                },
            });
            logRow.cells.push({
                value: log.d === app_enums_1.enums.AccessDirection.Entrance ? "Giriş" : log.d === app_enums_1.enums.AccessDirection.Exit ? "Çıkış" : undefined,
                border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                alignment: {
                    horizontal: "center",
                    vertical: "bottom",
                    wrapText: true,
                },
            });
            accessLogRows.push(logRow);
        }
        this._accessLogData = accessLogRows;
    }
    async setLeavesData(rows) {
        let permissionsData = [];
        const minutesInADay = 24 * 60;
        for (const row of rows) {
            for (const leave of row.data.p) {
                const permName = (this._ppermissions?.find((p) => p.ptid === leave.pt)).name;
                let rowData = {
                    cells: [],
                };
                rowData.cells.push({
                    value: luxon_1.DateTime.fromISO(leave.r.s)
                        .setLocale(this._locale)
                        .toLocaleString(luxon_1.DateTime.DATETIME_MED),
                    alignment: {
                        horizontal: "center",
                        vertical: "bottom",
                        wrapText: true,
                    },
                    border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                });
                rowData.cells.push({
                    value: luxon_1.DateTime.fromISO(leave.r.e)
                        .setLocale(this._locale)
                        .toLocaleString(luxon_1.DateTime.DATETIME_MED),
                    alignment: {
                        horizontal: "center",
                        vertical: "bottom",
                        wrapText: true,
                    },
                    border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                });
                rowData.cells.push({
                    value: permName,
                    alignment: {
                        horizontal: "center",
                        vertical: "bottom",
                        wrapText: true,
                    },
                    border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                });
                rowData.cells.push({
                    value: luxon_1.DateTime.fromJSDate(row.date).setLocale(this._locale).toLocaleString(luxon_1.DateTime.DATE_MED),
                    alignment: {
                        horizontal: "center",
                        vertical: "bottom",
                        wrapText: true,
                    },
                    border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                });
                rowData.cells.push({
                    value: leave.u / minutesInADay,
                    alignment: {
                        horizontal: "center",
                        vertical: "bottom",
                        wrapText: true,
                    },
                    border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                    numFmt: '[<0.000694444]"";[<0.0415][m]" ' +
                        i18n_1.default.__({ phrase: "EXCEL-REPORT.MINUTE_ABBREVATION", locale: this._locale }) +
                        '";[h] "' +
                        i18n_1.default.__({ phrase: "EXCEL-REPORT.HOUR_ABBREVATION", locale: this._locale }) +
                        ' " m "' +
                        i18n_1.default.__({ phrase: "EXCEL-REPORT.MINUTE_ABBREVATION", locale: this._locale }) +
                        '"',
                });
                permissionsData.push(rowData);
            }
        }
        permissionsData.sort((a, b) => {
            const nameA = String(a.cells[2].value).toLowerCase();
            const nameB = String(b.cells[2].value).toLowerCase();
            return nameA.localeCompare(nameB);
        });
        this._permissionData = permissionsData;
    }
}
exports.ExcelReportWorkSummaryOfEmployee = ExcelReportWorkSummaryOfEmployee;
