"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmployeeInstantAttendanceReport = void 0;
const dal_manager_1 = require("../../../dal/dal.manager");
const i18n_1 = __importDefault(require("i18n"));
const app_enums_1 = require("../../../app.enums");
const generator_1 = require("../generator");
const excel_report_refactory_1 = require("../excel.report.refactory");
const excel_report_column_extractor_1 = __importStar(require("../excel.report.column.extractor"));
const restapi_1 = require("../../../lib/es/models/restapi");
const employeeStatusAtSegmentStatusAll = -1;
const reportdef = {
    dataColumns: [
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.MissingWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExpectedWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.NormalWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.AccountedOffTimePermissionDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExtraWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.TotalWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.AttendanceStatusText,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.FirstInTime,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.LastOutTime,
    ],
};
class EmployeeInstantAttendanceReport extends generator_1.ReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._options = request.filter;
        this._reportFactory = new excel_report_refactory_1.ReportFactory(request.organizationId, locale);
    }
    async generateReport() {
        const headers = [
            {
                phrase: "PDF-REPORT.less_working_with_permission",
                cellWidth: 20,
            },
            {
                phrase: "PDF-REPORT.expected_workplan",
                cellWidth: 20,
            },
            {
                phrase: "PDF-REPORT.actual_working",
                cellWidth: 20,
            },
            {
                phrase: "PDF-REPORT.day_off",
                cellWidth: 20,
            },
            {
                phrase: "PDF-REPORT.extra_working",
                cellWidth: 20,
            },
            {
                phrase: "PDF-REPORT.total_work_duration",
                cellWidth: 20,
            },
            {
                phrase: "EXCEL-REPORT.STATUS",
                cellWidth: 20,
            },
            {
                phrase: "EXCEL-REPORT.FIRST_START",
                cellWidth: 20,
            },
            {
                phrase: "EXCEL-REPORT.LAST_LEAVE",
                cellWidth: 20,
            },
        ];
        let sheetInfo = [
            {
                sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.EMPLOYEE_INSTANT_ATTENDANCE_REPORT", locale: this._locale }),
                headers,
            },
        ];
        const reportInfoSheetData = {
            reportNamePhrase: "EXCEL-REPORT.EMPLOYEE_INSTANT_ATTENDANCE_REPORT",
            filters: {
                orgUnitIds: this._options.idBasedUserFilter.organizationUnitIds,
                applyOrganizationUnitFilterHierarchically: this._options.idBasedUserFilter.applyOrganizationUnitFilterHierarchically,
                employeeStatusAtSegmentStatus: this._options.employeeStatusAtSegment.status || employeeStatusAtSegmentStatusAll,
                employeeStatusAtSegmentWorking: this._options.employeeStatusAtSegment.working,
                employeeStatusAtSegmentInRegion: this._options.employeeStatusAtSegment.inRegion,
            },
        };
        await this._reportFactory.initialize({
            requesterUserId: this._request.requesterUserId,
            userIds: [],
            reportInfoSheetData,
            sheetInfo,
        });
        const context = {
            locale: this._locale,
        };
        await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
            return await dal_manager_1.dbManager.accessPacs2.getEmployeeDaysFiltered(this._request.organizationId, this._request.requesterUserId, {
                startDate: new Date(this._options.dateTime),
                endDate: new Date(this._options.dateTime),
                organizationUnitIds: this._options.idBasedUserFilter?.organizationUnitIds,
                organizationUnitHierarchically: this._options.idBasedUserFilter?.applyOrganizationUnitFilterHierarchically,
                status: restapi_1.IdentityStatusType.Enabled,
                sortType: 1,
                sortOrder: "ASC",
                take: null,
                skip: null,
            }, async (rows) => {
                const userIds = rows.map((item) => item.userId);
                await this._reportFactory.appendToUserInfo(userIds);
                const sheetInfo = [
                    {
                        sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.EMPLOYEE_INSTANT_ATTENDANCE_REPORT", locale: this._locale }),
                        data: [],
                    },
                ];
                rows.map((row) => {
                    let employeeStatuses = row.data.c || [];
                    let validStatuses = dal_manager_1.dbManager.accessPacs2.collectAttendanceEmployeeTimeRangeTypePair(this._options.employeeStatusAtSegment);
                    let isValid = employeeStatuses.some((status) => validStatuses.some((valid) => {
                        if (valid.at !== undefined && valid.et !== undefined) {
                            return (status.at === valid.at &&
                                status.et === valid.et &&
                                new Date(this._options.dateTime) >= new Date(status.s) &&
                                new Date(this._options.dateTime) <= new Date(status.e));
                        }
                        if (valid.at !== undefined) {
                            return status.at === valid.at && new Date(this._options.dateTime) >= new Date(status.s) && new Date(this._options.dateTime) <= new Date(status.e);
                        }
                        if (valid.et !== undefined) {
                            return status.et === valid.et && new Date(this._options.dateTime) >= new Date(status.s) && new Date(this._options.dateTime) <= new Date(status.e);
                        }
                        return false;
                    }));
                    if (isValid) {
                        let generatedCells = [];
                        for (const element of reportdef.dataColumns) {
                            if (row.data) {
                                generatedCells.push(excel_report_column_extractor_1.default.invoke(element, row.data, context, trx));
                            }
                        }
                        sheetInfo[0].data.push({
                            userId: row.userId,
                            cells: generatedCells,
                        });
                    }
                });
                this._reportFactory.appendData(sheetInfo);
            });
        }, this._request.requesterUserId, this._request.organizationId);
        const fileObj = await this._reportFactory.finalize(reportInfoSheetData);
        return {
            format: app_enums_1.enums.ReportFormat.Excel,
            preparedReportId: fileObj.fileId,
            filePath: fileObj.filePath,
            notificationType: undefined,
            reportType: app_enums_1.enums.ReportCode.InstantAttendanceStatus,
            sendFileInAttachments: undefined,
        };
    }
}
exports.EmployeeInstantAttendanceReport = EmployeeInstantAttendanceReport;
