"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DurationInRegionOverviewReport = void 0;
const app_logs_1 = require("../../../app.logs");
const dal_manager_1 = require("../../../dal/dal.manager");
const i18n_1 = __importDefault(require("i18n"));
const app_enums_1 = require("../../../app.enums");
const generator_1 = require("../generator");
const report_util_1 = require("../report.util");
const excel_report_refactory_1 = require("../excel.report.refactory");
class DurationInRegionOverviewReport extends generator_1.ReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._options = request.filter;
    }
    async generateReport() {
        try {
            const region = await dal_manager_1.dbManager.accessRegion.getRegionIdName(this._request.organizationId, [this._options.regionId]);
            const data = await dal_manager_1.dbManager.organizationTransaction(async (trx) => dal_manager_1.dbManager.accessRegion.getDurationInRegionReportOverview(this._request.organizationId, this._request.requesterUserId, trx, undefined, this._options), this._request.requesterUserId, this._request.organizationId);
            const userIds = [...new Set(data.items.map((item) => item.user.id))];
            const generalSheetData = data.items.map((item) => ({
                userId: item.user.id,
                cells: [
                    {
                        value: item.duration
                            ? i18n_1.default.__({ phrase: "PDF.PDF_MINUTE_HOUR", locale: this._locale }, { hour: (0, report_util_1.convertSecondsToHoursMinutes)(item.duration).hours.toString(), minute: (0, report_util_1.convertSecondsToHoursMinutes)(item.duration).minutes.toString() })
                            : "",
                    },
                    { value: region[0]?.name ?? "" },
                ],
            }));
            const sheetInfo = [
                {
                    sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: this._locale }),
                    headers: [
                        { phrase: "EXCEL-REPORT.SPENT_DURATION_IN_REGION", width: 40 },
                        { phrase: "EXCEL-REPORT.REGION", width: 40 },
                    ],
                    data: generalSheetData,
                },
            ];
            const reportInfoSheetData = {
                reportNamePhrase: "EXCEL-REPORT.SPENT_DURATION_IN_REGION",
                filters: {
                    regionId: this._options.regionId,
                    orgUnitIds: this._options.organizationUnitIds,
                    userIds: this._options.userIds,
                    userGroupIds: this._options.userGroupIds,
                    applyOrganizationUnitFilterHierarchically: this._options.applyOrganizationUnitFilterHierarchically,
                    dateTimeRange: { startDateTime: this._options.range.start, endDateTime: this._options.range.end },
                },
            };
            const reportFactory = new excel_report_refactory_1.ReportFactory(this._request.organizationId, this._locale);
            await reportFactory.initialize({
                requesterUserId: this._request.requesterUserId,
                userIds,
                reportInfoSheetData,
                sheetInfo,
            });
            reportFactory.appendData(sheetInfo);
            const fileObj = await reportFactory.finalize(reportInfoSheetData);
            return {
                format: app_enums_1.enums.ReportFormat.Excel,
                preparedReportId: fileObj.fileId,
                filePath: fileObj.filePath,
                notificationType: undefined,
                reportType: app_enums_1.enums.ReportCode.DurationInRegionReportOverview,
                sendFileInAttachments: undefined,
            };
        }
        catch (error) {
            app_logs_1.logger.error(`Error generating DurationInRegionOverviewReport: ${error.message}`, {
                stack: error.stack,
                organizationId: this._request.organizationId,
                requesterUserId: this._request.requesterUserId,
            });
            throw new Error("Failed to generate DurationInRegionOverviewReport");
        }
    }
}
exports.DurationInRegionOverviewReport = DurationInRegionOverviewReport;
