"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PacsMontlyWorkSummaryExcelReport = void 0;
const luxon_1 = require("luxon");
const dal_manager_1 = require("../../../dal/dal.manager");
const i18n_1 = __importDefault(require("i18n"));
const app_logs_1 = require("../../../app.logs");
const app_enums_1 = require("../../../app.enums");
const generator_1 = require("../generator");
const excel_report_refactory_1 = require("../excel.report.refactory");
const excel_report_column_extractor_1 = __importStar(require("../excel.report.column.extractor"));
const reportdef = {
    dataColumns: [
        excel_report_column_extractor_1.EmployeeDayTotalDataColumnTypes.NormalWorkDuration,
        excel_report_column_extractor_1.EmployeeDayTotalDataColumnTypes.ExtraWorkDuration,
        excel_report_column_extractor_1.EmployeeDayTotalDataColumnTypes.TotalWorkDuration,
        excel_report_column_extractor_1.EmployeeDayTotalDataColumnTypes.MissingWorkDuration,
        excel_report_column_extractor_1.EmployeeDayTotalDataColumnTypes.ExpectedWorkDuration,
    ],
};
class PacsMontlyWorkSummaryExcelReport extends generator_1.ReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._options = request.filter;
        this._reportFactory = new excel_report_refactory_1.ReportFactory(request.organizationId, locale);
    }
    async generateReport() {
        try {
            const dateFilter = this._options.dateFilter;
            if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Annually && dateFilter.year) {
                this._begin = luxon_1.DateTime.fromObject({ year: dateFilter.year, month: 1, day: 1 }).startOf("year");
                this._end = this._begin.endOf("year");
            }
            else if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Monthly && dateFilter.month) {
                this._begin = luxon_1.DateTime.fromObject({ year: dateFilter.year, month: dateFilter.month, day: 1 }).startOf("month");
                this._end = this._begin.endOf("month");
            }
            else if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Whole && dateFilter.range?.startDateTime && dateFilter.range?.endDateTime) {
                this._begin = luxon_1.DateTime.fromJSDate(new Date(dateFilter.range.startDateTime)).startOf("day");
                this._end = luxon_1.DateTime.fromJSDate(new Date(dateFilter.range.endDateTime)).endOf("day");
            }
            let headers = [
                {
                    phrase: "EXCEL-REPORT.ACTUAL_WORK",
                    width: 20,
                },
                {
                    phrase: "EXCEL-REPORT.EXTRA_WORK",
                    width: 20,
                },
                {
                    phrase: "EXCEL-REPORT.TOTAL_WORKING",
                    width: 20,
                },
                {
                    phrase: "EXCEL-REPORT.INCOMPLETE_OVERTIME",
                    width: 20,
                },
                {
                    phrase: "EXCEL-REPORT.EXPECTED_WORKTIME",
                    width: 20,
                },
            ];
            if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Monthly) {
                headers.unshift({
                    phrase: "EXCEL-REPORT.CONTROL_STATUS",
                    width: 20,
                });
            }
            const sheetInfo = [
                {
                    sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: this._locale }),
                    headers,
                },
            ];
            const reportInfoSheetData = {
                reportNamePhrase: "REPORT.PACS_EXCEL_MONTHLY_EXTRA_HOURS",
                filters: {
                    orgUnitIds: this._options.userFilter.organizationUnitIds,
                    applyOrganizationUnitFilterHierarchically: this._options.userFilter.applyOrganizationUnitFilterHierarchically,
                    userGroupIds: this._options.userFilter.userGroupIds,
                    userIds: this._options.userFilter.userIds,
                    workplanIds: this._options.userFilter.workPlanIds,
                    dateTimeRange: {
                        startDateTime: this._begin.toJSDate(),
                        endDateTime: this._end.toJSDate(),
                    },
                },
            };
            await this._reportFactory.initialize({
                requesterUserId: this._request.requesterUserId,
                userIds: [],
                reportInfoSheetData,
                sheetInfo,
            });
            let totalNormalWorkDuration = 0;
            let totalExtraWorkDuration = 0;
            let totalMissedWorkDuration = 0;
            let totalExpectedWorkDuration = 0;
            const context = {
                locale: this._locale,
            };
            await dal_manager_1.dbManager.organizationTransaction(async (trx) => {
                return await dal_manager_1.dbManager.accessPacs2.getEmployeeDaysDateRangeFiltered(this._request.organizationId, this._request.requesterUserId, {
                    startDate: this._begin,
                    endDate: this._end,
                    workPlanIds: this._options.userFilter?.workPlanIds,
                    userIds: this._options.userFilter?.userIds,
                    userGroupIds: this._options.userFilter?.userGroupIds,
                    organizationUnitIds: this._options.userFilter?.organizationUnitIds,
                    organizationUnitHierarchically: this._options.userFilter?.applyOrganizationUnitFilterHierarchically,
                    status: this._options.userFilter?.userOrganizationStatus,
                }, trx, async (rows) => {
                    const userIds = rows.map((item) => item.userId);
                    await this._reportFactory.appendToUserInfo(userIds);
                    const sheetInfo = [
                        {
                            sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: this._locale }),
                            data: [],
                        },
                    ];
                    rows.map((row) => {
                        totalNormalWorkDuration += row.data.n;
                        totalExtraWorkDuration += row.data.e;
                        totalMissedWorkDuration += row.data.m;
                        totalExpectedWorkDuration += row.data.ew;
                        let generatedCells = [];
                        for (const element of reportdef.dataColumns) {
                            generatedCells.push(excel_report_column_extractor_1.default.invoke(element, row.data, context, trx));
                        }
                        if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Monthly) {
                            generatedCells.unshift({
                                value: row.isChecked ?? false
                                    ? i18n_1.default.__({ phrase: "EXCEL-REPORT.CONTROL_STATE_APPROVED", locale: this._locale })
                                    : i18n_1.default.__({ phrase: "EXCEL-REPORT.CONTROL_STATE_WAITING", locale: this._locale }),
                                border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                            });
                        }
                        sheetInfo[0].data.push({
                            userId: row.userId,
                            cells: generatedCells,
                        });
                    });
                    this._reportFactory.appendData(sheetInfo);
                });
            }, this._request.requesterUserId, this._request.organizationId);
            totalNormalWorkDuration = totalNormalWorkDuration / (24 * 60);
            totalExtraWorkDuration = totalExtraWorkDuration / (24 * 60);
            totalMissedWorkDuration = totalMissedWorkDuration / (24 * 60);
            totalExpectedWorkDuration = totalExpectedWorkDuration / (24 * 60);
            sheetInfo[0].data = [
                {
                    userId: null,
                    cells: [
                        {
                            border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                            value: totalNormalWorkDuration,
                            fillColor: "B8CCE4",
                            numFmt: excel_report_column_extractor_1.default.getDurationFormatExcel(this._locale),
                        },
                        {
                            border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                            value: totalExtraWorkDuration,
                            fillColor: "B8CCE4",
                            numFmt: excel_report_column_extractor_1.default.getDurationFormatExcel(this._locale),
                        },
                        {
                            border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                            value: totalNormalWorkDuration + totalExtraWorkDuration,
                            fillColor: "B8CCE4",
                            numFmt: excel_report_column_extractor_1.default.getDurationFormatExcel(this._locale),
                        },
                        {
                            border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                            value: totalMissedWorkDuration,
                            fillColor: "B8CCE4",
                            numFmt: excel_report_column_extractor_1.default.getDurationFormatExcel(this._locale),
                        },
                        {
                            border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                            value: totalExpectedWorkDuration,
                            fillColor: "B8CCE4",
                            numFmt: excel_report_column_extractor_1.default.getDurationFormatExcel(this._locale),
                        },
                    ],
                },
            ];
            if (dateFilter.group === app_enums_1.enums.MonthlySummaryReportDateFilterGroup.Monthly) {
                sheetInfo[0].data[0].cells.unshift({
                    border: generator_1.ReportGenerator.Constants.Styling.AllThin,
                    value: "",
                    fillColor: "B8CCE4",
                });
            }
            this._reportFactory.appendData(sheetInfo);
            const fileObj = await this._reportFactory.finalize(reportInfoSheetData);
            return {
                format: app_enums_1.enums.ReportFormat.Excel,
                preparedReportId: fileObj.fileId,
                filePath: fileObj.filePath,
                notificationType: undefined,
                reportType: app_enums_1.enums.ReportCode.PacsMonthlyWorkingHoursSummary,
                sendFileInAttachments: undefined,
            };
        }
        catch (error) {
            app_logs_1.logger.error(`Error generating PacsMontlyWorkSummaryExcelReport: ${error.message}`, {
                stack: error.stack,
                organizationId: this._request.organizationId,
                requesterUserId: this._request.requesterUserId,
            });
            throw new Error("Failed to generate PacsMontlyWorkSummaryExcelReport");
        }
    }
}
exports.PacsMontlyWorkSummaryExcelReport = PacsMontlyWorkSummaryExcelReport;
