"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DailyFirstEntranceLastExitSummaryReport = void 0;
const i18n_1 = __importDefault(require("i18n"));
const app_enums_1 = require("../../../app.enums");
const app_logs_1 = require("../../../app.logs");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_db_armon_schema_1 = require("../../../dal/db/armon/dal.db.armon.schema");
const excel_report_column_extractor_1 = __importStar(require("../excel.report.column.extractor"));
const excel_report_refactory_1 = require("../excel.report.refactory");
const generator_1 = require("../generator");
const reportGeneralDef = {
    dataColumns: [
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.Date,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.FirstInTime,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.LastOutTime,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.AttendanceStatusText,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.UsedPermissions,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.WorkplanText,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExpectedEntrance,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExpectedLeave,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExpectedWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.NormalWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.MissingWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExtraWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.PhysicallyInRegionDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.FixedBreakDuration,
    ],
};
const reportSummaryDef = {
    dataColumns: [
        excel_report_column_extractor_1.EmployeeBasedDataColumnTypes.ExpectedWorkDays,
        excel_report_column_extractor_1.EmployeeBasedDataColumnTypes.DaysStartedWorkingOnTime,
        excel_report_column_extractor_1.EmployeeBasedDataColumnTypes.DaysStartedWorkingEarlyAndOnTime,
        excel_report_column_extractor_1.EmployeeBasedDataColumnTypes.DaysStartedWorkingLateInTolerance,
        excel_report_column_extractor_1.EmployeeBasedDataColumnTypes.DaysBeingLate,
        excel_report_column_extractor_1.EmployeeBasedDataColumnTypes.DaysEarlyLeave,
        excel_report_column_extractor_1.EmployeeBasedDataColumnTypes.DaysEarlyLeaveInTolerance,
        excel_report_column_extractor_1.EmployeeBasedDataColumnTypes.DaysExtraWork,
        excel_report_column_extractor_1.EmployeeBasedDataColumnTypes.UsedLeaveCount,
    ],
};
class DailyFirstEntranceLastExitSummaryReport extends generator_1.ReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._workplansWithPeriods = [];
        this._ppermissions = [];
        this._holidays = [];
        this._sheetInfo = [
            {
                sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: this._locale }),
                data: [],
                headers: this.getGeneralHeaders(),
            },
            {
                sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.SUMMARY", locale: this._locale }),
                data: [],
                headers: this.getSummaryHeaders(),
            },
        ];
        this._options = request.filter;
        this._reportFactory = new excel_report_refactory_1.ReportFactory(this._request.organizationId, this._locale);
    }
    async onPerEmployeeDataCallbackFunctionReader(rows) {
        app_logs_1.logger.debug("Fetch reader total data %s rows", rows.length);
        const wps = new Set();
        const leaveIds = new Set();
        const holidayIds = new Set();
        const userIds = rows.map((item) => item.userId);
        await this._reportFactory.appendToUserInfo(userIds);
        for (const row of rows) {
            row.days.forEach((day) => {
                day.w.forEach((w) => {
                    wps.add(w);
                });
            });
            row.days.forEach((day) => {
                day.p.forEach((leave) => {
                    leaveIds.add(leave.p);
                });
            });
            row.days.forEach((day) => {
                day.h.forEach((holiday) => {
                    holidayIds.add(holiday.h);
                });
            });
        }
        await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            if (wps.size !== 0) {
                const workplansWithPeriods = (await trx.query(`SELECT wp.id, wp.name , wpp."details"
						FROM "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}" wp
						LEFT JOIN "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.viewNames.vW_WorkPlanPeriodTstzrange}" wpp ON wpp."workPlanId" = wp.id
						WHERE wp."id" = ANY($1)`, [Array.from(wps)])).rows;
                this._workplansWithPeriods = [...this._workplansWithPeriods, ...workplansWithPeriods];
            }
            if (leaveIds.size !== 0) {
                const ppermissions = (await trx.query(`SELECT p."id" as pid, pt."id" as ptid, pt."name", p."status", p."startDateTime", p."endDateTime"
					FROM "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.ppermissionTypes}" pt
					INNER JOIN "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.ppermissions}" p ON p."ppermissionTypeId" = pt.id
					WHERE p."id" = ANY($1)`, [Array.from(leaveIds)])).rows;
                this._ppermissions = [...this._ppermissions, ...ppermissions];
            }
            if (holidayIds.size !== 0) {
                const holidays = (await trx.query(`SELECT id, title, "startDateTime", "endDateTime"
  					 FROM "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.vacations}"
   					 WHERE "id" = ANY($1)`, [Array.from(holidayIds)])).rows;
                this._holidays = [...this._holidays, ...holidays];
            }
            for (const employeeDays of rows) {
                employeeDays.days = employeeDays.days.sort((a, b) => new Date(a.d).getTime() - new Date(b.d).getTime());
                for (const day of employeeDays.days) {
                    let context = {
                        workplans: this._workplansWithPeriods,
                        leaves: this._ppermissions,
                        holidays: this._holidays,
                        user: {
                            id: employeeDays.userId,
                            name: employeeDays.name,
                            surname: employeeDays.surname,
                            uniqueId: employeeDays.uniqueId,
                        },
                        date: new Date(day.d),
                        locale: this._locale,
                    };
                    let generatedGeneralColumns = [];
                    if (day) {
                        for (const element of reportGeneralDef.dataColumns) {
                            generatedGeneralColumns.push(excel_report_column_extractor_1.default.invoke(element, day, context, trx));
                        }
                        this._sheetInfo[0].data.push({
                            userId: employeeDays.userId,
                            cells: generatedGeneralColumns,
                        });
                    }
                    else {
                        this._sheetInfo[0].data.push({
                            userId: employeeDays.userId,
                            cells: [
                                {
                                    value: i18n_1.default.__({ phrase: "EXCEL-REPORT.STILL_CALCULATING", locale: context.locale }),
                                    border: generator_1.ReportGenerator.Constants.Styling.AllDotted,
                                },
                            ],
                        });
                    }
                }
                let context = {
                    locale: this._locale,
                };
                if (employeeDays.days) {
                    let generatedSummaryColumns = [];
                    for (const element of reportSummaryDef.dataColumns) {
                        generatedSummaryColumns.push(excel_report_column_extractor_1.default.invoke(element, employeeDays.days, context));
                    }
                    this._sheetInfo[1].data.push({
                        userId: employeeDays.userId,
                        cells: generatedSummaryColumns,
                    });
                }
                else {
                    this._sheetInfo[1].data.push({
                        userId: employeeDays.userId,
                        cells: [
                            {
                                value: i18n_1.default.__({ phrase: "EXCEL-REPORT.STILL_CALCULATING", locale: context.locale }),
                                border: generator_1.ReportGenerator.Constants.Styling.AllDotted,
                            },
                        ],
                    });
                }
            }
        });
    }
    async generateReport() {
        try {
            let fileObj;
            const reportInfoSheetData = {
                reportNameValue: i18n_1.default.__({ phrase: "REPORT.PACS_USER_DAILY_TITLE", locale: this._locale }),
                filters: {
                    organizationUnitIds: this._options.userFilter.organizationUnitIds,
                    organizationUnitHierachially: this._options.userFilter.applyOrganizationUnitFilterHierarchically,
                    userIds: this._options.userFilter.userIds,
                    userGroupIds: this._options.userFilter.userGroupIds,
                    status: this._options.userFilter.userOrganizationStatus,
                    dateTimeRange: {
                        startDateTime: this._options.dateRange.startDateTime,
                        endDateTime: this._options.dateRange.endDateTime,
                    },
                },
            };
            await this._reportFactory.initialize({
                requesterUserId: this._request.requesterUserId,
                userIds: [],
                reportInfoSheetData,
                sheetInfo: this._sheetInfo,
            });
            await dal_manager_1.dbManager.accessPacs2.getEmployeeDaysPerEmployeeFiltered(this._request.organizationId, this._request.requesterUserId, {
                startDate: new Date(this._options.dateRange.startDateTime),
                endDate: new Date(this._options.dateRange.endDateTime),
                organizationUnitIds: this._options.userFilter?.organizationUnitIds,
                organizationUnitHierarchically: this._options.userFilter?.applyOrganizationUnitFilterHierarchically,
                userGroupIds: this._options.userFilter?.userGroupIds,
                userIds: this._options.userFilter?.userIds,
                status: this._options.userFilter.userOrganizationStatus,
                workStatusFilter: this._options.userFilter.workStatusFilter,
                workPlanIds: this._options.userFilter.workPlanIds,
                sortType: 1,
                sortOrder: "ASC",
                take: null,
                skip: null,
            }, this.onPerEmployeeDataCallbackFunctionReader.bind(this));
            this._reportFactory.appendData(this._sheetInfo);
            fileObj = await this._reportFactory.finalize(reportInfoSheetData);
            return {
                format: app_enums_1.enums.ReportFormat.Excel,
                preparedReportId: fileObj.fileId,
                filePath: fileObj.filePath,
                notificationType: undefined,
                reportType: app_enums_1.enums.ReportCode.PacsFirstInLastOutSummaryMultipleUsers,
                sendFileInAttachments: undefined,
            };
        }
        catch (error) {
            app_logs_1.logger.error(`Error generating EntryByUnitReport: ${error.message}`, {
                stack: error.stack,
                organizationId: this._request.organizationId,
                requesterUserId: this._request.requesterUserId,
            });
            throw new Error("Failed to generate EntryByUnitReport");
        }
    }
    getGeneralHeaders() {
        return [
            {
                phrase: "EXCEL-REPORT.DATE",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.FIRST_START",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.LAST_LEAVE",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.STATUS",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.USED_PERMISSION",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.WORKPLAN",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.EXPECTED_ENTRANCE",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.EXPECTED_EXIT",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.EXPECTED_WORK_DURATION",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.NORMAL_WORK_DURATION",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.MISSING_WORK",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.OVERTIME",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.PHYSICALLY_IN_REGION_DURATION",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.USED_TOTAL_BREAK_DURATION",
                width: 20,
            },
        ];
    }
    getSummaryHeaders() {
        return [
            {
                phrase: "EXCEL-REPORT.EXPECTED_WORK_DAYS",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.DAYS_STARTED_WORKING_ON_TIME",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.DAYS_STARTED_WORKING_EARLY_AND_ON_TIME",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.DAYS_STARTED_WORKING_LATE_IN_TOLERANCE",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.DAYS_BEING_LATE",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.DAYS_EARLY_LEAVE",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.DAYS_EARLY_LEAVE_IN_TOLERANCE",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.DAYS_EXTRA_WORK",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.DAYS_LEAVE_USED",
                width: 20,
            },
        ];
    }
}
exports.DailyFirstEntranceLastExitSummaryReport = DailyFirstEntranceLastExitSummaryReport;
