"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArventoAccessLogsReport = void 0;
const path = __importStar(require("path"));
const uuid_1 = __importDefault(require("uuid"));
const lodash_1 = __importDefault(require("lodash"));
const app_config_1 = require("../../../app.config");
const i18n_1 = __importDefault(require("i18n"));
const luxon_1 = require("luxon");
const dal_manager_1 = require("../../../dal/dal.manager");
const app_enums_1 = require("../../../app.enums");
const app_logs_1 = require("../../../app.logs");
const exceljs_1 = __importDefault(require("exceljs"));
const api_error_1 = require("../../../api/api.error");
const generator_1 = require("../generator");
const restapi_1 = require("../../../lib/es/models/restapi");
class ArventoAccessLogsReport extends generator_1.ReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._filter = this._request.filter;
        this._fileId = uuid_1.default.v4();
        this._filePath = path.join(app_config_1.appConfig.tmpDirectory, this._fileId + ".xlsx");
        this._currentDate = luxon_1.DateTime.now();
        this._wb = new exceljs_1.default.stream.xlsx.WorkbookWriter({
            filename: this._filePath,
            useStyles: true,
            useSharedStrings: true,
        });
    }
    async generateReport() {
        this._organizationName = (await dal_manager_1.dbManager.accessRedisCache.getOrganizationCache({ organizationId: this._request.organizationId })).n;
        app_logs_1.logger.debug("Organization Name : " + this._organizationName);
        this._ws = this._wb.addWorksheet(i18n_1.default.__({ phrase: "EXCEL-REPORT.VEHICLE_TRACKING_ACCESS_LOGS", locale: this._locale }), {
            pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
        });
        this._ws.properties.defaultRowHeight = 15;
        this._rowIndex = 8;
        let { caption: requestedUserCaption } = await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: this._request.organizationId, userId: this._request.requesterUserId });
        if (!requestedUserCaption) {
            throw new Error("Not found");
        }
        this._requestedUserCaption = requestedUserCaption[0].text[0];
        app_logs_1.logger.debug("Requested User : " + this._requestedUserCaption);
        this._wb.creator = this._requestedUserCaption;
        await this.addFilterToSheet(this._ws, 1, 1);
        this.initSheet(this._ws, 7, 1);
        app_logs_1.logger.debug("Generating report...");
        await this.constructExcel();
        app_logs_1.logger.debug("end of fetching");
        this._ws.pageSetup.printArea = "A1:" + this._ws.getColumn(this._ws.columns.length).letter + this._rowIndex;
        this._ws.pageSetup.printTitlesRow = "7:7";
        await this._wb.commit();
        app_logs_1.logger.debug("File is ready -> " + this._filePath);
        return {
            preparedReportId: this._fileId,
            filePath: this._filePath,
            format: app_enums_1.enums.ReportFormat.Excel,
            notificationType: undefined,
            reportType: app_enums_1.enums.ReportCode.AccessLogs,
            sendFileInAttachments: undefined,
        };
    }
    async addFilterToSheet(ws, startRowIndex, startColIndex) {
        let filterResult = await this.createFilters();
        let filtersArr = [];
        if (filterResult.users) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.IDENTITES", locale: this._locale }) + " : " + filterResult.users);
        }
        if (filterResult.organizationUnits) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.ORGANIZATION_UNITS", locale: this._locale }) + " : " + filterResult.organizationUnits);
        }
        if (filterResult.accessControlPoints) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.ACCESS_CONTROL_POINTS", locale: this._locale }) + " : " + filterResult.accessControlPoints);
        }
        if (filterResult.regions) {
            filtersArr.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.REGIONS", locale: this._locale }) + " : " + filterResult.regions);
        }
        if (this._filter.type) {
            filtersArr.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.ARVENTO_ACCESS_LOG_TYPE", locale: this._locale }) + " : " + this.getAccessLogType(this._filter.type));
        }
        if (this._filter.region) {
            filtersArr.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.REGION", locale: this._locale }) + " : " + this._filter.region);
        }
        if (this._filter.licencePlate) {
            filtersArr.push(i18n_1.default.__({ phrase: "PDF-REPORT.licence_plate", locale: this._locale }) + " : " + this._filter.licencePlate);
        }
        if (this._filter.isSynchronized !== undefined) {
            filtersArr.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.IS_SYNCHRONIZED", locale: this._locale }) + " : " + this.getIsSynchronizedValue(this._filter.isSynchronized));
        }
        if (filtersArr.length === 0) {
            filtersArr.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.NOT_EXISTING", locale: this._locale }));
        }
        app_logs_1.logger.debug("Applied Filters:");
        app_logs_1.logger.debug(filtersArr);
        app_logs_1.logger.debug(filtersArr.join("\r\n"));
        app_logs_1.logger.debug("\n");
        this.addFilterCell11(ws, startRowIndex, startColIndex, this._organizationName + " " + i18n_1.default.__({ phrase: "EXCEL-REPORT.VEHICLE_TRACKING_ACCESS_LOGS", locale: this._locale }), generator_1.ReportGenerator.Constants.Styling.AllThin, {
            bold: true,
        });
        this.addFilterCell11(ws, startRowIndex + 1, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.FILE_CREATION_DATE", locale: this._locale }), generator_1.ReportGenerator.Constants.Styling.AllThin);
        this.addFilterCell11(ws, startRowIndex + 1, startColIndex + 1, this._currentDate.setLocale(this._locale).toLocaleString(luxon_1.DateTime.DATE_FULL) + " " + this._currentDate.setLocale(this._locale).toLocaleString(luxon_1.DateTime.TIME_24_WITH_SECONDS), generator_1.ReportGenerator.Constants.Styling.AllThin, { italic: false });
        this.addFilterCell11(ws, startRowIndex + 2, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.REQUESTED_USER", locale: this._locale }), generator_1.ReportGenerator.Constants.Styling.AllThin);
        this.addFilterCell11(ws, startRowIndex + 2, startColIndex + 1, this._requestedUserCaption, generator_1.ReportGenerator.Constants.Styling.AllThin);
        this.addFilterCell11(ws, startRowIndex + 3, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.DATE_REPORT_BELONGS_TO", locale: this._locale }), generator_1.ReportGenerator.Constants.Styling.AllThin);
        this.addFilterCell11(ws, startRowIndex + 3, startColIndex + 1, filterResult.date, generator_1.ReportGenerator.Constants.Styling.AllThin);
        ws.mergeCells(startRowIndex, startColIndex, startRowIndex, startColIndex + 2);
        ws.mergeCells(startRowIndex + 1, startColIndex + 1, startRowIndex + 1, startColIndex + 2);
        ws.mergeCells(startRowIndex + 2, startColIndex + 1, startRowIndex + 2, startColIndex + 2);
        ws.mergeCells(startRowIndex + 3, startColIndex + 1, startRowIndex + 3, startColIndex + 2);
        ws.mergeCells(startRowIndex + 4, startColIndex + 1, startRowIndex + 4, startColIndex + 2);
        this.addFilterCell11(ws, startRowIndex + 4, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.APPLIED_FILTERS", locale: this._locale }), generator_1.ReportGenerator.Constants.Styling.AllThin);
        this.addFilterCell11(ws, startRowIndex + 4, startColIndex + 1, filtersArr.join("\r\n"), generator_1.ReportGenerator.Constants.Styling.AllThin);
        let filterlength = filtersArr.length;
        let row = ws.getRow(startRowIndex + 4);
        row.height = filterlength * 20;
    }
    initSheet(ws, startRowIndex, startColIndex) {
        let columns = [];
        let data = [
            {
                phrase: "EXCEL-REPORT.ACCESS_LOGS_USER",
                cellWidth: 30,
            },
            {
                phrase: "IDENTITY.UNIQUEID",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.ACCESS_LOGS_ACCESS_TIME",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.ACCESS_LOGS_ACCESS_POINT",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.ARVENTO_ACCESS_LOG_TYPE",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.IS_SYNCHRONIZED",
                cellWidth: 30,
            },
            {
                phrase: "EXCEL-REPORT.REGION",
                cellWidth: 30,
            },
            {
                phrase: "PDF-REPORT.licence_plate",
                cellWidth: 30,
            },
        ];
        startColIndex = this.addInitCellsToRow(data, columns, startColIndex, startRowIndex, ws);
        ws.autoFilter = {
            from: "A" + startRowIndex,
            to: ws.getColumn(columns.length).letter + startRowIndex,
        };
        ws.columns = columns;
        ws.views.push({ state: "frozen", ySplit: startRowIndex, activeCell: "A1", showGridLines: false });
    }
    async createFilters() {
        let date;
        const startDate = new Date(this._filter.startUtc);
        const endDate = new Date(this._filter.endUtc);
        if (startDate != null && endDate != null) {
            date =
                luxon_1.DateTime.fromJSDate(startDate).setLocale(this._locale).toLocaleString(luxon_1.DateTime.DATE_FULL) +
                    " " +
                    luxon_1.DateTime.fromJSDate(startDate).setLocale(this._locale).toLocaleString(luxon_1.DateTime.TIME_24_WITH_SECONDS) +
                    " - " +
                    luxon_1.DateTime.fromJSDate(endDate).setLocale(this._locale).toLocaleString(luxon_1.DateTime.DATE_FULL) +
                    " " +
                    luxon_1.DateTime.fromJSDate(endDate).setLocale(this._locale).toLocaleString(luxon_1.DateTime.TIME_24_WITH_SECONDS);
        }
        else if (startDate != null) {
            date =
                luxon_1.DateTime.fromJSDate(startDate).setLocale(this._locale).toLocaleString(luxon_1.DateTime.DATE_FULL) +
                    " " +
                    luxon_1.DateTime.fromJSDate(startDate).setLocale(this._locale).toLocaleString(luxon_1.DateTime.TIME_24_WITH_SECONDS);
        }
        let filterResult = await dal_manager_1.dbManager.accessReport.collectAccessLogReportFilterInfo(this._filter.userIds, this._filter.userGroupIds, this._filter.organizationUnitIds, this._filter.accessControlPointIds, this._filter.regionIds, this._request.organizationId);
        let users;
        if (filterResult.userCaptions != null && filterResult.userCaptions.length > 0) {
            let _res = "";
            filterResult.userCaptions.forEach((userCaption, index) => {
                _res += "";
                userCaption.captionLines.forEach((item, _index) => {
                    if (item.text != null && item.text != "__avatar") {
                        item.text.forEach((element) => {
                            if (element != null)
                                _res += element + (_index < filterResult.userCaptions.length - 1 ? " " : "");
                        });
                    }
                });
                _res += index < filterResult.userCaptions.length - 1 ? "\r\n" : "";
            });
            users = _res;
        }
        let userGroups;
        if (filterResult.userGroups != null && filterResult.userGroups.length > 0) {
            let res = "";
            filterResult.userGroups.forEach((userGroup, index) => {
                res += userGroup.name + (index < filterResult.userGroups.length - 1 ? "\r\n" : " ");
            });
            userGroups = res;
        }
        let organizationUnits;
        if (filterResult.organizationUnits != null && filterResult.organizationUnits.length > 0) {
            let res = "";
            filterResult.organizationUnits.forEach((org, index) => {
                res += org.name + (index < filterResult.organizationUnits.length - 1 ? "\r\n" : " ");
            });
            organizationUnits = res;
        }
        let regions;
        if (filterResult.regions != null && filterResult.regions.length > 0) {
            let res = "";
            filterResult.regions.forEach((org, index) => {
                res += org.name + (index < filterResult.regions.length - 1 ? "\r\n" : " ");
            });
            regions = res;
        }
        let accessControlPoints;
        if (filterResult.accessControlPoints != null && filterResult.accessControlPoints.length > 0) {
            let res = "";
            filterResult.accessControlPoints.forEach((acp, index) => {
                res += acp.name + (index < filterResult.accessControlPoints.length - 1 ? "\r\n" : " ");
            });
            accessControlPoints = res;
        }
        return {
            date: date,
            filterResult: filterResult,
            users: users,
            userGroups: userGroups,
            organizationUnits: organizationUnits,
            accessControlPoints: accessControlPoints,
            regions: regions,
        };
    }
    async constructExcel() {
        if (this._filter.authorizeForFilter) {
            let authResultForFilter = await dal_manager_1.dbManager.accessFunctions.dbFuncAuthorizeUserFor({
                organizationId: this._request.organizationId,
                userId: this._request.requesterUserId,
                organizationUnitIds: this._filter.organizationUnitIds,
                accessControlPointIds: this._filter.accessControlPointIds,
                userIds: this._filter.userIds,
                userGroupIds: this._filter.userGroupIds,
            });
            if (!authResultForFilter.result) {
                throw (0, api_error_1.generateForbiddenError)({ message: "Unauthorized filter items" });
            }
            if (lodash_1.default.isEmpty(this._filter.organizationUnitIds) && lodash_1.default.isEmpty(this._filter.userGroupIds) && lodash_1.default.isEmpty(this._filter.userIds)) {
                if (this._filter.permittedUnitIds) {
                    this._filter.organizationUnitIds = this._filter.permittedUnitIds;
                }
                else {
                    const userOrganizationUnits = await dal_manager_1.dbManager.armondb
                        .withSchema(this._request.organizationId)
                        .from("users as u")
                        .innerJoin("userOrganizations as uo", "uo.userId", "u.id")
                        .innerJoin("userOrganizationOrganizationUnits as uoou", "uoou.userOrganizationId", "uo.id")
                        .innerJoin("organizationUnits as ou", (join) => {
                        join.on(dal_manager_1.dbManager.armondb.raw(`ou."ancestorIds" like '%' || uoou."organizationUnitId" || '%'`)).orOn("ou.id", "uoou.organizationUnitId");
                    })
                        .whereNull("u.deletedAt")
                        .whereNull("uoou.deletedAt")
                        .whereNull("uo.deletedAt")
                        .where("uo.organizationId", this._request.organizationId)
                        .where("u.id", this._request.requesterUserId)
                        .select("ou.id");
                    this._filter.organizationUnitIds = userOrganizationUnits.map((u) => u.id);
                }
            }
        }
        let filterUsers = await dal_manager_1.dbManager.accessFunctions.dbFuncCollectUsersForAccessReportFilter({
            organizationId: this._request.organizationId,
            userIds: this._filter.userIds,
            organizationUnitIds: this._filter.organizationUnitIds,
            userGroupIds: this._filter.userGroupIds,
            filterOrganizationUnitMembersHierarchically: this._filter.filterOrganizationUnitMembersHierarchically,
        });
        let filterUserIds = (filterUsers && filterUsers.length) > 0 ? filterUsers.map((f) => f.userId) : [];
        this._filter.userIds = filterUserIds;
        const option = Object.assign(this._filter, {
            pagination: {
                take: app_config_1.appConfig.reportExportRowLimit,
                skip: undefined,
            },
        });
        const result = await dal_manager_1.dbManager.accessAccessLog.getArventoAccessLogs(this._request.organizationId, option, this._request.requesterUserId, this._filter.authorizeForFilter);
        this._userData = await dal_manager_1.dbManager.accessUser.getUsersFullnamesAndUniqueIds(this._request.organizationId, result.items.map((r) => r.userId));
        if (result) {
            app_logs_1.logger.debug("[AccessLogsReport]Fetch data %s rows", result.items.length);
            this.constructRows(result);
        }
    }
    createCellForAccessTime(utc) {
        if (utc) {
            let date = luxon_1.DateTime.fromJSDate(utc).setLocale(this._locale);
            return date.toLocaleString(luxon_1.DateTime.DATE_FULL) + " " + date.toLocaleString(luxon_1.DateTime.TIME_24_WITH_SECONDS);
        }
        else {
            return "";
        }
    }
    constructRows(rows) {
        rows.items.forEach((record) => {
            let colIndex = 1;
            let userData = this._userData.filter((user) => user.userId === record.userId)[0];
            const rowData = [
                userData.fullName,
                userData.uniqueId,
                this.createCellForAccessTime(record?.actionUtc) ?? "",
                record?.accessControlPointName ?? "",
                record?.type ? this.getAccessLogType(record?.type) : "",
                this.getIsSynchronizedValue(record?.isSynchronized) ?? "",
                record?.region ?? "",
                record?.licencePlate ?? "",
            ];
            colIndex = this.addCellsToRow(rowData, colIndex, this._rowIndex, this._ws);
            this._ws.getRow(this._rowIndex).commit();
            this._rowIndex++;
        });
    }
    getAccessLogType(accessLogType) {
        const translationKey = accessLogType === restapi_1.ArventoAccessLogType.ArventoQr ? "EXCEL-REPORT.ARVENTO_QR_ACCESS_LOG" : "EXCEL-REPORT.ARVENTO_REGION_ACCESS_LOG";
        return i18n_1.default.__({ phrase: translationKey, locale: this._locale });
    }
    getIsSynchronizedValue(isSynchronized) {
        if (isSynchronized !== undefined) {
            const translationKey = isSynchronized ? "EXCEL-REPORT.YES" : "EXCEL-REPORT.NO";
            return i18n_1.default.__({ phrase: translationKey, locale: this._locale });
        }
        return "";
    }
}
exports.ArventoAccessLogsReport = ArventoAccessLogsReport;
