"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.splitDateRangeAccordingToIntersections = void 0;
const lodash_1 = require("lodash");
function splitDateRangeAccordingToIntersections(xRange, oRange, x, o) {
    let result = [];
    let rint = xRange.intersect(oRange);
    if (rint) {
        let rsubs = xRange.subtract(rint);
        o.range = rint;
        x.range = undefined;
        if (rsubs && rsubs.length > 0) {
            if (rsubs.length === 2) {
                result.push(Object.assign({}, (0, lodash_1.cloneDeep)(x), { range: rsubs[0] }));
                result.push(o);
                result.push(Object.assign({}, (0, lodash_1.cloneDeep)(x), { range: rsubs[1] }));
            }
            else if (rsubs.length === 1) {
                if (rsubs[0].start.isBefore(rint.start)) {
                    x.range = rsubs[0];
                    result.push(x);
                    result.push(o);
                }
                else {
                    result.push(o);
                    x.range = rsubs[0];
                    result.push(x);
                }
            }
        }
        else {
            result.push(o);
        }
    }
    else {
        result.push(o);
    }
    return result;
}
exports.splitDateRangeAccordingToIntersections = splitDateRangeAccordingToIntersections;
