"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PacsModels = void 0;
var PacsModels;
(function (PacsModels) {
    PacsModels.dateFormat = "YYYYMMDD";
    PacsModels.timeFormat = "HHmm";
    PacsModels.dateTimeFormat = PacsModels.dateFormat + PacsModels.timeFormat;
    let PacsErrorCodes;
    (function (PacsErrorCodes) {
        PacsErrorCodes[PacsErrorCodes["MultiWorkingHoursIntersecting"] = 1] = "MultiWorkingHoursIntersecting";
        PacsErrorCodes[PacsErrorCodes["WorkingHoursNotIntersectCalculationInterval"] = 2] = "WorkingHoursNotIntersectCalculationInterval";
        PacsErrorCodes[PacsErrorCodes["MultiFixedBreaksIntersecting"] = 3] = "MultiFixedBreaksIntersecting";
        PacsErrorCodes[PacsErrorCodes["HolidayNotIntersectCalculationInterval"] = 4] = "HolidayNotIntersectCalculationInterval";
        PacsErrorCodes[PacsErrorCodes["PermissionCollusion"] = 5] = "PermissionCollusion";
        PacsErrorCodes[PacsErrorCodes["FlexibleWorkPlansMustContainTheWholeDay"] = 6] = "FlexibleWorkPlansMustContainTheWholeDay";
        PacsErrorCodes[PacsErrorCodes["EmployeeCanWorkOnlyOneFlexibleWorkPlanForaDay"] = 7] = "EmployeeCanWorkOnlyOneFlexibleWorkPlanForaDay";
    })(PacsErrorCodes = PacsModels.PacsErrorCodes || (PacsModels.PacsErrorCodes = {}));
    class PacsError extends Error {
        constructor(code, message) {
            super(message);
            this._code = code;
        }
        get code() {
            return this._code;
        }
    }
    PacsModels.PacsError = PacsError;
    class MultiRangeError extends PacsError {
        constructor(code, ranges, message) {
            super(code, (message || "") +
                " [" +
                ranges
                    .map((r) => {
                    return r.start.format(PacsModels.dateTimeFormat) + " " + r.end.format(PacsModels.dateTimeFormat);
                })
                    .join("],[") +
                "]");
            this._ranges = ranges;
        }
        get ranges() {
            return this._ranges;
        }
    }
    PacsModels.MultiRangeError = MultiRangeError;
    class RangeError extends PacsError {
        constructor(code, range, message) {
            super(code, (message || "") + " " + range.start.format(PacsModels.dateTimeFormat) + " " + range.end.format(PacsModels.dateTimeFormat));
            this._range = range;
        }
        get range() {
            return this._range;
        }
    }
    PacsModels.RangeError = RangeError;
    let WorkPlanExcelSheetType;
    (function (WorkPlanExcelSheetType) {
        WorkPlanExcelSheetType["Input"] = "input";
    })(WorkPlanExcelSheetType = PacsModels.WorkPlanExcelSheetType || (PacsModels.WorkPlanExcelSheetType = {}));
    let AccessLogExcelSheetType;
    (function (AccessLogExcelSheetType) {
        AccessLogExcelSheetType["Input"] = "input";
    })(AccessLogExcelSheetType = PacsModels.AccessLogExcelSheetType || (PacsModels.AccessLogExcelSheetType = {}));
})(PacsModels = exports.PacsModels || (exports.PacsModels = {}));
