"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.intersectsWithHolidays = exports.calculateRangesExceptHolidays = void 0;
const moment_1 = __importDefault(require("moment"));
const moment_range_1 = require("moment-range");
function calculateRangesExceptHolidays(ranges, holidays) {
    let result = ranges;
    for (const h of holidays.items) {
        let newResult = [];
        for (const r of result) {
            let rint = r.intersect(new moment_range_1.DateRange(h.startDateTime, h.endDateTime));
            if (rint) {
                let rsubs = r.subtract(rint);
                if (rsubs && rsubs.length > 0) {
                    newResult.push(...rsubs);
                }
                else {
                    newResult.push(r);
                }
            }
            else {
                newResult.push(r);
            }
        }
        result = newResult;
    }
    return result;
}
exports.calculateRangesExceptHolidays = calculateRangesExceptHolidays;
function intersectsWithHolidays(start, end, holidays) {
    let intersects = { morning: false, afternoon: false };
    const dayStart = (0, moment_1.default)(start.clone()).startOf("day");
    let range = new moment_range_1.DateRange(start.clone(), end.clone());
    for (const h of holidays.items) {
        const holidayRange = new moment_range_1.DateRange(h.startDateTime, h.endDateTime);
        let morningRange = new moment_range_1.DateRange(dayStart.clone(), dayStart.clone().add(12, "h")).intersect(holidayRange);
        intersects.morning = intersects.morning || (morningRange ? morningRange.overlaps(range, { adjacent: false }) : false);
        let afternoonRange = new moment_range_1.DateRange(dayStart.clone().add(12, "h"), dayStart.clone().add(24, "h")).intersect(holidayRange);
        intersects.afternoon = intersects.afternoon || (afternoonRange ? afternoonRange.overlaps(range, { adjacent: false }) : false);
    }
    return intersects;
}
exports.intersectsWithHolidays = intersectsWithHolidays;
