"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.unsubscribeUrls = exports.generateNotificationContent = exports.generateNotificationInstance = void 0;
const enums_1 = require("../../lib/access-model/v2/enums");
const fs = __importStar(require("fs"));
const Handlebars = __importStar(require("handlebars"));
const translate = __importStar(require("i18n"));
const path = __importStar(require("path"));
const app_config_1 = require("../../app.config");
const app_enums_1 = require("../../app.enums");
const app_logs_1 = require("../../app.logs");
const dal_memcache_1 = require("../../dal/access/dal.memcache");
const dal_constants_1 = require("../../dal/dal.constants");
const dal_manager_1 = require("../../dal/dal.manager");
const dal_utils_1 = require("../../dal/dal.utils");
const restapi_1 = require("../../lib/es/models/restapi");
const business_hooks_1 = require("../business.hooks");
const business_main_1 = require("../business.main");
const report_util_1 = require("../report/report.util");
const business_visitor_1 = require("../visitor/business.visitor");
const moment = require("moment");
const uuid = require("uuid");
const luxon_1 = require("luxon");
async function generateNotificationInstance(amqpMessage) {
    let { o: organizationId, i: eventId, d: instanceData } = amqpMessage;
    let notification = await dal_manager_1.dbManager.accessNotifications.getNotificationOfEvent({ organizationId, eventId });
    const trxResult = await dal_manager_1.dbManager.pgTransactionMainDb(async (trx) => {
        try {
            notification = await setNotificationMediums(organizationId, notification, trx);
            if (isAllMediumsClose(notification)) {
                app_logs_1.logger.debug(`eventId:[${eventId}] All notification mediums are closed!!`);
                return { goToMultipleUser: false };
            }
            if (notification.type === app_enums_1.enums.NotificationType.ReportServiceError) {
                notification.sms = false;
                notification.web = true;
                notification.email = false;
            }
            else if (notification.type === app_enums_1.enums.NotificationType.VisitorInvitation) {
                let instanceMedium = instanceData.s;
                notification.sms = notification.sms && instanceMedium === app_enums_1.enums.VisitorCommunicationMediumType.PhoneNumber;
                notification.web = false;
                notification.email = notification.email && instanceMedium === app_enums_1.enums.VisitorCommunicationMediumType.Email;
                notification.pushNotification = false;
            }
            else if (notification.type === app_enums_1.enums.NotificationType.RegionEmergencyStart || notification.type === app_enums_1.enums.NotificationType.RegionEmergencyStopped) {
                notification.email = false;
            }
            else if (notification.type === app_enums_1.enums.NotificationType.AccountCreated) {
                notification.sms = false;
                notification.web = false;
                notification.email = true;
                notification.pushNotification = false;
            }
            else if (notification.type === app_enums_1.enums.NotificationType.AccessPointQrCodeUpdatedToUser) {
                notification.sms = false;
                notification.web = false;
                notification.email = false;
                notification.pushNotification = true;
            }
            let state = 1;
            if (isEmptyReportNotification(notification, instanceData)) {
                state = 7;
            }
            const singleUserId = notification.filter ? (0, dal_utils_1.getSingleUserIdFromFilter)(notification.filter) : instanceData.receiverUserIds?.length === 1 ? instanceData.receiverUserIds[0] : null;
            if (singleUserId) {
                const { d: isDisabled } = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId, userId: singleUserId, trx });
                if (isDisabled) {
                    state = 9;
                    app_logs_1.logger.warn("Disabled User Received Notification");
                }
                return {
                    goToMultipleUser: false,
                    singleUserNotifications: await generateNotificationInstanceForSingleUser(organizationId, { notification, userId: singleUserId, instanceData, state, eventId, amqpMessage }, trx),
                };
            }
            await dal_manager_1.dbManager.accessNotifications.createNotificationInstancesForUserFilter(organizationId, { notification, state, eventId, userIds: instanceData.receiverUserIds }, trx);
            if (state === 7) {
                return { goToMultipleUser: false, singleUserNotifications: [] };
            }
            return { goToMultipleUser: true };
        }
        catch (error) {
            app_logs_1.logger.debug(`Notification Service Error ${error}`);
        }
    });
    if (!trxResult.goToMultipleUser) {
        if (trxResult.singleUserNotifications?.length < 1) {
            app_logs_1.logger.warn("No allowed single user medium. Did you medium enable on notification table ?");
        }
        return;
    }
    let instances = [];
    do {
        try {
            await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                instances = await dal_manager_1.dbManager.accessNotifications.fetchPendingNotificationInstanceOfEvent(organizationId, { createdT: notification.createdT, eventId }, trx);
                if (instances.length > 0) {
                    await Promise.all(instances.map(async (instance) => {
                        try {
                            const receiverUser = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId, userId: instance.receiverUserId, trx: trx });
                            if (!receiverUser.l) {
                                receiverUser.l = i18n.getLocale();
                            }
                            const content = await generateNotificationContent({
                                organizationId,
                                notification,
                                medium: instance.medium,
                                receiverUser: { ...receiverUser, id: instance.receiverUserId },
                                instanceData,
                                unsubscribeUrls: instance.medium === app_enums_1.enums.NotificationMedium.Email
                                    ? await (0, exports.unsubscribeUrls)({
                                        organizationId,
                                        notificationType: notification.type,
                                        receiverUserId: instance.receiverUserId,
                                        locale: receiverUser.l,
                                        trx,
                                    })
                                    : undefined,
                            });
                            await dal_manager_1.dbManager.accessNotifications.setNotificationContent(organizationId, {
                                content,
                                id: instance.id,
                                createdT: instance.createdT,
                            }, trx);
                        }
                        catch (error) {
                            app_logs_1.logger.error("error while creating instance content: " + error.message);
                            app_logs_1.logger.error(error);
                        }
                    }));
                }
            });
        }
        catch (error) {
            app_logs_1.logger.error("error while creating the contents: " + error.message || error);
        }
    } while (instances.length > 0);
}
exports.generateNotificationInstance = generateNotificationInstance;
async function generateNotificationInstanceForSingleUser(organizationId, params, trx) {
    const result = [];
    const { notification, userId } = params;
    const receiverUser = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId, userId, trx });
    if (!receiverUser.l) {
        receiverUser.l = i18n.getLocale();
    }
    const userAllowedMediums = receiverUser.s.mediumSettings.custom?.[notification.type] ?? receiverUser.s.mediumSettings.general;
    const singleInstanceParams = {
        createdT: notification.createdT,
        mediumGroupId: uuid.v4(),
        notificationId: notification.notificationId,
        receiverUserId: userId,
    };
    if (notification.web) {
        const instance = { ...singleInstanceParams, id: uuid.v4(), medium: app_enums_1.enums.NotificationMedium.Web, state: params.state, eventId: params.eventId };
        if (!userAllowedMediums.web) {
            instance.state = 6;
            await dal_manager_1.dbManager.accessNotifications.addNotificationInstance(organizationId, instance, trx);
        }
        else {
            const content = await generateNotificationContent({
                organizationId,
                notification,
                medium: app_enums_1.enums.NotificationMedium.Web,
                trx,
                receiverUser: { ...receiverUser, id: instance.receiverUserId },
                instanceData: params.instanceData,
            });
            await dal_manager_1.dbManager.accessNotifications.addNotificationInstance(organizationId, {
                ...instance,
                content,
            }, trx);
            if (shouldSendNotification(notification.type, instance.state)) {
                result.push({
                    organizationId,
                    trx,
                    notification: {
                        instanceId: instance.id,
                        receiverUserId: instance.receiverUserId,
                        content,
                        type: notification.type,
                    },
                    medium: app_enums_1.enums.NotificationMedium.Web,
                    message: params.amqpMessage,
                });
            }
        }
    }
    if (notification.sms) {
        const instance = { ...singleInstanceParams, id: uuid.v4(), medium: app_enums_1.enums.NotificationMedium.SMS, state: params.state, eventId: params.eventId };
        if (!userAllowedMediums.sms) {
            instance.state = 6;
            await dal_manager_1.dbManager.accessNotifications.addNotificationInstance(organizationId, instance, trx);
        }
        else {
            const content = await generateNotificationContent({
                organizationId,
                notification,
                medium: app_enums_1.enums.NotificationMedium.SMS,
                trx,
                receiverUser: { ...receiverUser, id: instance.receiverUserId },
                instanceData: params.instanceData,
            });
            await dal_manager_1.dbManager.accessNotifications.addNotificationInstance(organizationId, {
                ...instance,
                content,
            }, trx);
            if (shouldSendNotification(notification.type, instance.state)) {
                result.push({
                    organizationId,
                    trx,
                    notification: {
                        instanceId: instance.id,
                        receiverUserId: instance.receiverUserId,
                        content,
                        type: notification.type,
                    },
                    medium: restapi_1.NotificationMedium.SMS,
                    message: params.amqpMessage,
                });
            }
        }
    }
    if (notification.email) {
        const instance = { ...singleInstanceParams, id: uuid.v4(), medium: app_enums_1.enums.NotificationMedium.Email, state: params.state, eventId: params.eventId };
        if (!userAllowedMediums.email) {
            instance.state = 6;
            await dal_manager_1.dbManager.accessNotifications.addNotificationInstance(organizationId, instance, trx);
        }
        else {
            const content = await generateNotificationContent({
                organizationId,
                notification,
                medium: app_enums_1.enums.NotificationMedium.Email,
                trx,
                receiverUser: { ...receiverUser, id: instance.receiverUserId },
                instanceData: params.instanceData,
                unsubscribeUrls: await (0, exports.unsubscribeUrls)({ organizationId, notificationType: notification.type, receiverUserId: instance.receiverUserId, locale: receiverUser.l, trx }),
            });
            await dal_manager_1.dbManager.accessNotifications.addNotificationInstance(organizationId, {
                ...instance,
                content,
            }, trx);
            if (instance.state === 7) {
                return;
            }
            if (shouldSendNotification(notification.type, instance.state)) {
                result.push({
                    organizationId,
                    notification: {
                        instanceId: instance.id,
                        content: content,
                        receiverUserId: instance.receiverUserId,
                        type: notification.type,
                    },
                    trx,
                    medium: restapi_1.NotificationMedium.Email,
                    message: params.amqpMessage,
                });
            }
        }
    }
    if (notification.pushNotification) {
        const instance = { ...singleInstanceParams, id: uuid.v4(), medium: app_enums_1.enums.NotificationMedium.PushNotification, state: params.state, eventId: params.eventId };
        if (!userAllowedMediums.pushNotification) {
            instance.state = 6;
            await dal_manager_1.dbManager.accessNotifications.addNotificationInstance(organizationId, instance, trx);
        }
        else {
            const content = await generateNotificationContent({
                organizationId,
                notification,
                medium: app_enums_1.enums.NotificationMedium.PushNotification,
                trx,
                receiverUser: { ...receiverUser, id: instance.receiverUserId },
                instanceData: params.instanceData,
            });
            await dal_manager_1.dbManager.accessNotifications.addNotificationInstance(organizationId, {
                ...instance,
                content,
            }, trx);
            if (shouldSendNotification(notification.type, instance.state)) {
                result.push({
                    notification: {
                        instanceId: instance.id,
                        content,
                        receiverUserId: instance.receiverUserId,
                        type: notification.type,
                    },
                    organizationId,
                    trx,
                    medium: restapi_1.NotificationMedium.PushNotification,
                    message: params.amqpMessage,
                });
            }
        }
    }
    return result;
}
async function generateNotificationContent(params) {
    let content;
    switch (params.notification.type) {
        case app_enums_1.enums.NotificationType.VisitorCame:
            content = await generateVisitorCameNotificationContent(params);
            break;
        case app_enums_1.enums.NotificationType.HugeReport:
            content = await generateHugeReportNotificationContent(params);
            break;
        case app_enums_1.enums.NotificationType.ScheduledReport:
            content = await generateScheduledReportNotificationContent(params);
            break;
        case app_enums_1.enums.NotificationType.TerminalEmergencyStarted:
            content = await generateTerminalEmergencyStartedNotificationContent(params);
            break;
        case app_enums_1.enums.NotificationType.TerminalEmergencyStopped:
            content = await generateTerminalEmergencyStoppedNotificationContent(params);
            break;
        case app_enums_1.enums.NotificationType.RegionEmergencyStart:
            content = await generateRegionEmergencyStartNotificationContent(params);
            break;
        case app_enums_1.enums.NotificationType.RegionEmergencyStopped:
            content = await generateRegionEmergencyStoppedNotificationContent(params);
            break;
        case app_enums_1.enums.NotificationType.NewFeedback:
            content = await generateNewFeedbackNotificationContent(params);
            break;
        case app_enums_1.enums.NotificationType.FeedbackUpdate:
            content = await generateUpdatedFeedbackNotification(params);
            break;
        case app_enums_1.enums.NotificationType.TerminalConnected:
            content = await generateDeviceConnectedNotification(params);
            break;
        case app_enums_1.enums.NotificationType.TerminalDisconnected:
            content = await generateDeviceDisconnectedNotification(params);
            break;
        case app_enums_1.enums.NotificationType.PPermissionWaitForApprovementToApprover:
            content = await generatePPermissionNeedApproveNotification(params);
            break;
        case app_enums_1.enums.NotificationType.PPermissionApprovementToOwner:
            content = await generatePPermissionApprovementToOwnerNotification(params);
            break;
        case app_enums_1.enums.NotificationType.PPermissionApprovementStatesCompleted:
            content = await generatePPermissionApprovementToManagersNotification(params);
            break;
        case app_enums_1.enums.NotificationType.PPermissionWaitForSignature:
            content = await generatePPermissionWaitForSignatureNotification(params);
            break;
        case app_enums_1.enums.NotificationType.PPermissionWaitForSignatureReminder:
            content = await generatePPermissionWaitForSignatureReminderNotification(params);
            break;
        case app_enums_1.enums.NotificationType.PACSSelfAbsentEmployee:
            content = await generatePACSSelfAbsentEmployeeNotification(params);
            break;
        case app_enums_1.enums.NotificationType.PACSSelfOverworkedEmployee:
            content = await generatePACSSelfOverworkedEmployeeNotification(params);
            break;
        case app_enums_1.enums.NotificationType.PACSSelfMissingWork:
            content = await generatePACSSelfMissingWorkNotification(params);
            break;
        case app_enums_1.enums.NotificationType.IdentityAccess:
            content = await generateIdentityAccessNotification(params);
            break;
        case app_enums_1.enums.NotificationType.SelfIdentityAccess:
            content = await generateSelfIdentityAccessNotification(params);
            break;
        case app_enums_1.enums.NotificationType.StatusSensor:
            content = await generateStatusSensorNotification(params);
            break;
        case app_enums_1.enums.NotificationType.CounterSensor:
            content = await generateCounterSensorNotification(params);
            break;
        case app_enums_1.enums.NotificationType.VisitorInvitation:
            content = await generateVisitorInvitationNotification(params);
            break;
        case app_enums_1.enums.NotificationType.Announcement:
            content = await generateAnnouncementNotification(params);
            break;
        case app_enums_1.enums.NotificationType.EmploymentEnd:
            content = await generateEmploymentEndNotification(params);
            break;
        case app_enums_1.enums.NotificationType.ReportServiceError:
            content = generateReportServiceErrorNotification(params);
            break;
        case app_enums_1.enums.NotificationType.DoorOpenedByForce:
            content = await generateDoorOpenedByForceNotification(params);
            break;
        case app_enums_1.enums.NotificationType.AccessPointQrCodeUpdatedToUser:
            content = generateAccessPointQrCodeUpdatedToUserNotification(params);
            break;
        case app_enums_1.enums.NotificationType.DeviceWasNotInformed:
            content = generateDeviceWasNotInformedNotification(params);
            break;
        case app_enums_1.enums.NotificationType.LicenseLimitReached:
            content = await generateLicenseLimitReachedNotification(params);
            break;
        case app_enums_1.enums.NotificationType.AccountCreated:
            content = await generateAccountCreatedNotification(params);
            break;
        case app_enums_1.enums.NotificationType.AssaAbloyDeviceBatteryStatusChanged:
            content = await generateAssaAbloyDeviceBatteryStatusChangedNotification(params);
            break;
        case app_enums_1.enums.NotificationType.VisitorExcelImportResultNotification:
            content = await generateVisitorExcelImportResultNotificationNotification(params);
            break;
        case app_enums_1.enums.NotificationType.AccessLogExcelImportResultNotification:
            content = await generateAccessLogExcelImportResultNotificationNotification(params);
            break;
        case app_enums_1.enums.NotificationType.WorkPlanExcelImportResultNotification:
            content = await generateWorkPlanExcelImportResultNotificationNotification(params);
            break;
        case app_enums_1.enums.NotificationType.SMSBalance:
            content = await generateSMSBalanceNotification(params);
            break;
        case app_enums_1.enums.NotificationType.SendingVerificationToken:
            content = await generateVerificationTokenForEnableMultiFactorAuth(params);
            break;
        case app_enums_1.enums.NotificationType.Custom:
            const hook = business_hooks_1.armonHookManager.getOrganizationCustomNotificationHook(params.organizationId);
            if (hook) {
                content = await hook(params);
            }
            break;
        default:
            app_logs_1.logger.error(`unknown notification type[${params.notification.type} orgId[${params.organizationId}]`);
            break;
    }
    return content;
}
exports.generateNotificationContent = generateNotificationContent;
function generateDeviceWasNotInformedNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    if (params.medium === app_enums_1.enums.NotificationMedium.Web) {
        return {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.OFFLINE_TERMINAL_CHANGES", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.OFFLINE_TERMINAL_CHANGES", locale }, { terminals: instanceData.t.map((terminal) => terminal.name).join(", ") }),
        };
    }
}
async function generateLicenseLimitReachedNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const translatedTitle = translate.__({ phrase: "NOTIFICATION.TITLE.MODULE_LIMIT_REACHED", locale }, { module: translate.__({ phrase: "LICENSE." + app_enums_1.enums.ArmonApplicationModule[instanceData.t].toUpperCase(), locale }) });
    const translatedBody = translate.__({ phrase: "NOTIFICATION.MESSAGE.MODULE_LIMIT_REACHED", locale }, { module: translate.__({ phrase: "LICENSE." + app_enums_1.enums.ArmonApplicationModule[instanceData.t].toUpperCase(), locale }) });
    switch (params.medium) {
        case app_enums_1.enums.NotificationMedium.PushNotification:
        case app_enums_1.enums.NotificationMedium.Web:
            const result = {
                title: translatedTitle,
                body: translatedBody,
                data: null,
            };
            if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
                return {
                    ...result,
                    token: params.receiverUser.n,
                    tokenType: params.receiverUser.z,
                };
            }
            else {
                return result;
            }
        case app_enums_1.enums.NotificationMedium.SMS:
            return {
                text: translatedBody,
                phoneNumber: params.receiverUser.m,
            };
        case app_enums_1.enums.NotificationMedium.Email: {
            return {
                subject: translatedTitle,
                html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "licenseLimitReached." + locale + ".handlebars"), "utf8"))({
                    title: translatedTitle,
                    body: translatedBody,
                    unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                    unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                    armonLogo: null,
                    year: new Date().getFullYear().toString(),
                }),
                to: params.receiverUser.e,
            };
        }
        default:
            break;
    }
}
function generateAccessPointQrCodeUpdatedToUserNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
        return {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.QRCODECHANGED", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.QRCODECHANGED", locale }),
            data: {
                o: params.organizationId,
                a: instanceData.a,
            },
            token: params.receiverUser.n,
            tokenType: params.receiverUser.z,
        };
    }
}
async function generateDoorOpenedByForceNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const { n: accessPointName } = await dal_manager_1.dbManager.accessRedisCache.getAccessPointCache({ organizationId: params.organizationId, accessPointId: instanceData.a });
    let user = null;
    if (instanceData.l) {
        let accessLog = await dal_manager_1.dbManager.accessLog.getLogDetailInfoById(params.organizationId, instanceData.l);
        if (accessLog) {
            user = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId: params.organizationId, userId: accessLog.log.o, trx: params.trx });
        }
    }
    const message = {
        title: translate.__({ phrase: "NOTIFICATION.TITLE.STATUSSENSOR", locale }),
        body: "",
        data: {
            a: instanceData.a,
            l: instanceData.l,
            r: instanceData.r,
            t: instanceData.t.toLocaleString(locale),
        },
    };
    switch (instanceData.r) {
        case enums_1.EnumsV2.StatusSensorReason.ExitButtonTriggeredRelayDrive:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSOREXITBUTTON", locale }, {
                accesscontrolpoint: accessPointName,
                date: instanceData.t.toLocaleString(locale),
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.LeavedOpenned:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORLEAVEOPENNED", locale }, {
                accesscontrolpoint: accessPointName,
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.ClosedAfterLeavedOpennedTimeout:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORCLOSEDAFTERLEAVEOPENNEDTIMEOUT", locale }, {
                accesscontrolpoint: accessPointName,
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.WiegandReaderTriggeredRelayDrive:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORACCESSDEVICE", locale }, {
                accesscontrolpoint: accessPointName,
                date: instanceData.t.toLocaleString(locale),
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.RemoteAccessTriggeredRelayDrive:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORREMOTEOPEN", locale }, {
                accesscontrolpoint: accessPointName,
                date: instanceData.t.toLocaleString(locale),
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.UnknownReasonOpenAlthoughRelayIsMapped:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORUNKNOWNOPENNEDWITHRELAY", locale }, {
                accesscontrolpoint: accessPointName,
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.UnknownReasonOpenRelayIsNotMapped:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORUNKNOWNOPENNEDWITHOUTRELAY", locale }, {
                accesscontrolpoint: accessPointName,
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.Closed:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORCLOSED", locale }, {
                accesscontrolpoint: accessPointName,
            });
            break;
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.STATUSSENSOR", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "status-sensor-notification." + locale + ".handlebars"), "utf8"))({
                text: message.body,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...message,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return message;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: message.body,
            phoneNumber: params.receiverUser.m,
        };
    }
}
function generateReportServiceErrorNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const reportname = instanceData?.t ? (0, business_main_1.transformReportCodeToLocalizedMessages)(instanceData.t, locale) : null;
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.REPORTSERVICEERROR", locale }),
            body: reportname
                ? translate.__({ phrase: "NOTIFICATION.MESSAGE.REPORTSERVICEERRORWITHREPORTNAME", locale }, {
                    reportname,
                })
                : translate.__({ phrase: "NOTIFICATION.MESSAGE.REPORTSERVICEERROR", locale }),
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
}
async function generatePACSSelfMissingWorkNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const user = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId: params.organizationId, userId: instanceData.u, trx: params.trx });
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        const hook = business_hooks_1.armonHookManager.getOnPACSSelfMissingWorkEmailNotificationHook(params.organizationId);
        if (hook) {
            return hook(params);
        }
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.PACSMISSINGWORK", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "pacs-missing-work-self." + locale + ".handlebars"), "utf8"))({
                fullname: user.f,
                duration: instanceData.d,
                enddate: new Date(instanceData.e).toLocaleString(locale),
                startdate: new Date(instanceData.s).toLocaleString(locale),
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.PACSMISSINGWORK", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.PACSMISSINGWORKSELF", locale }, {
                fullname: user.f,
                duration: instanceData.d + "",
                startdate: new Date(instanceData.s).toLocaleString(locale),
                enddate: new Date(instanceData.e).toLocaleString(locale),
            }),
            data: {
                u: instanceData.u,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.PACSMISSINGWORKSELF", locale }, {
                receiverFullname: params.receiverUser.f,
                startdate: new Date(instanceData.s).toLocaleString(locale),
                enddate: new Date(instanceData.e).toLocaleString(locale),
                duration: instanceData.d + "",
            }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generatePACSSelfAbsentEmployeeNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const user = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId: params.organizationId, userId: instanceData.u, trx: params.trx });
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        const hook = business_hooks_1.armonHookManager.getOnPACSSelfAbsentEmployeeEmailNotificationHook(params.organizationId);
        if (hook) {
            return hook(params);
        }
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.PACSABSENTEMPLOYEENOTIFICATIONSELF", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "pacs-absent-employee-self." + locale + ".handlebars"), "utf8"))({
                fullname: user.f,
                time: new Date().toLocaleString(locale),
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.PACSABSENTEMPLOYEENOTIFICATIONSELF", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.PACSABSENTEMPLOYEESELFNOTIFICATION", locale }, {
                fullname: user.f,
                time: new Date().toLocaleString(locale),
            }),
            data: {
                u: instanceData.u,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        const hook = business_hooks_1.armonHookManager.getOnPACSSelfAbsentEmployeeSMSNotificationHook(params.organizationId);
        if (hook) {
            return hook(params);
        }
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.PACSABSENTEMPLOYEESELFNOTIFICATION", locale }, {
                fullname: user.f,
                time: new Date(instanceData.e).toLocaleString(locale),
            }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generatePACSSelfOverworkedEmployeeNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const user = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId: params.organizationId, userId: instanceData.u, trx: params.trx });
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        const hook = business_hooks_1.armonHookManager.getOnPACSSelfOverworkedEmployeeEmailNotificationHook(params.organizationId);
        if (hook) {
            return hook(params);
        }
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.PACSOVERWORKEDEMPLOYEENOTIFICATIONSELF", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "pacs-overworked-employee-self." + locale + ".handlebars"), "utf8"))({
                fullname: user.f,
                time: new Date().toLocaleString(locale),
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.PACSOVERWORKEDEMPLOYEENOTIFICATIONSELF", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.PACSOVERWORKEDEMPLOYEESELFNOTIFICATION", locale }, {
                fullname: user.f,
                time: new Date().toLocaleString(locale),
            }),
            data: {
                u: instanceData.u,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        const hook = business_hooks_1.armonHookManager.getOnPACSSelfOverworkedEmployeeSMSNotificationHook(params.organizationId);
        if (hook) {
            return hook(params);
        }
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.PACSOVERWORKEDEMPLOYEESELFNOTIFICATION", locale }, {
                fullname: user.f,
                time: new Date(instanceData.e).toLocaleString(locale),
            }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateEmploymentEndNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.ANNOUNCEMENT", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "pastEmploymentEndUserAutoDisabled." + locale + ".handlebars"), "utf8"))({
                title: translate.__({ phrase: "NOTIFICATION.TITLE.PASTEMPLOYMENTENDUSER", locale }),
                message: translate.__({ phrase: "NOTIFICATION.MESSAGE.PASTEMPLOYMENTENDUSER", locale }),
                users: instanceData.u.map((userInfo) => {
                    return { username: userInfo.n };
                }),
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                footer: translate.__({ phrase: "NOTIFICATION-MAIL.footer", locale }) + " panel.armongate.com",
                year: moment().format("YYYY"),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.PASTEMPLOYMENTENDUSER", locale }, {}),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.PASTEMPLOYMENTENDUSER", locale: locale }),
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.MESSAGE.PASTEMPLOYMENTENDUSER", locale }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateAnnouncementNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    let attachmentList = undefined;
    if (instanceData.a) {
        attachmentList = await dal_manager_1.dbManager.accessNotifications.listAttachments(params.organizationId, instanceData.a);
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.ANNOUNCEMENT", locale }, { subject: instanceData.s }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "announcement." + locale + ".handlebars"), "utf8"))({
                title: instanceData.s,
                body: instanceData.b,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.ANNOUNCEMENT", locale }, { subject: instanceData.s }),
            body: instanceData.b,
            data: attachmentList
                ? {
                    i: attachmentList,
                }
                : undefined,
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.ANNOUNCEMENT", locale: locale }, { body: instanceData.b }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateVisitorInvitationNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const invitationInfo = instanceData.i;
    if (instanceData.s === app_enums_1.enums.VisitorCommunicationMediumType.Email) {
        let _organizationName = "";
        let _info = [];
        let _visitorName = "";
        if (invitationInfo.organizationContactInfo && invitationInfo.organizationContactInfo.name) {
            _organizationName = invitationInfo.organizationContactInfo.name;
        }
        if (invitationInfo.visitorProfile && invitationInfo.visitorProfile.fields && invitationInfo.visitorProfile.fields.name) {
            _visitorName = translate.__({ phrase: "VISITOR-MAIL.appeal", locale }) + " " + invitationInfo.visitorProfile.fields.name;
        }
        if (invitationInfo.expectedStartUtc) {
            let s = moment(invitationInfo.expectedStartUtc).locale(locale).format("DD/MM/YYYY HH:mm");
            if (invitationInfo.expectedEndUtc)
                s += " - " + moment(invitationInfo.expectedEndUtc).locale(locale).format("DD/MM/YYYY HH:mm");
            _info.push(s);
        }
        if (invitationInfo.visitedUser && invitationInfo.visitedUser.fullname) {
            _info.push(translate.__({ phrase: "VISITOR-MAIL.visited_person", locale }) + ": " + invitationInfo.visitedUser.fullname);
        }
        if (invitationInfo.visitorRegistrationPointName) {
            _info.push(translate.__({ phrase: "VISITOR-MAIL.visitor_registration_point_name", locale }) + ": " + invitationInfo.visitorRegistrationPointName);
        }
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.VISITORQRCODE", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "visitor-invitation." + locale + ".handlebars"), "utf8"))({
                organizationLogo: "",
                organizationName: _organizationName,
                message: translate.__({ phrase: "VISITOR-MAIL.message", locale }),
                title: translate.__({ phrase: "VISITOR-MAIL.title", locale }),
                info: _info.join("<br>"),
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                headerLogo: business_visitor_1.armonHeaderLogo,
                unsubscribeEmail: params.unsubscribeUrls?.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls?.unsubscribeTypeUrl,
                visitorName: _visitorName,
                year: new Date().getFullYear().toString(),
            }),
            to: instanceData.e,
            attachments: instanceData.q
                ? [
                    {
                        filename: "qrcode.png",
                        path: instanceData.q,
                        contentType: dal_constants_1.DalConstants.pngContentType,
                    },
                ]
                : [],
        };
    }
    else if (instanceData.s === app_enums_1.enums.VisitorCommunicationMediumType.PhoneNumber) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.VISITORQRCODE", locale: locale }, { orgname: invitationInfo.organizationContactInfo.name }) +
                " https://panel.armongate.com/qr/?qr=" +
                encodeURI(JSON.stringify(invitationInfo.qrCodeData)),
            phoneNumber: instanceData.e,
        };
    }
}
async function generateCounterSensorNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const { n: accessPointName } = await dal_manager_1.dbManager.accessRedisCache.getAccessPointCache({ organizationId: params.organizationId, accessPointId: instanceData.a });
    let identity = null;
    if (instanceData.l) {
        const accessLog = await dal_manager_1.dbManager.accessLog.getLogDetailInfoById(params.organizationId, instanceData.l);
        if (accessLog) {
            identity = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId: params.organizationId, userId: accessLog.log.o, trx: params.trx });
        }
    }
    const message = {
        title: translate.__({ phrase: "NOTIFICATION.TITLE.COUNTERSENSOR", locale }),
        body: "",
        data: {
            a: instanceData.a,
            r: instanceData.r,
            t: new Date(instanceData.t).toLocaleString(locale),
            l: instanceData.l,
        },
    };
    switch (instanceData.r) {
        case app_enums_1.enums.CounterSensorReason.ExitButtonTriggeredRelayDrive:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSOREXITBUTTON", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
        case app_enums_1.enums.CounterSensorReason.WiegandReaderTriggeredRelayDrive:
            if (identity) {
                message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORACCESSDEVICEWITHIDENTITY", locale }, {
                    accesscontrolpoint: accessPointName,
                    date: new Date(instanceData.t).toLocaleString(locale),
                    fullname: identity?.f,
                });
            }
            else {
                message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORACCESSDEVICE", locale }, {
                    accesscontrolpoint: accessPointName,
                    date: new Date(instanceData.t).toLocaleString(locale),
                });
            }
            break;
        case app_enums_1.enums.CounterSensorReason.RemoteAccessTriggeredRelayDrive:
            if (identity) {
                message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORREMOTEOPENWITHIDENTITY", locale }, {
                    accesscontrolpoint: accessPointName,
                    date: new Date(instanceData.t).toLocaleString(locale),
                    fullname: identity?.f,
                });
            }
            else {
                message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORREMOTEOPEN", locale }, {
                    accesscontrolpoint: accessPointName,
                    date: new Date(instanceData.t).toLocaleString(locale),
                });
            }
            break;
        case app_enums_1.enums.CounterSensorReason.UnknownReasonCounterAlthoughRelayIsMapped:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORUNKNOWNOPENNEDWITHRELAY", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
        case app_enums_1.enums.CounterSensorReason.UnknownReasonCounterRelayIsNotMapped:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORUNKNOWNOPENNEDWITHOUTRELAY", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
        case app_enums_1.enums.CounterSensorReason.LessAccessThanGranted:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.COUNTERSENSORLESSACCESSTHANGRANTED", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
        case app_enums_1.enums.CounterSensorReason.MoreAccessThanGranted:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.COUNTERSENSORMOREACCESSTHANGRANTED", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: message.title,
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "counter-sensor-notification." + locale + ".handlebars"), "utf8"))({
                text: message.body,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                year: new Date().getFullYear().toString(),
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...message,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return message;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: message.body,
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateStatusSensorNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const { n: accessPointName } = await dal_manager_1.dbManager.accessRedisCache.getAccessPointCache({ organizationId: params.organizationId, accessPointId: instanceData.a });
    let user = null;
    if (instanceData.l) {
        let accessLog = await dal_manager_1.dbManager.accessLog.getLogDetailInfoById(params.organizationId, instanceData.l);
        if (accessLog) {
            user = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId: params.organizationId, userId: accessLog.log.o, trx: params.trx });
        }
    }
    const message = {
        title: translate.__({ phrase: "NOTIFICATION.TITLE.STATUSSENSOR", locale }),
        body: "",
        data: {
            a: instanceData.a,
            l: instanceData.l,
            r: instanceData.r,
            t: new Date(instanceData.t).toLocaleString(locale),
        },
    };
    switch (instanceData.r) {
        case enums_1.EnumsV2.StatusSensorReason.ExitButtonTriggeredRelayDrive:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSOREXITBUTTON", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.LeavedOpenned:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORLEAVEOPENNED", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.ClosedAfterLeavedOpennedTimeout:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORCLOSEDAFTERLEAVEOPENNEDTIMEOUT", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.WiegandReaderTriggeredRelayDrive:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORACCESSDEVICE", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.RemoteAccessTriggeredRelayDrive:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORREMOTEOPEN", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.UnknownReasonOpenAlthoughRelayIsMapped:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORUNKNOWNOPENNEDWITHRELAY", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.UnknownReasonOpenRelayIsNotMapped:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORUNKNOWNOPENNEDWITHOUTRELAY", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
        case enums_1.EnumsV2.StatusSensorReason.Closed:
            message.body = translate.__({ phrase: "NOTIFICATION.MESSAGE.SENSORCLOSED", locale }, {
                accesscontrolpoint: accessPointName,
                date: new Date(instanceData.t).toLocaleString(locale),
            });
            break;
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.STATUSSENSOR", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "status-sensor-notification." + locale + ".handlebars"), "utf8"))({
                text: message.body,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...message,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return message;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: message.body,
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateIdentityAccessNotification(params) {
    const locale = params.receiverUser.l;
    const settings = await dal_manager_1.dbManager.accessNotifications.getAccessNotificationSettings({
        organizationId: params.organizationId,
        notificationId: params.notification.notificationId,
        trx: params.trx,
    });
    const instanceData = params.instanceData;
    const region = await dal_manager_1.dbManager.accessRedisCache.getRegionCache({ organizationId: params.organizationId, regionId: settings.regionId, trx: params.trx });
    const accessPoint = await dal_manager_1.dbManager.accessRedisCache.getAccessPointCache({ organizationId: params.organizationId, accessPointId: instanceData.a });
    let text = "";
    if (instanceData.r === app_enums_1.enums.libEnumsV2.AccessLogReason.Success) {
        const interpolation = {
            identity: instanceData?.on ? instanceData?.on : translate.__({ phrase: "PDF-REPORT.unknown_identity", locale }),
            region: region.n,
            accesscontrolpoint: accessPoint.n,
        };
        text =
            instanceData.d === app_enums_1.enums.AccessDirection.Entrance
                ? translate.__({ phrase: "NOTIFICATION.MESSAGE.REGIONSUCCESSFULLENTRANCEACCESS", locale }, interpolation)
                : instanceData.d === app_enums_1.enums.AccessDirection.Exit
                    ? translate.__({ phrase: "NOTIFICATION.MESSAGE.REGIONSUCCESSFULLEXITACCESS", locale }, interpolation)
                    : translate.__({ phrase: "NOTIFICATION.MESSAGE.REGIONSUCCESSFULLUNDIRECTEDACCESS", locale }, interpolation);
    }
    else {
        const reason = (0, report_util_1.getLocalizedTextOfAccessLogReason)(instanceData.r, locale);
        const interpolation = {
            identity: instanceData?.on ? instanceData?.on : translate.__({ phrase: "PDF-REPORT.unknown_identity", locale }),
            region: region.n,
            accesscontrolpoint: accessPoint.n,
            reason,
        };
        text =
            instanceData.d === app_enums_1.enums.AccessDirection.Entrance
                ? translate.__({ phrase: "NOTIFICATION.MESSAGE.REGIONFAILEDENTRANCEACCESS", locale }, interpolation)
                : instanceData.d === app_enums_1.enums.AccessDirection.Exit
                    ? translate.__({ phrase: "NOTIFICATION.MESSAGE.REGIONFAILEDEXITACCESS", locale }, interpolation)
                    : translate.__({ phrase: "NOTIFICATION.MESSAGE.REGIONFAILEDUNDIRECTEDACCESS", locale }, interpolation);
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.ACCESS", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "access-notification." + locale + ".handlebars"), "utf8"))({
                text,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.ACCESS", locale }),
            body: text,
            data: {
                b: settings.regionId,
                d: instanceData.a,
                f: instanceData.t,
                i: instanceData.i,
                r: instanceData.r,
                g: instanceData.d,
                s: instanceData.s,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text,
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateSelfIdentityAccessNotification(params) {
    const instanceData = params.instanceData;
    const locale = params.receiverUser.l;
    const accessPointId = await dal_manager_1.dbManager.accessRedisCache.getAccessPointCache({ organizationId: params.organizationId, accessPointId: instanceData.a, trx: params.trx });
    let text = "";
    const interpolation = {
        accessPointName: accessPointId.n,
    };
    if (instanceData.m) {
        text = instanceData.m;
    }
    else {
        if (instanceData.r === app_enums_1.enums.libEnumsV2.AccessLogReason.Success) {
            text =
                instanceData.d === app_enums_1.enums.AccessDirection.Entrance
                    ? translate.__({ phrase: "NOTIFICATION.MESSAGE.SELF_IDENTITY_ACCESS_ENTRY_SUCCESS", locale }, interpolation)
                    : instanceData.d === app_enums_1.enums.AccessDirection.Exit
                        ? translate.__({ phrase: "NOTIFICATION.MESSAGE.SELF_IDENTITY_ACCESS_EXIT_SUCCESS", locale }, interpolation)
                        : translate.__({ phrase: "NOTIFICATION.MESSAGE.SELF_IDENTITY_ACCESS_UNDIRECTED_SUCCESS", locale }, interpolation);
        }
        else {
            text =
                instanceData.d === app_enums_1.enums.AccessDirection.Entrance
                    ? translate.__({ phrase: "NOTIFICATION.MESSAGE.SELF_IDENTITY_ACCESS_ENTRY_FAIL", locale }, interpolation)
                    : instanceData.d === app_enums_1.enums.AccessDirection.Exit
                        ? translate.__({ phrase: "NOTIFICATION.MESSAGE.SELF_IDENTITY_ACCESS_EXIT_FAIL", locale }, interpolation)
                        : translate.__({ phrase: "NOTIFICATION.MESSAGE.SELF_IDENTITY_ACCESS_UNDIRECTED_FAIL", locale }, interpolation);
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.ACCESS", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "announcement." + locale + ".handlebars"), "utf8"))({
                title: translate.__({ phrase: "NOTIFICATION.TITLE.ACCESS", locale }),
                body: text,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.ACCESS", locale }),
            body: text,
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text,
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generatePPermissionWaitForSignatureReminderNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    let ppermission;
    try {
        ppermission = await dal_manager_1.dbManager.accessPacs.getPPermission(params.organizationId, instanceData.p);
    }
    catch (error) {
        return {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONDELETED", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONDELETED", locale }),
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONWAITFORSIGNATUREREMINDER", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "ppermissionWaitForSignatureReminder." + locale + ".handlebars"), "utf8"))({
                requestedDate: ppermission.requestDateTime.toLocaleString(locale),
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                ppermissionTypeName: ppermission.ppermissionType.name,
                ppermissionStartDate: ppermission.dateRange.startDateTime.toLocaleString(locale),
                ppermissionEndDate: ppermission.dateRange.endDateTime.toLocaleString(locale),
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONWAITFORSIGNATUREREMINDER", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONWAITFORSIGNATUREREMINDER", locale }),
            data: {
                p: instanceData.p,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.PPERMISSIONWAITFORSIGNATUREREMINDER", locale: locale }, { receiverFullname: params.receiverUser.f }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generatePPermissionWaitForSignatureNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    let ppermission;
    try {
        ppermission = await dal_manager_1.dbManager.accessPacs.getPPermission(params.organizationId, instanceData.p);
    }
    catch (error) {
        return {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONDELETED", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONDELETED", locale }),
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONWAITFORSIGNATURE", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "ppermissionWaitForSignature." + locale + ".handlebars"), "utf8"))({
                requestedDate: ppermission.requestDateTime.toLocaleString(locale),
                ppermissionTypeName: ppermission.ppermissionType.name,
                ppermissionStartDate: ppermission.dateRange.startDateTime.toLocaleString(locale),
                ppermissionEndDate: ppermission.dateRange.endDateTime.toLocaleString(locale),
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONWAITFORSIGNATURE", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONWAITFORSIGNATURE", locale }),
            data: {
                p: instanceData.p,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.PPERMISSIONWAITFORSIGNATURE", locale: locale }, { receiverfullname: params.receiverUser.f }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generatePPermissionApprovementToOwnerNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    let ppermission;
    try {
        ppermission = await dal_manager_1.dbManager.accessPacs.getPPermission(params.organizationId, instanceData.p);
    }
    catch (error) {
        return {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONDELETED", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONDELETED", locale }),
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: instanceData.isApproved
                ? translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONAPPROVEMENT", locale })
                : translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONREJECTION", locale }),
            html: instanceData.isApproved
                ? Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "ppermissionApprovedToOwner." + locale + ".handlebars"), "utf8"))({
                    approvedDate: ppermission.requestDateTime.toLocaleString(locale),
                    ppermissionTypeName: ppermission.ppermissionType.name,
                    ppermissionStartDate: ppermission.dateRange.startDateTime.toLocaleString(locale),
                    ppermissionEndDate: ppermission.dateRange.endDateTime.toLocaleString(locale),
                    unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                    unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                    armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                    year: new Date().getFullYear().toString(),
                })
                : Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "ppermissionRejectedToOwner." + locale + ".handlebars"), "utf8"))({
                    approvedDate: ppermission.requestDateTime.toLocaleString(locale),
                    ppermissionTypeName: ppermission.ppermissionType.name,
                    ppermissionStartDate: ppermission.dateRange.startDateTime.toLocaleString(locale),
                    ppermissionEndDate: ppermission.dateRange.endDateTime.toLocaleString(locale),
                    unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                    unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                    armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                    year: new Date().getFullYear().toString(),
                }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: instanceData.isApproved
                ? translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONAPPROVEMENT", locale })
                : translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONREJECTION", locale }),
            body: instanceData.isApproved
                ? translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONAPPROVEMENT", locale })
                : translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONREJECTION", locale }),
            data: {
                p: instanceData.p,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: instanceData.isApproved
                ? translate.__({ phrase: "NOTIFICATION.SMS.PPERMISSIONAPPROVEMENT", locale }, { receiverFullname: params.receiverUser.f })
                : translate.__({ phrase: "NOTIFICATION.SMS.PPERMISSIONREJECTION", locale }, { receiverFullname: params.receiverUser.f }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generatePPermissionApprovementToManagersNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    let ppermission;
    let fullName;
    try {
        ppermission = await dal_manager_1.dbManager.accessPacs.getPPermission(params.organizationId, instanceData.p);
        fullName = (await dal_manager_1.dbManager.accessUser.getBasicUserInfo(params.organizationId, instanceData.permissionOwnerUserId)).fullname;
    }
    catch (error) {
        return {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONDELETED", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONDELETED", locale }),
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: instanceData.isApproved
                ? translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONAPPROVEMENT", locale })
                : translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONREJECTION", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", (instanceData.isApproved ? "ppermissionApproved." : "ppermissionRejected.") + locale + ".handlebars"), "utf8"))({
                approvedDate: ppermission.requestDateTime.toLocaleString(locale),
                ppermissionTypeName: ppermission.ppermissionType.name,
                ppermissionStartDate: ppermission.dateRange.startDateTime.toLocaleString(locale),
                ppermissionEndDate: ppermission.dateRange.endDateTime.toLocaleString(locale),
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
                fullName,
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: instanceData.isApproved
                ? translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONAPPROVEMENT", locale })
                : translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONREJECTION", locale }),
            body: instanceData.isApproved
                ? translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONAPPROVEDOTHER", locale }, { fullName })
                : translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONREJECTEDOTHER", locale }, { fullName }),
            data: {
                p: instanceData.p,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: instanceData.isApproved
                ? translate.__({ phrase: "NOTIFICATION.SMS.PPERMISSIONAPPROVEMENT", locale }, { fullName })
                : translate.__({ phrase: "NOTIFICATION.SMS.PPERMISSIONREJECTION", locale }, { fullName }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateVerificationTokenForEnableMultiFactorAuth(params) {
    const locale = params.receiverUser.l;
    const { t: token } = params.instanceData;
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.TOKEN_GENERATED", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "verification-token." + locale + ".handlebars"), "utf8"))({
                token,
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.TOKEN_GENERATED", locale }, { token: token.toString() }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generatePPermissionNeedApproveNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    let ppermission;
    try {
        ppermission = await dal_manager_1.dbManager.accessPacs.getPPermission(params.organizationId, instanceData.p);
    }
    catch (error) {
        return {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONDELETED", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONDELETED", locale }),
        };
    }
    const requesterUsers = await Promise.all(instanceData.u.map(async (userId) => await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId: params.organizationId, userId, trx: params.trx })));
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONPENDINGAPPROVEMENT", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "ppermissionNeedApprove." + locale + ".handlebars"), "utf8"))({
                approverUserFullname: params.receiverUser.f,
                requesterUserFullname: requesterUsers
                    .map((requestUser) => requestUser.f)
                    .sort()
                    .join(", "),
                multiple: requesterUsers.length > 0 ? true : false,
                requestedDate: ppermission.requestDateTime.toLocaleString(locale),
                ppermissionTypeName: ppermission.ppermissionType.name,
                ppermissionStartDate: ppermission.dateRange.startDateTime.toLocaleString(locale),
                ppermissionEndDate: ppermission.dateRange.endDateTime.toLocaleString(locale),
                note: ppermission.note,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                url: app_config_1.appConfig.hostBaseRedirectUrl + "#/pacs/permissionsmanagement?id=" + ppermission.id + (instanceData.i ? "&uhr=1" : "&uhr=0"),
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        let bodyText = "";
        let startDate = luxon_1.DateTime.fromISO(ppermission.dateRange.startDateTime.toISOString()).setLocale(locale);
        let startMonth = startDate.toLocaleString({ month: "long" });
        let endDate = luxon_1.DateTime.fromISO(ppermission.dateRange.endDateTime.toISOString()).setLocale(locale);
        let endMonth = endDate.toLocaleString({ month: "long" });
        let ppermissionDuration = endDate.diff(startDate, "days");
        let ppermissionFirstRequesterFullname = requesterUsers[0].f;
        let ppermissionRequesterCount = requesterUsers.length;
        let localeStringVars = {};
        if (ppermissionRequesterCount === 1) {
            if (ppermissionDuration.days < 1) {
                localeStringVars = {
                    requesterName: ppermissionFirstRequesterFullname,
                    day: startDate.day,
                    month: startMonth,
                    startTime: startDate.toFormat("HH':'mm"),
                    endTime: endDate.toFormat("HH':'mm"),
                    ppermissionTypeName: ppermission.ppermissionType.name,
                };
                bodyText = translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONPENDINGAPPROVEMENTSAMEDAY", locale }, localeStringVars);
            }
            else {
                localeStringVars = {
                    requesterName: ppermissionFirstRequesterFullname,
                    startDay: startDate.day,
                    startMonth: startMonth,
                    endDay: endDate.day,
                    endMonth: endMonth,
                    ppermissionTypeName: ppermission.ppermissionType.name,
                };
                bodyText = translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONPENDINGAPPROVEMENTDIFFDAY", locale }, localeStringVars);
            }
        }
        else {
            localeStringVars = {
                requesterName: ppermissionFirstRequesterFullname,
                requesterCount: ppermissionRequesterCount - 1,
            };
            bodyText = translate.__({ phrase: "NOTIFICATION.MESSAGE.PPERMISSIONPENDINGAPPROVEMENTMULTIUSER", locale }, localeStringVars);
        }
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.PPERMISSIONPENDINGAPPROVEMENT", locale }),
            body: bodyText,
            data: {
                h: instanceData.i,
                p: instanceData.p,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.PPERMISSIONPENDINGAPPROVEMENT", locale: locale }, { receiverFullname: params.receiverUser.f }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateDeviceDisconnectedNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const device = await dal_manager_1.dbManager.accessRedisCache.getDeviceNotificationInfoCache({ organizationId: params.organizationId, deviceId: instanceData.t, trx: params.trx });
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.DEVICEDISCONNECTED", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "deviceDisconnected." + locale + ".handlebars"), "utf8"))({
                deviceName: device?.n,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                deviceLocation: device.l,
                deviceLastSync: moment().add(-10, "minute").locale(locale).format("DD MMMM YYYY HH:mm:ss"),
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.DEVICEDISCONNECTED", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.DEVICEDISCONNECTED", locale }, {
                devicename: device?.n,
            }),
            data: {
                d: instanceData.t,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.DEVICEDISCONNECTED", locale }, {
                receiverFullname: params.receiverUser.f,
                devicename: device?.n,
            }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateDeviceConnectedNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const device = await dal_manager_1.dbManager.accessRedisCache.getDeviceNotificationInfoCache({ organizationId: params.organizationId, deviceId: instanceData.t, trx: params.trx });
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.DEVICECONNECTED", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "deviceConnected." + locale + ".handlebars"), "utf8"))({
                deviceName: device?.n,
                deviceLocation: device.l,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                deviceLastSync: moment().locale(locale).format("DD MMMM YYYY HH:mm:ss"),
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.DEVICECONNECTED", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.DEVICECONNECTED", locale }, {
                devicename: device?.n,
            }),
            data: {
                d: instanceData.t,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.DEVICECONNECTED", locale }, {
                devicename: device?.n,
                receiverFullname: params.receiverUser.f,
            }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateUpdatedFeedbackNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const feedbackDetails = await dal_manager_1.dbManager.accessSystem.getOrganizationFeedback(params.organizationId, instanceData.f);
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.UPDATEDFEEDBACK", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "updatedFeedback." + locale + ".handlebars"), "utf8"))({
                userFullname: feedbackDetails.requestUser.fullname,
                title: feedbackDetails.title,
                content: feedbackDetails.body,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                feedbackType: translate.__({ phrase: `FEEDBACK.TYPE.${feedbackDetails.type}`, locale }),
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.UPDATEDFEEDBACK", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.UPDATEDFEEDBACK", locale }),
            data: {
                f: instanceData.f,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.UPDATEDFEEDBACK", locale }, { receiverFullname: params.receiverUser.f }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateNewFeedbackNotificationContent(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const feedbackDetails = await dal_manager_1.dbManager.accessSystem.getOrganizationFeedback(params.organizationId, instanceData.f);
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({
                phrase: "NOTIFICATION.TITLE.NEWFEEDBACK",
                locale,
            }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "newFeedback." + locale + ".handlebars"), "utf8"))({
                userFullname: feedbackDetails.requestUser.fullname,
                title: feedbackDetails.title,
                content: feedbackDetails.body,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                feedbackType: translate.__({ phrase: `FEEDBACK.TYPE.${feedbackDetails.type}`, locale }),
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.NEWFEEDBACK", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.NEWFEEDBACK", locale }),
            data: {
                f: instanceData.f,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.NEWFEEDBACK", locale }, {
                receiverFullname: params.receiverUser.f,
                creator: feedbackDetails.requestUser.fullname,
                title: feedbackDetails.title,
                type: translate.__({ phrase: `FEEDBACK.TYPE.${feedbackDetails.type}`, locale }),
            }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateRegionEmergencyStoppedNotificationContent(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const region = await dal_manager_1.dbManager.accessRedisCache.getRegionCache({ organizationId: params.organizationId, regionId: instanceData.r, trx: params.trx });
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({
                phrase: "NOTIFICATION.TITLE.EMERGENCYSTOP",
                locale: locale,
            }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "regionEmergencyStopped." + locale + ".handlebars"), "utf8"))({
                regionname: region.n,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.EMERGENCYSTOP", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.REGIONEMERGENCYSTOP", locale }, {
                regionname: region.n,
            }),
            data: {
                r: instanceData.r,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.REGIONEMERGENCYSTOP", locale: locale }, { regionName: region.n, receiverFullname: params.receiverUser.f }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateRegionEmergencyStartNotificationContent(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const region = await dal_manager_1.dbManager.accessRedisCache.getRegionCache({ organizationId: params.organizationId, regionId: instanceData.r, trx: params.trx });
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({
                phrase: "NOTIFICATION.TITLE.EMERGENCYSTART",
                locale,
            }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "regionEmergencyStarted." + locale + ".handlebars"), "utf8"))({
                regionname: region.n,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.EMERGENCYSTART", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.REGIONEMERGENCYSTART", locale }, {
                regionname: region.n,
            }),
            data: {
                r: instanceData.r,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.REGIONEMERGENCYSTART", locale: locale }, {
                regionname: region.n,
                receiverFullname: params.receiverUser.f,
            }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateTerminalEmergencyStoppedNotificationContent(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const terminal = await dal_manager_1.dbManager.accessRedisCache.getDeviceNotificationInfoCache({ organizationId: params.organizationId, deviceId: instanceData.t, trx: params.trx });
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({
                phrase: "NOTIFICATION.TITLE.EMERGENCYSTOP",
                locale,
            }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "terminal_Emergency_Stopped." + locale + ".handlebars"), "utf8"))({
                terminalName: terminal.n,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                regionName: instanceData.rn,
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.EMERGENCYSTOP", locale }),
            body: instanceData.rn
                ? translate.__({ phrase: "NOTIFICATION.MESSAGE.RELATED_REGION_TERMINAL_EMERGENCY_STOP", locale }, {
                    terminalName: terminal.n,
                    regionName: instanceData.rn,
                })
                : translate.__({ phrase: "NOTIFICATION.MESSAGE.TERMINALEMERGENCYSTOP", locale }, {
                    terminalName: terminal.n,
                }),
            data: {
                t: instanceData.t,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: instanceData.rn
                ? translate.__({ phrase: "NOTIFICATION.SMS.RELATED_REGION_TERMINAL_EMERGENCY_STOP", locale }, {
                    terminalName: terminal.n,
                    receiverFullname: params.receiverUser.f,
                    regionName: instanceData.rn,
                })
                : translate.__({ phrase: "NOTIFICATION.SMS.TERMINALEMERGENCYSTOP", locale }, {
                    terminalName: terminal.n,
                    receiverFullname: params.receiverUser.f,
                }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateTerminalEmergencyStartedNotificationContent(params) {
    const locale = params.receiverUser.l ?? (await (0, dal_memcache_1.getCacheOrganizationSettings)(params.organizationId, params.trx)).locale;
    const instanceData = params.instanceData;
    const terminal = await dal_manager_1.dbManager.accessRedisCache.getDeviceNotificationInfoCache({ organizationId: params.organizationId, deviceId: instanceData.t, trx: params.trx });
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({
                phrase: "NOTIFICATION.TITLE.EMERGENCYSTART",
                locale: locale,
            }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "terminal_Emergency_Started." + locale + ".handlebars"), "utf8"))({
                terminalName: terminal.n,
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                regionName: instanceData.rn,
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.EMERGENCYSTART", locale }),
            body: instanceData.rn
                ? translate.__({ phrase: "NOTIFICATION.MESSAGE.RELATED_REGION_TERMINAL_EMERGENCY_START", locale }, {
                    terminalName: terminal.n,
                    regionName: instanceData.rn,
                })
                : translate.__({ phrase: "NOTIFICATION.MESSAGE.TERMINALEMERGENCYSTART", locale }, {
                    terminalName: terminal.n,
                }),
            data: {
                t: instanceData.t,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: instanceData.rn
                ? translate.__({ phrase: "NOTIFICATION.SMS.RELATED_REGION_TERMINAL_EMERGENCY_START", locale: locale }, {
                    terminalName: terminal.n,
                    receiverFullname: params.receiverUser.f,
                    regionName: instanceData.rn,
                })
                : translate.__({ phrase: "NOTIFICATION.SMS.TERMINALEMERGENCYSTART", locale: locale }, {
                    terminalName: terminal.n,
                    receiverFullname: params.receiverUser.f,
                }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateScheduledReportNotificationContent(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const preparedReport = await dal_manager_1.dbManager.accessReport.getPreparedReport(instanceData.i, params.organizationId);
    const template = await dal_manager_1.dbManager.accessReport.getReportTemplateViaNotificationId({
        organizationId: params.organizationId,
        notificationId: params.notification.notificationId,
        trx: params.trx,
    });
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: template.name,
            html: instanceData.a
                ? Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "scheduledReportWithAttachment." + locale + ".handlebars"), "utf8"))({
                    unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                    unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                    reportTypeName: (0, business_main_1.transformReportCodeToLocalizedMessages)(template.type, locale),
                    year: new Date().getFullYear().toString(),
                    templateName: template.name,
                    armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                    requesterUserFullname: params.receiverUser.f,
                })
                : Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "scheduledReportWithoutAttachment." + locale + ".handlebars"), "utf-8"))({
                    unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                    unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                    requesterUserFullname: params.receiverUser.f,
                    templatename: template.name,
                    reportname: (0, business_main_1.transformReportCodeToLocalizedMessages)(template.type, locale),
                    url: app_config_1.appConfig.hostBaseRedirectUrl + "/?pre=" + instanceData.i,
                    armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                    year: new Date().getFullYear().toString(),
                }),
            to: params.receiverUser.e,
            attachments: instanceData.a
                ? [
                    {
                        path: path.resolve(app_config_1.appConfig.preparedReportDirectory, instanceData.i),
                        filename: (0, business_main_1.transformReportCodeToLocalizedMessages)(instanceData.t, locale, instanceData.c) +
                            " | " +
                            new Date().toLocaleString(locale) +
                            (preparedReport.format === app_enums_1.enums.ReportFormat.Excel ? ".xlsx" : ".pdf"),
                        contentType: preparedReport.format === app_enums_1.enums.ReportFormat.Excel ? dal_constants_1.DalConstants.excelContentType : dal_constants_1.DalConstants.pdfContentType,
                    },
                ]
                : undefined,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.REPORTREADY", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.SCHEDULEDREPORTREADY", locale }, {
                templatename: template?.name,
                reporttypename: template?.type ? (0, business_main_1.transformReportCodeToLocalizedMessages)(template.type, locale) : undefined,
            }),
            data: {
                r: template?.type,
                s: instanceData.r,
                t: template?.id,
                i: instanceData.i,
                f: preparedReport.format,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.SCHEDULEDREPORTREADY", locale }, {
                templatename: template.name,
                reporttypename: (0, business_main_1.transformReportCodeToLocalizedMessages)(template.type, locale),
                url: app_config_1.appConfig.hostBaseRedirectUrl + "/?pre=" + instanceData.i,
            }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateHugeReportNotificationContent(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const preparedReport = await dal_manager_1.dbManager.accessReport.getPreparedReport(instanceData.i, params.organizationId);
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({
                phrase: "NOTIFICATION.TITLE.REPORTREADY",
                locale: locale,
            }),
            html: instanceData.a
                ? Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "hugeReportNotificationWithAttachment." + locale + ".handlebars"), "utf8"))({
                    unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                    unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                    reportTypeName: (0, business_main_1.transformReportCodeToLocalizedMessages)(instanceData.t, locale),
                    year: new Date().getFullYear().toString(),
                    armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                })
                : Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "hugeReportNotificationWithoutAttachment." + locale + ".handlebars"), "utf8"))({
                    unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                    unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                    reportTypeName: (0, business_main_1.transformReportCodeToLocalizedMessages)(instanceData.t, locale),
                    year: new Date().getFullYear().toString(),
                    url: app_config_1.appConfig.hostBaseRedirectUrl + "/?pre=" + instanceData.i,
                    armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                }),
            to: params.receiverUser.e,
            attachments: instanceData.a
                ? [
                    {
                        path: path.resolve(app_config_1.appConfig.preparedReportDirectory, instanceData.i),
                        filename: (0, business_main_1.transformReportCodeToLocalizedMessages)(instanceData.t, locale, instanceData.c) +
                            " | " +
                            new Date().toLocaleString(locale) +
                            (preparedReport.format === app_enums_1.enums.ReportFormat.Excel ? ".xlsx" : ".pdf"),
                        contentType: preparedReport.format === app_enums_1.enums.ReportFormat.Excel ? dal_constants_1.DalConstants.excelContentType : dal_constants_1.DalConstants.pdfContentType,
                    },
                ]
                : undefined,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.REPORTREADY", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.HUGEREPORTREADY", locale }, {
                reporttypename: (0, business_main_1.transformReportCodeToLocalizedMessages)(instanceData.t, locale),
            }),
            data: {
                r: instanceData.t,
                s: instanceData.r,
                i: instanceData.i,
                f: preparedReport.format,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.HUGEREPORTREADY", locale }, {
                url: app_config_1.appConfig.hostBaseRedirectUrl + "/?pre=" + instanceData.i,
                reporttypename: (0, business_main_1.transformReportCodeToLocalizedMessages)(instanceData.t, locale),
            }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateAssaAbloyDeviceBatteryStatusChangedNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    let batteryLevelLocaledString = null;
    switch (instanceData.s) {
        case app_enums_1.enums.AssaAbloyBatteryLevel.OK:
            batteryLevelLocaledString = translate.__({ phrase: "SYSTEMHEALTH.INFO_BATTERY_NORMAL", locale }, { b: instanceData.s.toString() });
            break;
        case app_enums_1.enums.AssaAbloyBatteryLevel.LOW:
            batteryLevelLocaledString = translate.__({ phrase: "SYSTEMHEALTH.INFO_BATTERY_WARNING", locale }, { b: instanceData.s.toString() });
            break;
        case app_enums_1.enums.AssaAbloyBatteryLevel.EMPTY:
            batteryLevelLocaledString = translate.__({ phrase: "SYSTEMHEALTH.INFO_BATTERY_CRITICAL", locale }, { b: instanceData.s.toString() });
            break;
    }
    switch (params.medium) {
        case app_enums_1.enums.NotificationMedium.Email:
            return {
                subject: translate.__({ phrase: "NOTIFICATION.TITLE.ASSA_ABLOY_BATTERY_STATUS", locale }),
                html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "assa-abloy-battery-state." + (locale ?? "en") + ".handlebars"), "utf8"))({
                    devicename: instanceData.dn ?? "N/A",
                    state: batteryLevelLocaledString,
                    accesscontrolpointname: instanceData.an ?? "N/A",
                    timestamp: instanceData.t,
                    unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                    unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                }),
                to: params.receiverUser.e,
            };
        case app_enums_1.enums.NotificationMedium.PushNotification:
            return {
                title: translate.__({ phrase: "NOTIFICATION.TITLE.ASSA_ABLOY_BATTERY_STATUS", locale }),
                body: translate.__({ phrase: "NOTIFICATION.MESSAGE.ASSA_ABLOY_BATTERY_STATUS", locale }, {
                    lockname: instanceData.dn ?? "N/A",
                    acpname: instanceData.an ?? "N/A",
                    batterylevel: batteryLevelLocaledString,
                    timestamp: instanceData.t,
                }),
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        case app_enums_1.enums.NotificationMedium.SMS:
            return {
                text: translate.__({ phrase: "NOTIFICATION.MESSAGE.ASSA_ABLOY_BATTERY_STATUS", locale }, {
                    lockname: instanceData.dn ?? "N/A",
                    acpname: instanceData.an ?? "N/A",
                    batterylevel: batteryLevelLocaledString,
                    timestamp: instanceData.t,
                }),
                phoneNumber: params.receiverUser.m,
            };
        case app_enums_1.enums.NotificationMedium.Web:
            return {
                title: translate.__({ phrase: "NOTIFICATION.TITLE.ASSA_ABLOY_BATTERY_STATUS", locale }),
                body: translate.__({ phrase: "NOTIFICATION.MESSAGE.ASSA_ABLOY_BATTERY_STATUS", locale }, {
                    lockname: instanceData.dn ?? "N/A",
                    acpname: instanceData.an ?? "N/A",
                    batterylevel: batteryLevelLocaledString,
                    timestamp: instanceData.t,
                }),
            };
        default:
            break;
    }
    return null;
}
async function generateVisitorExcelImportResultNotificationNotification(params) {
    const locale = params.receiverUser.l ?? "en";
    const instanceData = params.instanceData;
    switch (params.medium) {
        case app_enums_1.enums.NotificationMedium.Email:
            if (instanceData.s) {
                return {
                    subject: translate.__({ phrase: "NOTIFICATION.TITLE.VISITOR_EXCEL_IMPORT_RESULT", locale }),
                    html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "visitorExcelImportResultNotificationSuccess." + locale + ".handlebars"), "utf8"))({
                        importTime: new Date(instanceData.t).toLocaleString(locale),
                        importName: instanceData.en,
                        totalVisitorCount: instanceData.tc.toString(),
                        activationCount: instanceData.sc.toString(),
                        unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                        unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                        year: new Date().getFullYear().toString(),
                    }),
                    to: params.receiverUser.e,
                };
            }
            else {
                const visitorModuleSettings = await dal_manager_1.dbManager.accessVisitor.getVisitAndVisitorFormSettings(params.organizationId);
                const visitorProfilesAndVisitStates = await dal_manager_1.dbManager.accessVisitor.listVisitorProfilesWithState(params.organizationId, visitorModuleSettings, instanceData.fc, 0, instanceData.fv.map((fv) => fv.vpi));
                const compiledHtml = Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "visitorExcelImportResultNotificationFailure." + locale + ".handlebars"), "utf8"))({
                    importTime: new Date(instanceData.t).toLocaleString(locale),
                    importName: instanceData.en,
                    totalVisitorCount: instanceData.tc.toString(),
                    activationCount: instanceData.sc.toString(),
                    failedCount: instanceData.fc?.toString(),
                    failedVisits: instanceData.fv.map((fv) => {
                        return {
                            reason: fv.r,
                            visitorName: visitorProfilesAndVisitStates.items.find((f) => f.id === fv.vpi)?.captionLines[0] ?? "N/A",
                            uniqueId: visitorProfilesAndVisitStates.items.find((f) => f.id === fv.vpi)["uniqueId"] ?? "N/A",
                        };
                    }),
                    unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                    unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                    year: new Date().getFullYear().toString(),
                });
                return {
                    subject: translate.__({ phrase: "NOTIFICATION.TITLE.VISITOR_EXCEL_IMPORT_RESULT", locale }),
                    html: compiledHtml,
                    to: params.receiverUser.e,
                };
            }
        case app_enums_1.enums.NotificationMedium.PushNotification:
            return {
                title: translate.__({ phrase: "NOTIFICATION.TITLE.VISITOR_EXCEL_IMPORT_RESULT", locale }),
                body: translate.__({ phrase: instanceData.s ? "NOTIFICATION.MESSAGE.VISITOR_EXCEL_IMPORT_SUCCESS" : "NOTIFICATION.MESSAGE.VISITOR_EXCEL_IMPORT_FAILURE", locale }, {
                    importName: instanceData.en,
                    importTime: new Date(instanceData.t).toLocaleString(locale),
                    totalVisitorCount: instanceData.tc.toString(),
                    activationCount: instanceData.sc.toString(),
                    failCount: instanceData.fc?.toString(),
                }),
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        case app_enums_1.enums.NotificationMedium.SMS:
            return {
                text: translate.__({ phrase: instanceData.s ? "NOTIFICATION.MESSAGE.VISITOR_EXCEL_IMPORT_SUCCESS" : "NOTIFICATION.MESSAGE.VISITOR_EXCEL_IMPORT_FAILURE", locale }, {
                    importName: instanceData.en,
                    importTime: new Date(instanceData.t).toLocaleString(locale),
                    totalVisitorCount: instanceData.tc.toString(),
                    activationCount: instanceData.sc.toString(),
                    failCount: instanceData.fc?.toString() ?? "N/A",
                }),
                phoneNumber: params.receiverUser.m,
            };
        case app_enums_1.enums.NotificationMedium.Web:
            return {
                title: translate.__({ phrase: "NOTIFICATION.TITLE.VISITOR_EXCEL_IMPORT_RESULT", locale }),
                body: translate.__({ phrase: instanceData.s ? "NOTIFICATION.MESSAGE.VISITOR_EXCEL_IMPORT_SUCCESS" : "NOTIFICATION.MESSAGE.VISITOR_EXCEL_IMPORT_FAILURE", locale }, {
                    importName: instanceData.en,
                    importTime: new Date(instanceData.t).toLocaleString(locale),
                    totalVisitorCount: instanceData.tc.toString(),
                    activationCount: instanceData.sc.toString(),
                    failCount: instanceData.fc?.toString() ?? "N/A",
                }),
            };
        default:
            break;
    }
    return null;
}
async function generateAccessLogExcelImportResultNotificationNotification(params) {
    const locale = params.receiverUser.l ?? "en";
    const instanceData = params.instanceData;
    return {
        title: translate.__({ phrase: "NOTIFICATION.TITLE.ACCESS_LOG_EXCEL_IMPORT_RESULT", locale }),
        body: translate.__({ phrase: instanceData.s ? "NOTIFICATION.MESSAGE.ACCESS_LOG_EXCEL_IMPORT_SUCCESS" : "NOTIFICATION.MESSAGE.ACCESS_LOG_EXCEL_IMPORT_FAILURE", locale }, {
            importTime: new Date(instanceData.t).toLocaleString(locale),
        }),
    };
}
async function generateWorkPlanExcelImportResultNotificationNotification(params) {
    const locale = params.receiverUser.l ?? "en";
    const instanceData = params.instanceData;
    return {
        title: translate.__({ phrase: "NOTIFICATION.TITLE.WORKPLAN_EXCEL_IMPORT_RESULT", locale }),
        body: translate.__({ phrase: instanceData.s ? "NOTIFICATION.MESSAGE.WORKPLAN_EXCEL_IMPORT_SUCCESS" : "NOTIFICATION.MESSAGE.WORKPLAN_EXCEL_IMPORT_FAILURE", locale }, {
            importTime: new Date(instanceData.t).toLocaleString(locale),
        }),
    };
}
async function generateSMSBalanceNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    const threshold = instanceData.t;
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.SMSBALANCE", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "smsBalance." + locale + ".handlebars"), "utf8"))({
                threshold: threshold.toString(),
                unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
                unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
                armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
                year: new Date().getFullYear().toString(),
            }),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.SMSBALANCE", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.SMSBALANCE", locale }, { threshold: threshold.toString() }),
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: "NOTIFICATION.SMS.SMSBALANCE", locale }, { threshold: threshold.toString() }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
async function generateAccountCreatedNotification(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        const contextData = {
            username: params.forListing ? "*****" : instanceData.u,
            password: params.forListing ? "*****" : instanceData.p,
            loginlink: app_config_1.appConfig.httpServer.hostBaseRedirectUrl,
            year: new Date().getFullYear().toString(),
            organizationName: (await dal_manager_1.dbManager.accessRedisCache.getOrganizationCache({ organizationId: params.organizationId })).n,
            armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
            unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
            unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
        };
        const hook = business_hooks_1.armonHookManager.getOnPrepareAccountCreatedEmailNotificationHook(params.organizationId);
        if (hook) {
            return hook(contextData, params);
        }
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.ACCOUNT_CREATED", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "account-created." + locale + ".handlebars"), "utf8"))(contextData),
            to: instanceData.u,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.Web) {
        return {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.ACCOUNT_CREATED", locale }),
            body: translate.__({ phrase: "NOTIFICATION.TITLE.ACCOUNT_CREATED", locale }),
        };
    }
}
async function generateVisitorCameNotificationContent(params) {
    const locale = params.receiverUser.l;
    const instanceData = params.instanceData;
    let visitInfo = await dal_manager_1.dbManager.accessVisitor.getVisitorFullnameAndRegistrationPoint(params.organizationId, instanceData.a, params.trx);
    if (params.medium === app_enums_1.enums.NotificationMedium.Email) {
        const context = {
            visitorFullname: visitInfo.visitorFullname,
            visitedFullname: params.receiverUser.f,
            visitorRegistrationPoint: visitInfo.visitorRegistrationPointName,
            year: new Date().getFullYear().toString(),
            organizationName: (await dal_manager_1.dbManager.accessRedisCache.getOrganizationCache({ organizationId: params.organizationId })).n,
            date: visitInfo.date.toLocaleString(params.receiverUser.l),
            armonLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
            headerLogo: "",
            organizationLogo: await (0, dal_memcache_1.getBase64Logo)(params.organizationId),
            unsubscribeEmail: params.unsubscribeUrls.unsubscribeEmailUrl,
            unsubscribeType: params.unsubscribeUrls.unsubscribeTypeUrl,
        };
        const hook = business_hooks_1.armonHookManager.getOnPrepareVisitorCameEmailNotificationHook(params.organizationId);
        if (hook) {
            return hook(context, params);
        }
        return {
            subject: translate.__({ phrase: "NOTIFICATION.TITLE.VISITORCAME", locale }),
            html: Handlebars.compile(fs.readFileSync(path.join(app_config_1.appConfig.assetsDirectory, "web", "views", "email", "visitorCame." + locale + ".handlebars"), "utf8"))(context),
            to: params.receiverUser.e,
        };
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification || params.medium === app_enums_1.enums.NotificationMedium.Web) {
        const result = {
            title: translate.__({ phrase: "NOTIFICATION.TITLE.VISITORCAME", locale }),
            body: translate.__({ phrase: "NOTIFICATION.MESSAGE.VISITORCAME", locale }, {
                visitorname: visitInfo?.visitorFullname || "****",
            }),
            data: {
                v: instanceData.a,
            },
        };
        if (params.medium === app_enums_1.enums.NotificationMedium.PushNotification) {
            return {
                ...result,
                token: params.receiverUser.n,
                tokenType: params.receiverUser.z,
            };
        }
        else {
            return result;
        }
    }
    if (params.medium === app_enums_1.enums.NotificationMedium.SMS) {
        return {
            text: translate.__({ phrase: visitInfo.visitorRegistrationPointName ? "NOTIFICATION.SMS.VISITORCAMEMULTIDOOR" : "NOTIFICATION.SMS.VISITORCAMESINGLEDOOR", locale }, { registrationPoint: visitInfo.visitorRegistrationPointName, visitorFullname: visitInfo.visitorFullname, receiverfullname: params.receiverUser.f }),
            phoneNumber: params.receiverUser.m,
        };
    }
}
const shouldSendNotification = (type, state) => ![7, 6].includes(state) && type !== app_enums_1.enums.NotificationType.ReportServiceError;
function isEmptyReportNotification(notification, instanceData) {
    return (instanceData &&
        notification.type === app_enums_1.enums.NotificationType.ScheduledReport &&
        instanceData.r === restapi_1.ReportServiceResult.NotGeneratedBecauseOfEmptyReport);
}
async function setNotificationMediums(organizationId, notification, trx) {
    const organizationNotificationSettings = (await (0, dal_memcache_1.getCacheOrganizationSettings)(organizationId, trx)).notification;
    const organizationMediumSetting = organizationNotificationSettings.mediumSettings?.custom?.[notification.type] ?? organizationNotificationSettings.mediumSettings?.general;
    notification.web = organizationMediumSetting.web && notification.web && organizationNotificationSettings.availableMediums.web;
    notification.email = organizationMediumSetting.email && notification.email && organizationNotificationSettings.availableMediums.email;
    notification.sms = organizationMediumSetting.sms && notification.sms && organizationNotificationSettings.availableMediums.sms;
    notification.pushNotification = organizationMediumSetting.pushNotification && notification.pushNotification && organizationNotificationSettings.availableMediums.pushNotification;
    return notification;
}
function isAllMediumsClose(notification) {
    return !notification.web && !notification.email && !notification.sms && !notification.pushNotification;
}
const unsubscribeUrls = async (params) => {
    const tokens = await dal_manager_1.dbManager.accessNotifications.prepareNotificationUnsubsribeToken({
        organizationId: params.organizationId,
        type: params.notificationType,
        userId: params.receiverUserId,
        trx: params.trx,
    });
    return {
        unsubscribeEmailUrl: path.join(app_config_1.appConfig.httpServer.apiBasePath, "unsub", params.organizationId, tokens.generalToken, params.locale),
        unsubscribeTypeUrl: path.join(app_config_1.appConfig.httpServer.apiBasePath, "unsub", params.organizationId, tokens.typeToken, params.locale),
    };
};
exports.unsubscribeUrls = unsubscribeUrls;
