"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.canRemoveAccessRights = exports.canAlterAccessRights = exports.canUserChangeRole = exports.canChangeAccessRights = exports.isUserLastAdmin = void 0;
const dal_manager_1 = require("../dal/dal.manager");
const predefined_roles_1 = require("../dal/db/predefined/predefined.roles");
const lodash_1 = __importDefault(require("lodash"));
const api_securityhelper_1 = require("../api/api.securityhelper");
async function isUserLastAdmin(organizationId, userId) {
    let systemAdmins = await dal_manager_1.dbManager.accessUser.listUsersWithRoleId(organizationId, predefined_roles_1.PredefinedRoles.SystemAdministrator.id);
    if (systemAdmins.length == 1 && systemAdmins[0] == userId) {
        return Promise.resolve(true);
    }
    return Promise.resolve(false);
}
exports.isUserLastAdmin = isUserLastAdmin;
async function canChangeAccessRights(organizationId, userId, updatedAccessRights, removedAccessControlPointIds) {
    if (updatedAccessRights.length < 1 && removedAccessControlPointIds.length < 1) {
        return true;
    }
    let accessRights = await dal_manager_1.dbManager.accessAccessControlPoint.getUserAccessControlPointRights(organizationId, userId);
    let viewAcpIds = accessRights.filter((a) => a.accessControlPointId);
    let accessControlPointRights = await dal_manager_1.dbManager.accessAccessControlPoint.listAccessRightsByAccessControlPoints(organizationId, viewAcpIds.map((a) => a.accessControlPointId));
    for (const updatedRight of updatedAccessRights) {
        if (!updatedRight.config || !updatedRight.grant) {
            let countOfGranters = accessControlPointRights.filter((a) => a.id == updatedRight.accessControlPointId && a.userAccessRights.read && a.userAccessRights.grant && a.userId != userId).length;
            if (countOfGranters < 1) {
                return Promise.resolve(false);
            }
            let countOfConfigers = accessControlPointRights.filter((a) => a.id == updatedRight.accessControlPointId && a.userAccessRights.read && a.userAccessRights.config && a.userId != userId).length;
            if (countOfConfigers < 1) {
                return Promise.resolve(false);
            }
        }
    }
    for (const removedAcpId of removedAccessControlPointIds) {
        let countOfGranters = accessControlPointRights.filter((a) => a.id == removedAcpId && a.userAccessRights.read && a.userAccessRights.grant && a.userId != userId).length;
        if (countOfGranters < 1) {
            return Promise.resolve(false);
        }
        let countOfConfigers = accessControlPointRights.filter((a) => a.id == removedAcpId && a.userAccessRights.read && a.userAccessRights.config && a.userId != userId).length;
        if (countOfConfigers < 1) {
            return Promise.resolve(false);
        }
    }
    return Promise.resolve(true);
}
exports.canChangeAccessRights = canChangeAccessRights;
async function canUserChangeRole(organizationId, requesterRoleId, targetRoleId, targetUserId) {
    let roles = await dal_manager_1.dbManager.accessUser.listRolesOfOrganization(organizationId);
    let targetRole = roles.find((r) => r.id == targetRoleId);
    let requesterRole = roles.find((r) => r.id == requesterRoleId);
    if (!targetRole || !requesterRole) {
        return Promise.resolve(false);
    }
    let missingPermissions = targetRole.permissions.filter((t) => !requesterRole.permissions.includes(t));
    if (missingPermissions && missingPermissions.length > 0) {
        (0, api_securityhelper_1.throwAuthError)(null, missingPermissions, targetRole.permissions, true);
        return Promise.resolve(false);
    }
    let isLastAdmin = await isUserLastAdmin(organizationId, targetUserId);
    if (targetUserId && targetRole.typeId != predefined_roles_1.PredefinedRoles.SystemAdministrator.id && isLastAdmin) {
        return Promise.resolve(false);
    }
    return Promise.resolve(true);
}
exports.canUserChangeRole = canUserChangeRole;
async function canAlterAccessRights(organizationId, requesterUserId, updatedAccessRights) {
    if (!updatedAccessRights.some((u) => u.grant == false)) {
        return Promise.resolve(true);
    }
    let grantRemovedAcpIds = updatedAccessRights.filter((u) => u.grant == false).map((u) => u.accessControlPointId);
    return canRemoveAccessRights(organizationId, requesterUserId, grantRemovedAcpIds);
}
exports.canAlterAccessRights = canAlterAccessRights;
async function canRemoveAccessRights(organizationId, requesterUserId, accessControlPointIds) {
    let accessControlPointRights = await dal_manager_1.dbManager.accessAccessControlPoint.listAccessRightsByAccessControlPoints(organizationId, accessControlPointIds);
    let grouped = lodash_1.default.groupBy(accessControlPointRights, (u) => u.id);
    for (const id of accessControlPointIds) {
        if (grouped[id].filter((f) => f.userAccessRights.grant).length == 1) {
            return Promise.resolve(false);
        }
    }
    return Promise.resolve(true);
}
exports.canRemoveAccessRights = canRemoveAccessRights;
